
#ifndef IIRSCRAM_SLICE_NAME_HH
#define IIRSCRAM_SLICE_NAME_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_SliceName.hh,v 
// 
//---------------------------------------------------------------------------

#include "IIRBase_SliceName.hh"

class IIR_TypeDefinition;
class IIRScram_SliceName : public IIRBase_SliceName {

public:
  set<IIR_TypeDefinition> *_get_rval_set( IIR_Boolean (IIR::*constraint_function)() = 0 );
  void _type_check( set<IIR_TypeDefinition> * );

  void _publish_vhdl(ostream &);

  void _publish_cc();
  void _publish_cc_elaborate();
  void _publish_cc_name_elaborate();
  void _publish_cc_range();
  void _publish_cc_declarator();
  void _publish_cc_bounds();
  void _publish_cc_name();
  void _publish_cc_slice_name_as_for_loop();
  
  void _add_decl_into_cgen_symbol_table();

  IIR_Declaration* _get_prefix_declaration();

  IIR_Mode _get_mode();
  
  ostream &_print( ostream &os );

  IIR_Boolean _is_readable();
  IIR_Boolean _is_writable();  
  IIR_Boolean _is_resolved();
  IIR_Boolean _is_variable();
  IIR_Boolean _is_concurrent_generate_statement();
  set<IIR_Declaration> *_symbol_lookup(){ return NULL; }
  IIR_TypeDefinition* _get_name_type();
  
  void _set_subtype( IIR_TypeDefinition * );
  IIR_TypeDefinition *_get_subtype();

  // These methods can be called when a block configuration has a
  // block specification in the form of <GENERATE LABEL>( <RANGE> ) -
  // the parser builds a slice to represent this.
  void _make_interface_visible( symbol_table * );

  IIR_List *_get_statement_list();

  IIR *_clone();

  IIR *_get_suffix();

  // (See IIRScram.hh for description)
  IIR_Declaration *_find_formal_declaration();
  
  set<IIR_Declaration> *_get_implicit_declarations(){ return _implicit_decls; }
  void _set_implicit_declarations( set<IIR_Declaration> *id ){ _implicit_decls = id; }

  IIR_Boolean _is_globally_static_primary();

protected:
  
  IIRScram_SliceName(){ my_subtype = NULL; _implicit_decls = NULL; }
  virtual ~IIRScram_SliceName() = 0;
    
private:
  IIR_TypeDefinition *my_subtype;
  set<IIR_Declaration> *_implicit_decls;
};

#endif

