#ifndef IIRSCRAM_RANGE_TYPE_DEFINITION_HH
#define IIRSCRAM_RANGE_TYPE_DEFINITION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_RangeTypeDefinition.hh,v 1.2 1999/03/09 20:56:09 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_RangeTypeDefinition.hh"

class IIRScram_RangeTypeDefinition : public IIRBase_RangeTypeDefinition {
// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:
  // XXX - this is a kludge.  This shouldn't need to be here.  Essentially
  // a range type is a type that we don't know if it is discrete or not...
  IIR_Boolean _is_discrete_type(){ return TRUE; };
  IIR_Boolean _is_numeric_type(){ return TRUE; };

  void _publish_vhdl(ostream &);
  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl_constraint(ostream &);
  void _publish_cc_bounds();
  void _publish_cc_range();
  void _publish_cc_universal_type();
  void _publish_cc_kernel_type();

  virtual IIR_TypeDefinition *_get_new_subtype();

protected:
  IIRScram_RangeTypeDefinition() {}
  virtual ~IIRScram_RangeTypeDefinition() = 0;
    
private:
};
#endif
