#ifndef IIRSCRAM_PHYSICAL_LITERAL_HH
#define IIRSCRAM_PHYSICAL_LITERAL_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_PhysicalLiteral.hh,v 1.2 1999/03/09 20:55:51 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_PhysicalLiteral.hh"

class ostream;
template <class type> class set;

class IIRScram_PhysicalLiteral : public IIRBase_PhysicalLiteral {
// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:
  void _publish_vhdl(ostream &);
  void _publish_cc();
  void _publish_cc_universal_type();
  void _publish_cc_universal_value();
  void _publish_cc_elaborate();
  void _publish_cc_wait_data();
  void _publish_cc_value();
  void _publish_cc_unit_name();
  void _publish_cc_initialization_value();
  void _publish_cc_headers();
  void _publish_cc_state_object_init();
  void _get_list_of_input_signals(set<IIR_Declaration>*);
  
  IIR_Boolean _is_resolved( );
  IIR_Boolean _is_static_expression() {return TRUE;}

  void _type_check( set<IIR_TypeDefinition> * );
  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0);
  IIR_TypeDefinition *_get_subtype();

  ostream &_print( ostream & );
  IIR *_clone();

protected:
  IIRScram_PhysicalLiteral() {}
  virtual ~IIRScram_PhysicalLiteral() = 0;
    
private:
};
#endif
