
#ifndef IIRSCRAM_OTHERS_INITIALIZATION_HH
#define IIRSCRAM_OTHERS_INITIALIZATION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_OthersInitialization.hh,v 
// 
//---------------------------------------------------------------------------

#include "IIRBase_OthersInitialization.hh"
class IIR_DesignatorList;

class IIRScram_OthersInitialization : public IIRBase_OthersInitialization {

// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:

  void _publish_vhdl(ostream &);
  void _publish_cc_initialization_value();
  void _publish_cc();
  void _publish_cc_headers();
  void _publish_cc_state_object_init();
  void _add_decl_into_cgen_symbol_table();
  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);
  void _get_list_of_input_signals(set<IIR_Declaration>*);

  ostream &_print( ostream & );
  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0);
  IIR *_semantic_transform( set<IIR_TypeDefinition> * );
  void _type_check( set<IIR_TypeDefinition> * );

  IIR *_rval_to_decl( IIR_TypeDefinition * );
  IIR_Boolean _is_resolved();

  IIR_Boolean _is_globally_static();

protected:
  
  IIRScram_OthersInitialization() {};
  virtual ~IIRScram_OthersInitialization() = 0;
    
private:
  // This method will build a set of the possible element types of this
  // "others" based off of the context passed in.
  set<IIR_TypeDefinition> *_build_element_subtype_set( set<IIR_TypeDefinition> *context_set );
  

};

#endif
