#ifndef IIRSCRAM_MODULUS_OPERATOR_HH
#define IIRSCRAM_MODULUS_OPERATOR_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ModulusOperator.hh,v 1.2 1999/03/09 20:55:29 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_ModulusOperator.hh"

class IIRScram_ModulusOperator : public IIRBase_ModulusOperator {

public:
  void _publish_vhdl_operator(ostream &);
  void _publish_cc_operator_name();
  IIRScram::OperatorPrecedenceLevel  _get_operator_precedence();

  IIR *_clone();
  bool _is_associative(IIR_Kind);

protected:
  IIRScram_ModulusOperator() {}
  virtual ~IIRScram_ModulusOperator() = 0;
    
private:
};
#endif
