// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_LengthAttribute.cc,v 1.2 1999/03/09 20:55:16 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_LengthAttribute.hh"
#include "IIR_ConstantDeclaration.hh"
#include "IIR_Identifier.hh"
#include "symbol_table.hh"
#include "resolution_func.hh"
#include "set.hh"
#include "StandardPackage.hh"

IIRScram_LengthAttribute::~IIRScram_LengthAttribute() {}


void 
IIRScram_LengthAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'LENGTH ";

  if (get_suffix() != NULL) {
    _vhdl_out << "(";
    get_suffix()->_publish_vhdl(_vhdl_out);
    _vhdl_out << ") ";
  }
}


void 
IIRScram_LengthAttribute::_publish_cc() {
  _publish_cc_type_attribute("LENGTH");
}


IIR_TextLiteral *
IIRScram_LengthAttribute::_build_attribute_name() {
  char *name = "length";
  return IIR_Identifier::get( name, strlen(name) );
}


IIR_TypeDefinition *
IIRScram_LengthAttribute::_get_subtype(){
  return (IIR_TypeDefinition *)StandardPackage::savant_universal_integer;
}


IIR_Declaration *
IIRScram_LengthAttribute::_get_implicit_declaration( char *decl_name,
						     IIR_TypeDefinition *decl_type ){
  ASSERT( decl_type->_is_integer_type() == TRUE );
  return _build_constant_declaration( decl_name, decl_type );
}

void 
IIRScram_LengthAttribute::_resolve_suffix_special(){
  _resolve_suffix_local_static_int();
}


IIR *
IIRScram_LengthAttribute::_clone(){
  IIR_LengthAttribute *my_clone = new IIR_LengthAttribute();
  my_clone->set_suffix( get_suffix() );
  IIR_Attribute::_clone( my_clone );

  return my_clone;
}
