#ifndef IIRSCRAM_INTEGER_LITERAL_HH
#define IIRSCRAM_INTEGER_LITERAL_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_IntegerLiteral.hh,v 1.2 1999/03/09 20:55:01 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_IntegerLiteral.hh"

template <class type> class set;
class IIR_Declaration;

class IIRScram_IntegerLiteral : public IIRBase_IntegerLiteral {

// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:
  void _publish_vhdl(ostream &);
  void _publish_vhdl_range(ostream &);
  void _publish_cc();
  void _publish_cc_bounds();
  void _publish_cc_data();
  void _publish_cc_wait_data();
  void _publish_cc_state_object_init();
  void _publish_cc_value();
  void _publish_cc_universal_value();
  void _publish_cc_initialization_value();
  void _publish_cc_elaborate();
  void _publish_cc_condition();
  void _publish_cc_headers();
  void _publish_cc_type_name();

  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)()=0); 
  void _type_check(set<IIR_TypeDefinition>*) {}
  ostream &_print( ostream & );
  IIR_Char* print(IIR_Int32);
  IIR_Int32 _get_value();
  IIR_Boolean _is_integer_literal();
  IIR_Boolean _is_negative();
  IIR *_clone() { return this; }

  IIR_IntegerLiteral *_get_integer_static_value();

protected:
  IIRScram_IntegerLiteral() {}
  virtual ~IIRScram_IntegerLiteral() = 0;
    
private:
};
#endif
