#ifndef IIRSCRAM_IMAGE_ATTRIBUTE_HH
#define IIRSCRAM_IMAGE_ATTRIBUTE_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ImageAttribute.hh,v 1.2 1999/03/09 20:54:56 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_ImageAttribute.hh"

class IIRScram_ImageAttribute : public IIRBase_ImageAttribute {

public:
  void _publish_vhdl(ostream &);
  void _publish_cc();
  IIR_TextLiteral *_build_attribute_name();

  IIR_Boolean _has_suffix(){ return TRUE; }
  void _set_suffix( IIR *new_suffix ){ set_suffix( new_suffix ); }

  IIR_TypeDefinition *_get_subtype();
  
  IIR_Declaration *_get_implicit_declaration( char *, IIR_TypeDefinition * );

  IIR_Boolean _is_function_attribute(){ return TRUE; }

protected:
  void _resolve_suffix_special();

  IIRScram_ImageAttribute(){ }

  virtual ~IIRScram_ImageAttribute() = 0;
    
private:
};
#endif
