// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Radharamanan Radhakrishnan ramanan@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_FunctionDeclaration.cc,v 1.7 1999/10/07 14:05:04 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_FunctionDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_Declaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_StringLiteral.hh"
#include "IIR_Attribute.hh"
#include "set.hh"
#include "symbol_table.hh"
#include "IIR_ArrayTypeDefinition.hh"
#include "IIR_InterfaceDeclaration.hh"
#include "IIR_SignalDeclaration.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_FunctionDeclaration::~IIRScram_FunctionDeclaration() {}


void 
IIRScram_FunctionDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  if (get_pure() == IIR_IMPURE_FUNCTION) {
    _vhdl_out << "impure ";
  }
  
  _vhdl_out << "function ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  
  if (interface_declarations.num_elements() != 0) {
    _vhdl_out << " (";
    interface_declarations._publish_vhdl_decl(_vhdl_out);
    _vhdl_out << ")";
  }
    
  _vhdl_out << " return ";
  get_return_type()->_publish_vhdl(_vhdl_out);
  
  if (_contains_body() == TRUE) {
    _vhdl_out << " is " << endl;
    subprogram_declarations._publish_vhdl_decl(_vhdl_out);
    _vhdl_out << "begin" << endl;
    subprogram_body._publish_vhdl(_vhdl_out);
    _vhdl_out << "end function " << *get_declarator() << ";" << endl;
  }
  else {
    _vhdl_out << ";\n";
  }
}

void 
IIRScram_FunctionDeclaration::_publish_cc() {
  ASSERT((get_declarator()->get_kind() == IIR_IDENTIFIER) ||
	 (get_declarator()->get_kind() == IIR_STRING_LITERAL));

  if(cgen_sym_tab_ptr != NULL){
    if (!cgen_sym_tab_ptr->in_scope(this)) {
      cgen_sym_tab_ptr->add_declaration(this);
    }
  }
  if(_is_implicit_declaration() == TRUE) {
    if(_get_attribute_name() != NULL) {
      _get_attribute_name()->_publish_cc();
      return;
     }
  }
//   if(get_declarator()->_is_string_literal()) {
//     ((IIR_StringLiteral*)_get_declarator())->_publish_cc_function_name();
//   } else {
//     _cc_out << "savant";
//     _get_declarator()->_publish_cc();
//     _cc_out << "_";
//     get_return_type()->_publish_cc_type_name();
//   }

  _get_declarator()->_publish_cc();
}


void 
IIRScram_FunctionDeclaration::_publish_cc_bounds() {
  _get_return_type()->_publish_cc_bounds();
}

void
IIRScram_FunctionDeclaration::_publish_cc_necessary_copying() {
  if (_is_implicit_declaration() == TRUE) {
    ASSERT ( _get_attribute_name()  != NULL );
    _get_attribute_name()->_publish_cc_necessary_copying();
  }
}

void
IIRScram_FunctionDeclaration::_publish_cc_read_or_write(const char *functionName, const char *streamName) {
  if (_is_implicit_declaration() == TRUE) {
    ASSERT ( _get_attribute_name()  != NULL );
    _get_attribute_name()->_publish_cc_read_or_write(functionName, streamName);
  }
}

void
IIRScram_FunctionDeclaration::_publish_cc_decl() {
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  if(_is_implicit_declaration() == TRUE) {
    _get_attribute_name()->_publish_cc_necessary_decl_in_state();
    return;
  }

  if(_contains_body() == TRUE){
    ASSERT(cgen_sym_tab_ptr != NULL);
    
    // Publish the subprograms and types within the declaratiove region of
    // this subprogram, since these need to be published just once.  They
    // should not be published while publishing the type conversion
    // function / resolution function.
    subprogram_declarations._publish_cc_decl_subprograms_and_types();
    
    PublishedUnit _saved_publishing_unit = _get_currently_publishing_unit();
    _set_currently_publishing_unit(IIRScram::FUNCTION);

    // Redefine savantnow for a subprogram.
    _publish_cc_redefine_savantnow();
    get_return_type()->_publish_cc_type_name();
    _cc_out << " ";
    if(get_declarator()->_is_string_literal()) {
      // ((IIR_StringLiteral*)get_declarator())->_publish_cc_function_name();
      _get_declarator()->_publish_cc();
    }
    else {
      // _cc_out << "savant";
      _get_declarator()->_publish_cc();
      // _cc_out << "_";
      // get_return_type()->_publish_cc_type_name();
    }
    _cc_out << "(";
    
    // First argument of the subprogram is always a pointer to the process
    // that invoked it.  This is required since we need to access methods
    // like getTimeNow() and writeline() from the subprogram, but which are
    // methods of a process.
    _cc_out << "VHDLKernelBase *processPtr";
    
    if(interface_declarations.num_elements() != 0) {
      _cc_out << ", ";
      interface_declarations._publish_cc_decl_subprogram_args(FALSE);
    }
    _cc_out << ") {" << endl;
    
    // Publish any declarations in this function 
    _publish_cc_declarations();
    _cc_out << endl;
    
    // Publish the body of the function.  
    _set_publish_prefix_string(NULL);
    subprogram_body._publish_cc();
    _cc_out << "}" << endl;
    
    if(_is_possible_resolution_function() == TRUE) {
      _publish_cc_resolution_function();
    }
    
    if(_is_possible_type_conversion_function() == TRUE) {
      _publish_cc_type_conversion_function();
    }
    
    _set_currently_publishing_unit(_saved_publishing_unit);
    
    // Restore the definition of savantnow
    _publish_cc_restore_savantnow();
  }
}


// If this function could be used as a resolution function, publish it
// with the required signature.
// A function could be a resolution funcion if ALL the following
// conditions are satisfied (Section 2.4 of LRM)
// 1. It takes single argument of type "constant",
// 2. The argument is an unconstrained array type, and
// 3. The type of an element of the array is the same as the return type
//    of the function
IIR_Boolean
IIRScram_FunctionDeclaration::_is_possible_resolution_function() {
  //Conditions 1 & 2 checked in first if
  if(_num_subprogram_args() == 1 && 
     interface_declarations.first()->_is_constant() &&
     interface_declarations.first()->get_subtype()->_is_unconstrained_array_type()  ) {
    //condition 3.
    IIR_Declaration* return_decl = get_return_type()->_get_declaration();
    IIR_Declaration* element_decl = ((IIR_ArrayTypeDefinition*)interface_declarations.first()->get_subtype())->get_element_subtype()->_get_declaration();
    if(return_decl == element_decl) {
      return TRUE;
    }
  }
  return FALSE;
}


// If this function could be used as a type conversionfunction, publish it
// with the required signature.
// A function could be a type conversion funcion if ALL the following
// conditions are satisfied (Section 4.3.2.2 of LRM)
// 1. It takes single argument.
IIR_Boolean
IIRScram_FunctionDeclaration::_is_possible_type_conversion_function() {
  if(_num_subprogram_args() == 1) {
    return TRUE;
  } else {
    return FALSE;
  }
}

void
IIRScram_FunctionDeclaration::_publish_cc_resolution_function_name() {
  if(get_declarator()->_is_string_literal()) {
    // ((IIR_StringLiteral*)get_declarator())->_publish_cc_function_name();
    _get_declarator()->_publish_cc();
  } else {
    _cc_out << "savant";
    _get_declarator()->_publish_cc();
  }
  _cc_out << "Type";
  interface_declarations.first()->get_subtype()->_publish_cc_type_name();
  _cc_out << "Ret";
  get_return_type()->_publish_cc_type_name();
  _cc_out << "_RF";
}

void
IIRScram_FunctionDeclaration::_publish_cc_resolution_function() {
  _allocate_return_value = TRUE;

  _cc_out << "VHDLType* ";
  _publish_cc_resolution_function_name();
  _cc_out << "(VHDLKernelBase* processPtr, int numElem, "
	  << "VHDLType **savantvalue) {" << endl;

  IIR_TextLiteral *arg_declarator = interface_declarations.first()->_get_declarator();

  _cc_out << "  int Length = 0;" << endl;
  _cc_out << "  if( numElem >= 0) {" << endl;
  _cc_out << "     Length = numElem - 1;" << endl;
  _cc_out << "  }" << endl;

  _cc_out << " processPtr = processPtr;" << endl;
  interface_declarations.first()->get_subtype()->_publish_cc_type_name();
  _cc_out << " " << *arg_declarator << "(ObjectBase::VARIABLE, 0, to, "
	  << "Length);" << endl
	  << " for(register int savantIterator = 0; savantIterator < numElem; savantIterator++) {" << endl
	  << "   " << *arg_declarator << "[savantIterator] = (";
  if (get_return_type()->_is_scalar_type() == TRUE &&
      get_return_type()->_is_kernel_type() == FALSE){
    get_return_type()->_publish_cc_kernel_type();
  }
  else {
    get_return_type()->_publish_cc_type_name();
  }
  _cc_out << "&)*savantvalue[savantIterator];" << endl
	  << " }" << endl << endl;

  // Publish any declarations in this function 
  _publish_cc_declarations();

  // Publish the body of the function.  
  subprogram_body._publish_cc();
  _cc_out << "}" << endl << endl;
  _allocate_return_value = FALSE;
}

void
IIRScram_FunctionDeclaration::_publish_cc_type_conversion_function_name() {
  if(get_declarator()->_is_string_literal()) {
    // ((IIR_StringLiteral*)get_declarator())->_publish_cc_function_name();
    _get_declarator()->_publish_cc();
  } else {
    _cc_out << "savant";
    _get_declarator()->_publish_cc();
  }
  _cc_out << "Type";
  interface_declarations.first()->get_subtype()->_publish_cc_type_name();
  _cc_out << "Ret";
  get_return_type()->_publish_cc_type_name();
  _cc_out << "_TCF";
}
  
void
IIRScram_FunctionDeclaration::_publish_cc_type_conversion_function() {
  _allocate_return_value = TRUE;

  _cc_out << "VHDLType* ";
  _publish_cc_type_conversion_function_name();
  _cc_out << "(VHDLKernelBase* processPtr, VHDLType *savantvalue) {" << endl;

  IIR_TextLiteral *arg_declarator = interface_declarations.first()->_get_declarator();

  _cc_out << " processPtr = processPtr;" << endl;
  if (interface_declarations.first()->get_subtype()->_is_kernel_type() == FALSE  && interface_declarations.first()->get_subtype()->_is_scalar_type() == TRUE){
    interface_declarations.first()->get_subtype()->_publish_cc_kernel_type();
  }
  else {
    interface_declarations.first()->get_subtype()->_publish_cc_type_name();
  }
  _cc_out << " " << *arg_declarator << "(ObjectBase::VARIABLE, *(";

  if(interface_declarations.first()->get_subtype()->_is_iir_scalar_type_definition() == TRUE) {
    interface_declarations.first()->get_subtype()->_publish_cc_kernel_type();
  } else {
    interface_declarations.first()->get_subtype()->_publish_cc_type_name();
  }    
  
  _cc_out << " *) savantvalue);" << endl;

  // Publish any declarations in this function 
  _publish_cc_declarations();
  // Publish the body of the function.  
  subprogram_body._publish_cc();
  _cc_out << "}" << endl << endl;
  _allocate_return_value = FALSE;
}

  
void
IIRScram_FunctionDeclaration::_publish_cc_init_function() {
  if(IIRScram_Identifier::_cmp((IIR_Identifier*)get_declarator(),"now") == 0){
    return;
  }

  ASSERT(_is_implicit_declaration() == TRUE);
  if(_is_implicit_declaration() == TRUE) {
    _get_attribute_name()->_publish_cc_init();
  }

}


// This function publishes the constructor of signals in the constructor
// of the state.
void
IIRScram_FunctionDeclaration::_publish_cc_state_object_init() {
  if (IIRScram_Identifier::_cmp((IIR_Identifier*)get_declarator(), "now") == 0) {
    return;
  }
  if(_is_implicit_declaration() == TRUE) {
    _get_attribute_name()->_publish_cc_state_object_init();
  }  

}  

void 
IIRScram_FunctionDeclaration::_publish_cc_type_info() {
  subprogram_declarations._publish_cc_type_info();
}

void
IIRScram_FunctionDeclaration::_publish_cc_extern_type_info() {
  subprogram_declarations._publish_cc_extern_type_info();
}


IIR_TypeDefinition* 
IIRScram_FunctionDeclaration::_get_return_type() {
  return get_return_type();
}


IIR_TypeDefinition *
IIRScram_FunctionDeclaration::_get_subtype(){
  IIR_TypeDefinition *retval;

  retval = get_return_type();

  ASSERT( retval != NULL );

  return retval;
}

IIRScram_Declaration::declaration_type 
IIRScram_FunctionDeclaration::_get_type(){
   return FUNCTION;
}


void 
IIRScram_FunctionDeclaration::_publish_cc_wait_data() {
  if (!IIRScram_Identifier::_cmp((IIR_Identifier*)get_declarator(), "now")) {
    _cc_out << "SavanttimeType(ObjectBase::VARIABLE,s->lVT.time)";
  }
  else {
    _get_declarator()->_publish_cc();
  }
}


IIR_Int32
IIRScram_FunctionDeclaration::_get_num_indexes(){
  return get_return_type()->_get_num_indexes();
}


IIR_TypeDefinition *
IIRScram_FunctionDeclaration::_get_type_of_element( int index ){
  // Stolen almost verbatim from IIRScram_ObjectDeclaration
  IIR_TypeDefinition *current_subtype = NULL;

  if( _num_required_args() == 0 ){
    if( index > _get_num_indexes() ){
      return NULL;
    }
    
    current_subtype = get_return_type();
    if( index == 0 ){
      return current_subtype;
    }
  
    int i;
    for( i = 0; i < index - 1; i++ ){
      ASSERT( current_subtype->_is_array_type() == TRUE );
      current_subtype = current_subtype->_get_element_subtype();
    }
  }
  else{
    return get_return_type();
  }

  return current_subtype;
}

// Mangling of functions and procedures is done here as a constnat string
// "savant" is added as a suffix to the function name.
//
// This cannot be done at the subprogram level as for functions, the
// return type is added a prefix while for procedures it is not.

void
IIRScram_FunctionDeclaration::_mangle_declarator() {
  ostrstream newMangledDeclarator;
  IIR_InterfaceDeclaration *interface_element;

  IIR_Boolean is_operator = _is_operator();

  if ((is_operator == TRUE) && (_is_implicit_declaration() == FALSE)) {
    is_operator = FALSE;
  }
  
  if ((_get_declarative_region() != NULL) && (this->get_kind() != IIR_LIBRARY_DECLARATION) && (is_operator == FALSE)) {
    //  if (_get_declarative_region() != NULL) {
    if ((_get_declarative_region()->_is_textio() == FALSE) && (_get_declarative_region()->_is_standard() == FALSE))  {
      if (IIR_TextLiteral::_cmp(get_declarator(), "endfile") != 0) {
	newMangledDeclarator << *_get_declarative_region()->_get_declarator();
	newMangledDeclarator << "_";
      }
    }
  }

  if(get_declarator()->_is_string_literal() == TRUE) {
    IIR_Boolean _is_unary_operator = FALSE;
    if (interface_declarations.num_elements() == 1) {
      _is_unary_operator = TRUE;
    }
    ((IIR_StringLiteral*)get_declarator())->_convert_function_name(newMangledDeclarator, _is_unary_operator);
  } else {
    newMangledDeclarator << "savant"
			 << *get_declarator();
  }
  
  //Mangling with the argument types
  if ((_get_declarative_region()->_is_standard() == FALSE) &&
      (is_operator == FALSE) &&
      (IIR_TextLiteral::_cmp(get_declarator(), "endfile") != 0)) {
    if(interface_declarations.num_elements() >= 1) {
      interface_element = interface_declarations.first();
      // newMangledDeclarator << "_";
      while (interface_element != NULL) {
	ASSERT(interface_element->_get_subtype() != NULL);
	if (interface_element->_get_subtype()->_get_declaration() == NULL) {
	  if (interface_element->_get_subtype()->_get_bottom_base_type() != NULL &&
	      interface_element->_get_subtype()->_get_bottom_base_type()->_get_declaration() != NULL){
	    newMangledDeclarator << *((IIRScram_Declaration *) interface_element->get_subtype()->_get_bottom_base_type()->_get_declaration())->get_declarator();
	  }
	}
	else {
	  newMangledDeclarator << *((IIRScram_Declaration *) interface_element->get_subtype()->_get_declaration())->get_declarator();
	}
	interface_element = interface_declarations.successor(interface_element);
      }
    }
  }
  
  if ((IIR_TextLiteral::_cmp(get_declarator(), "now") != 0) &&
      (_is_operator() == FALSE)) {
    newMangledDeclarator << "_"
			 << *(get_return_type()->_get_declarator());
  }
  
  newMangledDeclarator << ends;
  _set_mangled_declarator(newMangledDeclarator.str());
}

IIR_Boolean
IIRScram_FunctionDeclaration::_is_operator() {
  // This is needed as operators are seen as function calls but are handled
  // differently.
  static char *operators[] = {"\"=\"", "\"=\"", "\">\"", "\"<\"",
			      "\"<=\"", "\">=\"", "\"/=\"", "\"&\"",
			      "\"+\"", "\"-\"", "\"*\"", "\"/\"",
			      "\"**\"", "\"mod\"", "\"rem\"", "\"abs\"",
			      "\"and\"", "\"or\"", "\"not\"", "\"xor\"",
			      "\"xnor\"", "\"sll\"", "\"srl\"",
			      "\"sla\"", "\"sra\"", "\"rol\"",
			      "\"ror\"", "\"nor\"", "\"nand\"", 0};
  
  IIR_TextLiteral *decl = get_declarator();
  
  for(int i = 0; operators[i] != 0; i++) {
    if (IIR_TextLiteral::_cmp(decl, operators[i]) == 0) {
      return TRUE;
    }
  }

  return FALSE;
}

IIR_Boolean 
IIRScram_FunctionDeclaration::_is_access_type(){
  if( get_return_type() == NULL ){
    return false;
  }
  else{
    return get_return_type()->_is_access_type();
  }
}

IIR_Boolean 
IIRScram_FunctionDeclaration::_could_be_conversion_function( ){
  IIR_Boolean retval = FALSE;
  if( interface_declarations.num_elements() == 1 ){
    // We know the argument is the right type, and the return type is
    // right, or we wouldn't have resolved it to this.
    retval = TRUE;
  }
  
  return retval;
}

IIR *
IIRScram_FunctionDeclaration::_clone() {
  return this;
}
