
#ifndef IIRSCRAM_FLOATING_SUBTYPE_DEFINITION_HH
#define IIRSCRAM_FLOATING_SUBTYPE_DEFINITION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_FloatingSubtypeDefinition.hh,v 
// 
//---------------------------------------------------------------------------

#include "IIRBase_FloatingSubtypeDefinition.hh"


class IIRScram_FloatingSubtypeDefinition : public IIRBase_FloatingSubtypeDefinition {

public:

  virtual IIR_Boolean _is_subtype();
  void _publish_cc_type_info();
  void _publish_cc_extern_type_info();

  IIR_FunctionDeclaration* _get_resolution_function(){ return get_resolution_function(); }
  void _set_resolution_function(IIR_FunctionDeclaration *new_function ){
    set_resolution_function( new_function );
  }

protected:
  
  IIRScram_FloatingSubtypeDefinition() {};
  virtual ~IIRScram_FloatingSubtypeDefinition() = 0;
    
private:
  

};

#endif

