#ifndef IIRSCRAM_CONSTANT_INTERFACE_DECLARATION_HH
#define IIRSCRAM_CONSTANT_INTERFACE_DECLARATION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ConstantInterfaceDeclaration.hh,v 1.2 1999/03/09 20:53:50 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_ConstantInterfaceDeclaration.hh"

class IIR_List;

class IIRScram_ConstantInterfaceDeclaration : public IIRBase_ConstantInterfaceDeclaration {
// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:
  void _publish_vhdl_decl(ostream &);
  void _publish_cc_decl();

  void _publish_cc_elaborate();
  void _publish_cc_elaborate_as_pointers(IIR_Boolean publishDefinition = TRUE);
  declaration_type _get_type();
  void _publish_cc();
  void _publish_cc_headers();
  void _publish_cc_state_object_init();
  void _publish_cc_type_name();
  void _publish_cc_object_type();
  void _publish_cc_initialization_value();
  void _publish_cc_universal_value();
  void _publish_cc_kernel_type();
  
  IIR_Boolean _is_static_expression() { return TRUE; }
  IIR_Boolean _is_constant() { return TRUE; }

  IIR *_clone();

  void _type_check( IIRScram_InterfaceDeclaration::_InterfaceListType );

protected:
  IIRScram_ConstantInterfaceDeclaration() {}
  virtual ~IIRScram_ConstantInterfaceDeclaration() = 0;
    
private:
};
#endif

