// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_CaseStatementAlternativeByExpression.cc,v 1.2 1999/03/09 20:53:16 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_CaseStatementAlternativeByExpression.hh"
#include "IIR_Choice.hh"

IIRScram_CaseStatementAlternativeByExpression::~IIRScram_CaseStatementAlternativeByExpression() {}


void 
IIRScram_CaseStatementAlternativeByExpression::
_publish_vhdl(ostream &_vhdl_out) {
  _vhdl_out << "when ";
  get_choice()->_publish_vhdl(_vhdl_out);

  if (sequence_of_statements.first() != NULL) {
    _vhdl_out << " =>\n";
    sequence_of_statements._publish_vhdl(_vhdl_out);
  }
  else {
    _vhdl_out << ",";
  }
}


void
IIRScram_CaseStatementAlternativeByExpression::_publish_cc() {
  // XXX this code assumes that each case choice is exactly one value.
  // It will have to be modified for ranges.

  if(get_choice()->get_value()->_is_subtype()) {
    //choice is a discrete range
    _cc_out << "else if (SAVANT_BOOLEAN_TRUE ==";    
    get_choice()->_publish_cc_discrete_range();
    _cc_out << " {\n";
    sequence_of_statements._publish_cc();
    _cc_out << "}\n";
  }
  else {
    _cc_out << "else if (SAVANT_BOOLEAN_TRUE == savantEqual(";
    _current_publish_node->_publish_cc();
    _cc_out << ", ";
    get_choice()->_publish_cc();
    _cc_out << ")) {\n ";
    sequence_of_statements._publish_cc();
    _cc_out << "}\n";
  }
}


set<IIR_TypeDefinition> *
IIRScram_CaseStatementAlternativeByExpression::_get_rval_set(IIR_Boolean (IIR::*constraint_function)() ){
  ASSERT( get_choice() != NULL );
  return get_choice()->_get_rval_set(constraint_function);
}


IIR *
IIRScram_CaseStatementAlternativeByExpression::_rval_to_decl( IIR_TypeDefinition *my_typedef ){
  ASSERT( get_choice() != NULL );
  set_choice( (IIR_Choice *)get_choice()->_rval_to_decl( my_typedef ) );
  return this;
}


set<IIR_Declaration> *
IIRScram_CaseStatementAlternativeByExpression::_symbol_lookup(){
  return get_choice()->_symbol_lookup();
}


ostream &
IIRScram_CaseStatementAlternativeByExpression::_print( ostream &os ){
  os << *get_choice();
  return os;
}


void 
IIRScram_CaseStatementAlternativeByExpression::
_type_check( set<IIR_TypeDefinition> *context_set ){
  get_choice()->_type_check( context_set );
}


IIR_Boolean
IIRScram_CaseStatementAlternativeByExpression::_is_resolved(){
  return get_choice()->_is_resolved();
  // The statements should be checked if they're resolved somewhere
  // else.  If we do it here, then we'll end up with cascading calls
  // to "_is_resolved".  (What if one of our statements is also a case
  // statement, for instance, and one of it's)
}

IIR*
IIRScram_CaseStatementAlternativeByExpression::_clone() {
  IIR_Choice *choiceclone;
  IIR_CaseStatementAlternativeByExpression *clone;
  clone = new IIR_CaseStatementAlternativeByExpression;
  IIRScram_CaseStatementAlternative::_clone(clone);

  choiceclone = (IIR_Choice*)get_choice()->_clone();
  clone->set_choice(choiceclone);

  return clone;
}
