#ifndef IIRSCRAM_ACCESS_TYPE_DEFINITION_HH
#define IIRSCRAM_ACCESS_TYPE_DEFINITION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_AccessTypeDefinition.hh,v 1.4 1999/05/20 00:29:20 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_AccessTypeDefinition.hh"

class IIR_AccessTypeDefinition;
class IIR_ScalarTypeDefinition;
class IIR_TypeDeclaration;

class IIRScram_AccessTypeDefinition : public IIRBase_AccessTypeDefinition {

public:
  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl_subtype_decl(ostream &);

  // c++ code generation methods
  void _publish_cc();
  virtual void _publish_cc_kernel_type();

  void _publish_cc_constructor_args();
  void _add_decl_into_cgen_symbol_table();
  virtual void _publish_cc_headers();
  virtual void _publish_cc_data_members();

  virtual void _publish_cc_decl_constructors();
  virtual void _publish_cc_type_constructors();
  virtual void _publish_cc_subtype_constructors();

  virtual void _publish_cc_decl_destructors();
  virtual void _publish_cc_type_destructors();
  virtual void _publish_cc_subtype_destructors();

  virtual void _publish_cc_type_operator_equalto();
  virtual void _publish_cc_subtype_operator_equalto();
  virtual void _publish_cc_decl_operator_equalto();
  virtual void _publish_cc_decl_type_attributes();
  void _publish_cc_decl_operator_subscript();

  virtual void _publish_cc_relational_operators();
  virtual void _publish_cc_equality_operator();
  virtual void _publish_cc_inequality_operator();

  virtual void _publish_cc_composite_init();
  void _publish_cc_decl_cc();
  void _publish_cc_function_all();
  void _publish_cc_function_setpointer();
  void _publish_cc_function_print();
  void _publish_cc_function_resetpointer();
  void _publish_cc_function_getpointer();

  IIR_Boolean _is_access_type() { return true; }
  IIR_Boolean _is_iir_access_type_definition() { return true; }

  IIR_Boolean _is_scalar_type();
  IIR_Boolean _is_array_type();
  IIR_Boolean _is_unconstrained_array_type();
  IIR_Boolean _is_record_type();
  IIR_Boolean _designates_incomplete_type();

  IIR_TypeDefinition *_get_element_subtype();
  void _set_element_subtype( IIR_TypeDefinition * );

  IIR_ScalarTypeDefinition *_get_index_subtype();
  IIR_Int32 _get_num_indexes();

  virtual IIR_Boolean _has_access_type() { return TRUE; }

  set<IIR_Declaration> *_find_declarations( IIR_Name * );
  
  //  IIR_TypeDefinition *_check_special_compatible( IIR_TypeDefinition * );

  IIR_Boolean is_element();
  void set_is_element( IIR_Boolean );  

  //The two functions have to be dummy for Access  Types
  virtual void _publish_cc_class_last_event(){}
  virtual void _publish_cc_class_event(){}

  void _publish_cc_extern_type_info() {}
  void _publish_cc_type_info() {}
  
  IIR *_clone();
  void _clone( IIR_AccessTypeDefinition * );

  void _come_into_scope( symbol_table *sym_tab, IIR_TypeDeclaration * );
  void _come_out_of_scope( symbol_table *sym_tab );

protected:
  IIRScram_AccessTypeDefinition();
  virtual ~IIRScram_AccessTypeDefinition() = 0;
  
  IIR_TypeDefinition *_construct_new_subtype( IIR_Name *resolution_function, 
					      IIR_ScalarTypeDefinition *new_constraint );
    
private:
};
#endif

