// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_TextLiteral.cc,v 1.2 1999/03/09 20:52:11 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_TextLiteral.hh"
#include "error_func.hh"


IIRBase_TextLiteral::IIRBase_TextLiteral(){
  text = NULL;
}


IIRBase_TextLiteral::~IIRBase_TextLiteral(){
}


IIR_Char *
IIRBase_TextLiteral::get_text(){
  return text->get_text();
}


IIR_Int32 
IIRBase_TextLiteral::get_text_length(){
  return text->get_text_length();
}


IIR_Char &
IIRBase_TextLiteral::operator[]( IIR_Int32 subscript ){
  _check_bounds( subscript );
  return text->operator[]( subscript );
}


void 
IIRBase_TextLiteral::_check_bounds( IIR_Int32 subscript ){
  if( subscript < 0 || subscript > (get_text_length() - 1) ){
    ostrstream err;
    err << "Error! IIRBase_TextLiteralLiteral array subscript out of bounds!"
	<< ends;
    report_error( this, err );
    abort();
  }  
}


int 
IIRBase_TextLiteral::_cmp( IIR_TextLiteral *a, IIR_TextLiteral *b ) {
  int size_a, size_b;
  size_a = a->get_text_length();
  size_b = b->get_text_length();

  if( size_a > size_b ){
    return 1;
  }
  if (size_b > size_a) {
    return -1;
  }

  char *text_a = a->get_text();
  char *text_b = b->get_text();

  int i;
  for( i = 0; i < size_a; i++ ){
    if( text_a[i] != text_b[i] ){
      return text_a[i] - text_b[i];
    }
  }

  return 0;
}


int 
IIRBase_TextLiteral::_cmp( IIR_TextLiteral *a, char *b ) {
  int size_a, size_b;
  size_a = a->get_text_length();
  size_b = strlen(b);

  if( size_a > size_b ){
    return 1;
  }
  if (size_b > size_a) {
    return -1;
  }

  char *text_a = a->get_text();

  int i;
  for( i = 0; i < size_a; i++ ){
    if( text_a[i] != b[i] ){
      return text_a[i] - b[i];
    }
  }

  return 0;
}


ostream &
IIRBase_TextLiteral::_print( ostream &os ){
  int i;
  
  for(i = 0; i < get_text_length(); i++ ){
    os << operator[](i);
  }

  return os;
}


char *
IIRBase_TextLiteral::_convert_to_c_string(){
  return text->_convert_to_c_string();
}


char *
IIRBase_TextLiteral::_convert_to_library_name(){
  return _convert_to_c_string();
}
