
#ifndef IIRBASE_PACKAGE_DECLARATION_HH
#define IIRBASE_PACKAGE_DECLARATION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_PackageDeclaration.hh,v 1.2 1999/03/09 20:51:14 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_LibraryUnit.hh"
#include "IIR_DeclarationList.hh"

class IIR_PackageBodyDeclaration;

class IIRBase_PackageDeclaration : public IIR_LibraryUnit {

public:

  IIR_Kind get_kind() {return IIR_PACKAGE_DECLARATION;}
  IIR_Char *get_kind_text() {return "IIR_PackageDeclaration";}

  IIR_PackageBodyDeclaration *get_package_body();
  void set_package_body( IIR_PackageBodyDeclaration * );

  IIR_DeclarationList         package_declarative_part;

protected:
  
  IIRBase_PackageDeclaration();
  virtual ~IIRBase_PackageDeclaration() = 0;
    
private:
  
  IIR_PackageBodyDeclaration *my_package_body;

};
#endif
