
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_GenericList.cc,v 1.2 1999/03/09 20:50:13 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_GenericList.hh"
#include "IIR_ConstantInterfaceDeclaration.hh"

IIRBase_GenericList::IIRBase_GenericList() {}
IIRBase_GenericList::~IIRBase_GenericList() {}

void
IIRBase_GenericList::prepend( IIR_ConstantInterfaceDeclaration* element ){
  ASSERT( element->get_kind() == IIR_CONSTANT_INTERFACE_DECLARATION );
  
  IIR_InterfaceList::prepend( element );
}

void
IIRBase_GenericList::append( IIR_ConstantInterfaceDeclaration* element ){
  ASSERT( element->get_kind() == IIR_CONSTANT_INTERFACE_DECLARATION );
  
  IIR_InterfaceList::append( element );
}

IIR_Boolean 
IIRBase_GenericList::insert_after( IIR_ConstantInterfaceDeclaration* existing_element,
					   IIR_ConstantInterfaceDeclaration* new_element) {

  ASSERT( existing_element->get_kind() == IIR_CONSTANT_INTERFACE_DECLARATION );
  ASSERT( new_element->get_kind() == IIR_CONSTANT_INTERFACE_DECLARATION );

  IIR_InterfaceList::insert_after( existing_element, new_element );

  return true;
}

IIR_Boolean
IIRBase_GenericList::insert_before_element(  IIR_ConstantInterfaceDeclaration* existing_element,
					     IIR_ConstantInterfaceDeclaration* new_element) {

  _report_undefined_scram_fn("IIRBase_GenericList::insert_before_element");

  return true;
}

IIR_Boolean
IIRBase_GenericList::remove( IIR_ConstantInterfaceDeclaration* existing_element) {
  ASSERT( existing_element->get_kind() == IIR_CONSTANT_INTERFACE_DECLARATION );

  IIR_InterfaceList::remove( existing_element );

  return true;
}

IIR_ConstantInterfaceDeclaration*
IIRBase_GenericList::successor( IIR_ConstantInterfaceDeclaration* element ) {

  IIR_InterfaceDeclaration *retval = IIR_InterfaceList::successor( element );

  ASSERT( retval == NULL || retval->get_kind() == IIR_CONSTANT_INTERFACE_DECLARATION );

  return (IIR_ConstantInterfaceDeclaration *)retval;
}

IIR_ConstantInterfaceDeclaration*
IIRBase_GenericList::predecessor( IIR_ConstantInterfaceDeclaration *element ){
  ASSERT( element->get_kind() == IIR_CONSTANT_INTERFACE_DECLARATION );

  IIR_InterfaceDeclaration *retval = IIR_InterfaceList::predecessor( element );
  
  ASSERT( retval == NULL || retval->get_kind() == IIR_CONSTANT_INTERFACE_DECLARATION );

  return (IIR_ConstantInterfaceDeclaration *)retval;
}

IIR_ConstantInterfaceDeclaration *
IIRBase_GenericList::first( ) {
  IIR_InterfaceDeclaration *retval = IIR_InterfaceList::first();
  
  ASSERT( retval == NULL || retval->get_kind() == IIR_CONSTANT_INTERFACE_DECLARATION );

  return (IIR_ConstantInterfaceDeclaration*)retval;
}

IIR_ConstantInterfaceDeclaration*
IIRBase_GenericList::get_nth_element( IIR_Int32 position ){
  
  IIR_InterfaceDeclaration *retval = IIR_InterfaceList::get_nth_element( position );
  
  ASSERT( retval == NULL || retval->get_kind() == IIR_CONSTANT_INTERFACE_DECLARATION );

  return (IIR_ConstantInterfaceDeclaration*)retval;  

}

IIR_ConstantInterfaceDeclaration*
IIRBase_GenericList::last() {
  IIR_InterfaceDeclaration *retval = IIR_InterfaceList::last();
  
  ASSERT( retval == NULL || retval->get_kind() == IIR_CONSTANT_INTERFACE_DECLARATION );

  return (IIR_ConstantInterfaceDeclaration*)retval;
}

IIR_Int32
IIRBase_GenericList::get_position( IIR_ConstantInterfaceDeclaration* element ) {

  return IIR_InterfaceList::get_position(element);
}


