/*$Id: d_vccs.cc,v 15.15 1999/10/22 06:36:22 al Exp $ -*- C++ -*-
 * functions for vccs
 */
#include "d_vccs.h"
/*--------------------------------------------------------------------------*/
void DEV_VCCS::precalc()
{
  y0.f0 = LINEAR;
  y0.f1 = value();
  y1 = y0;
  m0.c1 = y0.f1;
  m0.c0 = 0.;
  assert(loss == 0.);
  set_constant(!has_tr_eval());
  set_converged(!has_tr_eval());
}
/*--------------------------------------------------------------------------*/
void DEV_VCCS::dc_begin()
{
  if (!has_tr_eval()){
    assert(y0.f0 == LINEAR);
    assert(y0.f1 == value());
    assert(m0.c1 == y0.f1);
    assert(m0.c0 == 0.);
    assert(loss == 0.);
  }
}
/*--------------------------------------------------------------------------*/
bool DEV_VCCS::do_tr()
{ 
  {if (has_tr_eval()){
    m0.x = volts_limited(n[IN1],n[IN2]);
    y0.x = m0.x;
    tr_eval();
    assert(y0.f0 != LINEAR);
    store_values();
    q_load();
    m0 = CPOLY1(y0);
  }else{
    untested();
    assert(y0.f0 == LINEAR);
    assert(y0.f1 == value());
    assert(m0.c1 == y0.f1);
    assert(m0.c0 == 0.);
    assert(y1 == y0);
    assert(converged());
  }}
  return converged();
}
/*--------------------------------------------------------------------------*/
void DEV_VCCS::do_ac()
{
  {if (has_ac_eval()){
    untested();
    ac_eval();
    acg = ev;
  }else{
    assert(ev == y0.f1);
    assert(has_tr_eval() || ev == value());
  }}
  assert(acg == ev);
  ac_load_active(); 
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
