/*$Id: d_cs.cc,v 15.15 1999/10/22 06:36:22 al Exp $ -*- C++ -*-
 * functions for fixed current source
 * x = 0, y.f0 = nothing, ev = y.f1 = amps.
 */
#include "d_cs.h"
/*--------------------------------------------------------------------------*/
void DEV_CS::precalc()
{
  assert(loss == 0.);
  y0.x  = 0.;
  y0.f0 = 0.;
  y0.f1 = value();
  y1 = y0;
  m0.x  = 0.;
  m0.c0 = y0.f1;
  m0.c1 = 0.;
  set_constant(!has_tr_eval());
  set_converged(!has_tr_eval());
}
/*--------------------------------------------------------------------------*/
void DEV_CS::dc_begin()
{
  if (!has_tr_eval()){
    assert(loss == 0.);
    assert(y0.x  == 0.);
    assert(y0.f0 == 0.);
    assert(y0.f1 == value());
    assert(m0.x  == 0.);
    assert(m0.c0 == y0.f1);
    assert(m0.c1 == 0.);
  }
}
/*--------------------------------------------------------------------------*/
bool DEV_CS::do_tr()
{
  assert(m0.x == 0.);
  {if (has_tr_eval()){
    y0.x = SIM::time0;
    tr_eval();
    store_values();
    q_load();
    m0.c0 = y0.f1;
    assert(m0.c1 == 0.);
  }else{
    untested();
    assert(y0.x  == 0.);
    assert(y0.f0 == 0.);
    assert(y0.f1 == value());
    assert(m0.x  == 0.);
    assert(m0.c0 == y0.f1);
    assert(m0.c1 == 0.);
    assert(y1 == y0);
    assert(converged());
  }}
  return converged();
}
/*--------------------------------------------------------------------------*/
void DEV_CS::do_ac()
{
  {if (has_ac_eval()){
    ac_eval();
    acg = ev;
    ac_load_source();
  }else{
    assert(acg == 0.);
  }}
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
