//  UWidget.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
// The X11 Unicode Widget
// 

#include "UWidget.h"
#include "UCommon.h"
#include "UFontMap.h"
#include "UFreeType.h"
#include "UFontFreeType.h"
#include <string.h>
#define XK_MISCELLANY
#define XK_LATIN1
#include <X11/keysymdef.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <ctype.h>
#include <strings.h>

static int hasKeyRelease = 0;

#define U_PARA_SEP 0x2029
#define U_LINE_SEP 0x2028

UWidget::~UWidget ()
{
	// This needs gcs
	if (pixmapFonts) delete pixmapFonts;
	if (uDisplay != 0)
	{
		// GC should go away with window.
		// BUG?
		//XFreeGC (uDisplay, ugc);
		//XFreeGC (uDisplay, ucgc);
		//XFreeGC (uDisplay, urgc);
	}
	if (uCursor!=0) delete uCursor;
	if (char2BLen!=0) delete char2BBuf;
	if (uString != 0) delete uString;
	if (uInput!=0) delete uInput;
	if (uFont !=0) delete uFont;
}

UWidget::UWidget (const char* nameIn, 
	const UMultiLine multiLineIn, 
	const UEditable editableIn) : UWidgetX ()
{
	name = new char[strlen (nameIn) +1];
	CHECKNULL (name);
	multiLine = multiLineIn;
	editable = editableIn;
	tabSize = 8;
	strcpy (name, nameIn);
	uTextBufferSize = 0;
	uTextSize = 0;
	uTextSizes = 0;
	uTextTabSizes = 0;
	uTextCtrlSizes = 0;
	uTextBuffer = 0;
	pixmapFonts = 0;
	uX = 0;
	uY = 0;
	uFullHeight=-1;
	uFullWidth=-1;
	uFont = 0;
	uDisplay = 0;
	underLine[0].posX=-1;
	underLine[1] = underLine[0];
	reversePoints[0].posX=-1;
	reversePoints[1] = reversePoints[0];
	clearSelection();
	reverseP=0;
	clipboardActive=0;
	uCursor = 0;
	uCursorBox.width=0;
	uCursorBox.height=0;
	uCursorBox.posNeedX=-1;
	uCursorBox.at.posX=0;
	uCursorBox.at.posY=0;
	uCursorBox.at.coordX=0;
	uCursorBox.at.coordY=0;
	uCursorBox.before = uCursorBox.at;
	char2BLen=0;
	uString=0;
	uCornerX = 0;
	uCornerY = 0;
	uInput = new UInput ();
	CHECKNULL (uInput);
	modified = 0;
	startDrag = 0;

	// New 
	uXInputActive=0;
	uXInput=0;
}

UWidget::UWidget (const char* nameIn, Display* displayIn, Window windowIn, 
	const UMultiLine multiLineIn, 
	const UEditable editableIn) : UWidgetX ()
{
	name = new char[strlen (nameIn) +1];
	CHECKNULL (name);
	multiLine = multiLineIn;
	editable = editableIn;
	strcpy (name, nameIn);
	tabSize = 8;
	pixmapFonts = 0;
	uTextBufferSize = 0;
	uTextSize = 0;
	uTextSizes = 0;
	uTextTabSizes = 0;
	uTextCtrlSizes = 0;
	uTextBuffer = 0;
	uX = 0;
	uY = 0;
	uFullHeight=-1;
	uFullWidth=-1;
	uFont = 0;
	uDisplay = 0;
	underLine[0].posX=-1;
	underLine[1] = underLine[0];
	reversePoints[0].posX=-1;
	reversePoints[1] = reversePoints[0];
	clearSelection();
	reverseP=0;
	uCursor = 0;
	uCursorBox.width=0;
	uCursorBox.height=0;
	uCursorBox.posNeedX=-1;
	uCursorBox.at.posX=0;
	uCursorBox.at.posY=0;
	uCursorBox.at.coordX=0;
	uCursorBox.at.coordY=0;
	uCursorBox.before = uCursorBox.at;
	char2BLen=0;
	uString=0;
	clipboardActive=0;
	uCornerX = 0;
	uCornerY = 0;
	uInput = new UInput ();
	CHECKNULL (uInput);

	uSetWidget (displayIn, windowIn);
	modified = 0;
	startDrag = 0;

	uXInput = 0;
	uXInputActive=0;
}

void 
UWidget::uInherit (UWidget* uwidgetIn)
{
	if (uDisplay !=0)
	{
		uSetBackground (uwidgetIn->uBackground);
		uSetForeground (uwidgetIn->uForeground);
		uSetCursorColor (uwidgetIn->uCursorColor);
	}
	uSetEditable (uwidgetIn->editable);
	uSetMultiLine (uwidgetIn->multiLine);
	tabSize = uwidgetIn->tabSize;
	if (uwidgetIn->uString!=0)
	{
		uSetConverter (uwidgetIn->uString->getConverter());
	}

	if (uwidgetIn->uFont!=0 && uDisplay!=0)
	{
		if (uFont!=0)
		{
			delete uFont;
		}
		if (uwidgetIn->uFont->isA (UFont::UX11))
		{
			uFont = new UFontX11 (*((UFontX11*)uwidgetIn->uFont));
		}
		else if (uwidgetIn->uFont->isA (UFont::UFREE))
		{
			uFont = new UFontFreeType (*((UFontFreeType*)uwidgetIn->uFont));
		}
	}
	uSetInput (uwidgetIn->uInput->getName());
}

int
UWidget::uMinimumHeight ()
{
	if (uFont ==0) return 0;
	if (uFont->isNew())
	{
		uSetCursor (UCursor::WAIT, 1);
		uFont->getFont ();
		clearSelection ();
		uSetCursor (UCursor::INSERT, 1);
	}
	if (uXInput==0) return uFont->fontHeight + uBorderSize * 4;
	return uFont->fontHeight * 2 + uBorderSize * 4;
}

int
UWidget::uMinimumWidth ()
{
	if (uFont ==0) return 0;
	if (uFont->isNew())
	{
		uSetCursor (UCursor::WAIT, 1);
		uFont->getFont ();
		clearSelection ();
		uSetCursor (UCursor::INSERT, 1);
	}
	return uFont->fontWidth + uBorderSize * 4;
}

UWidget::UStatus
UWidget::uSetWidget (Display* displayIn, Window windowIn)
{
	XGCValues		gcv;
	XWindowAttributes 	attr;

	if (uDisplay != 0) return ERROR;

	XGetWindowAttributes (displayIn, windowIn, &attr);
	uWidth = attr.width;
	uHeight = attr.height;
	uDisplay = displayIn;
	uScreen = DefaultScreen (uDisplay);
	uBackground = attr.backing_pixel;
	uForeground = BlackPixel (uDisplay, uScreen);
	uCursorColor = BlackPixel (uDisplay, uScreen);
	uWindow = windowIn;
	gcv.foreground = uForeground;
	gcv.background = uBackground;
	ugc = XCreateGC (uDisplay, uWindow, GCForeground | GCBackground, &gcv);
	ucgc = XCreateGC (uDisplay, uWindow, GCForeground | GCBackground, &gcv);
	gcv.foreground = uBackground;
	gcv.background = uForeground;
	urgc = XCreateGC (uDisplay, uWindow, GCForeground | GCBackground, &gcv);
	if (attr.visual->c_class !=  PseudoColor)
	{
		pixmapFonts = new UPixmapCache(displayIn, uWindow,
			ugc, urgc, attr.depth);
	}
	// XSetWindowBackground (uDisplay, uWindow, uBackground);
	cursorState = US_OFF;
	uCursor = new UCursor(uDisplay, uWindow);
	uSetCursor (UCursor::INSERT);
	uCursorBox.width=0;
	uCursorBox.height=0;
	uCursorBox.posNeedX=-1;
	uCursorBox.at.posX=0;
	uCursorBox.at.posY=0;
	uCursorBox.at.coordX=0;
	uCursorBox.at.coordY=0;
	uCursorBox.before = uCursorBox.at;
	uSetCursorXY (0, 0);

	return OK;
}

void 
UWidget::uSetTabSize (const int tabs)
{
	tabSize = tabs;
	uRefresh ();
}

void
UWidget::uSetCursorViewable ()
{
	if (uCursorBox.at.coordX <= uX+uBorderSize)
	{
		if (uX>0) uSetHScroll (uCursorBox.at.coordX, 0, 0, 0);
	}
	else if (uCursorBox.at.coordX+uCursorBox.width-uX+uBorderSize *2> uWidth)
	{
		uSetHScroll (uCursorBox.at.coordX-uWidth +uBorderSize *2
			+ ((uFont==0)?  uCursorBox.width: uFont->fontWidth), 
			0, 0, 0);
	}
	if (uCursorBox.at.coordY <= uY+uBorderSize )
	{
		if (uY>0) uSetVScroll (uCursorBox.at.coordY, 0, 0, 0);
	}
	else if (uCursorBox.at.coordY+uCursorBox.height-uY+uBorderSize*2 > uHeight)
	{
		uSetVScroll (uCursorBox.at.coordY+uCursorBox.height-uHeight+uBorderSize*2, 0, 0, 0);
	}
}

void
UWidget::uProcMousePressEvent (const UMouseButton but, 
	const int xIn, const int yIn)
{
	UPoint		textXY;
	int		cliplen;
	unsigned char*	chars;

	if (underLine[0] != underLine[1])
	{
		uInput->resetState ();
		hideUnderLine();
		underLine[0] = underLine[1];
	}
	switch (but)
	{
	case UB_LEFT:
		getTextPosition (xIn, yIn, &textXY.posX, &textXY.posY);
		if (multiLine!=MULTILINE && multiLine!=MULTILINE_SCROLL)
		{
			textXY.posY=0;
		}

		if (textXY != uCursorBox.at)
		{
			uSetCursorXY (textXY.posX, textXY.posY);
			uSetCursorViewable ();
		}
		startSelection (uCursorBox.at.coordX, uCursorBox.at.coordY, 
			textXY.posX, textXY.posY);
		if (cursorState == US_OFF || cursorState == US_FROZEN_OFF)
		{
			drawCursor (US_ON);
		}
		cursorState = US_FROZEN_ON;
		break;
	case UB_MIDDLE:
		if (editable != EDITABLE) break;
		// get text from cutbuffer and paste it.
		getTextPosition (xIn, yIn, &textXY.posX, &textXY.posY);
		// The guy may really want to put his stuff here
		if ((uCursorBox.at == reversePoints[reverseP] 
			|| uCursorBox.at == reversePoints[reverseP^1])
			&& reversePoints[reverseP] < reversePoints[reverseP^1])
		{
			clearSelection ();
			uSetCursorXY (textXY.posX, textXY.posY);
		}
		chars = uClipboardGet(&cliplen);
		uInsertText (chars, cliplen, 1, 0);
		uSetFullSize ();
		uSetCursorViewable();
		delete chars;
		break;
	default:
		break;
	}
}

void
UWidget::uProcMouseReleaseEvent (const UMouseButton but, 
	const int xIn, const int yIn)
{
	int	textX;
	int	textY;

	if (underLine[0] != underLine[1])
	{
		uInput->resetState ();
		hideUnderLine();
		underLine[0] = underLine[1];
	}
	switch (but)
	{
	case UB_LEFT:
		getTextPosition (xIn, yIn, &textX, &textY);
		endSelection (uCursorBox.at.coordX, uCursorBox.at.coordY, textX, textY);
		cursorState = (cursorState==US_FROZEN_ON)? US_ON:US_OFF;
		break;
	default:
		break;
	}
}

void
UWidget::uProcMouseMotionEvent (const UMouseButton but, 
	const int xIn, const int yIn)
{
	int	textX;
	int	textY;

	switch (but)
	{
	case UB_LEFT:
		if (cursorState != US_FROZEN_ON)
		{
			drawCursor(US_ON);
		}
		getTextPosition (xIn, yIn, &textX, &textY);
		if (textX != uCursorBox.at.posX || textY != uCursorBox.at.posY)
		{
			uSetCursorXY (textX, textY);
			uSetCursorViewable ();
		}
		continueSelection (uCursorBox.at.coordX, uCursorBox.at.coordY, textX, textY);
		cursorState = US_FROZEN_ON;
		break;
	default:
		break;
	}
}


void
UWidget::uProcKeyPressEvent (const UKey key, const int asci)
{
	int 		linesPerPage;
	int		topLine;
	int		lineNo;
	unsigned char	chars[2];
	UCS2*		ucs2;
	UCS2*		state;
	UString*	saveConverter;
	UPoint		fromP;
	UPoint		toP;
	UCursorBox	myCursor;
	UCS2		ucsTwo[2];
	
	// Hmmm.
	if (uXInputActive)
	{
	}
	switch (key)
	{
	case UK_HOME:
		if (editable==CURSOROFF) return;
		if (underLine[0] != underLine[1])
		{
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		if (uTextSize==0) return;
		if (uCursorBox.at.posX == 0)
		{
			return;
		}
		clearSelection();
		uCursorBox.posNeedX = -1;
		uSetCursorXY (0, uCursorBox.at.posY);
		uSetCursorViewable();
		return;
	case UK_CNTRL_HOME:
		if (editable==CURSOROFF) return;
		if (underLine[0] != underLine[1])
		{
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		if (uTextSize==0) return;
		if (uCursorBox.at.posX == 0)
		{
			return;
		}
		uCursorBox.posNeedX = -1;
		uSetCursorXY (0, uCursorBox.at.posY);
		uSetCursorViewable();
		continueSelection (
		   uCursorBox.at.coordX, uCursorBox.at.coordY,
		   uCursorBox.at.posX, uCursorBox.at.posY);
		return;
	case UK_LEFT:
		if (editable==CURSOROFF) return;
		if (underLine[0] != underLine[1])
		{
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		if (uTextSize==0) return;
		clearSelection();
		if (uCursorBox.at.posX == 0)
		{
			if (uCursorBox.at.posY==0) return;
			uCursorBox.posNeedX = -1;
			uSetCursorXY (uTextSizes[uCursorBox.at.posY-1], uCursorBox.at.posY-1);
			uSetCursorViewable();
			return;
		}
		uCursorBox.posNeedX = -1;
		if (uTextSizes[uCursorBox.at.posY] < uCursorBox.at.posX) 
		{
			uCursorBox.at.posX = uTextSizes[uCursorBox.at.posY];
		}
		uSetCursorXY (uCursorBox.at.posX-1, uCursorBox.at.posY);
		uSetCursorViewable();
		return;
	case UK_CNTRL_LEFT:
		if (editable==CURSOROFF) return;
		if (underLine[0] != underLine[1])
		{
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		if (uTextSize==0) return;
		if (uCursorBox.at.posX == 0)
		{
			if (uCursorBox.at.posY==0) return;
			uCursorBox.posNeedX = -1;
			uSetCursorXY (uTextSizes[uCursorBox.at.posY-1], uCursorBox.at.posY-1);
			uSetCursorViewable();
			continueSelection (
		   		uCursorBox.at.coordX, uCursorBox.at.coordY,
		   		uCursorBox.at.posX, uCursorBox.at.posY);
			return;
		}
		uCursorBox.posNeedX = -1;
		if (uTextSizes[uCursorBox.at.posY] < uCursorBox.at.posX) 
		{
			uCursorBox.at.posX = uTextSizes[uCursorBox.at.posY];
		}
		uSetCursorXY (uCursorBox.at.posX-1, uCursorBox.at.posY);
		uSetCursorViewable();
		continueSelection (
	   		uCursorBox.at.coordX, uCursorBox.at.coordY,
	   		uCursorBox.at.posX, uCursorBox.at.posY);
		return;
	case UK_END:
		if (editable==CURSOROFF) return;
		if (underLine[0] != underLine[1])
		{
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		if (uTextSize==0) return;
		if (uTextSizes[uCursorBox.at.posY]<=uCursorBox.at.posX) return;
		clearSelection();
		uCursorBox.posNeedX = -1;
		uSetCursorXY (uTextSizes[uCursorBox.at.posY], uCursorBox.at.posY);
		uSetCursorViewable();
		return;
	case UK_CNTRL_END:
		if (editable==CURSOROFF) return;
		if (underLine[0] != underLine[1])
		{
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		if (uTextSize==0) return;
		if (uTextSizes[uCursorBox.at.posY]<=uCursorBox.at.posX) return;
		uCursorBox.posNeedX = -1;
		uSetCursorXY (uTextSizes[uCursorBox.at.posY], uCursorBox.at.posY);
		uSetCursorViewable();
		continueSelection (
	   		uCursorBox.at.coordX, uCursorBox.at.coordY,
	   		uCursorBox.at.posX, uCursorBox.at.posY);
		return;
	case UK_RIGHT:
		if (editable==CURSOROFF) return;
		if (underLine[0] != underLine[1])
		{
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		if (uTextSize==0) return;
		clearSelection();
		if (uTextSizes[uCursorBox.at.posY] <= uCursorBox.at.posX)
		{
			if (multiLine!=MULTILINE && multiLine!=MULTILINE_SCROLL) return;
			if (uTextSize-1<=uCursorBox.at.posY) return;
			uCursorBox.posNeedX = -1;
			uSetCursorXY (0, uCursorBox.at.posY+1);
			uSetCursorViewable();
			return;
		}
		if (uTextSize >uCursorBox.at.posY && (
		  uTextBuffer[uCursorBox.at.posY][uCursorBox.at.posX] 
		    == U_LINE_SEP ||
		  uTextBuffer[uCursorBox.at.posY][uCursorBox.at.posX] 
		    == U_PARA_SEP ))
		{
			if (multiLine!=MULTILINE 
			    && multiLine!=MULTILINE_SCROLL) return;
			uCursorBox.posNeedX = -1;
			uSetCursorXY (0, uCursorBox.at.posY+1);
			uSetCursorViewable();
			return;
		}
		uCursorBox.posNeedX = -1;
		uSetCursorXY (uCursorBox.at.posX+1, uCursorBox.at.posY);
		uSetCursorViewable();
		return;
	case UK_CNTRL_RIGHT:
		if (editable==CURSOROFF) return;
		if (underLine[0] != underLine[1])
		{
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		if (uTextSize==0) return;
		if (uTextSizes[uCursorBox.at.posY] <= uCursorBox.at.posX)
		{
			if (multiLine!=MULTILINE && multiLine!=MULTILINE_SCROLL) return;
			if (uTextSize-1<=uCursorBox.at.posY) return;
			uCursorBox.posNeedX = -1;
			uSetCursorXY (0, uCursorBox.at.posY+1);
			uSetCursorViewable();
			continueSelection (
	   			uCursorBox.at.coordX, uCursorBox.at.coordY,
	   			uCursorBox.at.posX, uCursorBox.at.posY);
			return;
		}
		if (uTextSize >uCursorBox.at.posY && (
		  uTextBuffer[uCursorBox.at.posY][uCursorBox.at.posX] 
		    == U_LINE_SEP ||
		  uTextBuffer[uCursorBox.at.posY][uCursorBox.at.posX] 
		    == U_PARA_SEP ))
		{
			if (multiLine!=MULTILINE 
			    && multiLine!=MULTILINE_SCROLL) return;
			uCursorBox.posNeedX = -1;
			uSetCursorXY (0, uCursorBox.at.posY+1);
			uSetCursorViewable();
			continueSelection (
	   		   uCursorBox.at.coordX, uCursorBox.at.coordY,
	   		   uCursorBox.at.posX, uCursorBox.at.posY);
			return;
		}
		uCursorBox.posNeedX = -1;
		uSetCursorXY (uCursorBox.at.posX+1, uCursorBox.at.posY);
		uSetCursorViewable();
		continueSelection (
	   		uCursorBox.at.coordX, uCursorBox.at.coordY,
	   		uCursorBox.at.posX, uCursorBox.at.posY);
		return;
	case UK_UP:
		if (editable==CURSOROFF) return;
		if (underLine[0] != underLine[1])
		{
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		if (uCursorBox.at.posY == 0) return;
		clearSelection();
		if (uCursorBox.posNeedX == -1)  uCursorBox.posNeedX = uCursorBox.at.posX;
		uSetCursorXY (uCursorBox.posNeedX, uCursorBox.at.posY-1);
		uSetCursorViewable();
		return;
	case UK_CNTRL_UP:
		if (editable==CURSOROFF) return;
		if (underLine[0] != underLine[1])
		{
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		if (uCursorBox.at.posY == 0) return;
		if (uCursorBox.posNeedX == -1)  uCursorBox.posNeedX = uCursorBox.at.posX;
		uSetCursorXY (uCursorBox.posNeedX, uCursorBox.at.posY-1);
		uSetCursorViewable();
		continueSelection (
	   		uCursorBox.at.coordX, uCursorBox.at.coordY,
	   		uCursorBox.at.posX, uCursorBox.at.posY);
		return;
	case UK_DOWN:
		if (editable==CURSOROFF) return;
		if (multiLine!=MULTILINE && multiLine!=MULTILINE_SCROLL) return;
		if (underLine[0] != underLine[1])
		{
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		if (uCursorBox.at.posY >= uTextSize-1) return;
		clearSelection();
		if (uCursorBox.posNeedX == -1)  uCursorBox.posNeedX = uCursorBox.at.posX;
		uSetCursorXY (uCursorBox.posNeedX, uCursorBox.at.posY+1);
		uSetCursorViewable();
		return;
	case UK_CNTRL_DOWN:
		if (editable==CURSOROFF) return;
		if (multiLine!=MULTILINE && multiLine!=MULTILINE_SCROLL) return;
		if (underLine[0] != underLine[1])
		{
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		if (uCursorBox.at.posY >= uTextSize-1) return;
		if (uCursorBox.posNeedX == -1)  uCursorBox.posNeedX = uCursorBox.at.posX;
		uSetCursorXY (uCursorBox.posNeedX, uCursorBox.at.posY+1);
		uSetCursorViewable();
		continueSelection (
	   		uCursorBox.at.coordX, uCursorBox.at.coordY,
	   		uCursorBox.at.posX, uCursorBox.at.posY);
		return;
	case UK_PRIOR:
		if (editable==CURSOROFF) return;
		if (underLine[0] != underLine[1])
		{
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		if (uFont == 0 || uFont->fontHeight <=0) return;
		linesPerPage = uHeight/uFont->fontHeight;
		// First fully visible line
		topLine = (uY+uFont->fontHeight-1)/uFont->fontHeight;
		if (topLine<=0 || uTextSize ==0) return;
		if (uCursorBox.posNeedX == -1)  uCursorBox.posNeedX = uCursorBox.at.posX;
		lineNo = (topLine - linesPerPage < 0) ? 
			0 : topLine - linesPerPage;
		clearSelection();
		uSetVScroll (lineNo * uFont->fontHeight, 0, 0, 0);
		// move cursor if it was visible.
		if (uCursorBox.at.posY >= topLine 
			&&  uCursorBox.at.posY <= topLine + linesPerPage)
		{
			uSetCursorXY (uCursorBox.posNeedX, 
				uCursorBox.at.posY-topLine+lineNo);
			uSetCursorViewable();
		}
		return;
	case UK_CNTRL_PRIOR:
		if (editable==CURSOROFF) return;
		if (underLine[0] != underLine[1])
		{
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		if (uFont == 0 || uFont->fontHeight <=0) return;
		linesPerPage = uHeight/uFont->fontHeight;
		// First fully visible line
		topLine = (uY+uFont->fontHeight-1)/uFont->fontHeight;
		if (topLine<=0 || uTextSize ==0) return;
		if (uCursorBox.posNeedX == -1)  uCursorBox.posNeedX = uCursorBox.at.posX;
		lineNo = (topLine - linesPerPage < 0) ? 
			0 : topLine - linesPerPage;
		uSetVScroll (lineNo * uFont->fontHeight, 0, 0, 0);
		// move cursor if it was visible.
		if (uCursorBox.at.posY >= topLine 
			&&  uCursorBox.at.posY <= topLine + linesPerPage)
		{
			uSetCursorXY (uCursorBox.posNeedX, 
				uCursorBox.at.posY-topLine+lineNo);
			uSetCursorViewable();
			continueSelection (
	   			uCursorBox.at.coordX, uCursorBox.at.coordY,
	   			uCursorBox.at.posX, uCursorBox.at.posY);
		}
		return;
	case UK_NEXT:
		if (editable==CURSOROFF) return;
		if (multiLine!=MULTILINE && multiLine!=MULTILINE_SCROLL) return;
		if (underLine[0] != underLine[1])
		{
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		if (uFont == 0 || uFont->fontHeight <=0) return;
		clearSelection();
		linesPerPage = uHeight/uFont->fontHeight;
		topLine = (uY+uFont->fontHeight-1)/uFont->fontHeight;
		// First fully visible line
		if (topLine>=uTextSize-1 || uTextSize==0) return;

		// already visible.
		if (topLine + linesPerPage >= uTextSize) return;

		// if we can show only part of a page do it
		lineNo = topLine + linesPerPage;
		if (lineNo  > uTextSize - linesPerPage)
		{
			lineNo = uTextSize - linesPerPage;
			if (lineNo < 0) lineNo =0;
			if (lineNo>=uTextSize) lineNo = uTextSize-1;
		}

		if (lineNo <= topLine) return;
		if (uCursorBox.posNeedX == -1)  uCursorBox.posNeedX = uCursorBox.at.posX;
		clearSelection();
		uSetVScroll (lineNo*uFont->fontHeight, 0, 0, 0);
		// move cursor if it was visible.
		if (uCursorBox.at.posY >= topLine 
			&&  uCursorBox.at.posY <= topLine + linesPerPage)
		{
			uSetCursorXY (uCursorBox.posNeedX, 
				uCursorBox.at.posY+lineNo-topLine);
			uSetCursorViewable();
		}
		return;
	case UK_CNTRL_NEXT:
		if (editable==CURSOROFF) return;
		if (multiLine!=MULTILINE && multiLine!=MULTILINE_SCROLL) return;
		if (underLine[0] != underLine[1])
		{
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		if (uFont == 0 || uFont->fontHeight <=0) return;
		linesPerPage = uHeight/uFont->fontHeight;
		topLine = (uY+uFont->fontHeight-1)/uFont->fontHeight;
		// First fully visible line
		if (topLine>=uTextSize-1 || uTextSize==0) return;

		// already visible.
		if (topLine + linesPerPage >= uTextSize) return;

		// if we can show only part of a page do it
		lineNo = topLine + linesPerPage;
		if (lineNo  > uTextSize - linesPerPage)
		{
			lineNo = uTextSize - linesPerPage;
			if (lineNo < 0) lineNo =0;
			if (lineNo>=uTextSize) lineNo = uTextSize-1;
		}

		if (lineNo <= topLine) return;
		if (uCursorBox.posNeedX == -1)  uCursorBox.posNeedX = uCursorBox.at.posX;
		uSetVScroll (lineNo*uFont->fontHeight, 0, 0, 0);
		// move cursor if it was visible.
		if (uCursorBox.at.posY >= topLine 
			&&  uCursorBox.at.posY <= topLine + linesPerPage)
		{
			uSetCursorXY (uCursorBox.posNeedX, 
				uCursorBox.at.posY+lineNo-topLine);
			uSetCursorViewable();
			continueSelection (
	   			uCursorBox.at.coordX, uCursorBox.at.coordY,
	   			uCursorBox.at.posX, uCursorBox.at.posY);
		}
		return;
	case UK_DELETE:
		if (editable!=EDITABLE) return;
		if (underLine[0] != underLine[1])
		{
			hideUnderLine();
		}
		if (uDeleteSelection()!=0)
		{
			uSetCursorViewable ();
			return;
		}
		if (uTextSize >=uCursorBox.at.posY && 
		  uTextSizes[uCursorBox.at.posY]>uCursorBox.at.posX && (
		  uTextBuffer[uCursorBox.at.posY][uCursorBox.at.posX] 
		    == U_LINE_SEP ||
		  uTextBuffer[uCursorBox.at.posY][uCursorBox.at.posX] 
		    == U_PARA_SEP ))
		{
			fromP = uCursorBox.at;
			toP = uCursorBox.at;
			// Allow separators in single line
			if ((multiLine==MULTILINE 
				|| multiLine==MULTILINE_SCROLL)
			   && uTextSize > uCursorBox.at.posY)
			{
				toP.posX = 0;
				toP.posY++;
			}
			else
			{
				toP.posX++;
			}
			uDeleteText (fromP, toP);
			return;
		}
		uProcKeyPressEvent (UK_RIGHT, 0);
		if (uCursorBox.at.posX==0 && uCursorBox.at.posY==0) return;
		toP=uCursorBox.at;
		fromP=uCursorBox.before; 
		if (toP.posX==0)
		{
			myCursor = uCursorBox;
			myCursor.at.posY--;
			myCursor.at.posX=uTextSizes[myCursor.at.posY];
			getCursorPosition (&myCursor);
			fromP = myCursor.at;
		}
		uDeleteText (fromP, toP);
		if (underLine[0]!=underLine[1])
		{
			underLine[1]=uCursorBox.at;
			uInput->deleteLast ();
			if (underLine[0]!=underLine[1])
			{
				drawUnderLine();
			}
		}
		return;
	case UK_BACKSPACE:
		if (editable!=EDITABLE) return;
		if (underLine[0] != underLine[1])
		{
			hideUnderLine();
		}
		if (uDeleteSelection()!=0)
		{
			uSetCursorViewable ();
			return;
		}
		if (uCursorBox.at.posX==0 && uCursorBox.at.posY==0) return;
		toP=uCursorBox.at;
		fromP=uCursorBox.before; 
		if (toP.posX==0)
		{
			myCursor = uCursorBox;
			myCursor.at.posY--;
			myCursor.at.posX=uTextSizes[myCursor.at.posY];
			getCursorPosition (&myCursor);
			fromP = myCursor.at;
		}
		uDeleteText (fromP, toP);
		if (underLine[0]!=underLine[1])
		{
			underLine[1]=uCursorBox.at;
			uInput->deleteLast ();
			if (underLine[0]!=underLine[1])
			{
				drawUnderLine();
			}
		}
		return;

	case UK_RETURN:
		if (editable!=EDITABLE) return;
		if (multiLine!=MULTILINE && multiLine!=MULTILINE_SCROLL) return;
		if (underLine[0] != underLine[1])
		{
			// Finish it with space
			uProcKeyPressEvent (UK_ASCII, '\001');
			uProcKeyPressEvent (UK_BACKSPACE, 0);
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		clearSelection();
		ucsTwo[0] = (unsigned char) '\n';
		ucsTwo[1] = 0;
		uInsertUCS2 (ucsTwo, 1);
		uSetFullSize ();
		uSetCursorViewable();
		return;

	case UK_CNTRL_RETURN:
		if (editable!=EDITABLE) return;
		if (underLine[0] != underLine[1])
		{
			// Finish it with space
			uProcKeyPressEvent (UK_ASCII, '\001');
			uProcKeyPressEvent (UK_BACKSPACE, 0);
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		clearSelection();
		ucsTwo[0] = U_LINE_SEP;
		ucsTwo[1] = 0;
		uInsertUCS2 (ucsTwo, 1);
		uSetFullSize ();
		uSetCursorViewable();
		break;

	case UK_SHIFT_RETURN:
		if (editable!=EDITABLE) return;
		if (underLine[0] != underLine[1])
		{
			// Finish it with space
			uProcKeyPressEvent (UK_ASCII, '\001');
			uProcKeyPressEvent (UK_BACKSPACE, 0);
			uInput->resetState ();
			hideUnderLine();
			underLine[0] = underLine[1];
		}
		clearSelection();
		ucsTwo[0] = U_PARA_SEP;
		ucsTwo[1] = 0;
		uInsertUCS2 (ucsTwo, 1);
		uSetFullSize ();
		uSetCursorViewable();
		break;

	case UK_XINPUT_TOGGLE:
		if (uXInput!=0)
		{
			if (uXInputActive)
			{
				uXInput->uEnd ();
			}
			else
			{
				if (underLine[0] != underLine[1])
				{
					uInput->resetState ();
					hideUnderLine();
					underLine[0] = underLine [1];
				}
				uXInput->uStart();
			}
			return;
		}
	case UK_ASCII:
		if (editable!=EDITABLE) return;
		if (asci == 0)
		{
			if (underLine[0] != underLine[1])
			{
				// Finish it with space
				uProcKeyPressEvent (UK_ASCII, '\001');
				uProcKeyPressEvent (UK_BACKSPACE, 0);
				uInput->resetState ();
				hideUnderLine();
				underLine[0] = underLine[1];
			}
			clearSelection();
			ucsTwo[0] = 0;
			ucsTwo[1] = 0;
			uInsertUCS2 (ucsTwo, 1);
			uSetFullSize ();
			uSetCursorViewable();
			return;
		}
		if (asci == 27 && uXInput!=0)
		{
			if (uXInputActive)
			{
				uXInput->uEnd ();
			}
			else
			{
				if (underLine[0] != underLine[1])
				{
					uInput->resetState ();
					hideUnderLine();
					underLine[0] = underLine [1];
				}
				uXInput->uStart();
			}
			return;
		}

		// clear text if selected
		uDeleteSelection ();
		ucs2 = uInput->translate (asci);
		if (ucs2!=0)
		{
			if (underLine[0] != underLine[1])
			{
				hideUnderLine();
				uDeleteText (underLine[0], underLine[1]);
			}
			underLine[1] = underLine[0];
			uInsertUCS2 (ucs2, UCS2NullLen(ucs2));
			delete ucs2;
			if (uInput->getStateSize()>0)
			{
				underLine[0] = uCursorBox.at;
				underLine[1] = uCursorBox.at;
				state = uInput->getUCS2 ();
				uInsertUCS2 (state, UCS2NullLen(state));
				underLine[1] = uCursorBox.at;
				drawUnderLine ();
				delete state;
			}
			uSetFullSize ();
			uSetCursorViewable();
			return;
		}
		ucsTwo[0] = (UCS2) asci;
		ucsTwo[1] = 0;
		if (underLine[0] == underLine[1])
		{
			underLine[0] = uCursorBox.at;
			underLine[1] = uCursorBox.at;
			uInsertUCS2 (ucsTwo, 1);
			underLine[1] = uCursorBox.at;
		}
		else
		{
			underLine[1] = uCursorBox.at;
			uInsertUCS2 (ucsTwo, 1);
			underLine[1] = uCursorBox.at;
		}
		drawUnderLine ();
		uSetFullSize ();
		uSetCursorViewable();
		return;
	default:
		break;
	}
	return;
}

void
UWidget::uSetCursorXY (const int xIn, const int yIn)
{
	hideCursor();
	uCursorBox.at.posX = xIn;
	uCursorBox.at.posY = yIn;
	uCursorBox.width = 5;
	uCursorBox.height = 0;
	// calculate new position with redraw routine.
	getCursorPosition (&uCursorBox); 
	drawCursor (US_ON);
}

//
// You have to specify endpoint coordinates.
//
void
UWidget::drawVisibleSegments (const UPoint& fromIn, const UPoint& toIn, 
	UDrawType type, int fillEnd)
{
	UPoint			startP;
	UPoint			endP;
	int			lastWidth;
	

	if (uFont==0) return;

	// make sure dimensions are correct
	if (uFont->isNew())
	{
		uSetCursor (UCursor::WAIT, 1);
		uFont->getFont ();
		clearSelection ();
		uSetCursor (UCursor::INSERT, 1);
	}
	if (uFont->fontHeight == 0) return;

	// Draw whatever the bloke can see on the uScreen
	startP.posY = (uY - uBorderSize)/uFont->fontHeight;
	if (startP.posY < 0) startP.posY = 0;

	startP.posX = fromIn.posX;
	startP.coordX = fromIn.coordX;
	if (startP.posY > fromIn.posY)
	{
		startP.posX = 0;
		startP.coordX = 0;
	}

	if (fromIn > startP) startP = fromIn;

	// Draw line by line
	for (startP.coordY = startP.posY * uFont->fontHeight; 
		startP.posY < uTextSize 
		&& startP.coordY-uY+uBorderSize <= uHeight; 
		startP.coordY += uFont->fontHeight, 
		startP.posY++)
	{
		endP.coordY = startP.coordY;
		endP.posY=startP.posY;
		// -1 means...
		endP.posX = -1;
		endP.coordX  = (toIn.posY == startP.posY
			&& toIn.coordX < uWidth+uX-uBorderSize) 
			? toIn.coordX : uWidth+uX-uBorderSize;
		

		while (startP.posX < uTextSizes[startP.posY] 
			&& startP.coordX < endP.coordX)
		{
			lastWidth = drawSegments (startP, endP, type);
			if (lastWidth < 0) break;
		}

		if (startP.posX == uTextSizes[startP.posY] 
			&& startP.coordX < uWidth+uX-uBorderSize) switch (type)
		{
		case D_ASNEEDED:
			if (fillEnd==0 && toIn.posY == startP.posY) 
				break;
			if (reversePoints[reverseP] <= startP &&
				reversePoints[reverseP^1] > startP)
			{
				// It is anough to draw one font more.
				XFillRectangle (uDisplay, uWindow, ugc,
					startP.coordX-uX+uBorderSize+uCornerX, 
					startP.coordY-uY+uBorderSize+uCornerY, 
					uWidth+uX-uBorderSize, uFont->fontHeight);
			}
			else
			{
				XFillRectangle (uDisplay, uWindow, urgc,
					startP.coordX-uX+uBorderSize+uCornerX, 
					startP.coordY-uY+uBorderSize+uCornerY, 
					uWidth+uX-uBorderSize, uFont->fontHeight);
			}
			break;
		case D_NORMAL_FILL:
			// we know what we are doing
			if (fillEnd==0 && toIn.posY == startP.posY) 
				break;

			XFillRectangle (uDisplay, uWindow, urgc,
				startP.coordX-uX+uBorderSize+uCornerX, 
				startP.coordY-uY+uBorderSize+uCornerY, 
				uWidth+uX-uBorderSize, uFont->fontHeight);
			break;
		case D_REVERSE:
		default:
			// we know what we are doing
			if (fillEnd==0 && toIn.posY == startP.posY) 
				break;

			// It is anough to draw one font more.
			XFillRectangle (uDisplay, uWindow, ugc,
				startP.coordX-uX+uBorderSize+uCornerX, 
				startP.coordY-uY+uBorderSize+uCornerY, 
				uWidth+uX-uBorderSize, uFont->fontHeight);
			break;
		}
		if (toIn.posY == startP.posY) break;
			
		// start from zero...
		startP.coordX = 0;
		startP.posX = 0;
	}
	switch (type)
	{
	case D_ASNEEDED:
	case D_NORMAL_FILL:
		if (cursorState == US_ON || cursorState ==US_FROZEN_ON)
		{
			drawCursor (US_ON);
		}
		break;
	default:
		break;
	}
}

//
// Draw a line segment.
// required from.pos and from.coord, to.pos or to.coord.
//
int
UWidget::drawSegments (UPoint& from, const UPoint& to, const UDrawType type)
{
	UCS2*			text;
	int			len;
	UFontCache*    		fontCache;
	UPoint			segmentTo;
	int			lastWidth;
	UPoint			fromSave;
	
	if (uFont==0) return 0;

	// make sure dimensions are correct
	if (uFont->isNew())
	{
		uSetCursor (UCursor::WAIT, 1);
		uFont->getFont ();
		clearSelection ();
		uSetCursor (UCursor::INSERT, 1);
	}
	if (uFont->fontHeight == 0) return -1;

	text = uTextBuffer[from.posY];
	len = uTextSizes [from.posY];

	if (len +1> char2BLen)
	{
		if (char2BLen != 0) delete char2BBuf;
		char2BLen = len + 128;
		char2BBuf = new XChar2b[char2BLen];
		CHECKNULL (char2BBuf);
	}

	//
	// draw single font segments
	//
	segmentTo.coordX = to.coordX;
	segmentTo.posX = to.posX;

	lastWidth = 0;
	if (to.posX == -1)
	{
		if (segmentTo.coordX < 0) segmentTo.coordX = 0;
	}
	else
	{
		segmentTo.coordX = -1;
	}
	segmentTo.posY = from.posY;
	fromSave.posX = from.posX;
	fromSave.posY = from.posY;

	// search endpoint by coordinate
	while (from.posX < len && (to.posX == -1) 
		? from.coordX < to.coordX : from.posX < to.posX)
	{
		fontCache = uFont->getFont (text, from.posX, &segmentTo.posX);
		if (to.posX != -1 && segmentTo.posX > to.posX) 
		{
			segmentTo.posX = to.posX;
		}

		switch (type)
		{
		case D_ADJUST:
			lastWidth = drawSegment (from, segmentTo, text, 
				fontCache, S_ADJUST);
			break;
		case D_ASNEEDED:
			// No selection - for sure
			if ( reversePoints[reverseP] >= reversePoints[reverseP^1]
			    // both points before
			    || reversePoints[reverseP^1] <= from
			    // both points after 
			    || reversePoints[reverseP] >= segmentTo)
			{

				lastWidth = drawSegment (from, 
					segmentTo, text, fontCache, 
					S_NORMAL);
				break;
			}
			// selection will start
			if (from.posY == reversePoints[reverseP].posY
				&& from.posX < reversePoints[reverseP].posX)
			{
				if (reversePoints[reverseP].posX < segmentTo.posX)
				{
					segmentTo.posX = reversePoints[reverseP].posX; 
				}
				lastWidth = drawSegment (from, 
					segmentTo, text, fontCache, 
					S_NORMAL);
				break;
			}

			// selection will end
			if (from.posY == reversePoints[reverseP^1].posY
				&& segmentTo.posX > reversePoints[reverseP^1].posX)
			{
				segmentTo.posX = reversePoints[reverseP^1].posX; 
			}
			lastWidth = drawSegment (from, segmentTo, text, 
					fontCache, S_REVERSE);
			break;
		case D_REVERSE:
			lastWidth = drawSegment (from, segmentTo, text, 
					fontCache, S_REVERSE);
			break;
		case D_NORMAL:
			lastWidth = drawSegment (from, segmentTo, text, 
					fontCache, S_NORMAL);
			break;
		case D_NORMAL_FILL:
		default:
			lastWidth = drawSegment (from, segmentTo, text, 
					fontCache, S_NORMAL_FILL);
		}
	}
	if (type != D_ADJUST && underLine[0] != underLine[1])
	{
		if (fromSave < underLine[1] && from > underLine[0])
		{
			drawUnderLine();
		}
	}
	return lastWidth;
}

void
UWidget::drawUnderLine ()
{
	XDrawLine (uDisplay, uWindow, ucgc,
		underLine[0].coordX-uX+uBorderSize+uCornerX, 
		underLine[0].coordY-uY+uBorderSize+uCornerY+uFont->fontAscent+1,
		underLine[1].coordX-uX+uBorderSize+uCornerX-1,
		underLine[1].coordY-uY+uBorderSize+uCornerY+uFont->fontAscent+1);
}

void
UWidget::hideUnderLine ()
{
	XDrawLine (uDisplay, uWindow, urgc,
		underLine[0].coordX-uX+uBorderSize+uCornerX, 
		underLine[0].coordY-uY+uBorderSize+uCornerY+uFont->fontAscent+1,
		underLine[1].coordX-uX+uBorderSize+uCornerX-1,
		underLine[1].coordY-uY+uBorderSize+uCornerY+uFont->fontAscent+1);
}


//
// Draw a line segment with the same font.
// To is only provided to stop drawing unnecessary things.
// return the length of the last drawn
int
UWidget::drawSegment (UPoint& from, const UPoint& to, const UCS2* text,
	UFontCache* fontCacheIn, const USubDrawType type)
{
	const UFontMapStruct*	fontMapStruct;
	UCS2			converted;
	int			tabPixels;
	int			nextTab;
	int			count;
	int			i;
	int			lastLength;
	UCS2			escape[3];
	UFontCache*		escapeFont;
	UPoint			escapeFrom;
	UPoint			escapeTo;
	int			escapeLen;
	int			overallWidth;
	int			sY;
	int			sX;
	int			sWidth;


	lastLength = 0;
	sX = from.coordX-uX+uBorderSize+uCornerX;
	sY = from.coordY-uY+uBorderSize+uCornerY;

	// At least give some visual feedback
	if (text[from.posX] == U_PARA_SEP || text[from.posX] == U_LINE_SEP)
	{
		sWidth = uFont->fontAscent/2+2;
		if (sWidth<1) sWidth = 2;
		switch (text[from.posX])
		{
		case U_PARA_SEP: // paragraph separator
			switch (type)
			{
			case S_REVERSE:
				XFillRectangle (uDisplay, uWindow, ugc,
					sX, sY,
					sWidth,
					uFont->fontHeight);
				XDrawLine (uDisplay, uWindow, urgc,
					sX + sWidth-1,
					sY,
					sX + sWidth-1,
					sY +uFont->fontAscent-1);
				XFillArc (uDisplay, uWindow, urgc,
					sX+1,
					sY-1,
					sWidth*2-2,
					sWidth+1,
					90*64, 180*64);
				break;
			case S_NORMAL_FILL:
				XFillRectangle (uDisplay, uWindow, urgc,
					sX, sY,
					sWidth,
					uFont->fontHeight);
			case S_NORMAL:
				XDrawLine (uDisplay, uWindow, ugc,
					sX + sWidth-1,
					sY,
					sX + sWidth-1,
					sY + uFont->fontAscent-1);
				XFillArc (uDisplay, uWindow, ugc,
					sX+1,
					sY-1,
					sWidth*2-2,
					sWidth+1,
					90*64, 180*64);
					
				break;
			case S_ADJUST:
			default:
				break;
			}
			break;
		case U_LINE_SEP: // line separator
			switch (type)
			{
			case S_REVERSE:
				XFillRectangle (uDisplay, uWindow, ugc,
					sX, sY,
					sWidth,
					uFont->fontHeight);
				XDrawLine (uDisplay, uWindow, urgc,
					sX +sWidth-1,
					sY,
					sX +sWidth-1,
					sY +uFont->fontAscent-1);
				XDrawArc (uDisplay, uWindow, urgc,
					sX+3,
					sY+uFont->fontAscent-sWidth-1,
					sWidth*2-6,
					sWidth-1,
					90*64, 180*64);
				break;
			case S_NORMAL_FILL:
				XFillRectangle (uDisplay, uWindow, urgc,
					sX, sY,
					sWidth,
					uFont->fontHeight);
			case S_NORMAL:
				XDrawLine (uDisplay, uWindow, ugc,
					sX +sWidth-1,
					sY,
					sX +sWidth-1,
					sY +uFont->fontAscent-1);
				XDrawArc (uDisplay, uWindow, ugc,
					sX+3,
					sY+uFont->fontAscent-sWidth-1,
					sWidth*2-6,
					sWidth-1,
					90*64, 180*64);
				break;
			case S_ADJUST:
			default:
				break;
			}
		default:
			break;
		}
		lastLength = sWidth;
		from.coordX += sWidth;
		from.posX +=1;
		return lastLength;
	}
	if (fontCacheIn==0)
	{
		if (text[from.posX] < (UCS2) ' ') switch (text[from.posX])
		{
		case (UCS2) '\t':
			tabPixels = uFont->minFontWidth * tabSize;
			nextTab = tabPixels 
				+ tabPixels * (from.coordX / tabPixels);
			nextTab -= from.coordX;
			switch (type)
			{
			case S_NORMAL:
			case S_NORMAL_FILL:
			XFillRectangle (uDisplay, uWindow, urgc,
				sX, sY,
				nextTab,
				uFont->fontHeight);
				lastLength = nextTab;
				break;
			case S_REVERSE:
			XFillRectangle (uDisplay, uWindow, ugc,
				sX, sY,
				nextTab,
				uFont->fontHeight);
				lastLength = nextTab;
				break;
			case S_ADJUST:
				lastLength = nextTab;
			default:
				break;;
			}
			from.coordX +=  nextTab;
			from.posX +=1;
			return lastLength;
		default:
			escape[0] = (UCS2) '^';
			escape[1] = (UCS2) 'A' + text[from.posX] -1;
			escape[2] = 0;
			escapeFrom.posX = 0;
			escapeFrom.coordX = from.coordX;
			escapeFrom.posY = from.posY;
			escapeFrom.coordY = from.coordY;
			escapeTo.coordX=-1;
			escapeFont = uFont->getFont (escape, 
				escapeFrom.posX, &escapeTo.posX);
			escapeLen = escapeFrom.coordX;
			if (escapeFont!=0 && escapeTo.posX == 2)
			{
				drawSegment (escapeFrom, escapeTo, escape,
					escapeFont, type);
				from.coordX = escapeFrom.coordX;
				from.posX += 1; 
				lastLength = escapeFrom.coordX - escapeLen;
				return  lastLength;
			}
			
		}
		switch (type)
		{
		case S_REVERSE:
		XDrawRectangle (uDisplay, 
			uWindow, ugc, sX, sY,
			uFont->fontWidth-1, 
			uFont->fontHeight-1);
			lastLength = uFont->fontWidth;
		if (uFont->fontWidth-3 > 0 && uFont->fontHeight-3 > 0)
		{
			XFillRectangle (uDisplay, uWindow, ugc,
				sX + 2, sY+2,
				uFont->fontWidth-3,
				uFont->fontHeight-3);
		}
		XDrawRectangle (uDisplay, 
			uWindow, urgc, sX + 1, sY + 1, 
			uFont->fontWidth-3, 
			uFont->fontHeight-3);
		break;

		case S_NORMAL_FILL:
		// Make sure hole is there 
		if (uFont->fontWidth-3 > 0 && uFont->fontHeight-3 > 0)
		{
			XFillRectangle (uDisplay, uWindow, urgc,
				sX+2, sY+2,
				uFont->fontWidth-3,
				uFont->fontHeight-3);
		}
		XDrawRectangle (uDisplay, 
			uWindow, urgc, sX, sY,
			uFont->fontWidth-1, 
			uFont->fontHeight-1);
			lastLength = uFont->fontWidth;
		case S_NORMAL:
		XDrawRectangle (uDisplay, 
			uWindow, ugc, sX+1, sY+1,
			uFont->fontWidth-3, 
			uFont->fontHeight-3);
			lastLength = uFont->fontWidth;
		break;

		case S_ADJUST:
			lastLength = uFont->fontWidth;
		default:
			break;;
		}
		from.coordX += uFont->fontWidth;
		from.posX +=1;
		return lastLength;
	}
	if (fontCacheIn->getDirection() != 0)
	{
		escape[0] = (UCS2) ' '; // avoid infinite loop
		escape[1] = 0;
		escapeFrom.posX = 0;
		escapeFrom.coordX = from.coordX;
		escapeFrom.posY = from.posY;
		escapeFrom.coordY = from.coordY;
		escapeTo.coordX=-1;
		escapeTo.posX=1;
		escapeLen = escapeFrom.coordX;
		lastLength = drawSegment (escapeFrom, escapeTo, escape,
				0, type);
		from.coordX = escapeFrom.coordX;
		from.posX += 1; 
		lastLength = escapeFrom.coordX - escapeLen;
		return  lastLength;
	}

	fontMapStruct = uFont->getFontMapStruct (text[from.posX]);
	for (count=0, i=from.posX, overallWidth=0;
		i<to.posX && text[i]!= 0x2029 && text[i] != 0x2028; 
		i++, count++)
	{
		converted = (fontMapStruct==0) ? text[i]
			: fontMapStruct->encoder->encode (text[i]);
		char2BBuf[count].byte1 = converted >> 8;
		char2BBuf[count].byte2 = converted & 0xff;
		char2BBuf[count+1].byte2 = char2BBuf[count+1].byte1 = 0;

		lastLength = fontCacheIn->getWidth (char2BBuf[count]);

		// we can not draw a zero length char. Try to break
		if (lastLength == 0)
		{
			if (count!=0)
			{
				break;
			}
			// we need to do something..
			return drawSegment (from, to, text, 0, type);
			
		}
		overallWidth += lastLength;
		if (to.coordX >= 0 && overallWidth >= to.coordX - from.coordX)
		{
				count++;
				break;
		}
	}

	switch (type)
	{
	case S_REVERSE:
		fontCacheIn->drawImageString (uDisplay, uWindow, urgc,
			sX, sY,
			uFont->fontAscent,
			char2BBuf, count, pixmapFonts);

		for (i=0; i<uFont->fontAscent - fontCacheIn->getAscent(); i++)
		{
			XDrawLine (uDisplay, uWindow, ugc,
				sX, sY+i, sX+overallWidth-1, sY+i);
		}
		for (i=0; i<uFont->fontDescent - fontCacheIn->getDescent(); i++)
		{
			XDrawLine (uDisplay, uWindow, ugc,
				sX, sY +uFont->fontHeight-i-1,
				sX + overallWidth-1,
				sY + +uFont->fontHeight-i-1);
		}
		break;
	case S_NORMAL_FILL:
		fontCacheIn->drawImageString (uDisplay, uWindow, ugc,
			from.coordX-uX+uBorderSize+uCornerX,
			from.coordY-uY+uBorderSize+uCornerY, uFont->fontAscent,
			char2BBuf, count, pixmapFonts);

		for (i=0; i<uFont->fontAscent - fontCacheIn->getAscent(); i++)
		{
			XDrawLine (uDisplay, uWindow, urgc,
				sX, sY+i,
				sX+overallWidth-1,
				sY+i);
		}
		for (i=0; i<uFont->fontDescent - fontCacheIn->getDescent(); i++)
		{
			XDrawLine (uDisplay, uWindow, urgc,
				sX,
				sY +uFont->fontHeight-i-1,
				sX+overallWidth-1,
				sY +uFont->fontHeight-i-1);
		}
		break;
	case S_NORMAL:
		fontCacheIn->drawString (uDisplay, uWindow, ugc,
			sX, sY, uFont->fontAscent,
			char2BBuf, count, pixmapFonts);
		break;
	case S_ADJUST:
	default:
		break;;
	}
	from.coordX += overallWidth;
	from.posX += count;
	return lastLength;
}

//
// Translate virtual coordinates into text coordinates.
//
void
UWidget::getTextPosition (const int inX0, const int inY0, int* outX, int* outY)
{
	UPoint		startP;
	UPoint		endP;
	int		row;
	int		lastWidth = 0;
	int		inX;
	int		inY;

	*outX = 0;
	*outY = 0;

	if (uFont==0) return;

	inX = inX0 - uCornerX;
	inY = inY0 - uCornerY;

	// make sure dimensions are correct
	if (uFont->isNew())
	{
		uSetCursor (UCursor::WAIT, 1);
		uFont->getFont ();
		clearSelection ();
		uSetCursor (UCursor::INSERT, 1);
	}

	*outX = 0;
	*outY = 0;
	if (uTextSize==0)  return; 
	if (uFont->fontHeight <=0) return; 

	row = (inY+uY-uBorderSize)/uFont->fontHeight;
	if (row < 0) row = 0;

	if (row >= uTextSize)
	{
		row = uTextSize -1;
	}
	*outY = row;
	startP.posX=0;
	startP.coordX=0;
	startP.posY=row;
	endP.coordX = inX + uX - uBorderSize;
	endP.posX = -1;
	lastWidth = drawSegments (startP, endP, D_ADJUST);
	if (lastWidth < 0) return;
	if (startP.posX > 0  && lastWidth > 0 
		&& startP.coordX - endP.coordX > lastWidth/2)
	{
		*outX = startP.posX -1;
		return;
	}
	// can not be behind a separator
	if (startP.posX>0) 
		if (uTextBuffer[row][startP.posX-1] == U_PARA_SEP ||
		uTextBuffer[row][startP.posX-1] == U_LINE_SEP)
	{
		*outX = startP.posX -1;
		return;
	}
	*outX = startP.posX;
	return;
}

//
// Translate text coordinates into virtual coordinates.
//
void
UWidget::getCursorPosition (UCursorBox* pos)
{
	int		lastWidth;
	int		column;
	int		row;
	UPoint		startP;
	UPoint		endP;

	if (uFont==0)
	{
		pos->at.coordX = 0;
		pos->at.coordY = 0;
		pos->before =  pos->at;
		return;
	}

	pos->height = uFont->fontHeight;

	if (uTextSize==0)
	{
		pos->at.coordX = 0;
		pos->at.coordY = 0;
		pos->before =  pos->at;
		return;
	}

	row = (pos->at.posY >= uTextSize && pos->at.posY < 0) 
		? uTextSize-1: pos->at.posY;

	column = (pos->at.posX > uTextSizes[row] || pos->at.posX < 0) 
		? uTextSizes[row] : pos->at.posX;

	startP.posX=0;
	startP.posY=row;
	startP.coordX=0;
	startP.coordY = row * uFont->fontHeight;


	// can not be behind a separator
	if (column>0) if (uTextBuffer[row][column-1] == U_PARA_SEP ||
		uTextBuffer[row][column-1] == U_LINE_SEP)
	{
		column--;
	}

	endP.coordX =-1;
	endP.posX =column;

	lastWidth = drawSegments (startP, endP, D_ADJUST);
	if (lastWidth < 0)
	{
		pos->at.coordX = 0;
		pos->at.coordY = 0;
		pos->before =  pos->at;
		return;
	}
	pos->at = startP;
	pos->before = pos->at;
	if (lastWidth>0 && pos->at.posX > 0)
	{
		pos->before.coordX -= lastWidth;
		pos->before.posX -= 1;
	}
	return;
}

void
UWidget::hideCursor()
{
	UPoint		startP;
	UPoint		endP;

	if (cursorState==US_OFF) return;
	if (uCursorBox.width!=0 && uCursorBox.height!=0
		&& uCursorBox.at.coordX + uCursorBox.width/2 -uX + uBorderSize> 0
		&& uCursorBox.at.coordY + uCursorBox.height -uY + uBorderSize> 0
		&& uCursorBox.at.coordX-uX - uCursorBox.width/2 + uBorderSize< uWidth
		&& uCursorBox.at.coordY-uY + uBorderSize< uHeight)
	{	
		// delete previos cursor
		drawCursor (US_OFF);

		// redraw the string there
		if (uCursorBox.at.posY < uTextSize 
			&& uCursorBox.at.posX <= uTextSizes[uCursorBox.at.posY])
		{
			startP = uCursorBox.before;
			endP = uCursorBox.at;
			// make sure last one gets drawn
			endP.coordX += 1;
			drawVisibleSegments (startP, endP, D_ASNEEDED);
		}
		return;
	}
	cursorState=US_OFF;
}

void
UWidget::drawCursor(UCursorState state)
{
	GC	gcIn;

	if  (editable==CURSOROFF) return;
	gcIn = (state==US_ON) ? ucgc : urgc;
	if (uCursorBox.height==0)
	{
		getCursorPosition (&uCursorBox); 
	}
	if (uCursorBox.at.coordX + uCursorBox.width/2 - uX +uBorderSize > 0
		&& uCursorBox.at.coordY + uCursorBox.height -uY +uBorderSize> 0
		&& uCursorBox.at.coordX -uX -uCursorBox.width/2 +uBorderSize< uWidth
		&& uCursorBox.at.coordY -uY +uBorderSize < uHeight)
	{
		XDrawLine (uDisplay, uWindow, gcIn,
			uCursorBox.at.coordX-uCursorBox.width/2-uX +uBorderSize+uCornerX, uCursorBox.at.coordY-uY +uBorderSize+uCornerY,
			uCursorBox.at.coordX+uCursorBox.width/2-uX +uBorderSize+uCornerX, uCursorBox.at.coordY-uY +uBorderSize+uCornerY);

		XDrawLine (uDisplay, uWindow, gcIn,
			uCursorBox.at.coordX-uCursorBox.width/2-uX +uBorderSize+uCornerX, 
			uCursorBox.at.coordY+uCursorBox.height-uY +uBorderSize-1+uCornerY,
			uCursorBox.at.coordX+uCursorBox.width/2-uX +uBorderSize+uCornerX, 
			uCursorBox.at.coordY+uCursorBox.height-uY +uBorderSize-1+uCornerY);

		XDrawLine (uDisplay, uWindow, gcIn,
			uCursorBox.at.coordX-uX +uBorderSize+uCornerX,  uCursorBox.at.coordY-uY +uBorderSize+uCornerY,
			uCursorBox.at.coordX-uX +uBorderSize+uCornerX, uCursorBox.at.coordY+uCursorBox.height-uY +uBorderSize-1+uCornerY);
	}
	cursorState = state;
}

void
UWidget::uBlinkCursor(const int lastBlink)
{
	if (editable!=EDITABLE && 
		(cursorState==US_ON || cursorState==US_FROZEN_ON))
	{
		return;
	}
	if (lastBlink!=0)
	{
		if (cursorState==US_ON || cursorState==US_FROZEN_ON) return;
		if (cursorState==US_FROZEN_OFF)
		{
			drawCursor(US_ON);
			cursorState=US_FROZEN_ON;
			return;
		}
		drawCursor(US_ON);
		return;
	}
	if (cursorState==US_FROZEN_ON || cursorState==US_FROZEN_OFF) return;
	if (cursorState==US_OFF)
	{
		drawCursor(US_ON);
		return;
	}
	hideCursor();
	cursorState=US_OFF;
}

void
UWidget::uSetCursor (const UCursor::UType type, const int all)
{
	uCursor->setCursor (type, all);
}

UWidget::UStatus
UWidget::uSetInput  (const char *kmap)
{
	UInput::UStatus		status;

	if (underLine[0] != underLine[1])
	{
		uInput->resetState ();
		hideUnderLine();
		underLine[0] = underLine [1];
	}
	uSetCursor (UCursor::WAIT, 1);
	status = uInput->rename (kmap);
	uSetCursor (UCursor::INSERT, 1);
	return ((status==UInput::OK) ? OK: ERROR);
}

UWidget::UStatus
UWidget::uSetFont  (UFont* fontIn)
{
	if (uFont!=0)
	{
		delete uFont;
	}
	if (fontIn->isA (UFont::UX11))
	{
		uFont = new UFontX11 (*((UFontX11*)fontIn));
	}
	else if (fontIn->isA(UFont::UFREE))
	{
	
		uFont = new UFontFreeType (*((UFontFreeType*)fontIn));
	}
	if (pixmapFonts) pixmapFonts->clear();
	return OK;
}

UWidget::UStatus
UWidget::uSetFont  (const char* fontIn)
{
	UFontMap*	fMap;
	UFreeType*	fType;
	int		xPixel;
	UFont::UWeight  xWeight;
	UFont::USlant	xSlant;
	UFont::USpacing	xSpacing;
	UFreeTypeFace*	xFace;
	AString		avgWidth;
	AString		addStyle;

	if (uDisplay==0) return ERROR;

	xPixel = 0;
	xWeight = UFont::ANYWEIGHT;
	xSlant = UFont::ANYSLANT;
	xSpacing = UFont::ANYSPACING;
	fType = 0;
	fMap = UGetFontMap (fontIn);

	if (fMap == 0)
	{
		fType = UGetFreeType (fontIn);
		if (fType==0)
		{
			return ERROR;
		}
	}

	// You should really put back the old one here...
	
	if (uFont!=0)
	{
		xPixel = uFont->getPixel();
		xWeight = uFont->getWeight();
		xSlant = uFont->getSlant();
		xSpacing = uFont->getSpacing();
		avgWidth =  uFont->getAvgWidth();
		addStyle =  uFont->getAddStyle();
		if (fMap==0)
		{
			xFace=fType->getFreeTypeFace (
			  fType->freeTypeWeight (xWeight), 
			  fType->freeTypeSlant (xSlant));
			if (xFace==0) return ERROR;
			if (xFace->flags==UFreeTypeFace::EMPTY) return ERROR;
		}
		delete uFont;
	}

	if (pixmapFonts) pixmapFonts->clear();

	if (fMap!=0)
	{
		uFont = new UFontX11 (fMap, uDisplay, uScreen);
	}
	else
	{
		uFont = new UFontFreeType (fType, uDisplay, uScreen);
	}
	if (underLine[0] != underLine[1])
	{
		hideUnderLine();
		underLine[0]= underLine[1];
	}
	clearSelection();

	if (uFont==0) return ERROR;
	uFont->setPixel(xPixel);
	uFont->setWeight(xWeight);
	uFont->setSlant(xSlant);
	uFont->setSpacing(xSpacing);
	uFont->setAddStyle((const char*) addStyle);
	uFont->setAvgWidth((const char*) avgWidth);
	if (uXInputActive)
	{
		uXInput->uChangeAttributes (UXInput::UFONT);
	}
	return OK;
				
}

UWidget::UStatus
UWidget::uSetFontSize (const int pixel)
{
	if (uFont==0) return ERROR;
	if (underLine[0] != underLine[1])
	{
		hideUnderLine();
		underLine[0]= underLine[1];
	}
	clearSelection();
	if (pixmapFonts) pixmapFonts->clear();
	uFont->setPixel (pixel);
	return OK;
}

UWidget::UStatus
UWidget::uSetFontSlant (const char* slant)
{
	if (uFont==0) return ERROR;
	if (underLine[0] != underLine[1])
	{
		hideUnderLine();
		underLine[0]= underLine[1];
	}
	clearSelection();
	if (pixmapFonts) pixmapFonts->clear();
	uFont->setSlant (slant);
	return OK;
}

UWidget::UStatus
UWidget::uSetFontWeight (const char* weight)
{
	if (uFont==0) return ERROR;
	if (underLine[0] != underLine[1])
	{
		hideUnderLine();
		underLine[0]= underLine[1];
	}
	clearSelection();
	if (pixmapFonts) pixmapFonts->clear();
	uFont->setWeight (weight);
	return OK;
}

UWidget::UStatus
UWidget::uSetFontSpacing (const char* spacing)
{
	if (uFont==0) return ERROR;
	if (underLine[0] != underLine[1])
	{
		hideUnderLine();
		underLine[0]= underLine[1];
	}
	clearSelection();
	if (pixmapFonts) pixmapFonts->clear();
	uFont->setSpacing (spacing);
	return OK;
}

UWidget::UStatus
UWidget::uSetFontAddStyle (const char* addStyle)
{
	if (uFont==0) return ERROR;
	if (underLine[0] != underLine[1])
	{
		hideUnderLine();
		underLine[0]= underLine[1];
	}
	clearSelection();
	if (pixmapFonts) pixmapFonts->clear();
	uFont->setAddStyle (addStyle);
	return OK;
}

UWidget::UStatus
UWidget::uSetFontAvgWidth (const char* avgWidth)
{
	if (uFont==0) return ERROR;
	if (underLine[0] != underLine[1])
	{
		hideUnderLine();
		underLine[0]= underLine[1];
	}
	clearSelection();
	if (pixmapFonts) pixmapFonts->clear();
	uFont->setAvgWidth (avgWidth);
	return OK;
}

UString::UStatus
UWidget::uSetConverter  (const char* nameIn)
{
	if (clipboardActive!=0)
	{
		uClipboardClear ();
	}
	if (uString != 0) delete uString;
	uString = new UString();
	return uString->setConverter(nameIn);
}

void
UWidget::uSetBackground (unsigned long bg)
{
	XSetBackground (uDisplay, ugc, bg);
	XSetBackground (uDisplay, ucgc, bg);
	XSetForeground (uDisplay, urgc, bg);
	XSetWindowBackground (uDisplay, uWindow, bg);
	if (pixmapFonts) pixmapFonts->clear();
	uBackground = bg;
	if (uXInputActive)
	{
		uXInput->uChangeAttributes (UXInput::UBACKGROUND);
	}
}

void
UWidget::uSetCursorColor (unsigned long cr)
{
	XSetForeground (uDisplay, ucgc, cr);
	uCursorColor = cr;
}

void
UWidget::uSetEditable (const UEditable editableIn)
{
	if (editable != editableIn)
	{
		switch (editableIn)
		{
		case	VIEW: // view - cut ok, paste nok
			break;

		case	CURSOROFF: // no cut no paste no edit
			clearSelection();
			hideCursor ();		
			break;

		case 	EDITABLE: // everything ok.
			break;
		}
	}
	editable = editableIn;
}

void
UWidget::uSetMultiLine (const UMultiLine multiLineIn)
{
	multiLine = multiLineIn;
}


void
UWidget::uSetForeground (unsigned long fg)
{
	XSetForeground (uDisplay, ugc, fg);
	XSetBackground (uDisplay, urgc, fg);
	uForeground = fg;
	if (uXInputActive)
	{
		uXInput->uChangeAttributes (UXInput::UFOREGROUND);
	}
	if (pixmapFonts) pixmapFonts->clear();
}

UWidget::UStatus
UWidget::uClear  ()
{
	modified = 1;
	if (underLine[0] != underLine[1])
	{
		uInput->resetState ();
		uDeleteText (underLine[0], underLine[1]);
		hideUnderLine();
		underLine[0] = underLine [1];
	}
	reversePoints[0].posX=-1;
	reversePoints[1] = reversePoints[0];
	clearSelection();
	if (uTextSize)
	{
		 while (--uTextSize)
		{
			if (uTextBuffer[uTextSize] != 0) 
				delete uTextBuffer[uTextSize];
		}
	}
	if (uTextBuffer) delete uTextBuffer;
	if (uTextSizes) delete uTextSizes;
	if (uTextTabSizes) delete uTextTabSizes;
	if (uTextCtrlSizes) delete uTextCtrlSizes;
	uTextBuffer = 0;
	uTextSizes = 0;
	uTextTabSizes = 0;
	uTextCtrlSizes = 0;
	uTextBufferSize = 0;
	uSetCursorXY (0, 0);
	return OK;
}

void
UWidget::uHandleEvent (XEvent *event)
{
	XEvent			newEvent;
	XEvent			peekEvent;
	XEvent*			lastEvent;
	char			asci[16];
	int			count;
	KeySym			key;
	int			activeFlag;
	UKey			ukey;
	unsigned char*		chars;
	int			cliplen;

	switch (event->type)
	{
	case ConfigureNotify:
		uResize (event->xconfigure.width-2*uCornerX, 
			event->xconfigure.height-2*uCornerY,
			uCornerX, uCornerY);
		break;
	case Expose:
		uRedraw (event->xexpose.x, 
			event->xexpose.y,
			event->xexpose.width,
			event->xexpose.height);
		break;
	case GraphicsExpose:
		uRedraw (event->xgraphicsexpose.x, 
			event->xgraphicsexpose.y,
			event->xgraphicsexpose.width,
			event->xgraphicsexpose.height);
		break;
	case KeyRelease:
		count = XLookupString( &event->xkey, asci, 16, &key, 0 );
		hasKeyRelease = 1;
		if (key==XK_Control_L || key==XK_Control_R ||
			key==XK_Alt_L || key==XK_Alt_R)
		{
			endSelection (
			   uCursorBox.at.coordX, uCursorBox.at.coordY,
			   uCursorBox.at.posX, uCursorBox.at.posY);
		}
		break;
	case KeyPress:
		count = XLookupString( &event->xkey, asci, 16, &key, 0 );
		activeFlag = uXInputActive;

		// This is provided if uXInput dies.
		if (event->xkey.state & ControlMask) switch(key)
		{
		case XK_X: 
		case XK_x: 
			if (uXInput==0)
			{
				cerr << "warn: uXInput is not set.\n";
				break;
			}
			if (event->xkey.send_event) break;
			if (activeFlag)
			{
				uXInput->uEnd ();
			}
			else
			{
				if (underLine[0] != underLine[1])
				{
					uInput->resetState ();
					hideUnderLine();
					underLine[0] = underLine [1];
				}
				uXInput->uStart();
			}
			break;
		case XK_P: 
		case XK_p: 
			if (startDrag>0)
			{
				return;
			}
			chars = uClipboardGet(&cliplen);
			uInsertText (chars, cliplen, 1, 0);
			uSetFullSize ();
			uSetCursorViewable();
			delete chars;
			return;
			break;
		default:
			break;
		}
		if (startDrag>0) switch (key)
		{
		case XK_Up:
		case XK_Down:
		case XK_Left:
		case XK_Right:
		case XK_Prior:
		case XK_Next:
		case XK_Home:
		case XK_End:
		case XK_KP_Enter:
		case XK_Return:
			break;
		default:
			return;
		}

		// Process send events only if uXInputActive
		if (activeFlag && !event->xkey.send_event && key!=XK_Escape) break;

		// Get control characters
		switch (key)
		{
		case XK_Control_L:
		case XK_Control_R:
		case XK_Alt_L:
		case XK_Alt_R:
			if (hasKeyRelease && startDrag==0)
			{
				startSelection (
				   uCursorBox.at.coordX, uCursorBox.at.coordY,
			   	uCursorBox.at.posX, uCursorBox.at.posY);
				startDrag = -1;
			}
			break;

		case XK_Tab:

			asci[0] = '\t';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_Left:
			ukey = (startDrag) ? UK_CNTRL_LEFT : UK_LEFT;
			uProcKeyPressEvent (ukey, (const int) asci[0]);
			break;
		case XK_Right:
			ukey = (startDrag) ? UK_CNTRL_RIGHT : UK_RIGHT;
			uProcKeyPressEvent (ukey, (const int) asci[0]);
			break;
		case XK_Up:
			ukey = (startDrag) ? UK_CNTRL_UP : UK_UP;
			uProcKeyPressEvent (ukey, (const int) asci[0]);
			break;
		case XK_Down:
			ukey = (startDrag) ? UK_CNTRL_DOWN : UK_DOWN;
			uProcKeyPressEvent (ukey, (const int) asci[0]);
			break;
		case XK_Prior:
			ukey = (startDrag) ? UK_CNTRL_PRIOR : UK_PRIOR;
			uProcKeyPressEvent (ukey, (const int) asci[0]);
			break;
		case XK_Next:
			ukey = (startDrag) ? UK_CNTRL_NEXT : UK_NEXT;
			uProcKeyPressEvent (ukey, (const int) asci[0]);
			break;
		case XK_Return:
			if (startDrag)
			{
				if (event->xkey.state & ControlMask)
				{
					uProcKeyPressEvent (UK_CNTRL_RETURN, 
						(const int) asci[0]);
				}
				startSelection (
			   		uCursorBox.at.coordX, 
					uCursorBox.at.coordY,
			   		uCursorBox.at.posX, 
					uCursorBox.at.posY);
				startDrag = -1;
			}
			else if ( event->xkey.state & ShiftMask)
			{
				uProcKeyPressEvent (UK_SHIFT_RETURN, 
					(const int) asci[0]);
			}
			// Never happens
			else if (event->xkey.state & ControlMask)
			{
				uProcKeyPressEvent (UK_CNTRL_RETURN, 
					(const int) asci[0]);
			}
			else
			{
				uProcKeyPressEvent (UK_RETURN, 
					(const int) asci[0]);
			}
			break;
		case XK_Home:
			ukey = (startDrag) ? UK_CNTRL_HOME : UK_HOME;
			uProcKeyPressEvent (ukey, (const int) asci[0]);
			break;
		case XK_End:
			ukey = (startDrag) ? UK_CNTRL_END : UK_END;
			uProcKeyPressEvent (ukey, (const int) asci[0]);
			break;
		case XK_Delete:
			if (startDrag)
			{
				break;
			}
			uProcKeyPressEvent (UK_DELETE, (const int) asci[0]);
			break;
		case XK_Clear:
		case XK_BackSpace:
			if (startDrag)
			{
				break;
			}
			uProcKeyPressEvent (UK_BACKSPACE, (const int) asci[0]);
		case XK_Insert:
		case XK_Pause:
		case XK_Print:
		case 0x1005FF60:
		case 0x1007ff00:
		case XK_Shift_L:
		case XK_Shift_R:
		case XK_Shift_Lock:
		case XK_Meta_L:
		case XK_Meta_R:
		case XK_Caps_Lock:
		case XK_Num_Lock:
		case XK_Scroll_Lock:
			break;
		case XK_KP_Space:
			asci[0] = ' ';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_KP_Tab:
			asci[0] = '\t';
			   uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_KP_Enter:
			if (startDrag)
			{
				if ( event->xkey.state & ControlMask)
				{
					uProcKeyPressEvent (UK_CNTRL_RETURN, 
						(const int) asci[0]);
				}
				startSelection (
			   		uCursorBox.at.coordX, 
					uCursorBox.at.coordY,
			   		uCursorBox.at.posX, 
					uCursorBox.at.posY);
				startDrag = -1;
			}
			else if ( event->xkey.state & ShiftMask)
			{
				uProcKeyPressEvent (UK_SHIFT_RETURN, 
					(const int) asci[0]);
			}
			// Never happens
			else if (event->xkey.state & ControlMask)
			{
				uProcKeyPressEvent (UK_CNTRL_RETURN, 
					(const int) asci[0]);
			}
			else
			{
				uProcKeyPressEvent (UK_RETURN, 
					(const int) asci[0]);
			}
			break;
		case XK_KP_Equal:
			asci[0] = '=';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_KP_Multiply:
			asci[0] = '*';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_KP_Add:
			asci[0] = '+';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_KP_Separator:
			break;
		case XK_KP_Subtract:
			asci[0] = '-';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_KP_Decimal:
			break;
		case XK_KP_Divide:
			asci[0] = '/';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_KP_0:
			asci[0] = '0';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_KP_1:
			asci[0] = '1';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_KP_2:
			asci[0] = '2';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_KP_3:
			asci[0] = '3';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_KP_4:
			asci[0] = '4';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_KP_5:
			asci[0] = '5';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_KP_6:
			asci[0] = '6';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_KP_7:
			asci[0] = '7';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_KP_8:
			asci[0] = '8';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_KP_9:
			asci[0] = '9';
			uProcKeyPressEvent (UK_ASCII, (const int) asci[0]);
			break;
		case XK_Escape:
			if (uXInput!=0)
			{
				if (event->xkey.send_event) break;
				if (uXInputActive)
				{
					uXInput->uEnd ();
				}
				else
				{
					if (underLine[0] != underLine[1])
					{
						uInput->resetState ();
						hideUnderLine();
						underLine[0] = underLine [1];
					}
					uXInput->uStart();
				}
				break;
			}
		default:
			if (count==1)
			{
				if (event->xkey.state & ControlMask) switch(key)
				{
				// Processed Already.
				case XK_X: 
				case XK_x: 
					break;
				default:
					uProcKeyPressEvent (UK_ASCII, 
						(const int) asci[0]);
				}
				if ((event->xkey.state & ControlMask)==0)
				{
					uProcKeyPressEvent (UK_ASCII, 
						(const int) asci[0]);
				}
			}
			break;
		}
		break;
	case ButtonPress:
		if (event->xbutton.button == Button1)
		{
			uProcMousePressEvent (UB_LEFT, event->xbutton.x, 	
				event->xbutton.y);
		}
		if (event->xbutton.button == Button2)
		{
			uProcMousePressEvent (UB_MIDDLE, event->xbutton.x, 	
				event->xbutton.y);
		}
		break;
	case ButtonRelease:
		if (event->xbutton.button == Button1)
		{
			uProcMouseReleaseEvent (UB_LEFT, event->xbutton.x, 	
				event->xbutton.y);
		}
		if (event->xbutton.button == Button2)
		{
			uProcMouseReleaseEvent (UB_MIDDLE, event->xbutton.x, 	
				event->xbutton.y);
		}
		break;
	case MotionNotify:
		if (event->xmotion.state & Button1MotionMask)
		{
			lastEvent = event;
			// Event compression
			while (XEventsQueued (uDisplay, QueuedAfterFlush))
			{
				XPeekEvent (uDisplay, &peekEvent); 
				if (peekEvent.type == MotionNotify
					&& peekEvent.xmotion.window == uWindow
					&& peekEvent.xmotion.state == event->xmotion.state)
				{
					XNextEvent (uDisplay, &newEvent);
					lastEvent = &newEvent;
				}
				else
				{
					break;
				}
			}
			uProcMouseMotionEvent (UB_LEFT, lastEvent->xmotion.x,
				lastEvent->xmotion.y);
		}
		break;
	case SelectionClear:
		break;
	case SelectionNotify:
		break;
	case SelectionRequest:
		break;
	}
	return;
}

void
UWidget::uSetFullSize()
{
	int	newWidth = 0;
	int	newHeight = 0;
	int	maxWidth =0;
	int	newSize;
	int	i;

	// get approximate size of the widget
	if (uFont==0) return;
	// make sure dimensions are correct
	if (uFont->isNew())
	{
		uSetCursor (UCursor::WAIT, 1);
		uFont->getFont ();
		clearSelection ();
		uSetCursor (UCursor::INSERT, 1);
	}
	newHeight = uTextSize * uFont->fontHeight + uBorderSize * 2;
	for (i=0; i<uTextSize; i++)
	{
		newSize = uFont->fontWidth * (uTextSizes[i] + uTextCtrlSizes[i]
			   + (tabSize-1) * uTextTabSizes[i]);
		if (maxWidth < newSize) maxWidth = newSize;
	}
	newWidth = maxWidth;
	uFullHeight = newHeight;
	if (uHeight != 0)
	{
		uSetVScroll (-1, uFont->fontAscent+uFont->fontDescent, uHeight, uFullHeight);
	}
	uFullWidth = newWidth + uBorderSize*2;
	if (uWidth != 0)
	{
		uSetHScroll (-1, uFont->minFontWidth, uWidth, uFullWidth);
	}
}

void
UWidget::uResize (const int widthIn, const int heightIn, 
	const int cornerXIn, const int cornerYIn)
{
	XRectangle	clipRect;
	int		newHeight;
	int		oldHeight;
	int		oldCornerY;

	newHeight = heightIn-uXInputHeight;
	if (newHeight<0) newHeight=1; 
	if (uWidth == widthIn 
		&& uCornerX == cornerXIn
		&& uHeight == newHeight
		&& uCornerY == cornerYIn)
	{
		return;
	}
	oldCornerY = uCornerY;
	oldHeight = uHeight;
	uHeight = newHeight;
	uWidth = widthIn;
	uCornerX = cornerXIn;
	uCornerY = cornerYIn;
	clipRect.x = uCornerX;
	clipRect.y = uCornerY;
	clipRect.width = uWidth;
	clipRect.height = uHeight;

	XSetClipRectangles (uDisplay, ugc,
		0, 0, 
		&clipRect, 1, Unsorted);

	XSetClipRectangles (uDisplay, urgc,
		0, 0, 
		&clipRect, 1, Unsorted);

	XSetClipRectangles (uDisplay, ucgc,
		0, 0, 
		&clipRect, 1, Unsorted);

	uSetFullSize ();
	if (uXInputActive) 
	{
		uXInput->uChangeAttributes (UXInput::UAttribute (UXInput::UCLIENT_AREA | UXInput::USTATUS_AREA));
		uSetCursorViewable ();
	}
	if (uHeight + uCornerY > oldHeight + oldCornerY)
	{
		XClearArea (uDisplay, uWindow, uCornerX, 
				oldHeight+oldCornerY, uWidth, 
				uHeight-oldHeight +uCornerY -oldCornerY,True);
	}
}

void
UWidget::uHScroll (int value)
{
	int	diff;
	if (uX == value) return;
	// move and redraw
	diff = uX-value;
	uX = value;
	if (diff > 0)
	{
		// scroll left
		if (uWidth - diff > 0)
		{
			XCopyArea (uDisplay, uWindow, uWindow,
				ugc, uCornerX, uCornerY, 
				uWidth-diff, uHeight, 
				diff+uCornerX, uCornerY);
			XClearArea (uDisplay, uWindow, 
				uCornerX, uCornerY, diff, uHeight, False);
			uRedraw (uCornerX, uCornerY, diff, uHeight);
		}
		else
		{
			XClearArea (uDisplay, uWindow, 
				uCornerX, uCornerY, uWidth, uHeight, False);
			uRedraw (uCornerX, uCornerY, uWidth, uHeight);
		}
	}
	else
	{
		// scroll right
		if (uWidth + diff > 0)
		{
			XCopyArea (uDisplay, uWindow, uWindow, 
				ugc, -diff+uCornerX, uCornerY, 
				uWidth+diff, uHeight, 
				uCornerX, uCornerY);
			XClearArea (uDisplay, uWindow, 
				uWidth+diff+uCornerX, uCornerY, 
				-diff, uHeight, False);
			uRedraw (uWidth+diff+uCornerX, uCornerY, -diff, uHeight);
		}
		else
		{
			XClearArea (uDisplay, uWindow, 
				uCornerX, uCornerY, uWidth, uHeight, False);
			uRedraw (uCornerX, uCornerY, uWidth, uHeight);
		}
	}
}

void
UWidget::uVScroll (int value)
{
	int	diff;
	if (uY == value) return;
	diff = uY-value;
	uY = value;
	if (diff > 0)
	{
		// scroll down
		if (uHeight - diff > 0)
		{
			XCopyArea (uDisplay, uWindow, uWindow, 
				ugc, uCornerX, uCornerY, 
				uWidth, uHeight-diff, 
				uCornerX, diff+uCornerY);
			XClearArea (uDisplay, uWindow, 
				uCornerX, uCornerY, uWidth, diff, False);
			uRedraw (uCornerX, uCornerY, uWidth, diff);
		}
		else
		{
			XClearArea (uDisplay, uWindow, 
				uCornerX, uCornerY, uWidth, uHeight, False);
			uRedraw (uCornerX, uCornerY, uWidth, uHeight);
		}
	}
	else
	{
		// scroll up
		if (uHeight + diff > 0)
		{
			XCopyArea (uDisplay, uWindow, uWindow, 
				ugc, uCornerX, uCornerY-diff, 
				uWidth, uHeight+diff, 
				uCornerX, uCornerY);
			XClearArea (uDisplay, uWindow, 
				uCornerX, uHeight+diff+uCornerY, uWidth, -diff, False);
			uRedraw (uCornerX, uHeight+diff+uCornerY, uWidth, -diff);
		}
		else
		{
			XClearArea (uDisplay, uWindow, 
				uCornerX, uCornerY, uWidth, uHeight, False);
			uRedraw (uCornerX, uCornerY, uWidth, uHeight);
		}
	}
}

void
UWidget::uSetVScroll (int value, int step, int page, int max)
{
	uVScroll (value);
}

void
UWidget::uSetHScroll (int value, int step, int page, int max)
{
	uHScroll (value);
}

void
UWidget::uRefresh ()
{
	XWindowAttributes	xwa;


	uSetFullSize();
	getCursorPosition (&uCursorBox); 
	if (XGetWindowAttributes (uDisplay, uWindow, &xwa) && xwa.map_state == IsViewable)
	{
		XClearArea (uDisplay, uWindow, uCornerX, uCornerY, uWidth, uHeight, True);
	}
}

void
UWidget::uRedraw (const int xIn0, const int yIn0, 
		const int widthIn, const int heightIn)
{
	UPoint			startP;
	UPoint			endP;
	int			lastWidth;
	int			xIn;
	int			yIn;
	

	if (uFont==0) return;
	xIn = xIn0 - uCornerX;
	yIn = yIn0 - uCornerY;

	// make sure dimensions are correct
	if (uFont->isNew())
	{
		uSetCursor (UCursor::WAIT, 1);
		uFont->getFont ();
		clearSelection ();
		uSetCursor (UCursor::INSERT, 1);
	}
	if (uFont->fontHeight == 0) return;

	startP.posY = (yIn + uY - uBorderSize)/uFont->fontHeight;
	if (startP.posY < 0) startP.posY = 0;
	
	endP.posX=-1;

	// Draw line by line
	for (startP.coordY = startP.posY * uFont->fontHeight; 
		startP.posY < uTextSize 
		&& startP.coordY-uY+uBorderSize <= yIn + heightIn; 
		startP.coordY += uFont->fontHeight, 
		startP.posY++ )
	{
		// start from zero...
		startP.coordX = 0;
		startP.posX = 0;
		endP.coordX=xIn+uX-uBorderSize;

		//Use it later to adjust the coordinates
		lastWidth=drawSegments (startP, endP, D_ADJUST);
		if (lastWidth < 0) continue;
		if (startP.posX >0)
		{
			// draw half visible segments
			startP.posX--;
			startP.coordX -= lastWidth;
		}
		endP.coordX=xIn+widthIn+uX+uBorderSize;

		while (startP.posX < uTextSizes[startP.posY] 
			&& startP.coordX < endP.coordX)
		{
			lastWidth = drawSegments (startP, endP, D_ASNEEDED);
			if (lastWidth < 0) break;
		}
			
		// Clear till the end of row.
		if (startP.posX == uTextSizes[startP.posY]
			&& startP.coordX < uWidth+uX-uBorderSize)
		{
			if (reversePoints[reverseP] <= startP &&
				reversePoints[reverseP^1] > startP)
			{
				XFillRectangle (uDisplay, uWindow, ugc,
					startP.coordX-uX+uBorderSize+uCornerX, 
					startP.coordY-uY+uBorderSize+uCornerY, 
					endP.coordX-(startP.coordX-uX+uBorderSize),
					uFont->fontHeight);
			}
			else
			{
				XFillRectangle (uDisplay, uWindow, urgc,
					startP.coordX-uX+uBorderSize+uCornerX, 
					startP.coordY-uY+uBorderSize+uCornerY, 
					endP.coordX-(startP.coordX-uX+uBorderSize),
					uFont->fontHeight);
			}
		}
	}
	if (cursorState == US_ON || cursorState == US_FROZEN_ON)
	{
		drawCursor (US_ON);
	}
}

void
UWidget::uInsertLineUCS2 (UPoint& currentP, const UCS2 *text, 
	const int from, const int to, const int newLine)
{
	UCS2**		newBuffer;
	int*		newSizes;
	int*		newTabSizes;
	int*		newCtrlSizes;
	UCS2*		newTextBuffer;
	int		newSize;
	int		len;
	int		i;
	int		newTabs;
	int		newCtrls;
	int		endPart;

	clearSelection ();
	modified = 1;

	// make sure we have at least one more line
	if (uTextSize == uTextBufferSize) 
	{
		newSize = (uTextBufferSize==0) ?  1 : uTextBufferSize << 1;
		newBuffer =  new UCS2*[newSize];
		CHECKNULL (newBuffer);
		newSizes = new int [newSize];
		CHECKNULL (newSizes);
		newTabSizes = new int [newSize];
		CHECKNULL (newTabSizes);
		newCtrlSizes = new int [newSize];
		CHECKNULL (newCtrlSizes);
		if (uTextBufferSize != 0)
		{
			memcpy (newBuffer, uTextBuffer, 
				uTextSize * sizeof (UCS2 *));
			delete uTextBuffer;

			memcpy (newSizes, uTextSizes,
				uTextSize * sizeof (int));
			delete uTextSizes;

			memcpy (newTabSizes, uTextTabSizes,
				uTextSize * sizeof (int));
			delete uTextTabSizes;

			memcpy (newCtrlSizes, uTextCtrlSizes,
				uTextSize * sizeof (int));
			delete uTextCtrlSizes;
		}
		uTextBuffer = newBuffer;
		uTextSizes = newSizes;
		uTextTabSizes = newTabSizes;
		uTextCtrlSizes = newCtrlSizes;
		uTextBufferSize = newSize;
	}
	uTextBuffer[uTextSize] = 0;
	uTextSizes[uTextSize] = 0;
	uTextTabSizes[uTextSize] = 0;
	uTextCtrlSizes[uTextSize] = 0;

	// open new line
	if (newLine!=0)
	{
		// move lines below
		if (uTextSize>0) currentP.posY++;
		for (i=uTextSize; i>currentP.posY; i--)
		{
			uTextBuffer[i] = uTextBuffer[i-1];
			uTextSizes[i] = uTextSizes[i-1];
			uTextTabSizes[i] = uTextTabSizes[i-1];
			uTextCtrlSizes[i] = uTextCtrlSizes[i-1];
		}
		
		endPart = 0;
		if (uTextSize>0)
		{
			endPart = uTextSizes[currentP.posY-1] - currentP.posX;
		}
		if (endPart < 0) endPart = 0;
		uTextBuffer[currentP.posY] = new UCS2 [to-from + 1 + endPart];
		CHECKNULL (uTextBuffer[currentP.posY]);
		newTabs = 0;
		newCtrls = 0;
		if (endPart>0)
		{
			for (i=0; i<endPart; i++)
			{
				uTextBuffer[currentP.posY][i+to-from] =
					uTextBuffer[currentP.posY-1][currentP.posX+i];
				if (uTextBuffer[currentP.posY][i+to-from] 
					== (UCS2) '\t')
				{
					 newTabs++;
				}
				else if (uTextBuffer[currentP.posY][i+to-from] < ' ')
				{
					 newCtrls++;
				}
			}
			// should I free it up ?
			uTextBuffer[currentP.posY-1][currentP.posX] = 0;
			uTextTabSizes[currentP.posY-1] -= newTabs;
			uTextCtrlSizes[currentP.posY-1] -= newCtrls;
			uTextSizes[currentP.posY-1] -=  endPart;
		}
		for (i=from; i<to; i++)
		{
			uTextBuffer[currentP.posY][i-from] = text[i];
			if (text[i] == (UCS2) '\t')
			{
				 newTabs++;
			}
			else if (text[i] < ' ')
			{
				 newCtrls++;
			}
		}
		uTextBuffer[currentP.posY][to-from+endPart] = 0;
		uTextSizes[currentP.posY] = to-from+endPart;
		uTextTabSizes[currentP.posY] = newTabs;
		uTextCtrlSizes[currentP.posY] = newCtrls;
		uTextSize++;
		currentP.posX=to-from;
		return;
	}

	if (from >= to) return;

	// No need to insert new line
	newTextBuffer= new UCS2[uTextSizes[currentP.posY] + to -from +1];
	CHECKNULL (newTextBuffer);

	// move things up - without zero termination
	len = uTextSizes[currentP.posY]+to-from;

	// Begin
	if (currentP.posX > 0)
	{
		memcpy (newTextBuffer, uTextBuffer[currentP.posY], 
			currentP.posX * sizeof (UCS2));
	}
	newTabs = 0;
	newCtrls = 0;
	// Text
	for (i=from; i<to; i++)
	{
		newTextBuffer[i-from+currentP.posX] = text[i];
		if (text[i] == (UCS2) '\t')
		{
			newTabs++;
		}
		else if (text[i] < ' ')
		{
			newCtrls++;
		}
	}
	// After text
	if (currentP.posX != uTextSizes[currentP.posY])
	{
		memcpy (&newTextBuffer[currentP.posX+to-from], 
			&uTextBuffer[currentP.posY][currentP.posX],
			(uTextSizes[currentP.posY] - currentP.posX) 
			 * sizeof (UCS2));
	}
	// Null
	newTextBuffer[to-from + uTextSizes[currentP.posY]] = 0;

	uTextSizes[currentP.posY] += to-from;
	if (uTextBuffer[currentP.posY]!=0) delete uTextBuffer[currentP.posY];
	uTextBuffer[currentP.posY] = newTextBuffer;
	uTextTabSizes[currentP.posY] += newTabs;
	uTextCtrlSizes[currentP.posY] += newCtrls;
	currentP.posX += to-from;
	if (uTextSize==0) uTextSize=1;
	return;
}

void
UWidget::startSelection (const int coordXIn, const int coordYIn,
	const int xIn, const int yIn)
{
	clearSelection ();
	dragPoint.posX = xIn;
	dragPoint.posY = yIn;
	dragPoint.coordX = coordXIn;
	dragPoint.coordY = coordYIn;

	// 1 is always the last 
	// this is the small
	startDrag = 0;
	reverseP = 0;
}
void
UWidget::continueSelection (const int coordXIn, const int coordYIn,
	const int xIn, const int yIn)
{
	UPoint		startP;
	UPoint		endP;
	UPoint		newP;
	int		newReverseP;

	newP.posX = xIn;
	newP.posY = yIn;
	newP.coordX = coordXIn;
	newP.coordY = coordYIn;

	// This is the real start of drag
	if (startDrag <= 0)
	{
		startDrag = 1;
		reversePoints[0] = dragPoint;
		reversePoints[1] = dragPoint;
		newReverseP = 0;
	}

	// no change since last time
	if (reversePoints[1] == newP) return;

	newReverseP = (reversePoints[0] > newP) ? 1 : 0;

	if (reversePoints[1] < newP)
	{
		// select forward
		// do we need to delete previous selection?
		if (reverseP == 1)
		{
			startP = reversePoints[1];
			endP = (newReverseP==1) ? newP : reversePoints[0];
			drawVisibleSegments (startP, endP, D_NORMAL_FILL, 0);
		}
		// add new selection
		if (newReverseP==0) 
		{
			startP = (reverseP==0) 
				? reversePoints[1] : reversePoints[0];
			endP = newP;
			drawVisibleSegments (startP, endP, D_REVERSE, 0);
		}
	}
	else
	{
		// select backward
		// do we need to delete previous selection?
		if (reverseP==0)
		{
			startP = (newReverseP==0) ? newP :  reversePoints[0];
			endP = reversePoints[1];
			drawVisibleSegments (startP, endP, D_NORMAL_FILL,0);
		}
		// add new selection
		if (newReverseP==1) 
		{
			startP = newP;
			endP = (reverseP==1) 
				? reversePoints[1] : reversePoints[0];
			drawVisibleSegments (startP, endP, D_REVERSE, 0);
		}
	}
	reverseP = newReverseP;
	reversePoints[1] = newP;
}

void
UWidget::endSelection (const int coordXIn, const int coordYIn,
	const int xIn, const int yIn)
{
	UCS2*			ucs2;
	int			row;
	int			col;
	int			count;
	unsigned char*		bytes;
	int			byteLen;

	if (startDrag<=0)
	{
		startDrag = 0;
		return;
	}
	if (uTextSizes == 0)
	{
		startDrag = 0;
		return;
	}
	if (reversePoints[0].posX <0)
	{
		clearSelection();
		startDrag = 0;
		return;
	}
	continueSelection (coordXIn, coordYIn, xIn, yIn);
	startDrag = 0;

	// enhancements = store the cutbuffer and if selection changes
	// (new converter - reconvert
	if (reversePoints[reverseP] == reversePoints[reverseP^1])
	{
		return;
	}

	// put selection into cutbuffer - if there is text
	if (uString==0)
	{
		cerr << "warn: no converter set up for cut and paste.\n";
		return;
	}

	count=0;
	for (row=reversePoints[reverseP].posY; 
		row <= reversePoints[reverseP^1].posY; row++)
	{
		// cludge
		if (row > uTextSize || row < 0) break;
		for (col = (row == reversePoints[reverseP].posY) 
			? reversePoints[reverseP].posX : 0;
		   col < ((row == reversePoints[reverseP^1].posY)
			? reversePoints[reverseP^1].posX : uTextSizes[row]);
			col++)
	
		{
			if (col > uTextSizes[row] || col < 0) break;
			count++;
		}
		count++;
	}
	ucs2 = new UCS2[count];
	CHECKNULL (ucs2);
	count = 0;
	for (row=reversePoints[reverseP].posY; 
		row <= reversePoints[reverseP^1].posY; row++)
	{
		if (row > uTextSize || row < 0) break;
		for (col = (row == reversePoints[reverseP].posY) 
			? reversePoints[reverseP].posX : 0;
		   col < ((row == reversePoints[reverseP^1].posY)
			? reversePoints[reverseP^1].posX : uTextSizes[row]);
			col++)
	
		{
			if (uTextSize<= row || col > uTextSizes[row] || col < 0) break;
			ucs2[count++] = uTextBuffer[row][col];
		}
		if (count <=0 || (ucs2[count-1] != U_PARA_SEP  &&
				ucs2[count-1] != U_LINE_SEP))
		{
			ucs2[count++] = (UCS2) '\n';
		}
	}
	if (count>0 && ucs2[count-1] == (UCS2) '\n')
	{
		count--;
	}
	ucs2[count] = 0;
	uString->putUString (ucs2, count);
	bytes = uGetMarkedText(&byteLen);
	clipboardActive=1;
	uClipboardPut (bytes, byteLen);

	delete bytes;
	delete ucs2;
}

//
// This one is not supposed to remove the text from the textbuffer
//
void
UWidget::clearSelection ()
{	
	if (reversePoints[0].posX != -1)
	{
		drawVisibleSegments (reversePoints[reverseP], 
			reversePoints[reverseP^1], D_NORMAL_FILL);
	}
	reversePoints[0].posX=-1;
	reversePoints[0].coordX=-1;
	reversePoints[0].posY=-1;
	reversePoints[0].coordY=-1;
	reversePoints[1] = reversePoints[0];
}

unsigned char*
UWidget::uGetMarkedText(int* bytelen)
{
	unsigned char* bytes;
	if (uString==0) return 0;
	bytes =  uString->getString (bytelen);
	if (bytes == 0)
	{
		cerr << "error: count not encode selection";
	}
	return bytes;
}

// You need to free this up
unsigned char*
UWidget::uGetLine (const int lineNo, int* clen)
{
	if (lineNo< 0 || lineNo>= uTextSize) return 0;
	if (uString ==0) return 0;
	uString->putUString ((UCS2*) uTextBuffer[lineNo], uTextSizes[lineNo]);
	return  uString->getString (clen);
}

unsigned char*
UWidget::uGetBuffer (int* buflen)
{
	int		i;
	int		len;
	int		index;
	UCS2*		retVle;
	unsigned char* 	retChar;

	// get the buffer size.
	len = 0;
	for (i=0; i<uTextSize; i++)
	{
		len+=uTextSizes[i];
		len++;
	}
	retVle = new UCS2[len+1];
	CHECKNULL (retVle);
	
	index=0;
	for (i=0; i<uTextSize; i++)
	{
		if (uTextSizes[i]>0)
		{
			memcpy (&retVle[index], uTextBuffer[i], 
				uTextSizes[i] * sizeof(UCS2));
		}
		index+=uTextSizes[i];
		if (index<=0 || (retVle[index-1] != U_LINE_SEP &&
			retVle[index-1] != U_PARA_SEP))
		{
			retVle[index++] = '\n';
		}
	}
	if (i>0 && uTextSizes[i-1] == 0)
	{
		if (retVle[index-1]=='\n') index--;
	}
	retVle[index]=0;
	uString->putUString ((UCS2*) retVle, index);
	delete (retVle);
	retChar =  uString->getString (buflen);
	uString->putUString ((UCS2*) 0, 0);
	return retChar;
}

void
UWidget::uAppendText (const unsigned char *text, const int _length,
	const int moveCursor, const int newLine)
{
	UCursorBox	saveBox;

	if (moveCursor == 0)
	{
		saveBox = uCursorBox;
		uCursorBox.at.posX = 0;
		uCursorBox.at.posY = 0;
		if (uTextSize>0)
		{
			uCursorBox.at.posX = uTextSizes[uTextSize-1];
			uCursorBox.at.posY = uTextSize-1;
		}
		uCursorBox.at.coordX = 0;
		uCursorBox.at.coordY = 0;
	}
	else
	{
		if (uTextSize!=0)
		{
			uSetCursorXY (uTextSizes[uTextSize-1],
				uTextSize-1);
		}
	}
	uInsertText (text, _length, moveCursor, newLine);
	if (moveCursor==0) uCursorBox = saveBox;
}

void
UWidget::uDeleteText (const UPoint& from, const UPoint& to)
{
	int		i;
	int		count;
	UCS2*		newText;
	int		newTextSize;
	int		newTabs;
	int		newCtrls;
	UPoint		startP;
	UPoint		endP;
	UCursorState	saveState;
	int		endText;

	modified = 1;
	
	// the length of the new line is equal to the joint length
	saveState = cursorState;

	// No chance to redraw it automatically
	if ((saveState == US_ON || saveState ==US_FROZEN_ON) && to.posX==0)
	{
		drawCursor (US_OFF);
	}

	newTextSize = from.posX + uTextSizes[to.posY] - to.posX;
	newText = new UCS2 [newTextSize+1];
	newTabs = 0;
	newCtrls = 0;
	count = 0;
	for (i=0; i<from.posX; i++)
	{
		newText[count] = uTextBuffer[from.posY][i];
		if (newText[count] == (UCS2) '\t')
		{
			newTabs++;
		}
		else if (newText[count] < ' ')
		{
			newCtrls++;
		}
		count++;
	}
	for (i=to.posX; i<uTextSizes[to.posY]; i++)
	{
		newText[count] = uTextBuffer[to.posY][i];
		if (newText[count] == (UCS2) '\t')
		{
			newTabs++;
		}
		else if (newText[count] < ' ')
		{
			newCtrls++;
		}
		count++;
	}
	newText[count] = 0;
	// delete intermediate text
	for (i=from.posY; i <= to.posY; i++)
	{
		delete uTextBuffer[i];
	}
	uTextBuffer[from.posY] = newText;
	uTextSizes[from.posY] = newTextSize;
	uTextTabSizes[from.posY] = newTabs;
	uTextCtrlSizes[from.posY] = newCtrls;

	// move the guys from up to down
	if (from.posY != to.posY)
	{
		for (i=1; i<uTextSize-to.posY; i++)
		{
			uTextBuffer[from.posY+i] = uTextBuffer[i+to.posY];
			uTextSizes[from.posY+i] = uTextSizes[i+to.posY];
			uTextTabSizes[from.posY+i] = uTextTabSizes[i+to.posY];
			uTextCtrlSizes[from.posY+i] = uTextCtrlSizes[i+to.posY];
		}
		uTextSize -= to.posY-from.posY;
	}
	if (uCursorBox.at > from)
	{
		if (uCursorBox.at <= to)
		{
			uCursorBox.at = from;
		}
		else if (uCursorBox.at.posY == to.posY)
		{
			uCursorBox.at.posX = to.posX 
				-uCursorBox.at.posX + from.posX;
		}
		else
		{
			uCursorBox.at.posY -= to.posY-from.posY;
		}
		getCursorPosition (&uCursorBox);
	}

	// redraw
	startP=from;

	if (from.posY==to.posY) // one line
	{
		endP.posX = 0;
		endP.coordX = 0;
		endP.posY = from.posY+1;
		endP.coordY = 0;
	}
	else // redraw till the end of uScreen
	{
		endP.posX = 0;
		endP.coordX = 0;
		endP.posY=uTextSize;
		endP.coordY = 0;
	}
	drawVisibleSegments (startP, endP, D_NORMAL_FILL, 0);
	// delete unnecessary segments
	uSetFullSize ();
	uSetCursorViewable ();
	if (from.posY!=to.posY)
	{
		endText = uTextSize * uFont->fontHeight - uY + uBorderSize;
		if (endText < uHeight)
		{
			XClearArea (uDisplay, uWindow, uCornerX, 
				uCornerY+endText, 
				uWidth, uHeight-endText, False);
		}
	}
	if (saveState == US_ON || saveState ==US_FROZEN_ON)
	{
		drawCursor (US_ON);
	}
}

// middle button
void 
UWidget::uInsertText (const unsigned char *text, 
	const int _length, const int moveCursor, const int newLineIn)
{
	int		i;
	UCS2*		converted;
	UCS2*		clean;
	int		slen;

	if (text == 0)
	{
		cerr << "warn: can not paste - null string.\n";
		uClipboardClear ();
		return ;
	}
	if (uString != 0)
	{
		uString->putString (text, _length);
		converted = uString->getUString (&slen);
		uInsertUCS2 (converted, slen, moveCursor, newLineIn);
		delete converted;
	}
	else
	{
		clean = new UCS2[strlen ((const char*) text)+1];
		CHECKNULL (clean);
		for (i=0; text[i]!=0; i++)
		{
			clean[i] = (UCS2) text[i];
		}
		clean[i] = 0;
		uInsertUCS2 (clean, i, moveCursor, newLineIn);
		delete clean;
	}
}

void 
UWidget::uInsertUCS2 (const UCS2 *converted, const int len, 
	const int moveCursor, const int newLineIn)
{
	int		i;
	int		from;
	int		to;
	UPoint		startP;
	UPoint		endP;
	UPoint		currentP;
	int		newLine;
	UCS2		ucs2=0;
	int		incl;

	if (editable != EDITABLE) return;
	if (len == 0) return;

	startP = uCursorBox.at;
	currentP = startP;

	newLine=(newLineIn == 0) ? 0 : 1;
	for (i=0, from=0, to=0; i<len; i++, to++)
	{
		from=to;
		incl=0;
		while (i<len && converted[i] != (UCS2) '\n')
		{
			if (converted[i] == U_PARA_SEP 
				|| converted[i] == U_LINE_SEP)
			{
				// Allow only if line does not contain any
				// SEP. SEP can appear at the end only.
				if( (multiLine==MULTILINE 
					|| multiLine==MULTILINE_SCROLL)
					|| uTextSize==0
					|| uTextSizes[uCursorBox.at.posY]==0)
				{
					incl = 1;
				}
				else if (
				  uTextBuffer[uCursorBox.at.posY] [uTextSizes[uCursorBox.at.posY]-1]
					!= U_PARA_SEP &&
				  uTextBuffer[uCursorBox.at.posY][uTextSizes[uCursorBox.at.posY]-1]
					!= U_LINE_SEP)
				{
					incl = 1;
				}
				break;
			}
			i++;
			to++;
		}
		uInsertLineUCS2 (currentP, converted, 
					from, to+incl, newLine);
		
		if (multiLine!=MULTILINE && multiLine!=MULTILINE_SCROLL)
		{
			break;
		}
		newLine++;
	}
	// Insert new line at the end if necessary
	if (to>0 && newLineIn!=2 &&
		(converted[to-1] == (UCS2) '\n' ||
		converted[to-1] == U_PARA_SEP ||
		converted[to-1] == U_LINE_SEP) && 
		(multiLine==MULTILINE || multiLine==MULTILINE_SCROLL))
	{
		if (uTextSize==0 && to==1)
		{
			uInsertLineUCS2 (currentP, &ucs2, 0, 0, 1);
		}
		uInsertLineUCS2 (currentP, &ucs2, 0, 0, 1);
		newLine++;
	}
	if (to==0 && (multiLine==MULTILINE || multiLine==MULTILINE_SCROLL))
	{
		if (uTextSize==0)
		{
			uInsertLineUCS2 (currentP, &ucs2, 0, 0, 1);
		}
		uInsertLineUCS2 (currentP, &ucs2, 0, 0, 1);
		newLine++;
	}
	// No real-time refresh of characters - I may enhace it later...
	if (moveCursor ==0) 
	{
		return;
	}

	endP = currentP;
	uSetCursorXY (currentP.posX, currentP.posY);
	// wee need to redraw till end of line
	if (newLine==1)
	{
		endP.posX = 0;
		endP.coordX = 0;
		endP.posY = uCursorBox.at.posY+1;
		endP.coordY = 0;
	}
	else // redraw till the end of uScreen
	{
		endP.posX = 0;
		endP.coordX = 0;
		endP.posY=uTextSize;
		endP.coordY = 0;
	}
	drawVisibleSegments (startP, endP, D_NORMAL_FILL, 0);
	if (cursorState == US_ON || cursorState ==US_FROZEN_ON)
	{
		drawCursor (US_ON);
	}
}

void
UWidget::uClipboardClear()
{
	clipboardActive=0;
	clearSelection();
	if (uString!=0) uString->putUString ((UCS2*) 0, 0);
}

// Put text to clipboard 
void
UWidget::uClipboardPut (const unsigned char *text, const int len )
{
	clipboardActive=1;
}

// get text from clipboard 
unsigned char*	
UWidget::uClipboardGet (int *len)
{
	return 0;
}

void
UWidget::uXIMStart ()
{
	uXInputActive=1;
}

void
UWidget::uXIMEnd ()
{
	int	cleanHeight;
	uXInputActive=0;
	if (uXInputHeight!=0)
	{
		cleanHeight=uXInputHeight;
		uXInputHeight=0;
		XClearArea (uDisplay, uWindow, uCornerX, uCornerY+uHeight, 
				uWidth, cleanHeight, False);
		uResize (uWidth, uHeight+cleanHeight, 
			uCornerX, uCornerY);
		uSetCursorViewable();
	}
}

void
UWidget::uXIMFail ()
{
	int	cleanHeight;
	uXInputActive=0;
	if (uXInputHeight!=0)
	{
		cleanHeight=uXInputHeight;
		uXInputHeight=0;
		XClearArea (uDisplay, uWindow, uCornerX, uCornerY+uHeight, 
				uWidth, cleanHeight, False);
		uResize (uWidth, uHeight+cleanHeight, 
			uCornerX, uCornerY);
		uSetCursorViewable();
	}
}

int
UWidget::uDeleteSelection()
{
	UPoint		fromP;
	UPoint		toP;

	if ((reversePoints[reverseP] == uCursorBox.at ||
		reversePoints[reverseP^1] == uCursorBox.at)
		&& reversePoints[reverseP] != reversePoints[reverseP^1])
	{
		if (underLine[0] != underLine[1])
		{
			hideUnderLine();
		}
		underLine[0]=underLine[1];
		uInput->resetState();
		fromP = reversePoints[reverseP];
		toP = reversePoints[reverseP^1];
		clearSelection();
		uDeleteText (fromP, toP);
		return 1;
	}
	return 0;
}

int
UWidget::uFindUCS2 (const UCS2* text, const int len, int fromBegin)
{
	int		i,j,k;
	UPoint		fromP;
	UPoint		toP;
	int		line;
	int		column;
	int		toX;
	int		toY;

	if (text==0 || text[0] == 0) return -1;
	if (fromBegin==0)
	{
		line = uCursorBox.at.posY;
		column = uCursorBox.at.posX;;
		if ((reversePoints[reverseP] == uCursorBox.at ||
			reversePoints[reverseP^1] == uCursorBox.at)
			&& reversePoints[reverseP] != reversePoints[reverseP^1])
		{
			line = reversePoints[reverseP^1].posY;
			column = reversePoints[reverseP^1].posX;
		}
	}
	else
	{
		line = 0;
		column = 0;
	}
	for (i=line; i<uTextSize; i++)
	{
		for (j=column; j<uTextSizes[i]; j++)
		{
			for (k=0; k<len &&  j+k < uTextSizes[i] ; k++)
			{
				if (uTextBuffer[i][j+k] != text[k]) break;
			}
			if (k!=len) continue;
			if (underLine[0] != underLine[1])
			{
				hideUnderLine();
				underLine[0]= underLine[1];
			}
			clearSelection();
			toX = j+len;
			toY = i;
			// Select till next line 
			if (uTextSize > toY+1 && toX >0 && (
				multiLine==MULTILINE ||
				multiLine==MULTILINE_SCROLL)) 
			   if (uTextBuffer[toY][toX-1] == U_LINE_SEP ||
		  	   uTextBuffer[toY][toX-1] == U_PARA_SEP )
			{
				toX = 0;
				toY++;
			}
			uSetCursorXY (toX, toY);
			toP = uCursorBox.at;
			uSetCursorXY (j, i);
			fromP = uCursorBox.at;
			reversePoints[reverseP] = fromP;
			reversePoints[reverseP^1] = toP;
			uSetCursorViewable();
			drawVisibleSegments (reversePoints[reverseP], 
				reversePoints[reverseP^1], D_REVERSE, 0);
			return i;
		}
		column = 0;
	}
	clearSelection();
	return -1;
}

int
UWidget::uReplaceUCS2 (const UCS2* text, const int len)
{
	int	i;

	if (editable!=EDITABLE) return -1;
	uDeleteSelection ();
	if (text!=0) uInsertUCS2 (text, len);
	return 0;
}

int
UWidget::uGoTo (int lineNo)
{
	if (uTextSize==0) return 0;
	if (uCursorBox.at.posY == lineNo -1) return lineNo;

	if (underLine[0] != underLine[1])
	{
		hideUnderLine();
		underLine[0]= underLine[1];
	}
	clearSelection();
	uSetCursorXY ((uCursorBox.at.posX > uTextSizes[lineNo]) ?
		uTextSizes[lineNo] : uCursorBox.at.posX, 
		(uTextSize < lineNo || lineNo<=0) ?
		uTextSize-1 : lineNo-1);
	uSetCursorViewable();
	return lineNo;
}

int
operator< (const UPoint& p0, const UPoint& p1)
{
	return p0.posY < p1.posY 
		||  (p0.posY == p1.posY && p0.posX < p1.posX);
}

int
operator<= (const UPoint& p0, const UPoint& p1)
{
	return p0.posY < p1.posY 
		||  (p0.posY == p1.posY && p0.posX <= p1.posX);
}

int
operator> (const UPoint& p0, const UPoint& p1)
{
	return p0.posY > p1.posY 
		||  (p0.posY == p1.posY && p0.posX > p1.posX);
}

int
operator>= (const UPoint& p0, const UPoint& p1)
{
	return p0.posY > p1.posY 
		||  (p0.posY == p1.posY && p0.posX >= p1.posX);
}

int
operator== (const UPoint& p0, const UPoint& p1)
{
	return p0.posY == p1.posY &&  p0.posX == p1.posX;
}

int
operator!= (const UPoint& p0, const UPoint& p1)
{
	return p0.posY != p1.posY ||  p0.posX != p1.posX;
}

