//  UCommon.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UCommon.h"
#include "UString.h"
#include <string.h>
#include <sys/stat.h>
#include "UFontMap.h"
#include "UFreeType.h"
#include "UFontFreeType.h"

static char* defaultMapPath=".";

static char* mapPath=defaultMapPath;

const char*
UGetMapPath ()
{
	return mapPath;
}

void
USetMapPath (const char* newPathIn)
{
	char*	newPath;

	newPath = new char[strlen (newPathIn) +1];
	CHECKNULL (newPath);
	strcpy (newPath, newPathIn);

	if (mapPath!=defaultMapPath && mapPath!=0)
	{
		delete mapPath;
	}
	mapPath = newPath;
}

// Warning
int
UCS2Tabs (const UCS2* text, const int len)
{
	int	i=len;
	int tabCount=0;
	while (i--)
	{
		if (text[i] == (UCS2) '\t') tabCount++;
	}
	return tabCount;
}

int 
USplit (UCS2* text, const int len, UCS2*** ret, int** lens)
{
	int	i;
	int	index;
	int	lastLen;

	int lines = 0;
	for (i=0; i<len; i++) 
	{
		if (text[i]=='\n') lines++;
	}

	if (len >0 && text[len-1]!='\n') lines++;

	*ret = new UCS2*[lines+1];
	CHECKNULL (*ret);
	*lens = new int[lines+1];
	index =0;
	(*ret)[index] = &text[0];
	lastLen=0;
	for (i=0; i<len; i++)
	{
		if (text[i]=='\n')
		{
			text[i]=0;
			(*lens)[index++] = i-lastLen;
			(*ret)[index] = &text[i+1];
			lastLen = i+1;
		}
	}
	if (len > 0)
	{
		if (text[len-1]!='\n') (*lens)[index] = lastLen-i-1;
		return lines;
	}
	return 0;
}

// get buffer line by line, make sure it is double terminated
unsigned char*
UReadBuffer (istream* is, int *len)
{
	int		bufferSize;
	int		size;
	int		newBufferSize;
	unsigned char*	newBuffer;
	unsigned char*	buffer;

	bufferSize = 256;
	buffer = new unsigned char[bufferSize];
	CHECKNULL (buffer);
	size=0;
	while (is->get(buffer[size]))
	{
		size++;
		if (size+12>bufferSize)
		{
			newBufferSize = bufferSize<< 1;
			newBuffer =  new unsigned char[newBufferSize];
			CHECKNULL (newBuffer);
			memcpy (newBuffer, buffer, size);
			delete buffer;
			buffer = newBuffer;
			bufferSize = newBufferSize;
		}
	}
	buffer[size++]=0;
	*len = size-1;
	return buffer;
}

//
// zero on failure
// Warning
int
UWriteBuffer (ostream* os, const unsigned char *buffer, const int len)
{
	if (!os->write (buffer, len)) return -1;
	return len;
}

UCS2*
UCS2Get (const unsigned char* in, const int len)
{
	UCS2*	retVle;
	int	i;

	retVle = new UCS2[len + 1];
	CHECKNULL (retVle);
	for (i=0; in[i] != 0; i++)
	{
		retVle[i] = (UCS2) in[i];
	}
	retVle[i] = 0;
	return retVle;
}

UCS2*
UCS2Dup (const UCS2* text, const int len)
{
	UCS2*   retVle;

	retVle = new UCS2[len+1];
	memcpy (retVle, text, len * sizeof(UCS2));
	retVle[len]=0;
	return retVle;
}

int
UCS2NullLen (const UCS2* ucs2)
{
	int i=0;
	while (ucs2[i] != (UCS2) 0) i++;
	return i;
}

UCS2*
UCS2Concat (const UCS2* text0, const int len0, const UCS2* text1, const int len1)
{
	UCS2*   retVle;

	retVle = new UCS2[len0+len1+1];
	if (len0 > 0) memcpy (retVle, text0, len0 * sizeof(UCS2));
	if (len1 > 0) memcpy (&retVle[len0], text1, len1 * sizeof(UCS2));
	retVle[len0+len1]=0;
	return retVle;
}

#define UTValue(_v) _v

const char*
UWidgetVersion()
{
	return  UTValue ("yudit version 1.5\nGNU Copyright (C) gsinai@iname.com (Gaspar Sinai)\nTokyo, 30 November 1999");
}

char*
UFindFile (const char* path, const char *name)
{
	int		from;
	int		to;
	int		length;
	char*		pathName;
	struct stat 	buf;
	
	length = strlen (path);
	to = 0;
	from = 0;
	while (to<length)
	{
		while (path[to] != ':' && path[to] != 0) to++;
		if (to==from) { to++; from=to; continue; }
		pathName = new char[to-from +strlen (name) +2]; 
		CHECKNULL (pathName);

		memcpy (pathName, &path[from], to-from);

		pathName[to-from] = 0;
		if (pathName[to-from-1] != '/') strcat (pathName, "/");
		strcat (pathName, name);
		to++; from = to;
		if (stat (pathName, &buf) != 0)
		{
			delete pathName;
			continue;
		}
		return pathName;
	}
	return 0;
}

