/************************************************************************/
/*									*/
/*  ASCII, Names are the Postscript Glyph names, For the Control	*/
/*	characters, the names in /usr/pub/ascii are used.		*/
/*									*/
/*  ECMA 94 Latin 1 character Set Chart (= ISO 8859-1).			*/
/*  ASCII+ ISOLatin1Encoding.						*/
/*  Spelling follows the Postscipt Glyph Name, (prefixed with 'ISO1_'.)	*/
/*  Glyph names are from appendix E.5 (p. 495) of:			*/
/*  Adobe Systems: Postscript Language Reference Manual, Addison &	*/
/*	Wesley, Reading MA., 1990, ISBN 0-201-18127-4			*/
/*									*/
/*  Idem for Standard Encoding of Postscript.				*/
/*									*/
/*  Idem for NeXT Encoding of Postscript.				*/
/*									*/
/*  Idem for Apple Macintosh ROM character set.				*/
/*									*/
/*  Idem for EBCDIC for ibm 3270.					*/
/*	This is more or less guessed. Consulted are:			*/
/*	1)  Character map in x3270 source.				*/
/*	2)  Unicode Standard, Appendix 6.2, PC EBCDIC Code Page (p. 605)*/
/*	    Unicode Consortium: Unicode Standard, Version 1.0, Volume 1,*/
/*		Addidon & Wesley, Reading MA., 1991, ISBN 0-201-56788-1	*/
/*									*/
/************************************************************************/

#   define	CHARisUPPER	0x1
#   define	CHARisLOWER	0x2
#   define	CHARisDIGIT	0x4
#   define	CHARisALPHA	(CHARisUPPER|CHARisLOWER)
#   define	CHARisALNUM	(CHARisALPHA|CHARisDIGIT)

/************************************************************************/
/*									*/
/*  ASCII								*/
/*									*/
/************************************************************************/

#   define	ASCII__nul		0x00	/*  0			*/
#   define	ASCII__soh		0x01	/*  1			*/
#   define	ASCII__stx		0x02	/*  2			*/
#   define	ASCII__etx		0x03	/*  3			*/
#   define	ASCII__eot		0x04	/*  4			*/
#   define	ASCII__enq		0x05	/*  5			*/
#   define	ASCII__ack		0x06	/*  6			*/
#   define	ASCII__bel		0x07	/*  7			*/
#   define	ASCII__bs		0x08	/*  8			*/
#   define	ASCII__ht		0x09	/*  9			*/
#   define	ASCII__nl		0x0a	/*  10			*/
#   define	ASCII__vt		0x0b	/*  11			*/
#   define	ASCII__np		0x0c	/*  12			*/
#   define	ASCII__cr		0x0d	/*  13			*/
#   define	ASCII__so		0x0e	/*  14			*/
#   define	ASCII__si		0x0f	/*  15			*/
#   define	ASCII__dle		0x10	/*  16			*/
#   define	ASCII__dc1		0x11	/*  17			*/
#   define	ASCII__dc2		0x12	/*  18			*/
#   define	ASCII__dc3		0x13	/*  19			*/
#   define	ASCII__dc4		0x14	/*  20			*/
#   define	ASCII__nak		0x15	/*  21			*/
#   define	ASCII__syn		0x16	/*  22			*/
#   define	ASCII__etb		0x17	/*  23			*/
#   define	ASCII__can		0x18	/*  24			*/
#   define	ASCII__em		0x19	/*  25			*/
#   define	ASCII__sub		0x1a	/*  26			*/
#   define	ASCII__esc		0x1b	/*  27			*/
#   define	ASCII__fs		0x1c	/*  28			*/
#   define	ASCII__gs		0x1d	/*  29			*/
#   define	ASCII__rs		0x1e	/*  30			*/
#   define	ASCII__us		0x1f	/*  31			*/

#   define	ASCII_space		0x20	/*  32			*/
#   define	ASCII_exclam		0x21	/*  33			*/
#   define	ASCII_quotedbl		0x22	/*  34			*/
#   define	ASCII_numbersign	0x23	/*  35			*/
#   define	ASCII_dollar		0x24	/*  36			*/
#   define	ASCII_percent		0x25	/*  37			*/
#   define	ASCII_ampersand		0x26	/*  38			*/
#   define	ASCII_quoteright	0x27	/*  39			*/
#   define	ASCII_parenleft		0x28	/*  40			*/
#   define	ASCII_parenright	0x29	/*  41			*/
#   define	ASCII_asterisk		0x2a	/*  42			*/
#   define	ASCII_plus		0x2b	/*  43			*/
#   define	ASCII_comma		0x2c	/*  44			*/
#   define	ASCII_minus		0x2d	/*  45			*/
#   define	ASCII_period		0x2e	/*  46			*/
#   define	ASCII_slash		0x2f	/*  47			*/
#   define	ASCII_zero		0x30	/*  48			*/
#   define	ASCII_one		0x31	/*  49			*/
#   define	ASCII_two		0x32	/*  50			*/
#   define	ASCII_three		0x33	/*  51			*/
#   define	ASCII_four		0x34	/*  52			*/
#   define	ASCII_five		0x35	/*  53			*/
#   define	ASCII_six		0x36	/*  54			*/
#   define	ASCII_seven		0x37	/*  55			*/
#   define	ASCII_eight		0x38	/*  56			*/
#   define	ASCII_nine		0x39	/*  57			*/
#   define	ASCII_colon		0x3a	/*  58			*/
#   define	ASCII_semicolon		0x3b	/*  59			*/
#   define	ASCII_less		0x3c	/*  60			*/
#   define	ASCII_equal		0x3d	/*  61			*/
#   define	ASCII_greater		0x3e	/*  62			*/
#   define	ASCII_question		0x3f	/*  63			*/

#   define	ASCII_at		0x40	/*  64			*/
#   define	ASCII_A			0x41	/*  65			*/
#   define	ASCII_B			0x42	/*  66			*/
#   define	ASCII_C			0x43	/*  67			*/
#   define	ASCII_D			0x44	/*  68			*/
#   define	ASCII_E			0x45	/*  69			*/
#   define	ASCII_F			0x46	/*  70			*/
#   define	ASCII_G			0x47	/*  71			*/
#   define	ASCII_H			0x48	/*  72			*/
#   define	ASCII_I			0x49	/*  73			*/
#   define	ASCII_J			0x4a	/*  74			*/
#   define	ASCII_K			0x4b	/*  75			*/
#   define	ASCII_L			0x4c	/*  76			*/
#   define	ASCII_M			0x4d	/*  77			*/
#   define	ASCII_N			0x4e	/*  78			*/
#   define	ASCII_O			0x4f	/*  79			*/
#   define	ASCII_P			0x50	/*  80			*/
#   define	ASCII_Q			0x51	/*  81			*/
#   define	ASCII_R			0x52	/*  82			*/
#   define	ASCII_S			0x53	/*  83			*/
#   define	ASCII_T			0x54	/*  84			*/
#   define	ASCII_U			0x55	/*  85			*/
#   define	ASCII_V			0x56	/*  86			*/
#   define	ASCII_W			0x57	/*  87			*/
#   define	ASCII_X			0x58	/*  88			*/
#   define	ASCII_Y			0x59	/*  89			*/
#   define	ASCII_Z			0x5a	/*  90			*/
#   define	ASCII_bracketleft	0x5b	/*  91			*/
#   define	ASCII_backslash		0x5c	/*  92			*/
#   define	ASCII_bracketright	0x5d	/*  93			*/
#   define	ASCII_circumflex	0x5e	/*  94			*/
#   define	ASCII_underscore	0x5f	/*  95			*/

#   define	ASCII_quoteleft		0x60	/*  96			*/
#   define	ASCII_a			0x61	/*  97			*/
#   define	ASCII_b			0x62	/*  98			*/
#   define	ASCII_c			0x63	/*  99			*/
#   define	ASCII_d			0x64	/*  100			*/
#   define	ASCII_e			0x65	/*  101			*/
#   define	ASCII_f			0x66	/*  102			*/
#   define	ASCII_g			0x67	/*  103			*/
#   define	ASCII_h			0x68	/*  104			*/
#   define	ASCII_i			0x69	/*  105			*/
#   define	ASCII_j			0x6a	/*  106			*/
#   define	ASCII_k			0x6b	/*  107			*/
#   define	ASCII_l			0x6c	/*  108			*/
#   define	ASCII_m			0x6d	/*  109			*/
#   define	ASCII_n			0x6e	/*  110			*/
#   define	ASCII_o			0x6f	/*  111			*/
#   define	ASCII_p			0x70	/*  112			*/
#   define	ASCII_q			0x71	/*  113			*/
#   define	ASCII_r			0x72	/*  114			*/
#   define	ASCII_s			0x73	/*  115			*/
#   define	ASCII_t			0x74	/*  116			*/
#   define	ASCII_u			0x75	/*  117			*/
#   define	ASCII_v			0x76	/*  118			*/
#   define	ASCII_w			0x77	/*  119			*/
#   define	ASCII_x			0x78	/*  120			*/
#   define	ASCII_y			0x79	/*  121			*/
#   define	ASCII_z			0x7a	/*  122			*/
#   define	ASCII_braceleft		0x7b	/*  123			*/
#   define	ASCII_bar		0x7c	/*  124			*/
#   define	ASCII_braceright	0x7d	/*  125			*/
#   define	ASCII_tilde		0x7e	/*  126			*/
#   define	ASCII__del		0x7f	/*  127			*/

#   define	ASCII_isupper( c )	((c)>=ASCII_A&&(c)<=ASCII_Z)
#   define	ASCII_islower( c )	((c)>=ASCII_a&&(c)<=ASCII_z)
#   define	ASCII_isdigit( c )	((c)>=ASCII_zero&&(c)<=ASCII_nine)
#   define	ASCII_isalpha( c )	(ASCII_isupper((c))||ASCII_islower((c)))
#   define	ASCII_tolower( c )	(ASCII_isupper((c))?(c)+0x10:(c))
#   define	ASCII_toupper( c )	(ASCII_islower((c))?(c)-0x10:(c))

/************************************************************************/
/*  ISO Latin1 (ISO 8859-1)						*/
/************************************************************************/

#   define ISO1__nul		ASCII__nul	/*  0		*/
#   define ISO1__soh		ASCII__soh	/*  1		*/
#   define ISO1__stx		ASCII__stx	/*  2		*/
#   define ISO1__etx		ASCII__etx	/*  3		*/
#   define ISO1__eot		ASCII__eot	/*  4		*/
#   define ISO1__enq		ASCII__enq	/*  5		*/
#   define ISO1__ack		ASCII__ack	/*  6		*/
#   define ISO1__bel		ASCII__bel	/*  7		*/
#   define ISO1__bs		ASCII__bs	/*  8		*/
#   define ISO1__ht		ASCII__ht	/*  9		*/
#   define ISO1__nl		ASCII__nl	/*  10		*/
#   define ISO1__vt		ASCII__vt	/*  11		*/
#   define ISO1__np		ASCII__np	/*  12		*/
#   define ISO1__cr		ASCII__cr	/*  13		*/
#   define ISO1__so		ASCII__so	/*  14		*/
#   define ISO1__si		ASCII__si	/*  15		*/
#   define ISO1__dle		ASCII__dle	/*  16		*/
#   define ISO1__dc1		ASCII__dc1	/*  17		*/
#   define ISO1__dc2		ASCII__dc2	/*  18		*/
#   define ISO1__dc3		ASCII__dc3	/*  19		*/
#   define ISO1__dc4		ASCII__dc4	/*  20		*/
#   define ISO1__nak		ASCII__nak	/*  21		*/
#   define ISO1__syn		ASCII__syn	/*  22		*/
#   define ISO1__etb		ASCII__etb	/*  23		*/
#   define ISO1__can		ASCII__can	/*  24		*/
#   define ISO1__em		ASCII__em	/*  25		*/
#   define ISO1__sub		ASCII__sub	/*  26		*/
#   define ISO1__esc		ASCII__esc	/*  27		*/
#   define ISO1__fs		ASCII__fs	/*  28		*/
#   define ISO1__gs		ASCII__gs	/*  29		*/
#   define ISO1__rs		ASCII__rs	/*  30		*/
#   define ISO1__us		ASCII__us	/*  31		*/

#   define ISO1_space		ASCII_space	/*  32		*/
#   define ISO1_exclam		ASCII_exclam	/*  33		*/
#   define ISO1_quotedbl	ASCII_quotedbl	/*  34		*/
#   define ISO1_numbersign	ASCII_numbersign /*  35		*/
#   define ISO1_dollar		ASCII_dollar	/*  36		*/
#   define ISO1_percent		ASCII_percent	/*  37		*/
#   define ISO1_ampersand	ASCII_ampersand	/*  38		*/
#   define ISO1_quoteright	ASCII_quoteright /*  39		*/
#   define ISO1_parenleft	ASCII_parenleft	/*  40		*/
#   define ISO1_parenright	ASCII_parenright /*  41		*/
#   define ISO1_asterisk	ASCII_asterisk	/*  42		*/
#   define ISO1_plus		ASCII_plus	/*  43		*/
#   define ISO1_comma		ASCII_comma	/*  44		*/
#   define ISO1_minus		ASCII_minus	/*  45		*/
#   define ISO1_period		ASCII_period	/*  46		*/
#   define ISO1_slash		ASCII_slash	/*  47		*/
#   define ISO1_zero		ASCII_zero	/*  48		*/
#   define ISO1_one		ASCII_one	/*  49		*/
#   define ISO1_two		ASCII_two	/*  50		*/
#   define ISO1_three		ASCII_three	/*  51		*/
#   define ISO1_four		ASCII_four	/*  52		*/
#   define ISO1_five		ASCII_five	/*  53		*/
#   define ISO1_six		ASCII_six	/*  54		*/
#   define ISO1_seven		ASCII_seven	/*  55		*/
#   define ISO1_eight		ASCII_eight	/*  56		*/
#   define ISO1_nine		ASCII_nine	/*  57		*/
#   define ISO1_colon		ASCII_colon	/*  58		*/
#   define ISO1_semicolon	ASCII_semicolon	/*  59		*/
#   define ISO1_less		ASCII_less	/*  60		*/
#   define ISO1_equal		ASCII_equal	/*  61		*/
#   define ISO1_greater		ASCII_greater	/*  62		*/
#   define ISO1_question	ASCII_question	/*  63		*/

#   define ISO1_at		ASCII_at	/*  64		*/
#   define ISO1_A		ASCII_A		/*  65		*/
#   define ISO1_B		ASCII_B		/*  66		*/
#   define ISO1_C		ASCII_C		/*  67		*/
#   define ISO1_D		ASCII_D		/*  68		*/
#   define ISO1_E		ASCII_E		/*  69		*/
#   define ISO1_F		ASCII_F		/*  70		*/
#   define ISO1_G		ASCII_G		/*  71		*/
#   define ISO1_H		ASCII_H		/*  72		*/
#   define ISO1_I		ASCII_I		/*  73		*/
#   define ISO1_J		ASCII_J		/*  74		*/
#   define ISO1_K		ASCII_K		/*  75		*/
#   define ISO1_L		ASCII_L		/*  76		*/
#   define ISO1_M		ASCII_M		/*  77		*/
#   define ISO1_N		ASCII_N		/*  78		*/
#   define ISO1_O		ASCII_O		/*  79		*/
#   define ISO1_P		ASCII_P		/*  80		*/
#   define ISO1_Q		ASCII_Q		/*  81		*/
#   define ISO1_R		ASCII_R		/*  82		*/
#   define ISO1_S		ASCII_S		/*  83		*/
#   define ISO1_T		ASCII_T		/*  84		*/
#   define ISO1_U		ASCII_U		/*  85		*/
#   define ISO1_V		ASCII_V		/*  86		*/
#   define ISO1_W		ASCII_W		/*  87		*/
#   define ISO1_X		ASCII_X		/*  88		*/
#   define ISO1_Y		ASCII_Y		/*  89		*/
#   define ISO1_Z		ASCII_Z		/*  90		*/
#   define ISO1_bracketleft	ASCII_bracketleft /* 91		*/
#   define ISO1_backslash	ASCII_backslash	/*  92		*/
#   define ISO1_bracketright	ASCII_bracketright /* 93	*/
#   define ISO1_circumflex	ASCII_circumflex /*  94		*/
#   define ISO1_underscore	ASCII_underscore /*  95		*/

#   define ISO1_quoteleft	ASCII_quoteleft	/*  96		*/
#   define ISO1_a		ASCII_a		/*  97		*/
#   define ISO1_b		ASCII_b		/*  98		*/
#   define ISO1_c		ASCII_c		/*  99		*/
#   define ISO1_d		ASCII_d		/*  100		*/
#   define ISO1_e		ASCII_e		/*  101		*/
#   define ISO1_f		ASCII_f		/*  102		*/
#   define ISO1_g		ASCII_g		/*  103		*/
#   define ISO1_h		ASCII_h		/*  104		*/
#   define ISO1_i		ASCII_i		/*  105		*/
#   define ISO1_j		ASCII_j		/*  106		*/
#   define ISO1_k		ASCII_k		/*  107		*/
#   define ISO1_l		ASCII_l		/*  108		*/
#   define ISO1_m		ASCII_m		/*  109		*/
#   define ISO1_n		ASCII_n		/*  110		*/
#   define ISO1_o		ASCII_o		/*  111		*/
#   define ISO1_p		ASCII_p		/*  112		*/
#   define ISO1_q		ASCII_q		/*  113		*/
#   define ISO1_r		ASCII_r		/*  114		*/
#   define ISO1_s		ASCII_s		/*  115		*/
#   define ISO1_t		ASCII_t		/*  116		*/
#   define ISO1_u		ASCII_u		/*  117		*/
#   define ISO1_v		ASCII_v		/*  118		*/
#   define ISO1_w		ASCII_w		/*  119		*/
#   define ISO1_x		ASCII_x		/*  120		*/
#   define ISO1_y		ASCII_y		/*  121		*/
#   define ISO1_z		ASCII_z		/*  122		*/
#   define ISO1_braceleft	ASCII_braceleft	/*  123		*/
#   define ISO1_bar		ASCII_bar	/*  124		*/
#   define ISO1_braceright	ASCII_braceright /* 125		*/
#   define ISO1_tilde		ASCII_tilde	/*  126		*/
#   define ISO1__del		ASCII__del	/*  127		*/

#   define	ISO1__NOTDEF_128	128	/*  0x80	*/
#   define	ISO1__NOTDEF_129	129
#   define	ISO1__NOTDEF_130	130
#   define	ISO1__NOTDEF_131	131
#   define	ISO1__NOTDEF_132	132
#   define	ISO1__NOTDEF_133	133
#   define	ISO1__NOTDEF_134	134
#   define	ISO1__NOTDEF_135	135

#   define	ISO1__NOTDEF_136	136	/*  0x88	*/
#   define	ISO1__NOTDEF_137	137
#   define	ISO1__NOTDEF_138	138
#   define	ISO1__NOTDEF_139	139
#   define	ISO1__NOTDEF_140	140
#   define	ISO1__NOTDEF_141	141
#   define	ISO1__NOTDEF_142	142
#   define	ISO1__NOTDEF_143	143

#   define	ISO1_dotlessi		144	/*  0x90	*/
#   define	ISO1_grave		145
#   define	ISO1__acute_146		146
#   define	ISO1__circumflex_147	147
#   define	ISO1__tilde_148		148
#   define	ISO1__macron_149	149
#   define	ISO1_breve		150
#   define	ISO1_dotaccent		151

#   define	ISO1__dieresis_152	152
#   define	ISO1__NOTDEF_153	153
#   define	ISO1_ring		154
#   define	ISO1__cedilla_155	155
#   define	ISO1__NOTDEF_156	156
#   define	ISO1_hungarumlaut	157
#   define	ISO1_ogonek		158
#   define	ISO1_caron		159

#   define	ISO1_nobreakspace	160
#   define	ISO1_exclamdown		161
#   define	ISO1_cent		162
#   define	ISO1_sterling		163
#   define	ISO1_currency		164
#   define	ISO1_yen		165
#   define	ISO1_brokenbar		166
#   define	ISO1_section		167

#   define	ISO1_dieresis		168
#   define	ISO1_copyright		169
#   define	ISO1_ordfeminine	170
#   define	ISO1_guillemotleft	171
#   define	ISO1_logicalnot		172
#   define	ISO1_hyphen		173
#   define	ISO1_registered		174
#   define	ISO1_macron		175

#   define	ISO1_degree		176
#   define	ISO1_plusminus		177
#   define	ISO1_twosuperior	178
#   define	ISO1_threesuperior	179
#   define	ISO1_acute		180
#   define	ISO1_mu			181
#   define	ISO1_paragraph		182
#   define	ISO1_periodcentered	183

#   define	ISO1_cedilla		184
#   define	ISO1_onesuperior	185
#   define	ISO1_ordmasculine	186
#   define	ISO1_guillemotright	187
#   define	ISO1_onequarter		188
#   define	ISO1_onehalf		189
#   define	ISO1_threequarters	190
#   define	ISO1_questiondown	191

#   define	ISO1_Agrave		192
#   define	ISO1_Aacute		193
#   define	ISO1_Acircumflex	194
#   define	ISO1_Atilde		195
#   define	ISO1_Adieresis		196
#   define	ISO1_Aring		197
#   define	ISO1_AE			198
#   define	ISO1_Ccedilla		199

#   define	ISO1_Egrave		200
#   define	ISO1_Eacute		201
#   define	ISO1_Ecircumflex	202
#   define	ISO1_Edieresis		203
#   define	ISO1_Igrave		204
#   define	ISO1_Iacute		205
#   define	ISO1_Icircumflex	206
#   define	ISO1_Idieresis		207

#   define	ISO1_Eth		208
#   define	ISO1_Ntilde		209
#   define	ISO1_Ograve		210
#   define	ISO1_Oacute		211
#   define	ISO1_Ocircumflex	212
#   define	ISO1_Otilde		213
#   define	ISO1_Odieresis		214
#   define	ISO1_multiply		215

#   define	ISO1_Oslash		216
#   define	ISO1_Ugrave		217
#   define	ISO1_Uacute		218
#   define	ISO1_Ucircumflex	219
#   define	ISO1_Udieresis		220
#   define	ISO1_Yacute		221
#   define	ISO1_Thorn		222
#   define	ISO1_germandbls		223

#   define	ISO1_agrave		224
#   define	ISO1_aacute		225
#   define	ISO1_acircumflex	226
#   define	ISO1_atilde		227
#   define	ISO1_adieresis		228
#   define	ISO1_aring		229
#   define	ISO1_ae			230
#   define	ISO1_ccedilla		231

#   define	ISO1_egrave		232
#   define	ISO1_eacute		233
#   define	ISO1_ecircumflex	234
#   define	ISO1_edieresis		235
#   define	ISO1_igrave		236
#   define	ISO1_iacute		237
#   define	ISO1_icircumflex	238
#   define	ISO1_idieresis		239

#   define	ISO1_eth		240
#   define	ISO1_ntilde		241
#   define	ISO1_ograve		242
#   define	ISO1_oacute		243
#   define	ISO1_ocircumflex	244
#   define	ISO1_otilde		245
#   define	ISO1_odieresis		246
#   define	ISO1_divide		247

#   define	ISO1_oslash		248
#   define	ISO1_ugrave		249
#   define	ISO1_uacute		250
#   define	ISO1_ucircumflex	251
#   define	ISO1_udieresis		252
#   define	ISO1_yacute		253
#   define	ISO1_thorn		254
#   define	ISO1_ydieresis		255

#   define	ISO1_isupper(c)	((ASCII_isupper((c)))||\
				  ((c)>=ISO1_Agrave&&(c)<=ISO1_Odieresis)||\
				  ((c)>=ISO1_Oslash&&(c)<=ISO1_germandbls))
#   define	ISO1_islower(c)	((ASCII_islower((c)))||\
				  ((c)>=ISO1_germandbls&&(c)<=ISO1_odieresis)||\
				  ((c)>=ISO1_oslash&&(c)<=ISO1_ydieresis))
#   define	ISO1_isalpha(c)	(ISO1_isupper((c))||ISO1_islower((c)))
#   define	ISO1_isdigit(c)	(ASCII_isdigit((c)))
#   define	ISO1_isalnum(c)	(ISO1_isupper((c))||ISO1_islower((c))||\
				  ISO1_isdigit((c)))
#   define	ISO1_tolower(c)	(((ISO1_isupper(c)&&(c)!=ISO1_germandbls))?\
				    ((c)+0x20):(c))
#   define	ISO1_toupper(c)	(((ISO1_islower(c)&&(c)!=ISO1_germandbls))?\
				    ((c)-0x20):(c))

/************************************************************************/
/*  ISO Latin2 (ISO 8859-2)						*/
/************************************************************************/

#   define ISO2__nul		ASCII__nul	/*  0		*/
#   define ISO2__soh		ASCII__soh	/*  1		*/
#   define ISO2__stx		ASCII__stx	/*  2		*/
#   define ISO2__etx		ASCII__etx	/*  3		*/
#   define ISO2__eot		ASCII__eot	/*  4		*/
#   define ISO2__enq		ASCII__enq	/*  5		*/
#   define ISO2__ack		ASCII__ack	/*  6		*/
#   define ISO2__bel		ASCII__bel	/*  7		*/
#   define ISO2__bs		ASCII__bs	/*  8		*/
#   define ISO2__ht		ASCII__ht	/*  9		*/
#   define ISO2__nl		ASCII__nl	/*  10		*/
#   define ISO2__vt		ASCII__vt	/*  11		*/
#   define ISO2__np		ASCII__np	/*  12		*/
#   define ISO2__cr		ASCII__cr	/*  13		*/
#   define ISO2__so		ASCII__so	/*  14		*/
#   define ISO2__si		ASCII__si	/*  15		*/
#   define ISO2__dle		ASCII__dle	/*  16		*/
#   define ISO2__dc1		ASCII__dc1	/*  17		*/
#   define ISO2__dc2		ASCII__dc2	/*  18		*/
#   define ISO2__dc3		ASCII__dc3	/*  19		*/
#   define ISO2__dc4		ASCII__dc4	/*  20		*/
#   define ISO2__nak		ASCII__nak	/*  21		*/
#   define ISO2__syn		ASCII__syn	/*  22		*/
#   define ISO2__etb		ASCII__etb	/*  23		*/
#   define ISO2__can		ASCII__can	/*  24		*/
#   define ISO2__em		ASCII__em	/*  25		*/
#   define ISO2__sub		ASCII__sub	/*  26		*/
#   define ISO2__esc		ASCII__esc	/*  27		*/
#   define ISO2__fs		ASCII__fs	/*  28		*/
#   define ISO2__gs		ASCII__gs	/*  29		*/
#   define ISO2__rs		ASCII__rs	/*  30		*/
#   define ISO2__us		ASCII__us	/*  31		*/

#   define ISO2_space		ASCII_space	/*  32		*/
#   define ISO2_exclam		ASCII_exclam	/*  33		*/
#   define ISO2_quotedbl	ASCII_quotedbl	/*  34		*/
#   define ISO2_numbersign	ASCII_numbersign /*  35		*/
#   define ISO2_dollar		ASCII_dollar	/*  36		*/
#   define ISO2_percent		ASCII_percent	/*  37		*/
#   define ISO2_ampersand	ASCII_ampersand	/*  38		*/
#   define ISO2_quoteright	ASCII_quoteright /*  39		*/
#   define ISO2_parenleft	ASCII_parenleft	/*  40		*/
#   define ISO2_parenright	ASCII_parenright /*  41		*/
#   define ISO2_asterisk	ASCII_asterisk	/*  42		*/
#   define ISO2_plus		ASCII_plus	/*  43		*/
#   define ISO2_comma		ASCII_comma	/*  44		*/
#   define ISO2_minus		ASCII_minus	/*  45		*/
#   define ISO2_period		ASCII_period	/*  46		*/
#   define ISO2_slash		ASCII_slash	/*  47		*/
#   define ISO2_zero		ASCII_zero	/*  48		*/
#   define ISO2_one		ASCII_one	/*  49		*/
#   define ISO2_two		ASCII_two	/*  50		*/
#   define ISO2_three		ASCII_three	/*  51		*/
#   define ISO2_four		ASCII_four	/*  52		*/
#   define ISO2_five		ASCII_five	/*  53		*/
#   define ISO2_six		ASCII_six	/*  54		*/
#   define ISO2_seven		ASCII_seven	/*  55		*/
#   define ISO2_eight		ASCII_eight	/*  56		*/
#   define ISO2_nine		ASCII_nine	/*  57		*/
#   define ISO2_colon		ASCII_colon	/*  58		*/
#   define ISO2_semicolon	ASCII_semicolon	/*  59		*/
#   define ISO2_less		ASCII_less	/*  60		*/
#   define ISO2_equal		ASCII_equal	/*  61		*/
#   define ISO2_greater		ASCII_greater	/*  62		*/
#   define ISO2_question	ASCII_question	/*  63		*/

#   define ISO2_at		ASCII_at	/*  64		*/
#   define ISO2_A		ASCII_A		/*  65		*/
#   define ISO2_B		ASCII_B		/*  66		*/
#   define ISO2_C		ASCII_C		/*  67		*/
#   define ISO2_D		ASCII_D		/*  68		*/
#   define ISO2_E		ASCII_E		/*  69		*/
#   define ISO2_F		ASCII_F		/*  70		*/
#   define ISO2_G		ASCII_G		/*  71		*/
#   define ISO2_H		ASCII_H		/*  72		*/
#   define ISO2_I		ASCII_I		/*  73		*/
#   define ISO2_J		ASCII_J		/*  74		*/
#   define ISO2_K		ASCII_K		/*  75		*/
#   define ISO2_L		ASCII_L		/*  76		*/
#   define ISO2_M		ASCII_M		/*  77		*/
#   define ISO2_N		ASCII_N		/*  78		*/
#   define ISO2_O		ASCII_O		/*  79		*/
#   define ISO2_P		ASCII_P		/*  80		*/
#   define ISO2_Q		ASCII_Q		/*  81		*/
#   define ISO2_R		ASCII_R		/*  82		*/
#   define ISO2_S		ASCII_S		/*  83		*/
#   define ISO2_T		ASCII_T		/*  84		*/
#   define ISO2_U		ASCII_U		/*  85		*/
#   define ISO2_V		ASCII_V		/*  86		*/
#   define ISO2_W		ASCII_W		/*  87		*/
#   define ISO2_X		ASCII_X		/*  88		*/
#   define ISO2_Y		ASCII_Y		/*  89		*/
#   define ISO2_Z		ASCII_Z		/*  90		*/
#   define ISO2_bracketleft	ASCII_bracketleft /* 91		*/
#   define ISO2_backslash	ASCII_backslash	/*  92		*/
#   define ISO2_bracketright	ASCII_bracketright /* 93	*/
#   define ISO2_circumflex	ASCII_circumflex /*  94		*/
#   define ISO2_underscore	ASCII_underscore /*  95		*/

#   define ISO2_quoteleft	ASCII_quoteleft	/*  96		*/
#   define ISO2_a		ASCII_a		/*  97		*/
#   define ISO2_b		ASCII_b		/*  98		*/
#   define ISO2_c		ASCII_c		/*  99		*/
#   define ISO2_d		ASCII_d		/*  100		*/
#   define ISO2_e		ASCII_e		/*  101		*/
#   define ISO2_f		ASCII_f		/*  102		*/
#   define ISO2_g		ASCII_g		/*  103		*/
#   define ISO2_h		ASCII_h		/*  104		*/
#   define ISO2_i		ASCII_i		/*  105		*/
#   define ISO2_j		ASCII_j		/*  106		*/
#   define ISO2_k		ASCII_k		/*  107		*/
#   define ISO2_l		ASCII_l		/*  108		*/
#   define ISO2_m		ASCII_m		/*  109		*/
#   define ISO2_n		ASCII_n		/*  110		*/
#   define ISO2_o		ASCII_o		/*  111		*/
#   define ISO2_p		ASCII_p		/*  112		*/
#   define ISO2_q		ASCII_q		/*  113		*/
#   define ISO2_r		ASCII_r		/*  114		*/
#   define ISO2_s		ASCII_s		/*  115		*/
#   define ISO2_t		ASCII_t		/*  116		*/
#   define ISO2_u		ASCII_u		/*  117		*/
#   define ISO2_v		ASCII_v		/*  118		*/
#   define ISO2_w		ASCII_w		/*  119		*/
#   define ISO2_x		ASCII_x		/*  120		*/
#   define ISO2_y		ASCII_y		/*  121		*/
#   define ISO2_z		ASCII_z		/*  122		*/
#   define ISO2_braceleft	ASCII_braceleft	/*  123		*/
#   define ISO2_bar		ASCII_bar	/*  124		*/
#   define ISO2_braceright	ASCII_braceright /* 125		*/
#   define ISO2_tilde		ASCII_tilde	/*  126		*/
#   define ISO2__del		ASCII__del	/*  127		*/

#   define ISO2__NOTDEF_128	0x80		/*  128		*/
#   define ISO2__NOTDEF_129	0x81		/*  129		*/
#   define ISO2__NOTDEF_130	0x82		/*  130		*/
#   define ISO2__NOTDEF_131	0x83		/*  131		*/
#   define ISO2__NOTDEF_132	0x84		/*  132		*/
#   define ISO2__NOTDEF_133	0x85		/*  133		*/
#   define ISO2__NOTDEF_134	0x86		/*  134		*/
#   define ISO2__NOTDEF_135	0x85		/*  135		*/

#   define ISO2__NOTDEF_136	0x88		/*  136		*/
#   define ISO2__NOTDEF_137	0x89		/*  137		*/
#   define ISO2__NOTDEF_138	0x8a		/*  138		*/
#   define ISO2__NOTDEF_139	0x8b		/*  139		*/
#   define ISO2__NOTDEF_140	0x8c		/*  140		*/
#   define ISO2__NOTDEF_141	0x8d		/*  141		*/
#   define ISO2__NOTDEF_142	0x8e		/*  142		*/
#   define ISO2__NOTDEF_143	0x8f		/*  143		*/

#   define ISO2_dotlessi	0x90		/*  144		*/
#   define ISO2_grave		0x91		/*  145		*/
#   define ISO2__acute_146	0x92		/*  146		*/
#   define ISO2__circumflex_147	0x93		/*  147		*/
#   define ISO2__tilde_148	0x94		/*  148		*/
#   define ISO2__macron_149	0x95		/*  149		*/
#   define ISO2__breve_150	0x96		/*  150		*/
#   define ISO2__dotaccent_151	0x97		/*  151		*/

#   define ISO2__dieresis_152	0x98		/*  152		*/
#   define ISO2__NOTDEF_153	0x99		/*  153		*/
#   define ISO2_ring		0x9a		/*  154		*/
#   define ISO2__cedilla_155	0x9b		/*  155		*/
#   define ISO2__NOTDEF_156	0x9c		/*  156		*/
#   define ISO2__hungarumlaut_157 0x9d		/*  157		*/
#   define ISO2__ogonek_158	0x9e		/*  158		*/
#   define ISO2__caron_159	0x9f		/*  159		*/

#   define ISO2_nobreakspace	0xa0		/*  160		*/
#   define ISO2_Aogonek		0xa1		/*  161		*/
#   define ISO2_breve		0xa2		/*  162		*/
#   define ISO2_Lslash		0xa3		/*  163		*/
#   define ISO2_currency	0xa4		/*  164		*/
#   define ISO2_Lcaron		0xa5		/*  165		*/
#   define ISO2_Sacute		0xa6		/*  166		*/
#   define ISO2_section		0xa7		/*  167		*/

#   define ISO2_dieresis	0xa8		/*  168		*/
#   define ISO2_Scaron		0xa9		/*  169		*/
#   define ISO2_Scedilla	0xaa		/*  170		*/
#   define ISO2_Tcaron		0xab		/*  171		*/
#   define ISO2_Zacute		0xac		/*  172		*/
#   define ISO2_hyphen		0xad		/*  173		*/
#   define ISO2_Zcaron		0xae		/*  174		*/
#   define ISO2_Zdotaccent	0xaf		/*  175		*/

#   define ISO2_degree		0xb0		/*  176		*/
#   define ISO2_aogonek		0xb1		/*  177		*/
#   define ISO2_ogonek		0xb2		/*  178		*/
#   define ISO2_lslash		0xb3		/*  179		*/
#   define ISO2_acute		0xb4		/*  180		*/
#   define ISO2_lcaron		0xb5		/*  181		*/
#   define ISO2_sacute		0xb6		/*  182		*/
#   define ISO2_caron		0xb7		/*  183		*/

#   define ISO2_cedilla		0xb8		/*  184		*/
#   define ISO2_scaron		0xb9		/*  185		*/
#   define ISO2_scedilla	0xba		/*  186		*/
#   define ISO2_tcaron		0xbb		/*  187		*/
#   define ISO2_zacute		0xbc		/*  188		*/
#   define ISO2_hungarumlaut	0xbd		/*  189		*/
#   define ISO2_zcaron		0xbe		/*  190		*/
#   define ISO2_zdotaccent	0xbf		/*  191		*/

#   define ISO2_Racute		0xc0		/*  192		*/
#   define ISO2_Aacute		0xc1		/*  193		*/
#   define ISO2_Acircumflex	0xc2		/*  194		*/
#   define ISO2_Abreve		0xc3		/*  195		*/
#   define ISO2_Adieresis	0xc4		/*  196		*/
#   define ISO2_Lacute		0xc5		/*  197		*/
#   define ISO2_Cacute		0xc6		/*  198		*/
#   define ISO2_Ccedilla	0xc7		/*  199		*/

#   define ISO2_Ccaron		0xc8		/*  200		*/
#   define ISO2_Eacute		0xc9		/*  201		*/
#   define ISO2_Eogonek		0xca		/*  202		*/
#   define ISO2_Edieresis	0xcb		/*  203		*/
#   define ISO2_Ecaron		0xcc		/*  204		*/
#   define ISO2_Iacute		0xcd		/*  205		*/
#   define ISO2_Icircumflex	0xce		/*  206		*/
#   define ISO2_Dcaron		0xcf		/*  207		*/

#   define ISO2_Dcroat		0xd0		/*  208		*/
#   define ISO2_Nacute		0xd1		/*  209		*/
#   define ISO2_Ncaron		0xd2		/*  210		*/
#   define ISO2_Oacute		0xd3		/*  211		*/
#   define ISO2_Ocircumflex	0xd4		/*  212		*/
#   define ISO2_Ohungarumlaut	0xd5		/*  213		*/
#   define ISO2_Odieresis	0xd6		/*  214		*/
#   define ISO2_multiply	0xd7		/*  215		*/

#   define ISO2_Rcaron		0xd8		/*  216		*/
#   define ISO2_Uring		0xd9		/*  217		*/
#   define ISO2_Uacute		0xda		/*  218		*/
#   define ISO2_Uhungarumlaut	0xdb		/*  219		*/
#   define ISO2_Udieresis	0xdc		/*  220		*/
#   define ISO2_Yacute		0xdd		/*  221		*/
#   define ISO2_Tcedilla	0xde		/*  222		*/
#   define ISO2_germandbls	0xdf		/*  223		*/

#   define ISO2_racute		0xe0		/*  224		*/
#   define ISO2_aacute		0xe1		/*  225		*/
#   define ISO2_acircumflex	0xe2		/*  226		*/
#   define ISO2_abreve		0xe3		/*  227		*/
#   define ISO2_adieresis	0xe4		/*  228		*/
#   define ISO2_lacute		0xe5		/*  229		*/
#   define ISO2_cacute		0xe6		/*  230		*/
#   define ISO2_ccedilla	0xe7		/*  231		*/

#   define ISO2_ccaron		0xe8		/*  232		*/
#   define ISO2_eacute		0xe9		/*  233		*/
#   define ISO2_eogonek		0xea		/*  234		*/
#   define ISO2_edieresis	0xeb		/*  235		*/
#   define ISO2_ecaron		0xec		/*  236		*/
#   define ISO2_iacute		0xed		/*  237		*/
#   define ISO2_icircumflex	0xee		/*  238		*/
#   define ISO2_dcaron		0xef		/*  239		*/

#   define ISO2_dcroat		0xf0		/*  240		*/
#   define ISO2_nacute		0xf1		/*  241		*/
#   define ISO2_ncaron		0xf2		/*  242		*/
#   define ISO2_oacute		0xf3		/*  243		*/
#   define ISO2_ocircumflex	0xf4		/*  244		*/
#   define ISO2_ohungarumlaut	0xf5		/*  245		*/
#   define ISO2_odieresis	0xf6		/*  246		*/
#   define ISO2_divide		0xf7		/*  247		*/

#   define ISO2_rcaron		0xf8		/*  248		*/
#   define ISO2_uring		0xf9		/*  249		*/
#   define ISO2_uacute		0xfa		/*  250		*/
#   define ISO2_uhungarumlaut	0xfb		/*  251		*/
#   define ISO2_udieresis	0xfc		/*  252		*/
#   define ISO2_yacute		0xfd		/*  253		*/
#   define ISO2_tcedilla	0xfe		/*  254		*/
#   define ISO2_dotaccent	0xff		/*  255		*/

#   define	ISO2_isupper(c)	((ASCII_isupper((c)))||\
				  ((c)==ISO2_Aogonek)||\
				  ((c)==ISO2_Lslash)||\
				  ((c)==ISO2_Lcaron)||\
				  ((c)==ISO2_Sacute)||\
				  ((c)==ISO2_Scaron)||\
				  ((c)==ISO2_Scedilla)||\
				  ((c)==ISO2_Tcaron)||\
				  ((c)==ISO2_Zacute)||\
				  ((c)==ISO2_Zcaron)||\
				  ((c)==ISO2_Zdotaccent)||\
				  ((c)>=ISO2_Racute&&(c)<=ISO2_Odieresis)||\
				  ((c)>=ISO2_Rcaron&&(c)<=ISO2_germandbls))
#   define	ISO2_islower(c)	((ASCII_islower((c)))||\
				  ((c)==ISO2_aogonek)||\
				  ((c)==ISO2_lslash)||\
				  ((c)==ISO2_lcaron)||\
				  ((c)==ISO2_sacute)||\
				  ((c)==ISO2_scaron)||\
				  ((c)==ISO2_scedilla)||\
				  ((c)==ISO2_tcaron)||\
				  ((c)==ISO2_zacute)||\
				  ((c)==ISO2_zcaron)||\
				  ((c)==ISO2_zdotaccent)||\
				  ((c)>=ISO2_germandbls&&(c)<=ISO2_odieresis)||\
				  ((c)>=ISO2_rcaron&&(c)<=ISO2_tcedilla))
#   define	ISO2_isalpha(c)	(ISO2_isupper((c))||ISO2_islower((c)))
#   define	ISO2_isdigit(c)	(ASCII_isdigit((c)))
#   define	ISO2_isalnum(c)	(ISO2_isupper((c))||ISO2_islower((c))||\
				  ISO2_isdigit((c)))
#   define	ISO2_tolower(c)	(((ISO2_isupper(c)&&(c)!=ISO2_germandbls))?\
			(((c)>=0xa0&&(c)<=0xaf)?((c)+0x10):((c)+0x20)):(c))
#   define	ISO2_toupper(c)	(((ISO2_islower(c)&&(c)!=ISO2_germandbls))?\
			(((c)>=0xb0&&(c)<=0xbf)?((c)-0x10):((c)-0x20)):(c))

/************************************************************************/
/*  Adobe Postscript Standard encoding.					*/
/************************************************************************/
#   define	PS_space		ASCII_space
#   define	PS_exclam		ASCII_exclam
#   define	PS_quotedbl		ASCII_quotedbl
#   define	PS_numbersign		ASCII_numbersign
#   define	PS_dollar		ASCII_dollar
#   define	PS_percent		ASCII_percent
#   define	PS_ampersand		ASCII_ampersand
#   define	PS_quoteright		ASCII_quoteright

#   define	PS_parenleft		ASCII_parenleft
#   define	PS_parenright		ASCII_parenright
#   define	PS_asterisk		ASCII_asterisk
#   define	PS_plus			ASCII_plus
#   define	PS_comma		ASCII_comma
#   define	PS_minus		ASCII_minus
#   define	PS_period		ASCII_period
#   define	PS_slash		ASCII_slash

#   define	PS_zero			ASCII_zero
#   define	PS_one			ASCII_one
#   define	PS_two			ASCII_two
#   define	PS_three		ASCII_three
#   define	PS_four			ASCII_four
#   define	PS_five			ASCII_five
#   define	PS_six			ASCII_six
#   define	PS_seven		ASCII_seven

#   define	PS_eight		ASCII_eight
#   define	PS_nine			ASCII_nine
#   define	PS_colon		ASCII_colon
#   define	PS_semicolon		ASCII_semicolon
#   define	PS_less			ASCII_less
#   define	PS_equal		ASCII_equal
#   define	PS_greater		ASCII_greater
#   define	PS_question		ASCII_question

#   define	PS_at			ASCII_at
#   define	PS_A			ASCII_A
#   define	PS_B			ASCII_B
#   define	PS_C			ASCII_C
#   define	PS_D			ASCII_D
#   define	PS_E			ASCII_E
#   define	PS_F			ASCII_F
#   define	PS_G			ASCII_G

#   define	PS_H			ASCII_H
#   define	PS_I			ASCII_I
#   define	PS_J			ASCII_J
#   define	PS_K			ASCII_K
#   define	PS_L			ASCII_L
#   define	PS_M			ASCII_M
#   define	PS_N			ASCII_N
#   define	PS_O			ASCII_O

#   define	PS_P			ASCII_P
#   define	PS_Q			ASCII_Q
#   define	PS_R			ASCII_R
#   define	PS_S			ASCII_S
#   define	PS_T			ASCII_T
#   define	PS_U			ASCII_U
#   define	PS_V			ASCII_V
#   define	PS_W			ASCII_W

#   define	PS_X			ASCII_X
#   define	PS_Y			ASCII_Y
#   define	PS_Z			ASCII_Z
#   define	PS_bracketleft		ASCII_bracketleft
#   define	PS_backslash		ASCII_backslash
#   define	PS_bracketright		ASCII_bracketright
#   define	PS_asciicircum		ASCII_circumflex
#   define	PS_underscore		ASCII_underscore

#   define	PS_quoteleft		ASCII_quoteleft
#   define	PS_a			ASCII_a
#   define	PS_b			ASCII_b
#   define	PS_c			ASCII_c
#   define	PS_d			ASCII_d
#   define	PS_e			ASCII_e
#   define	PS_f			ASCII_f
#   define	PS_g			ASCII_g

#   define	PS_h			ASCII_h
#   define	PS_i			ASCII_i
#   define	PS_j			ASCII_j
#   define	PS_k			ASCII_k
#   define	PS_l			ASCII_l
#   define	PS_m			ASCII_m
#   define	PS_n			ASCII_n
#   define	PS_o			ASCII_o

#   define	PS_p			ASCII_p
#   define	PS_q			ASCII_q
#   define	PS_r			ASCII_r
#   define	PS_s			ASCII_s
#   define	PS_t			ASCII_t
#   define	PS_u			ASCII_u
#   define	PS_v			ASCII_v
#   define	PS_w			ASCII_w

#   define	PS_x			ASCII_x
#   define	PS_y			ASCII_y
#   define	PS_z			ASCII_z
#   define	PS_braceleft		ASCII_braceleft
#   define	PS_bar			ASCII_bar
#   define	PS_braceright		ASCII_braceright
#   define	PS_asciitilde		ASCII_tilde
/*0x7f*/

/*0200*/
/*0201*/
/*0202*/
/*0203*/
/*0204*/
/*0205*/
/*0206*/
/*0207*/

/*0210*/
/*0211*/
/*0212*/
/*0213*/
/*0214*/
/*0215*/
/*0216*/
/*0217*/

/*0220*/
/*0221*/
/*0222*/
/*0223*/
/*0224*/
/*0225*/
/*0226*/
/*0227*/

/*0230*/
/*0231*/
/*0232*/
/*0233*/
/*0234*/
/*0235*/
/*0236*/
/*0237*/

/*0240*/
#   define	PS_exclamdown		0xa1
#   define	PS_cent			0xa2
#   define	PS_sterling		0xa3
#   define	PS_fraction		0xa4
#   define	PS_yen			0xa5
#   define	PS_florin		0xa6
#   define	PS_section		0xa7

#   define	PS_currency		0xa8
#   define	PS_quotesingle		0xa9
#   define	PS_quotedblleft		0xaa
#   define	PS_guillemotleft	0xab
#   define	PS_guillsinglleft	0xac
#   define	PS_guillsinglright	0xad
#   define	PS_fi			0xae
#   define	PS_fl			0xaf

/*0260*/
#   define	PS_endash		0xb1
#   define	PS_dagger		0xb2
#   define	PS_daggerdbl		0xb3
#   define	PS_periodcentered	0xb4
/*0265*/
#   define	PS_paragraph		0xb6
#   define	PS_bullet		0xb7

#   define	PS_quotesinglbase	0xb8
#   define	PS_quotedblbase		0xb9
#   define	PS_quotedblright	0xba
#   define	PS_guillemotright	0xbb
#   define	PS_ellipsis		0xbc
#   define	PS_perthousand		0xbd
/*0276*/
#   define	PS_questiondown		0xbf

/*0300*/
#   define	PS_grave		0xc1
#   define	PS_acute		0xc2
#   define	PS_circumflex		0xc3
#   define	PS_tilde		0xc4
#   define	PS_macron		0xc5
#   define	PS_breve		0xc6
#   define	PS_dotaccent		0xc7

#   define	PS_dieresis		0xc8
/*0311*/
#   define	PS_ring			0xca
#   define	PS_cedilla		0xcb
/*0314*/
#   define	PS_hungarumlaut		0xcd
#   define	PS_ogonek		0xce
#   define	PS_caron		0xcf

#   define	PS_emdash		0xd0
/*0xd1*/
/*0xd2*/
/*0xd3*/
/*0xd4*/
/*0xd5*/
/*0xd6*/
/*0xd7*/

/*0330*/
/*0331*/
/*0332*/
/*0333*/
/*0334*/
/*0335*/
/*0336*/
/*0337*/

/*0xe0=0340*/
#   define	PS_AE			0xe1
/*0xe2*/
#   define	PS_ordfeminine		0xe3
/*0xe*/
/*0xe5*/
/*0xe6*/
/*0xe7*/

#   define	PS_Lslash		0xc8
#   define	PS_Oslash		0xe9
#   define	PS_OE			0xea
#   define	PS_ordmasculine		0xeb
/*0354*/
/*0355*/
/*0356*/
/*0357*/

/*0360*/
#   define	PS_ae			0xf1
/*0362*/
/*0363*/
/*0364*/
#   define	PS_dotlessi		0xf5
/*0366*/
/*0367*/

#   define	PS_lslash		0xf8
#   define	PS_oslash		0xf9
#   define	PS_oe			0xfa
#   define	PS_germandbls		0xfb
/*0374*/
/*0375*/
/*0376*/
/*0377*/

/************************************************************************/
/*  NeXT Postscript encoding.						*/
/************************************************************************/
#   define	NX_nul		ASCII_nul
#   define	NX_soh		ASCII_soh
#   define	NX_stx		ASCII_stx
#   define	NX_etx		ASCII_etx
#   define	NX_eot		ASCII_eot
#   define	NX_enq		ASCII_enq
#   define	NX_ack		ASCII_ack
#   define	NX_bel		ASCII_bel
#   define	NX_bs		ASCII_bs
#   define	NX_ht		ASCII_ht
#   define	NX_nl		ASCII_nl
#   define	NX_vt		ASCII_vt
#   define	NX_np		ASCII_np
#   define	NX_cr		ASCII_cr
#   define	NX_so		ASCII_so
#   define	NX_si		ASCII_si
#   define	NX_dle		ASCII_dle
#   define	NX_dc1		ASCII_dc1
#   define	NX_dc2		ASCII_dc2
#   define	NX_dc3		ASCII_dc3
#   define	NX_dc4		ASCII_dc4
#   define	NX_nak		ASCII_nak
#   define	NX_syn		ASCII_syn
#   define	NX_etb		ASCII_etb
#   define	NX_can		ASCII_can
#   define	NX_em		ASCII_em
#   define	NX_sub		ASCII_sub
#   define	NX_esc		ASCII_esc
#   define	NX_fs		ASCII_fs
#   define	NX_gs		ASCII_gs
#   define	NX_rs		ASCII_rs
#   define	NX_us		ASCII_us

#   define	NX_space	PS_space
#   define	NX_exclam	PS_exclam
#   define	NX_quotedbl	PS_quotedbl
#   define	NX_numbersign	PS_numbersign
#   define	NX_dollar	PS_dollar
#   define	NX_percent	PS_percent
#   define	NX_ampersand	PS_ampersand
#   define	NX_quoteright	PS_quoteright

#   define	NX_parenleft	PS_parenleft
#   define	NX_parenright	PS_parenright
#   define	NX_asterisk	PS_asterisk
#   define	NX_plus		PS_plus
#   define	NX_comma	PS_comma
#   define	NX_minus	PS_minus
#   define	NX_period	PS_period
#   define	NX_slash	PS_slash

#   define	NX_zero		PS_zero
#   define	NX_one		PS_one
#   define	NX_two		PS_two
#   define	NX_three	PS_three
#   define	NX_four		PS_four
#   define	NX_five		PS_five
#   define	NX_six		PS_six
#   define	NX_seven	PS_seven

#   define	NX_eight	PS_eight
#   define	NX_nine		PS_nine
#   define	NX_colon	PS_colon
#   define	NX_semicolon	PS_semicolon
#   define	NX_less		PS_less
#   define	NX_equal	PS_equal
#   define	NX_greater	PS_greater
#   define	NX_question	PS_question

#   define	NX_at		PS_at
#   define	NX_A		PS_A
#   define	NX_B		PS_B
#   define	NX_C		PS_C
#   define	NX_D		PS_D
#   define	NX_E		PS_E
#   define	NX_F		PS_F
#   define	NX_G		PS_G

#   define	NX_H		PS_H
#   define	NX_I		PS_I
#   define	NX_J		PS_J
#   define	NX_K		PS_K
#   define	NX_L		PS_L
#   define	NX_M		PS_M
#   define	NX_N		PS_N
#   define	NX_O		PS_O

#   define	NX_P		PS_P
#   define	NX_Q		PS_Q
#   define	NX_R		PS_R
#   define	NX_S		PS_S
#   define	NX_T		PS_T
#   define	NX_U		PS_U
#   define	NX_V		PS_V
#   define	NX_W		PS_W

#   define	NX_X		PS_X
#   define	NX_Y		PS_Y
#   define	NX_Z		PS_Z
#   define	NX_bracketleft	PS_bracketleft
#   define	NX_backslash	PS_backslash
#   define	NX_bracketright	PS_bracketright
#   define	NX_asciicircum	PS_asciicircum
#   define	NX_underscore	PS_underscore

#   define	NX_quoteleft	PS_quoteleft
#   define	NX_a		PS_a
#   define	NX_b		PS_b
#   define	NX_c		PS_c
#   define	NX_d		PS_d
#   define	NX_e		PS_e
#   define	NX_f		PS_f
#   define	NX_g		PS_g

#   define	NX_h		PS_h
#   define	NX_i		PS_i
#   define	NX_j		PS_j
#   define	NX_k		PS_k
#   define	NX_l		PS_l
#   define	NX_m		PS_m
#   define	NX_n		PS_n
#   define	NX_o		PS_o

#   define	NX_p		PS_p
#   define	NX_q		PS_q
#   define	NX_r		PS_r
#   define	NX_s		PS_s
#   define	NX_t		PS_t
#   define	NX_u		PS_u
#   define	NX_v		PS_v
#   define	NX_w		PS_w

#   define	NX_x		PS_x
#   define	NX_y		PS_y
#   define	NX_z		PS_z
#   define	NX_braceleft	PS_braceleft
#   define	NX_bar		PS_bar
#   define	NX_braceright	PS_braceright
#   define	NX_asciitilde	PS_asciitilde
#   define	NX_del		ASCII_del

/*0200*/
#   define	NX_Agrave		0x81
#   define	NX_Aacute		0x82
#   define	NX_Acircumflex		0x83
#   define	NX_Atilde		0x84
#   define	NX_Adieresis		0x85
#   define	NX_Aring		0x86
#   define	NX_Ccedilla		0x87

#   define	NX_Egrave		0x88
#   define	NX_Eacute		0x89
#   define	NX_Ecircumflex		0x8a
#   define	NX_Edieresis		0x8b
#   define	NX_Igrave		0x8c
#   define	NX_Iacute		0x8d
#   define	NX_Icircumflex		0x8e
#   define	NX_Idieresis		0x8f

#   define	NX_Eth			0x90
#   define	NX_Ntilde		0x91
#   define	NX_Ograve		0x92
#   define	NX_Oacute		0x93
#   define	NX_Ocircumflex		0x94
#   define	NX_Otilde		0x95
#   define	NX_Odieresis		0x96
#   define	NX_Ugrave		0x97

#   define	NX_Uacute		0x98
#   define	NX_Ucircumflex		0x99
#   define	NX_Udieresis		0x9a
#   define	NX_Yacute		0x9b
#   define	NX_Thorn		0x9c
#   define	NX_mu			0x9d
#   define	NX_multiply		0x9e
#   define	NX_divide		0x9f

#   define	NX_copyright		0xa0
#   define	NX_exclamdown		PS_exclamdown
#   define	NX_cent			PS_cent
#   define	NX_sterling		PS_sterling
#   define	NX_fraction		PS_fraction
#   define	NX_yen			PS_yen
#   define	NX_florin		PS_florin
#   define	NX_section		PS_section

#   define	NX_currency		PS_currency
#   define	NX_quotesingle		PS_quotesingle
#   define	NX_quotedblleft		PS_quotednlleft
#   define	NX_guillemotleft	PS_guillemotleft
#   define	NX_guillsinglleft	PS_guillsinglleft
#   define	NX_guillsinglright	PS_guillsinglright
#   define	NX_fi			PS_fi
#   define	NX_fl			PS_fl

#   define	NX_registered		0xb0
#   define	NX_endash		PS_endash
#   define	NX_dagger		PS_dagger
#   define	NX_daggerdbl		PS_daggerdbl
#   define	NX_periodcentered	PS_periodcentered
#   define	NX_brokenbar		0xb5
#   define	NX_paragraph		PS_paragraph
#   define	NX_bullet		PS_bullet

#   define	NX_quotesinglbase	PS_quotesinglbase
#   define	NX_quotedblbase		PS_quotedblbase
#   define	NX_quotedblright	PS_quotedblright
#   define	NX_guillemotright	PS_guillemotright
#   define	NX_ellipsis		PS_ellipsis
#   define	NX_perthousand		PS_perthousand
#   define	NX_logicalnot		0xbe
#   define	NX_questiondown		PS_questiondown

#   define	NX_onesuperior		0xc0
#   define	NX_grave		PS_grave
#   define	NX_acute		PS_acute
#   define	NX_circumflex		PS_circumflex
#   define	NX_tilde		PS_tilde
#   define	NX_macron		PS_macron
#   define	NX_breve		PS_breve
#   define	NX_dotaccent		PS_dotaccent

#   define	NX_dieresis		PS_dieresis
#   define	NX_twosuperior		0311
#   define	NX_ring			PS_ring
#   define	NX_cedilla		PS_cedilla
#   define	NX_threesuperior	0314
#   define	NX_hungarumlaut		PS_hungarumlaut
#   define	NX_ogonek		PS_ogonek
#   define	NX_caron		PS_caron

#   define	NX_emdash		PS_emdash
#   define	NX_plusminus		0xd1
#   define	NX_onequarter		0xd2
#   define	NX_onehalf		0xd3
#   define	NX_threequarters	0xd4
#   define	NX_agrave		0xd5
#   define	NX_aacute		0xd6
#   define	NX_acircumflex		0xd7

#   define	NX_atilde		0xd8
#   define	NX_adieresis		0xd9
#   define	NX_aring		0xda
#   define	NX_ccedilla		0xdb
#   define	NX_egrave		0xdc
#   define	NX_eacute		0xdd
#   define	NX_ecircumflex		0xde
#   define	NX_edieresis		0xdf

#   define	NX_igrave		0xe0
#   define	NX_AE			PS_AE
#   define	NX_iacute		0xe2
#   define	NX_ordfeminine		PS_ordfeminine
#   define	NX_icircumflex		0xe4
#   define	NX_idieresis		0xe5
#   define	NX_eth			0xe6
#   define	NX_ntilde		0xe7

#   define	NX_Lslash		PS_Lslash
#   define	NX_Oslash		PS_Oslash
#   define	NX_OE			PS_OE
#   define	NX_ordmasculine		PS_ordmasculine
#   define	NX_ograve		0xec
#   define	NX_oacute		0xed
#   define	NX_ocircumflex		0xee
#   define	NX_otilde		0xef

#   define	NX_odieresis		0xf0
#   define	NX_ae			PS_ae
#   define	NX_ugrave		0xf2
#   define	NX_uacute		0xf3
#   define	NX_ucircumflex		0xf4
#   define	NX_dotlessi		PS_dotlessi
#   define	NX_udieresis		0xf6
#   define	NX_yacute		0xf7

#   define	NX_lslash		PS_lslash
#   define	NX_oslash		PS_oslash
#   define	NX_oe			PS_oe
#   define	NX_germandbls		PS_germandbls
#   define	NX_thorn		0xfc
#   define	NX_ydieresis		0xfd
/*0376*/
/*0377*/

/************************************************************************/
/*  EBCDIC as used by the IBM 3270 series terminals.			*/
/************************************************************************/
#   define	EBCDIC_space		0x40
#   define	EBCDIC_0x41		0x41	/*  Non breaking space	*/
#   define	EBCDIC_acircumflex	0x42
#   define	EBCDIC_adieresis	0x43
#   define	EBCDIC_agrave		0x44
#   define	EBCDIC_aacute		0x45
#   define	EBCDIC_atilde		0x46
#   define	EBCDIC_a_XXX		0x47
#   define	EBCDIC_c_XXX		0x48
#   define	EBCDIC_ntilde		0x49
#   define	EBCDIC_cent		0x4a
#   define	EBCDIC_period		0x4b
#   define	EBCDIC_less		0x4c
#   define	EBCDIC_parenleft	0x4d
#   define	EBCDIC_plus		0x4e
#   define	EBCDIC_bar		0x4f
#   define	EBCDIC_ampersand	0x50
#   define	EBCDIC_eacute		0x51
#   define	EBCDIC_ecircumflex	0x52
#   define	EBCDIC_edieresis	0x53
#   define	EBCDIC_egrave		0x54
#   define	EBCDIC_iacute		0x55
#   define	EBCDIC_icircumflex	0x56
#   define	EBCDIC_idieresis	0x57
#   define	EBCDIC_igrave		0x58
#   define	EBCDIC_germandbls	0x59
#   define	EBCDIC_exclam		0x5a
#   define	EBCDIC_dollar		0x5b
#   define	EBCDIC_asterisk		0x5c
#   define	EBCDIC_parenright	0x5d
#   define	EBCDIC_semicolon	0x5e
#   define	EBCDIC_logicalnot	0x5f
#   define	EBCDIC_minus		0x60
#   define	EBCDIC_slash		0x61
#   define	EBCDIC_Acircumflex	0x62
#   define	EBCDIC_Adieresis	0x63
#   define	EBCDIC_Agrave		0x64
#   define	EBCDIC_Aacute		0x65
#   define	EBCDIC_Atilde		0x66
#   define	EBCDIC_Aring		0x67
#   define	EBCDIC_Ccedilla		0x68
#   define	EBCDIC_Ntilde		0x69
#   define	EBCDIC_brokenbar	0x6a
#   define	EBCDIC_comma		0x6b
#   define	EBCDIC_percent		0x6c
#   define	EBCDIC_underscore	0x6d
#   define	EBCDIC_greater		0x6e
#   define	EBCDIC_question		0x6f
#   define	EBCDIC_oslash		0x70
#   define	EBCDIC_Eacute		0x71
#   define	EBCDIC_Ecircumflex	0x72
#   define	EBCDIC_Edieresis	0x73
#   define	EBCDIC_Egrave		0x74
#   define	EBCDIC_Iacute		0x75
#   define	EBCDIC_Icircumflex	0x76
#   define	EBCDIC_Idieresis	0x77
#   define	EBCDIC_Igrave		0x78
#   define	EBCDIC_grave		0x79
#   define	EBCDIC_colon		0x7a
#   define	EBCDIC_numbersign	0x7b
#   define	EBCDIC_at		0x7c
#   define	EBCDIC_quotesingle	0x7d
#   define	EBCDIC_equal		0x7e
#   define	EBCDIC_quoteddbl	0x7f
#   define	EBCDIC_Oslash		0x80
#   define	EBCDIC_a		0x81
#   define	EBCDIC_b		0x82
#   define	EBCDIC_c		0x83
#   define	EBCDIC_d		0x84
#   define	EBCDIC_e		0x85
#   define	EBCDIC_f		0x86
#   define	EBCDIC_g		0x87
#   define	EBCDIC_h		0x88
#   define	EBCDIC_i		0x89
#   define	EBCDIC_guillemotleft	0x8a
#   define	EBCDIC_guillemotright	0x8b
#   define	EBCDIC_eth		0x8c
#   define	EBCDIC_yacute		0x8d
#   define	EBCDIC_thorn		0x8e
#   define	EBCDIC_plusminus	0x8f
#   define	EBCDIC_degree		0x90
#   define	EBCDIC_j		0x91
#   define	EBCDIC_k		0x92
#   define	EBCDIC_l		0x93
#   define	EBCDIC_m		0x94
#   define	EBCDIC_n		0x95
#   define	EBCDIC_o		0x96
#   define	EBCDIC_p		0x97
#   define	EBCDIC_q		0x98
#   define	EBCDIC_r		0x99
#   define	EBCDIC_ordfeminine	0x9a
#   define	EBCDIC_ordmasculine	0x9b
#   define	EBCDIC_ae		0x9c
#   define	EBCDIC_cedilla		0x9d
#   define	EBCDIC_AE		0x9e
#   define	EBCDIC_currency		0x9f
#   define	EBCDIC_mu		0xa0
#   define	EBCDIC_tilde		0xa1
#   define	EBCDIC_s		0xa2
#   define	EBCDIC_t		0xa3
#   define	EBCDIC_u		0xa4
#   define	EBCDIC_v		0xa5
#   define	EBCDIC_w		0xa6
#   define	EBCDIC_x		0xa7
#   define	EBCDIC_y		0xa8
#   define	EBCDIC_z		0xa9
#   define	EBCDIC_exclamdown	0xaa
#   define	EBCDIC_questiondown	0xab
#   define	EBCDIC_Eth		0xac
#   define	EBCDIC_Yacute		0xad
#   define	EBCDIC_Thorn		0xae
#   define	EBCDIC_registered	0xaf
#   define	EBCDIC_circumflex	0xb0
#   define	EBCDIC_sterling		0xb1
#   define	EBCDIC_yen		0xb2
#   define	EBCDIC_dotcentered	0xb3
#   define	EBCDIC_copyright	0xb4
#   define	EBCDIC_section		0xb5
#   define	EBCDIC_paragraph	0xb6
#   define	EBCDIC_onequarter	0xb7
#   define	EBCDIC_onehalf		0xb8
#   define	EBCDIC_threequarters	0xb9
#   define	EBCDIC_bracketleft	0xba
#   define	EBCDIC_bracketright	0xbb
#   define	EBCDIC_overscore	0xbc /**/
#   define	EBCDIC_dieresis		0xbd
#   define	EBCDIC_acute		0xbe
#   define	EBCDIC_multiply		0xbf
#   define	EBCDIC_braceleft	0xc0
#   define	EBCDIC_A		0xc1
#   define	EBCDIC_B		0xc2
#   define	EBCDIC_C		0xc3
#   define	EBCDIC_D		0xc4
#   define	EBCDIC_E		0xc5
#   define	EBCDIC_F		0xc6
#   define	EBCDIC_G		0xc7
#   define	EBCDIC_H		0xc8
#   define	EBCDIC_I		0xc9
#   define	EBCDIC_hyphen		0xca
#   define	EBCDIC_ocircumflex	0xcb
#   define	EBCDIC_odieresis	0xcc
#   define	EBCDIC_ograve		0xcd
#   define	EBCDIC_oacute		0xce
#   define	EBCDIC_otilde		0xcf
#   define	EBCDIC_braceright	0xd0
#   define	EBCDIC_J		0xd1
#   define	EBCDIC_K		0xd2
#   define	EBCDIC_L		0xd3
#   define	EBCDIC_M		0xd4
#   define	EBCDIC_N		0xd5
#   define	EBCDIC_O		0xd6
#   define	EBCDIC_P		0xd7
#   define	EBCDIC_Q		0xd8
#   define	EBCDIC_R		0xd9
#   define	EBCDIC_onesuperior	0xda
#   define	EBCDIC_ucircumflex	0xdb
#   define	EBCDIC_udieresis	0xdc
#   define	EBCDIC_ugrave		0xdd
#   define	EBCDIC_uacute		0xde
#   define	EBCDIC_ydieresis	0xdf
#   define	EBCDIC_backslash	0xe0
#   define	EBCDIC_divide		0xe1
#   define	EBCDIC_S		0xe2
#   define	EBCDIC_T		0xe3
#   define	EBCDIC_U		0xe4
#   define	EBCDIC_V		0xe5
#   define	EBCDIC_W		0xe6
#   define	EBCDIC_X		0xe7
#   define	EBCDIC_Y		0xe8
#   define	EBCDIC_Z		0xe9
#   define	EBCDIC_twosuperior	0xea
#   define	EBCDIC_Ocircumflex	0xeb
#   define	EBCDIC_Odieresis	0xec
#   define	EBCDIC_Ograve		0xed
#   define	EBCDIC_Oacute		0xee
#   define	EBCDIC_Otilde		0xef
#   define	EBCDIC_zero		0xf0
#   define	EBCDIC_one		0xf1
#   define	EBCDIC_two		0xf2
#   define	EBCDIC_three		0xf3
#   define	EBCDIC_four		0xf4
#   define	EBCDIC_five		0xf5
#   define	EBCDIC_six		0xf6
#   define	EBCDIC_seven		0xf7
#   define	EBCDIC_eight		0xf8
#   define	EBCDIC_nine		0xf9
#   define	EBCDIC_threesuperior	0xfa
#   define	EBCDIC_Ucircumflex	0xfb
#   define	EBCDIC_Udieresis	0xfc
#   define	EBCDIC_Ugrave		0xfd
#   define	EBCDIC_Uacute		0xfe
#   define	EBCDIC_OE		0xff

/************************************************************************/
/*  Code page 437 'English' of MS-DOS 5.0.				*/
/************************************************************************/
#   define	DOS437_nul		ASCII_nul
#   define	DOS437_soh		ASCII_soh
#   define	DOS437_stx		ASCII_stx
#   define	DOS437_etx		ASCII_etx
#   define	DOS437_eot		ASCII_eot
#   define	DOS437_enq		ASCII_enq
#   define	DOS437_ack		ASCII_ack
#   define	DOS437_bel		ASCII_bel

#   define	DOS437_bs		ASCII_bs
#   define	DOS437_ht		ASCII_ht
#   define	DOS437_nl		ASCII_nl
#   define	DOS437_vt		ASCII_vt
#   define	DOS437_np		ASCII_np
#   define	DOS437_cr		ASCII_cr
#   define	DOS437_so		ASCII_so
#   define	DOS437_si		ASCII_si

#   define	DOS437_dle		ASCII_dle
#   define	DOS437_dc1		ASCII_dc1
#   define	DOS437_dc2		ASCII_dc2
#   define	DOS437_dc3		ASCII_dc3
#   define	DOS437_dc4		ASCII_dc4
#   define	DOS437_nak		ASCII_nak
#   define	DOS437_syn		ASCII_syn
#   define	DOS437_etb		ASCII_etb

#   define	DOS437_can		ASCII_can
#   define	DOS437_em		ASCII_em
#   define	DOS437_sub		ASCII_sub
#   define	DOS437_esc		ASCII_esc
#   define	DOS437_fs		ASCII_fs
#   define	DOS437_gs		ASCII_gs
#   define	DOS437_rs		ASCII_rs
#   define	DOS437_us		ASCII_us

#   define	DOS437_space		ASCII_space
#   define	DOS437_exclam		ASCII_exclam
#   define	DOS437_quotedbl		ASCII_quotedbl
#   define	DOS437_numbersign	ASCII_numbersign
#   define	DOS437_dollar		ASCII_dollar
#   define	DOS437_percent		ASCII_percent
#   define	DOS437_ampersand	ASCII_ampersand
#   define	DOS437_quoteright	ASCII_quoteright

#   define	DOS437_parenleft	ASCII_parenleft
#   define	DOS437_parenright	ASCII_parenright
#   define	DOS437_asterisk		ASCII_asterisk
#   define	DOS437_plus		ASCII_plus
#   define	DOS437_comma		ASCII_comma
#   define	DOS437_minus		ASCII_minus
#   define	DOS437_period		ASCII_period
#   define	DOS437_slash		ASCII_slash

#   define	DOS437_zero		ASCII_zero
#   define	DOS437_one		ASCII_one
#   define	DOS437_two		ASCII_two
#   define	DOS437_three		ASCII_three
#   define	DOS437_four		ASCII_four
#   define	DOS437_five		ASCII_five
#   define	DOS437_six		ASCII_six
#   define	DOS437_seven		ASCII_seven

#   define	DOS437_eight		ASCII_eight
#   define	DOS437_nine		ASCII_nine
#   define	DOS437_colon		ASCII_colon
#   define	DOS437_semicolon	ASCII_semicolon
#   define	DOS437_less		ASCII_less
#   define	DOS437_equal		ASCII_equal
#   define	DOS437_greater		ASCII_greater
#   define	DOS437_question		ASCII_question

#   define	DOS437_at		ASCII_at
#   define	DOS437_A		ASCII_A
#   define	DOS437_B		ASCII_B
#   define	DOS437_C		ASCII_C
#   define	DOS437_D		ASCII_D
#   define	DOS437_E		ASCII_E
#   define	DOS437_F		ASCII_F
#   define	DOS437_G		ASCII_G

#   define	DOS437_H		ASCII_H
#   define	DOS437_I		ASCII_I
#   define	DOS437_J		ASCII_J
#   define	DOS437_K		ASCII_K
#   define	DOS437_L		ASCII_L
#   define	DOS437_M		ASCII_M
#   define	DOS437_N		ASCII_N
#   define	DOS437_O		ASCII_O

#   define	DOS437_P		ASCII_P
#   define	DOS437_Q		ASCII_Q
#   define	DOS437_R		ASCII_R
#   define	DOS437_S		ASCII_S
#   define	DOS437_T		ASCII_T
#   define	DOS437_U		ASCII_U
#   define	DOS437_V		ASCII_V
#   define	DOS437_W		ASCII_W

#   define	DOS437_X		ASCII_X
#   define	DOS437_Y		ASCII_Y
#   define	DOS437_Z		ASCII_Z
#   define	DOS437_bracketleft	ASCII_bracketleft
#   define	DOS437_backslash	ASCII_backslash
#   define	DOS437_bracketright	ASCII_bracketright
#   define	DOS437_asciicircum	ASCII_circumflex
#   define	DOS437_underscore	ASCII_underscore

#   define	DOS437_quoteleft	ASCII_quoteleft
#   define	DOS437_a		ASCII_a
#   define	DOS437_b		ASCII_b
#   define	DOS437_c		ASCII_c
#   define	DOS437_d		ASCII_d
#   define	DOS437_e		ASCII_e
#   define	DOS437_f		ASCII_f
#   define	DOS437_g		ASCII_g

#   define	DOS437_h		ASCII_h
#   define	DOS437_i		ASCII_i
#   define	DOS437_j		ASCII_j
#   define	DOS437_k		ASCII_k
#   define	DOS437_l		ASCII_l
#   define	DOS437_m		ASCII_m
#   define	DOS437_n		ASCII_n
#   define	DOS437_o		ASCII_o

#   define	DOS437_p		ASCII_p
#   define	DOS437_q		ASCII_q
#   define	DOS437_r		ASCII_r
#   define	DOS437_s		ASCII_s
#   define	DOS437_t		ASCII_t
#   define	DOS437_u		ASCII_u
#   define	DOS437_v		ASCII_v
#   define	DOS437_w		ASCII_w

#   define	DOS437_x		ASCII_x
#   define	DOS437_y		ASCII_y
#   define	DOS437_z		ASCII_z
#   define	DOS437_braceleft	ASCII_braceleft
#   define	DOS437_bar		ASCII_bar
#   define	DOS437_braceright	ASCII_braceright
#   define	DOS437_asciitilde	ASCII_tilde
#   define	DOS437_del		ASCII_del

#   define	DOS437_Ccedilla		128
#   define	DOS437_udieresis	129
#   define	DOS437_eacute		130
#   define	DOS437_acircumflex	131
#   define	DOS437_adieresis	132
#   define	DOS437_agrave		133
#   define	DOS437_aring		134
#   define	DOS437_ccedilla		135

#   define	DOS437_ecircumflex	136
#   define	DOS437_edieresis	137
#   define	DOS437_egrave		138
#   define	DOS437_idieresis	139
#   define	DOS437_icircumflex	140
#   define	DOS437_igrave		141
#   define	DOS437_Adieresis	142
#   define	DOS437_Aring		143

#   define	DOS437_Eacute		144
#   define	DOS437_ae		145
#   define	DOS437_AE		146
#   define	DOS437_ocircumflex	147
#   define	DOS437_odieresis	148
#   define	DOS437_ograve		149
#   define	DOS437_ucircumflex	150
#   define	DOS437_ugrave		151

#   define	DOS437_ydieresis	152
#   define	DOS437_Odieresis	153
#   define	DOS437_Udieresis	154
#   define	DOS437_cent		155
#   define	DOS437_sterling		156
#   define	DOS437_yen		157
#   define	DOS437_0x9e		158	/* peseta sign UNICODE 20a7 */
#   define	DOS437_florin		159

#   define	DOS437_aacute		160
#   define	DOS437_iacute		161
#   define	DOS437_oacute		162
#   define	DOS437_uacute		163
#   define	DOS437_ntilde		164
#   define	DOS437_Ntilde		165
#   define	DOS437_ordfeminine	166
#   define	DOS437_ordmasculine	167

#   define	DOS437_questiondown	168
#   define	DOS437_0xa9		169 	/*  reversed not UNICODE 2310 */
#   define	DOS437_logicalnot	170
#   define	DOS437_onehalf		171
#   define	DOS437_onequarter	172
#   define	DOS437_exclamdown	173
#   define	DOS437_guillemotleft	174
#   define	DOS437_guillemotright	175

#   define	DOS437_0xb0		176	/*  Line drawing	*/
#   define	DOS437_0xb1		177	/*  Line drawing	*/
#   define	DOS437_0xb2		178	/*  Line drawing	*/
#   define	DOS437_0xb3		179	/*  Line drawing	*/
#   define	DOS437_0xb4		180	/*  Line drawing	*/
#   define	DOS437_0xb5		181	/*  Line drawing	*/
#   define	DOS437_0xb6		182	/*  Line drawing	*/
#   define	DOS437_0xb7		183	/*  Line drawing	*/

#   define	DOS437_0xb8		184	/*  Line drawing	*/
#   define	DOS437_0xb9		185	/*  Line drawing	*/
#   define	DOS437_0xba		186	/*  Line drawing	*/
#   define	DOS437_0xbb		187	/*  Line drawing	*/
#   define	DOS437_0xbc		188	/*  Line drawing	*/
#   define	DOS437_0xbd		189	/*  Line drawing	*/
#   define	DOS437_0xbe		190	/*  Line drawing	*/
#   define	DOS437_0xbf		191	/*  Line drawing	*/

#   define	DOS437_0xc0		192	/*  Line drawing	*/
#   define	DOS437_0xc1		193	/*  Line drawing	*/
#   define	DOS437_0xc2		194	/*  Line drawing	*/
#   define	DOS437_0xc3		195	/*  Line drawing	*/
#   define	DOS437_0xc4		196	/*  Line drawing	*/
#   define	DOS437_0xc5		197	/*  Line drawing	*/
#   define	DOS437_0xc6		198	/*  Line drawing	*/
#   define	DOS437_0xc7		199	/*  Line drawing	*/

#   define	DOS437_0xc8		200	/*  Line drawing	*/
#   define	DOS437_0xc9		201	/*  Line drawing	*/
#   define	DOS437_0xca		202	/*  Line drawing	*/
#   define	DOS437_0xcb		203	/*  Line drawing	*/
#   define	DOS437_0xcc		204	/*  Line drawing	*/
#   define	DOS437_0xcd		205	/*  Line drawing	*/
#   define	DOS437_0xce		206	/*  Line drawing	*/
#   define	DOS437_0xcf		207	/*  Line drawing	*/

#   define	DOS437_0xd0		208	/*  Line drawing	*/
#   define	DOS437_0xd1		209	/*  Line drawing	*/
#   define	DOS437_0xd2		210	/*  Line drawing	*/
#   define	DOS437_0xd3		211	/*  Line drawing	*/
#   define	DOS437_0xd4		212	/*  Line drawing	*/
#   define	DOS437_0xd5		213	/*  Line drawing	*/
#   define	DOS437_0xd6		214	/*  Line drawing	*/
#   define	DOS437_0xd7		215	/*  Line drawing	*/

#   define	DOS437_0xd8		216	/*  Line drawing	*/
#   define	DOS437_0xd9		217	/*  Line drawing	*/
#   define	DOS437_0xda		218	/*  Line drawing	*/
#   define	DOS437_0xdb		219	/*  Line drawing	*/
#   define	DOS437_0xdc		220	/*  Line drawing	*/
#   define	DOS437_0xdd		221	/*  Line drawing	*/
#   define	DOS437_0xde		222	/*  Line drawing	*/
#   define	DOS437_0xdf		223	/*  Line drawing	*/

#   define	DOS437_alpha		224
#   define	DOS437_germandbls	225
#   define	DOS437_Gamma		226
#   define	DOS437_Pi		227
#   define	DOS437_Sigma		228
#   define	DOS437_sigma		229
#   define	DOS437_mu		230
#   define	DOS437_tau		231

#   define	DOS437_Phi		232
#   define	DOS437_Theta		233
#   define	DOS437_Omega		234
#   define	DOS437_delta		235
#   define	DOS437_infinity		236
#   define	DOS437_phi		237
#   define	DOS437_epsilon		238
#   define	DOS437_intersection	239

#   define	DOS437_equivalence	240
#   define	DOS437_plusminus	241
#   define	DOS437_greaterequal	242
#   define	DOS437_lessequal	243
#   define	DOS437_integraltp	244
#   define	DOS437_integralbt	245
#   define	DOS437_divide		246
#   define	DOS437_approxequal	247

#   define	DOS437_degree		248
#   define	DOS437_bullet		249
#   define	DOS437_periodcentered	250
#   define	DOS437_radical		251
#   define	DOS437_nsuperior	252
#   define	DOS437_twosuperior	253
#   define	DOS437_0xfe		254	/*  Drawing: black square */
#   define	DOS437_0xff		255

/************************************************************************/
/*  The Apple MACINTOSH character set.					*/
/************************************************************************/

#   define MAC_Adieresis		0x80
#   define MAC_Aring			0x81
#   define MAC_Ccedilla			0x82
#   define MAC_Eacute			0x83
#   define MAC_Ntilde			0x84
#   define MAC_Odieresis		0x85
#   define MAC_Udieresis		0x86
#   define MAC_aacute			0x87

#   define MAC_agrave			0x88
#   define MAC_acircumflex		0x89
#   define MAC_adieresis		0x8a
#   define MAC_atilde			0x8b
#   define MAC_aring			0x8c
#   define MAC_ccedilla			0x8d
#   define MAC_eacute			0x8e
#   define MAC_egrave			0x8f

#   define MAC_ecircumflex		0x90
#   define MAC_edieresis		0x91
#   define MAC_iacute			0x92
#   define MAC_igrave			0x93
#   define MAC_icircumflex		0x94
#   define MAC_idieresis		0x95
#   define MAC_ntilde			0x96
#   define MAC_oacute			0x97

#   define MAC_ograve			0x98
#   define MAC_ocircumflex		0x99
#   define MAC_odieresis		0x9a
#   define MAC_otilde			0x9b
#   define MAC_uacute			0x9c
#   define MAC_ugrave			0x9d
#   define MAC_ucircumflex		0x9e
#   define MAC_udieresis		0x9f

#   define MAC_degree			0xa1
#   define MAC_cent			0xa2
#   define MAC_sterling			0xa3
#   define MAC_section			0xa4
#   define MAC_paragraph		0xa6
#   define MAC_germandbls		0xa7

#   define MAC_registered		0xa8
#   define MAC_copyright		0xa9
#   define MAC_AE			0xae
#   define MAC_Oslash			0xaf

#   define MAC_plusminus		0xb1
#   define MAC_yen			0xb4
#   define MAC_mu			0xb5

#   define MAC_pi			0xb9
#   define MAC_ordfeminine		0xbb
#   define MAC_ordmasculine		0xbc
#   define MAC_ohm			0xbd
#   define MAC_ae			0xbe
#   define MAC_oslash			0xbf

#   define MAC_quesiondown		0xc0
#   define MAC_exclamdown		0xc1
#   define MAC_logicalnot		0xc2
#   define MAC_guillemotleft		0xc7
#   define MAC_guillemotright		0xc8

#   define MAC_Agrave			0xcb
#   define MAC_Atilde			0xcc
#   define MAC_Otilde			0xcd

#   define MAC_divide			0xd6

#   define MAC_ydieresis		0xd8
#   define MAC_Yacute			0xd9
#   define MAC_currency			0xdb

#   define MAC_Acircumflex		0xe5
#   define MAC_Ecircumflex		0xe6
#   define MAC_Aacute			0xe7

#   define MAC_Edieresis		0xe8
#   define MAC_Egrave			0xe9
#   define MAC_Iacute			0xea
#   define MAC_Icircumflex		0xeb
#   define MAC_Idieresis		0xec
#   define MAC_Igrave			0xed
#   define MAC_Oacute			0xee
#   define MAC_Ocircumflex		0xef

#   define MAC_Ograve			0xf1
#   define MAC_Uacute			0xf2
#   define MAC_Ucircumflex		0xf3
#   define MAC_Ugrave			0xf4

/************************************************************************/
/*  Postscript symbol encoding						*/
/************************************************************************/

#   define	PSSYM__UNDEF0			0
#   define	PSSYM__UNDEF1			1
#   define	PSSYM__UNDEF2			2
#   define	PSSYM__UNDEF3			3
#   define	PSSYM__UNDEF4			4
#   define	PSSYM__UNDEF5			5
#   define	PSSYM__UNDEF6			6
#   define	PSSYM__UNDEF7			7
#   define	PSSYM__UNDEF8			8
#   define	PSSYM__UNDEF9			9
#   define	PSSYM__UNDEF10			10
#   define	PSSYM__UNDEF11			11
#   define	PSSYM__UNDEF12			12
#   define	PSSYM__UNDEF13			13
#   define	PSSYM__UNDEF14			14
#   define	PSSYM__UNDEF15			15
#   define	PSSYM__UNDEF16			16
#   define	PSSYM__UNDEF17			17
#   define	PSSYM__UNDEF18			18
#   define	PSSYM__UNDEF19			19
#   define	PSSYM__UNDEF20			20
#   define	PSSYM__UNDEF21			21
#   define	PSSYM__UNDEF22			22
#   define	PSSYM__UNDEF23			23
#   define	PSSYM__UNDEF24			24
#   define	PSSYM__UNDEF25			25
#   define	PSSYM__UNDEF26			26
#   define	PSSYM__UNDEF27			27
#   define	PSSYM__UNDEF28			28
#   define	PSSYM__UNDEF29			29
#   define	PSSYM__UNDEF30			30
#   define	PSSYM__UNDEF31			31
#   define	PSSYM_space			32
#   define	PSSYM_exclam			33
#   define	PSSYM_universal			34
#   define	PSSYM_numbersign		35
#   define	PSSYM_existential		36
#   define	PSSYM_percent			37
#   define	PSSYM_ampersand			38
#   define	PSSYM_suchthat			39
#   define	PSSYM_parenleft			40
#   define	PSSYM_parenright		41
#   define	PSSYM_asteriskmath		42
#   define	PSSYM_plus			43
#   define	PSSYM_comma			44
#   define	PSSYM_minus			45
#   define	PSSYM_period			46
#   define	PSSYM_slash			47
#   define	PSSYM_zero			48
#   define	PSSYM_one			49
#   define	PSSYM_two			50
#   define	PSSYM_three			51
#   define	PSSYM_four			52
#   define	PSSYM_five			53
#   define	PSSYM_six			54
#   define	PSSYM_seven			55
#   define	PSSYM_eight			56
#   define	PSSYM_nine			57
#   define	PSSYM_colon			58
#   define	PSSYM_semicolon			59
#   define	PSSYM_less			60
#   define	PSSYM_equal			61
#   define	PSSYM_greater			62
#   define	PSSYM_question			63
#   define	PSSYM_congruent			64
#   define	PSSYM_Alpha			65
#   define	PSSYM_Beta			66
#   define	PSSYM_Chi			67
#   define	PSSYM_Delta			68
#   define	PSSYM_Epsilon			69
#   define	PSSYM_Phi			70
#   define	PSSYM_Gamma			71
#   define	PSSYM_Eta			72
#   define	PSSYM_Iota			73
#   define	PSSYM_theta1			74
#   define	PSSYM_Kappa			75
#   define	PSSYM_Lambda			76
#   define	PSSYM_Mu			77
#   define	PSSYM_Nu			78
#   define	PSSYM_Omicron			79
#   define	PSSYM_Pi			80
#   define	PSSYM_Theta			81
#   define	PSSYM_Rho			82
#   define	PSSYM_Sigma			83
#   define	PSSYM_Tau			84
#   define	PSSYM_Upsilon			85
#   define	PSSYM_sigma1			86
#   define	PSSYM_Omega			87
#   define	PSSYM_Xi			88
#   define	PSSYM_Psi			89
#   define	PSSYM_Zeta			90
#   define	PSSYM_bracketleft		91
#   define	PSSYM_therefore			92
#   define	PSSYM_bracketright		93
#   define	PSSYM_perpendicular		94
#   define	PSSYM_underscore		95
#   define	PSSYM_radicalex			96
#   define	PSSYM_alpha			97
#   define	PSSYM_beta			98
#   define	PSSYM_chi			99
#   define	PSSYM_delta			100
#   define	PSSYM_epsilon			101
#   define	PSSYM_phi			102
#   define	PSSYM_gamma			103
#   define	PSSYM_eta			104
#   define	PSSYM_iota			105
#   define	PSSYM_phi1			106
#   define	PSSYM_kappa			107
#   define	PSSYM_lambda			108
#   define	PSSYM_mu			109
#   define	PSSYM_nu			110
#   define	PSSYM_omicron			111
#   define	PSSYM_pi			112
#   define	PSSYM_theta			113
#   define	PSSYM_rho			114
#   define	PSSYM_sigma			115
#   define	PSSYM_tau			116
#   define	PSSYM_upsilon			117
#   define	PSSYM_omega1			118
#   define	PSSYM_omega			119
#   define	PSSYM_xi			120
#   define	PSSYM_psi			121
#   define	PSSYM_zeta			122
#   define	PSSYM_braceleft			123
#   define	PSSYM_bar			124
#   define	PSSYM_braceright		125
#   define	PSSYM_similar			126
#   define	PSSYM__UNDEF127			127
#   define	PSSYM__UNDEF128			128
#   define	PSSYM__UNDEF129			129
#   define	PSSYM__UNDEF130			130
#   define	PSSYM__UNDEF131			131
#   define	PSSYM__UNDEF132			132
#   define	PSSYM__UNDEF133			133
#   define	PSSYM__UNDEF134			134
#   define	PSSYM__UNDEF135			135
#   define	PSSYM__UNDEF136			136
#   define	PSSYM__UNDEF137			137
#   define	PSSYM__UNDEF138			138
#   define	PSSYM__UNDEF139			139
#   define	PSSYM__UNDEF140			140
#   define	PSSYM__UNDEF141			141
#   define	PSSYM__UNDEF142			142
#   define	PSSYM__UNDEF143			143
#   define	PSSYM__UNDEF144			144
#   define	PSSYM__UNDEF145			145
#   define	PSSYM__UNDEF146			146
#   define	PSSYM__UNDEF147			147
#   define	PSSYM__UNDEF148			148
#   define	PSSYM__UNDEF149			149
#   define	PSSYM__UNDEF150			150
#   define	PSSYM__UNDEF151			151
#   define	PSSYM__UNDEF152			152
#   define	PSSYM__UNDEF153			153
#   define	PSSYM__UNDEF154			154
#   define	PSSYM__UNDEF155			155
#   define	PSSYM__UNDEF156			156
#   define	PSSYM__UNDEF157			157
#   define	PSSYM__UNDEF158			158
#   define	PSSYM__UNDEF159			159
#   define	PSSYM__UNDEF160			160
#   define	PSSYM_Upsilon1			161
#   define	PSSYM_minute			162
#   define	PSSYM_lessequal			163
#   define	PSSYM_fraction			164
#   define	PSSYM_infinity			165
#   define	PSSYM_florin			166
#   define	PSSYM_club			167
#   define	PSSYM_diamond			168
#   define	PSSYM_heart			169
#   define	PSSYM_spade			170
#   define	PSSYM_arrowboth			171
#   define	PSSYM_arrowleft			172
#   define	PSSYM_arrowup			173
#   define	PSSYM_arrowright		174
#   define	PSSYM_arrowdown			175
#   define	PSSYM_degree			176
#   define	PSSYM_plusminus			177
#   define	PSSYM_second			178
#   define	PSSYM_greaterequal		179
#   define	PSSYM_multiply			180
#   define	PSSYM_proportional		181
#   define	PSSYM_partialdiff		182
#   define	PSSYM_bullet			183
#   define	PSSYM_divide			184
#   define	PSSYM_notequal			185
#   define	PSSYM_equivalence		186
#   define	PSSYM_approxequal		187
#   define	PSSYM_ellipsis			188
#   define	PSSYM_arrowvertex		189
#   define	PSSYM_arrowhorizex		190
#   define	PSSYM_carriagereturn		191
#   define	PSSYM_aleph			192
#   define	PSSYM_Ifraktur			193
#   define	PSSYM_Rfraktur			194
#   define	PSSYM_weierstrass		195
#   define	PSSYM_circlemultiply		196
#   define	PSSYM_circleplus		197
#   define	PSSYM_emptyset			198
#   define	PSSYM_intersection		199
#   define	PSSYM_union			200
#   define	PSSYM_propersuperset		201
#   define	PSSYM_reflexsuperset		202
#   define	PSSYM_notsubset			203
#   define	PSSYM_propersubset		204
#   define	PSSYM_reflexsubset		205
#   define	PSSYM_element			206
#   define	PSSYM_notelement		207
#   define	PSSYM_angle			208
#   define	PSSYM_gradient			209
#   define	PSSYM_registerserif		210
#   define	PSSYM_copyrightserif		211
#   define	PSSYM_trademarkserif		212
#   define	PSSYM_product			213
#   define	PSSYM_radical			214
#   define	PSSYM_dotmath			215
#   define	PSSYM_logicalnot		216
#   define	PSSYM_logicaland		217
#   define	PSSYM_logicalor			218
#   define	PSSYM_arrowdblboth		219
#   define	PSSYM_arrowdblleft		220
#   define	PSSYM_arrowdblup		221
#   define	PSSYM_arrowdblright		222
#   define	PSSYM_arrowdbldown		223
#   define	PSSYM_lozenge			224
#   define	PSSYM_angleleft			225
#   define	PSSYM_registersans		226
#   define	PSSYM_copyrightsans		227
#   define	PSSYM_trademarksans		228
#   define	PSSYM_summation			229
#   define	PSSYM_parenlefttp		230
#   define	PSSYM_parenleftex		231
#   define	PSSYM_parenleftbt		232
#   define	PSSYM_bracketlefttp		233
#   define	PSSYM_bracketleftex		234
#   define	PSSYM_bracketleftbt		235
#   define	PSSYM_bracelefttp		236
#   define	PSSYM_braceleftmid		237
#   define	PSSYM_braceleftbt		238
#   define	PSSYM_braceex			239
#   define	PSSYM__UNDEF240			240
#   define	PSSYM_angleright		241
#   define	PSSYM_integral			242
#   define	PSSYM_integraltp		243
#   define	PSSYM_integralex		244
#   define	PSSYM_integralbt		245
#   define	PSSYM_parenrighttp		246
#   define	PSSYM_parenrightex		247
#   define	PSSYM_parenrightbt		248
#   define	PSSYM_bracketrighttp		249
#   define	PSSYM_bracketrightex		250
#   define	PSSYM_bracketrightbt		251
#   define	PSSYM_bracerighttp		252
#   define	PSSYM_bracerightmid		253
#   define	PSSYM_bracerightbt		254
#   define	PSSYM__UNDEF255			255

/************************************************************************/
/*									*/
/*  Names for the characters in the Adobe Cyrillic Encoding.		*/
/*									*/
/************************************************************************/

#   define	PSCYR__0x00		0x00	/*   0  */
#   define	PSCYR__0x01		0x01	/*   1  */
#   define	PSCYR__0x02		0x02	/*   2  */
#   define	PSCYR__0x03		0x03	/*   3  */
#   define	PSCYR__0x04		0x04	/*   4  */
#   define	PSCYR__0x05		0x05	/*   5  */
#   define	PSCYR__0x06		0x06	/*   6  */
#   define	PSCYR__0x07		0x07	/*   7  */
#   define	PSCYR__0x08		0x08	/*   8  */
#   define	PSCYR__0x09		0x09	/*   9  */
#   define	PSCYR__0x0a		0x0a	/*  10  */
#   define	PSCYR__0x0b		0x0b	/*  11  */
#   define	PSCYR__0x0c		0x0c	/*  12  */
#   define	PSCYR__0x0d		0x0d	/*  13  */
#   define	PSCYR__0x0e		0x0e	/*  14  */
#   define	PSCYR__0x0f		0x0f	/*  15  */
#   define	PSCYR__0x10		0x10	/*  16  */
#   define	PSCYR__0x11		0x11	/*  17  */
#   define	PSCYR__0x12		0x12	/*  18  */
#   define	PSCYR__0x13		0x13	/*  19  */
#   define	PSCYR__0x14		0x14	/*  20  */
#   define	PSCYR__0x15		0x15	/*  21  */
#   define	PSCYR__0x16		0x16	/*  22  */
#   define	PSCYR__0x17		0x17	/*  23  */
#   define	PSCYR__0x18		0x18	/*  24  */
#   define	PSCYR__0x19		0x19	/*  25  */
#   define	PSCYR__0x1a		0x1a	/*  26  */
#   define	PSCYR__0x1b		0x1b	/*  27  */
#   define	PSCYR__0x1c		0x1c	/*  28  */
#   define	PSCYR__0x1d		0x1d	/*  29  */
#   define	PSCYR__0x1e		0x1e	/*  30  */
#   define	PSCYR__0x1f		0x1f	/*  31  */
#   define	PSCYR_space		0x20	/*  32  */
#   define	PSCYR_exclam		0x21	/*  33  */
#   define	PSCYR_quotedbl		0x22	/*  34  */
#   define	PSCYR_numbersign	0x23	/*  35  */
#   define	PSCYR_dollar		0x24	/*  36  */
#   define	PSCYR_percent		0x25	/*  37  */
#   define	PSCYR_ampersand		0x26	/*  38  */
#   define	PSCYR_quotesingle	0x27	/*  39  */
#   define	PSCYR_parenleft		0x28	/*  40  */
#   define	PSCYR_parenright	0x29	/*  41  */
#   define	PSCYR_asterisk		0x2a	/*  42  */
#   define	PSCYR_plus		0x2b	/*  43  */
#   define	PSCYR_comma		0x2c	/*  44  */
#   define	PSCYR_hyphen		0x2d	/*  45  */
#   define	PSCYR_period		0x2e	/*  46  */
#   define	PSCYR_slash		0x2f	/*  47  */
#   define	PSCYR_zero		0x30	/*  48  */
#   define	PSCYR_one		0x31	/*  49  */
#   define	PSCYR_two		0x32	/*  50  */
#   define	PSCYR_three		0x33	/*  51  */
#   define	PSCYR_four		0x34	/*  52  */
#   define	PSCYR_five		0x35	/*  53  */
#   define	PSCYR_six		0x36	/*  54  */
#   define	PSCYR_seven		0x37	/*  55  */
#   define	PSCYR_eight		0x38	/*  56  */
#   define	PSCYR_nine		0x39	/*  57  */
#   define	PSCYR_colon		0x3a	/*  58  */
#   define	PSCYR_semicolon		0x3b	/*  59  */
#   define	PSCYR_less		0x3c	/*  60  */
#   define	PSCYR_equal		0x3d	/*  61  */
#   define	PSCYR_greater		0x3e	/*  62  */
#   define	PSCYR_question		0x3f	/*  63  */
#   define	PSCYR_at		0x40	/*  64  */
#   define	PSCYR_A			0x41	/*  65  */
#   define	PSCYR_B			0x42	/*  66  */
#   define	PSCYR_C			0x43	/*  67  */
#   define	PSCYR_D			0x44	/*  68  */
#   define	PSCYR_E			0x45	/*  69  */
#   define	PSCYR_F			0x46	/*  70  */
#   define	PSCYR_G			0x47	/*  71  */
#   define	PSCYR_H			0x48	/*  72  */
#   define	PSCYR_I			0x49	/*  73  */
#   define	PSCYR_J			0x4a	/*  74  */
#   define	PSCYR_K			0x4b	/*  75  */
#   define	PSCYR_L			0x4c	/*  76  */
#   define	PSCYR_M			0x4d	/*  77  */
#   define	PSCYR_N			0x4e	/*  78  */
#   define	PSCYR_O			0x4f	/*  79  */
#   define	PSCYR_P			0x50	/*  80  */
#   define	PSCYR_Q			0x51	/*  81  */
#   define	PSCYR_R			0x52	/*  82  */
#   define	PSCYR_S			0x53	/*  83  */
#   define	PSCYR_T			0x54	/*  84  */
#   define	PSCYR_U			0x55	/*  85  */
#   define	PSCYR_V			0x56	/*  86  */
#   define	PSCYR_W			0x57	/*  87  */
#   define	PSCYR_X			0x58	/*  88  */
#   define	PSCYR_Y			0x59	/*  89  */
#   define	PSCYR_Z			0x5a	/*  90  */
#   define	PSCYR_bracketleft	0x5b	/*  91  */
#   define	PSCYR_backslash		0x5c	/*  92  */
#   define	PSCYR_bracketright	0x5d	/*  93  */
#   define	PSCYR_asciicircum	0x5e	/*  94  */
#   define	PSCYR_underscore	0x5f	/*  95  */
#   define	PSCYR_grave		0x60	/*  96  */
#   define	PSCYR_a			0x61	/*  97  */
#   define	PSCYR_b			0x62	/*  98  */
#   define	PSCYR_c			0x63	/*  99  */
#   define	PSCYR_d			0x64	/* 100  */
#   define	PSCYR_e			0x65	/* 101  */
#   define	PSCYR_f			0x66	/* 102  */
#   define	PSCYR_g			0x67	/* 103  */
#   define	PSCYR_h			0x68	/* 104  */
#   define	PSCYR_i			0x69	/* 105  */
#   define	PSCYR_j			0x6a	/* 106  */
#   define	PSCYR_k			0x6b	/* 107  */
#   define	PSCYR_l			0x6c	/* 108  */
#   define	PSCYR_m			0x6d	/* 109  */
#   define	PSCYR_n			0x6e	/* 110  */
#   define	PSCYR_o			0x6f	/* 111  */
#   define	PSCYR_p			0x70	/* 112  */
#   define	PSCYR_q			0x71	/* 113  */
#   define	PSCYR_r			0x72	/* 114  */
#   define	PSCYR_s			0x73	/* 115  */
#   define	PSCYR_t			0x74	/* 116  */
#   define	PSCYR_u			0x75	/* 117  */
#   define	PSCYR_v			0x76	/* 118  */
#   define	PSCYR_w			0x77	/* 119  */
#   define	PSCYR_x			0x78	/* 120  */
#   define	PSCYR_y			0x79	/* 121  */
#   define	PSCYR_z			0x7a	/* 122  */
#   define	PSCYR_braceleft		0x7b	/* 123  */
#   define	PSCYR_bar		0x7c	/* 124  */
#   define	PSCYR_braceright	0x7d	/* 125  */
#   define	PSCYR_asciitilde	0x7e	/* 126  */
#   define	PSCYR__0x7f		0x7f	/* 127  */
#   define	PSCYR_afii10051		0x80	/* 128  */
#   define	PSCYR_afii10052		0x81	/* 129  */
#   define	PSCYR_quotesinglbase	0x82	/* 130  */
#   define	PSCYR_afii10100		0x83	/* 131  */
#   define	PSCYR_quotedblbase	0x84	/* 132  */
#   define	PSCYR_ellipsis		0x85	/* 133  */
#   define	PSCYR_dagger		0x86	/* 134  */
#   define	PSCYR_daggerdbl		0x87	/* 135  */
#   define	PSCYR__0x88		0x88	/* 136  */
#   define	PSCYR_perthousand	0x89	/* 137  */
#   define	PSCYR_afii10058		0x8a	/* 138  */
#   define	PSCYR_guilsinglleft	0x8b	/* 139  */
#   define	PSCYR_afii10059		0x8c	/* 140  */
#   define	PSCYR_afii10061		0x8d	/* 141  */
#   define	PSCYR_afii10060		0x8e	/* 142  */
#   define	PSCYR_afii10145		0x8f	/* 143  */
#   define	PSCYR_afii10099		0x90	/* 144  */
#   define	PSCYR_quoteleft		0x91	/* 145  */
#   define	PSCYR_quoteright	0x92	/* 146  */
#   define	PSCYR_quotedblleft	0x93	/* 147  */
#   define	PSCYR_quotedblright	0x94	/* 148  */
#   define	PSCYR_bullet		0x95	/* 149  */
#   define	PSCYR_endash		0x96	/* 150  */
#   define	PSCYR_emdash		0x97	/* 151  */
#   define	PSCYR__0x98		0x98	/* 152  */
#   define	PSCYR_trademark		0x99	/* 153  */
#   define	PSCYR_afii10106		0x9a	/* 154  */
#   define	PSCYR_guilsinglright	0x9b	/* 155  */
#   define	PSCYR_afii10107		0x9c	/* 156  */
#   define	PSCYR_afii10109		0x9d	/* 157  */
#   define	PSCYR_afii10108		0x9e	/* 158  */
#   define	PSCYR_afii10193		0x9f	/* 159  */
#   define	PSCYR__space_0xa0	0xa0	/* 160  */
#   define	PSCYR_afii10062		0xa1	/* 161  */
#   define	PSCYR_afii10110		0xa2	/* 162  */
#   define	PSCYR_afii10057		0xa3	/* 163  */
#   define	PSCYR_currency		0xa4	/* 164  */
#   define	PSCYR_afii10050		0xa5	/* 165  */
#   define	PSCYR_brokenbar		0xa6	/* 166  */
#   define	PSCYR_section		0xa7	/* 167  */
#   define	PSCYR_afii10023		0xa8	/* 168  */
#   define	PSCYR_copyright		0xa9	/* 169  */
#   define	PSCYR_afii10053		0xaa	/* 170  */
#   define	PSCYR_guillemotleft	0xab	/* 171  */
#   define	PSCYR_logicalnot	0xac	/* 172  */
#   define	PSCYR__hyphen_0xad	0xad	/* 173  */
#   define	PSCYR_registered	0xae	/* 174  */
#   define	PSCYR_afii10056		0xaf	/* 175  */
#   define	PSCYR_degree		0xb0	/* 176  */
#   define	PSCYR_plusminus		0xb1	/* 177  */
#   define	PSCYR_afii10055		0xb2	/* 178  */
#   define	PSCYR_afii10103		0xb3	/* 179  */
#   define	PSCYR_afii10098		0xb4	/* 180  */
#   define	PSCYR_mu		0xb5	/* 181  */
#   define	PSCYR_paragraph		0xb6	/* 182  */
#   define	PSCYR_periodcentered	0xb7	/* 183  */
#   define	PSCYR_afii10071		0xb8	/* 184  */
#   define	PSCYR_afii61352		0xb9	/* 185  */
#   define	PSCYR_afii10101		0xba	/* 186  */
#   define	PSCYR_guillemotright	0xbb	/* 187  */
#   define	PSCYR_afii10105		0xbc	/* 188  */
#   define	PSCYR_afii10054		0xbd	/* 189  */
#   define	PSCYR_afii10102		0xbe	/* 190  */
#   define	PSCYR_afii10104		0xbf	/* 191  */
#   define	PSCYR_afii10017		0xc0	/* 192  */
#   define	PSCYR_afii10018		0xc1	/* 193  */
#   define	PSCYR_afii10019		0xc2	/* 194  */
#   define	PSCYR_afii10020		0xc3	/* 195  */
#   define	PSCYR_afii10021		0xc4	/* 196  */
#   define	PSCYR_afii10022		0xc5	/* 197  */
#   define	PSCYR_afii10024		0xc6	/* 198  */
#   define	PSCYR_afii10025		0xc7	/* 199  */
#   define	PSCYR_afii10026		0xc8	/* 200  */
#   define	PSCYR_afii10027		0xc9	/* 201  */
#   define	PSCYR_afii10028		0xca	/* 202  */
#   define	PSCYR_afii10029		0xcb	/* 203  */
#   define	PSCYR_afii10030		0xcc	/* 204  */
#   define	PSCYR_afii10031		0xcd	/* 205  */
#   define	PSCYR_afii10032		0xce	/* 206  */
#   define	PSCYR_afii10033		0xcf	/* 207  */
#   define	PSCYR_afii10034		0xd0	/* 208  */
#   define	PSCYR_afii10035		0xd1	/* 209  */
#   define	PSCYR_afii10036		0xd2	/* 210  */
#   define	PSCYR_afii10037		0xd3	/* 211  */
#   define	PSCYR_afii10038		0xd4	/* 212  */
#   define	PSCYR_afii10039		0xd5	/* 213  */
#   define	PSCYR_afii10040		0xd6	/* 214  */
#   define	PSCYR_afii10041		0xd7	/* 215  */
#   define	PSCYR_afii10042		0xd8	/* 216  */
#   define	PSCYR_afii10043		0xd9	/* 217  */
#   define	PSCYR_afii10044		0xda	/* 218  */
#   define	PSCYR_afii10045		0xdb	/* 219  */
#   define	PSCYR_afii10046		0xdc	/* 220  */
#   define	PSCYR_afii10047		0xdd	/* 221  */
#   define	PSCYR_afii10048		0xde	/* 222  */
#   define	PSCYR_afii10049		0xdf	/* 223  */
#   define	PSCYR_afii10065		0xe0	/* 224  */
#   define	PSCYR_afii10066		0xe1	/* 225  */
#   define	PSCYR_afii10067		0xe2	/* 226  */
#   define	PSCYR_afii10068		0xe3	/* 227  */
#   define	PSCYR_afii10069		0xe4	/* 228  */
#   define	PSCYR_afii10070		0xe5	/* 229  */
#   define	PSCYR_afii10072		0xe6	/* 230  */
#   define	PSCYR_afii10073		0xe7	/* 231  */
#   define	PSCYR_afii10074		0xe8	/* 232  */
#   define	PSCYR_afii10075		0xe9	/* 233  */
#   define	PSCYR_afii10076		0xea	/* 234  */
#   define	PSCYR_afii10077		0xeb	/* 235  */
#   define	PSCYR_afii10078		0xec	/* 236  */
#   define	PSCYR_afii10079		0xed	/* 237  */
#   define	PSCYR_afii10080		0xee	/* 238  */
#   define	PSCYR_afii10081		0xef	/* 239  */
#   define	PSCYR_afii10082		0xf0	/* 240  */
#   define	PSCYR_afii10083		0xf1	/* 241  */
#   define	PSCYR_afii10084		0xf2	/* 242  */
#   define	PSCYR_afii10085		0xf3	/* 243  */
#   define	PSCYR_afii10086		0xf4	/* 244  */
#   define	PSCYR_afii10087		0xf5	/* 245  */
#   define	PSCYR_afii10088		0xf6	/* 246  */
#   define	PSCYR_afii10089		0xf7	/* 247  */
#   define	PSCYR_afii10090		0xf8	/* 248  */
#   define	PSCYR_afii10091		0xf9	/* 249  */
#   define	PSCYR_afii10092		0xfa	/* 250  */
#   define	PSCYR_afii10093		0xfb	/* 251  */
#   define	PSCYR_afii10094		0xfc	/* 252  */
#   define	PSCYR_afii10095		0xfd	/* 253  */
#   define	PSCYR_afii10096		0xfe	/* 254  */
#   define	PSCYR_afii10097		0xff	/* 255  */

/************************************************************************/
/*									*/
/*  Names for the characters in the Windows 1250 code page.		*/
/*									*/
/************************************************************************/

#   define WIN1250__nul		ASCII__nul	/*  0		*/
#   define WIN1250__soh		ASCII__soh	/*  1		*/
#   define WIN1250__stx		ASCII__stx	/*  2		*/
#   define WIN1250__etx		ASCII__etx	/*  3		*/
#   define WIN1250__eot		ASCII__eot	/*  4		*/
#   define WIN1250__enq		ASCII__enq	/*  5		*/
#   define WIN1250__ack		ASCII__ack	/*  6		*/
#   define WIN1250__bel		ASCII__bel	/*  7		*/
#   define WIN1250__bs		ASCII__bs	/*  8		*/
#   define WIN1250__ht		ASCII__ht	/*  9		*/
#   define WIN1250__nl		ASCII__nl	/*  10		*/
#   define WIN1250__vt		ASCII__vt	/*  11		*/
#   define WIN1250__np		ASCII__np	/*  12		*/
#   define WIN1250__cr		ASCII__cr	/*  13		*/
#   define WIN1250__so		ASCII__so	/*  14		*/
#   define WIN1250__si		ASCII__si	/*  15		*/
#   define WIN1250__dle		ASCII__dle	/*  16		*/
#   define WIN1250__dc1		ASCII__dc1	/*  17		*/
#   define WIN1250__dc2		ASCII__dc2	/*  18		*/
#   define WIN1250__dc3		ASCII__dc3	/*  19		*/
#   define WIN1250__dc4		ASCII__dc4	/*  20		*/
#   define WIN1250__nak		ASCII__nak	/*  21		*/
#   define WIN1250__syn		ASCII__syn	/*  22		*/
#   define WIN1250__etb		ASCII__etb	/*  23		*/
#   define WIN1250__can		ASCII__can	/*  24		*/
#   define WIN1250__em		ASCII__em	/*  25		*/
#   define WIN1250__sub		ASCII__sub	/*  26		*/
#   define WIN1250__esc		ASCII__esc	/*  27		*/
#   define WIN1250__fs		ASCII__fs	/*  28		*/
#   define WIN1250__gs		ASCII__gs	/*  29		*/
#   define WIN1250__rs		ASCII__rs	/*  30		*/
#   define WIN1250__us		ASCII__us	/*  31		*/

#   define WIN1250_space	ASCII_space	/*  32		*/
#   define WIN1250_exclam	ASCII_exclam	/*  33		*/
#   define WIN1250_quotedbl	ASCII_quotedbl	/*  34		*/
#   define WIN1250_numbersign	ASCII_numbersign /*  35		*/
#   define WIN1250_dollar	ASCII_dollar	/*  36		*/
#   define WIN1250_percent	ASCII_percent	/*  37		*/
#   define WIN1250_ampersand	ASCII_ampersand	/*  38		*/
#   define WIN1250_quoteright	ASCII_quoteright /*  39		*/
#   define WIN1250_parenleft	ASCII_parenleft	/*  40		*/
#   define WIN1250_parenright	ASCII_parenright /*  41		*/
#   define WIN1250_asterisk	ASCII_asterisk	/*  42		*/
#   define WIN1250_plus		ASCII_plus	/*  43		*/
#   define WIN1250_comma	ASCII_comma	/*  44		*/
#   define WIN1250_minus	ASCII_minus	/*  45		*/
#   define WIN1250_period	ASCII_period	/*  46		*/
#   define WIN1250_slash	ASCII_slash	/*  47		*/
#   define WIN1250_zero		ASCII_zero	/*  48		*/
#   define WIN1250_one		ASCII_one	/*  49		*/
#   define WIN1250_two		ASCII_two	/*  50		*/
#   define WIN1250_three	ASCII_three	/*  51		*/
#   define WIN1250_four		ASCII_four	/*  52		*/
#   define WIN1250_five		ASCII_five	/*  53		*/
#   define WIN1250_six		ASCII_six	/*  54		*/
#   define WIN1250_seven	ASCII_seven	/*  55		*/
#   define WIN1250_eight	ASCII_eight	/*  56		*/
#   define WIN1250_nine		ASCII_nine	/*  57		*/
#   define WIN1250_colon	ASCII_colon	/*  58		*/
#   define WIN1250_semicolon	ASCII_semicolon	/*  59		*/
#   define WIN1250_less		ASCII_less	/*  60		*/
#   define WIN1250_equal	ASCII_equal	/*  61		*/
#   define WIN1250_greater	ASCII_greater	/*  62		*/
#   define WIN1250_question	ASCII_question	/*  63		*/

#   define WIN1250_at		ASCII_at	/*  64		*/
#   define WIN1250_A		ASCII_A		/*  65		*/
#   define WIN1250_B		ASCII_B		/*  66		*/
#   define WIN1250_C		ASCII_C		/*  67		*/
#   define WIN1250_D		ASCII_D		/*  68		*/
#   define WIN1250_E		ASCII_E		/*  69		*/
#   define WIN1250_F		ASCII_F		/*  70		*/
#   define WIN1250_G		ASCII_G		/*  71		*/
#   define WIN1250_H		ASCII_H		/*  72		*/
#   define WIN1250_I		ASCII_I		/*  73		*/
#   define WIN1250_J		ASCII_J		/*  74		*/
#   define WIN1250_K		ASCII_K		/*  75		*/
#   define WIN1250_L		ASCII_L		/*  76		*/
#   define WIN1250_M		ASCII_M		/*  77		*/
#   define WIN1250_N		ASCII_N		/*  78		*/
#   define WIN1250_O		ASCII_O		/*  79		*/
#   define WIN1250_P		ASCII_P		/*  80		*/
#   define WIN1250_Q		ASCII_Q		/*  81		*/
#   define WIN1250_R		ASCII_R		/*  82		*/
#   define WIN1250_S		ASCII_S		/*  83		*/
#   define WIN1250_T		ASCII_T		/*  84		*/
#   define WIN1250_U		ASCII_U		/*  85		*/
#   define WIN1250_V		ASCII_V		/*  86		*/
#   define WIN1250_W		ASCII_W		/*  87		*/
#   define WIN1250_X		ASCII_X		/*  88		*/
#   define WIN1250_Y		ASCII_Y		/*  89		*/
#   define WIN1250_Z		ASCII_Z		/*  90		*/
#   define WIN1250_bracketleft	ASCII_bracketleft /* 91		*/
#   define WIN1250_backslash	ASCII_backslash	/*  92		*/
#   define WIN1250_bracketright	ASCII_bracketright /* 93	*/
#   define WIN1250_circumflex	ASCII_circumflex /*  94		*/
#   define WIN1250_underscore	ASCII_underscore /*  95		*/

#   define WIN1250_quoteleft	ASCII_quoteleft	/*  96		*/
#   define WIN1250_a		ASCII_a		/*  97		*/
#   define WIN1250_b		ASCII_b		/*  98		*/
#   define WIN1250_c		ASCII_c		/*  99		*/
#   define WIN1250_d		ASCII_d		/*  100		*/
#   define WIN1250_e		ASCII_e		/*  101		*/
#   define WIN1250_f		ASCII_f		/*  102		*/
#   define WIN1250_g		ASCII_g		/*  103		*/
#   define WIN1250_h		ASCII_h		/*  104		*/
#   define WIN1250_i		ASCII_i		/*  105		*/
#   define WIN1250_j		ASCII_j		/*  106		*/
#   define WIN1250_k		ASCII_k		/*  107		*/
#   define WIN1250_l		ASCII_l		/*  108		*/
#   define WIN1250_m		ASCII_m		/*  109		*/
#   define WIN1250_n		ASCII_n		/*  110		*/
#   define WIN1250_o		ASCII_o		/*  111		*/
#   define WIN1250_p		ASCII_p		/*  112		*/
#   define WIN1250_q		ASCII_q		/*  113		*/
#   define WIN1250_r		ASCII_r		/*  114		*/
#   define WIN1250_s		ASCII_s		/*  115		*/
#   define WIN1250_t		ASCII_t		/*  116		*/
#   define WIN1250_u		ASCII_u		/*  117		*/
#   define WIN1250_v		ASCII_v		/*  118		*/
#   define WIN1250_w		ASCII_w		/*  119		*/
#   define WIN1250_x		ASCII_x		/*  120		*/
#   define WIN1250_y		ASCII_y		/*  121		*/
#   define WIN1250_z		ASCII_z		/*  122		*/
#   define WIN1250_braceleft	ASCII_braceleft	/*  123		*/
#   define WIN1250_bar		ASCII_bar	/*  124		*/
#   define WIN1250_braceright	ASCII_braceright /* 125		*/
#   define WIN1250_tilde	ASCII_tilde	/*  126		*/
#   define WIN1250__del		ASCII__del	/*  127		*/

#   define WIN1250__0x80	0x80		/*  128		*//**/
#   define WIN1250__0x81	0x81		/*  129		*//**/
#   define WIN1250_quotesinglbase 0x82		/*  130		*/
#   define WIN1250_florin	0x83		/*  131		*/
#   define WIN1250_quotedblbase	0x84		/*  132		*/
#   define WIN1250_ellipsis	0x85		/*  133		*/
#   define WIN1250_dagger	0x86		/*  134		*/
#   define WIN1250_daggerdbl	0x87		/*  135		*/
#   define WIN1250__circumflex_136 0x88		/*  136		*/
#   define WIN1250_perthousand	0x89		/*  137		*/
#   define WIN1250_Scaron	0x8a		/*  138		*/
#   define WIN1250_guilsinglleft 0x8b		/*  139		*/
#   define WIN1250_Sacute	0x8c		/*  140		*/
#   define WIN1250_Tcaron	0x8d		/*  141		*/
#   define WIN1250_Zcaron	0x8e		/*  142		*/
#   define WIN1250_Zacute	0x8f		/*  143		*/
#   define WIN1250__0x90	0x90		/*  144		*//**/
#   define WIN1250__quoteleft_145 0x91		/*  145		*/
#   define WIN1250__quoteright_146 0x92		/*  146		*/
#   define WIN1250_quotedblleft	0x93		/*  147		*/
#   define WIN1250_quotedblright 0x94		/*  148		*/
#   define WIN1250_bullet	0x95		/*  149		*/
#   define WIN1250_endash	0x96		/*  150		*/
#   define WIN1250_emdash	0x97		/*  151		*/
#   define WIN1250__tilde_152	0x98		/*  152		*/
#   define WIN1250_trademark	0x99		/*  153		*/
#   define WIN1250_scaron	0x9a		/*  154		*/
#   define WIN1250_guilsinglright 0x9b		/*  155		*/
#   define WIN1250_sacute	0x9c		/*  156		*/
#   define WIN1250_tcaron	0x9d		/*  157		*/
#   define WIN1250_zcaron	0x9e		/*  158		*/
#   define WIN1250_zacute	0x9f		/*  159		*/
#   define WIN1250__0xa0	0xa0		/*  160		*//**/
#   define WIN1250_caron	0xa1		/*  161		*/
#   define WIN1250_breve	0xa2		/*  162		*/
#   define WIN1250_Lslash	0xa3		/*  163		*/
#   define WIN1250_currency	0xa4		/*  164		*/
#   define WIN1250_Aogonek	0xa5		/*  165		*/
#   define WIN1250_brokenbar	0xa6		/*  166		*/
#   define WIN1250_section	0xa7		/*  167		*/
#   define WIN1250_dieresis	0xa8		/*  168		*/
#   define WIN1250_copyright	0xa9		/*  169		*/
#   define WIN1250_Scedilla	0xaa		/*  170		*/
#   define WIN1250_guillemotleft 0xab		/*  171		*/
#   define WIN1250_logicalnot	0xac		/*  172		*/
#   define WIN1250_hyphen	0xad		/*  173		*/
#   define WIN1250_registered	0xae		/*  174		*/
#   define WIN1250_Zdotaccent	0xaf		/*  175		*/
#   define WIN1250_degree	0xb0		/*  176		*/
#   define WIN1250_plusminus	0xb1		/*  177		*/
#   define WIN1250_ogonek	0xb2		/*  178		*/
#   define WIN1250_lslash	0xb3		/*  179		*/
#   define WIN1250_acute	0xb4		/*  180		*/
#   define WIN1250_mu		0xb5		/*  181		*/
#   define WIN1250_paragraph	0xb6		/*  182		*/
#   define WIN1250_periodcentered 0xb7		/*  183		*/
#   define WIN1250_cedilla	0xb8		/*  184		*/
#   define WIN1250_aogonek	0xb9		/*  185		*/
#   define WIN1250_scedilla	0xba		/*  186		*/
#   define WIN1250_guillemotright 0xbb		/*  187		*/
#   define WIN1250_Lcaron	0xbc		/*  188		*/
#   define WIN1250_hungarumlaut	0xbd		/*  189		*/
#   define WIN1250_lcaron	0xbe		/*  190		*/
#   define WIN1250_zdotaccent	0xbf		/*  191		*/
#   define WIN1250_Racute	0xc0		/*  192		*/
#   define WIN1250_Aacute	0xc1		/*  193		*/
#   define WIN1250_Acircumflex	0xc2		/*  194		*/
#   define WIN1250_Abreve	0xc3		/*  195		*/
#   define WIN1250_Adieresis	0xc4		/*  195		*/
#   define WIN1250_Lacute	0xc5		/*  197		*/
#   define WIN1250_Cacute	0xc6		/*  198		*/
#   define WIN1250_Ccedilla	0xc7		/*  199		*/
#   define WIN1250_Ccaron	0xc8		/*  200		*/
#   define WIN1250_Eacute	0xc9		/*  201		*/
#   define WIN1250_Eogonek	0xca		/*  202		*/
#   define WIN1250_Edieresis	0xcb		/*  202		*/
#   define WIN1250_Ecaron	0xcc		/*  204		*/
#   define WIN1250_Iacute	0xcd		/*  204		*/
#   define WIN1250_Icircumflex	0xce		/*  204		*/
#   define WIN1250_Dcaron	0xcf		/*  207		*/
#   define WIN1250_Dcroat	0xd0		/*  208		*/
#   define WIN1250_Nacute	0xd1		/*  209		*/
#   define WIN1250_Ncaron	0xd2		/*  210		*/
#   define WIN1250_Oacute	0xd3		/*  211		*/
#   define WIN1250_Ocircumflex	0xd4		/*  212		*/
#   define WIN1250_Ohungarumlaut 0xd5		/*  213		*/
#   define WIN1250_Odieresis	0xd6		/*  214		*/
#   define WIN1250_multiply	0xd7		/*  215		*/
#   define WIN1250_Rcaron	0xd8		/*  216		*/
#   define WIN1250_Uring	0xd9		/*  217		*/
#   define WIN1250_Uacute	0xda		/*  218		*/
#   define WIN1250_Uhungarumlaut 0xdb		/*  219		*/
#   define WIN1250_Udieresis	0xdc		/*  220		*/
#   define WIN1250_Yacute	0xdd		/*  221		*/
#   define WIN1250_Tcedilla	0xde		/*  222		*/
#   define WIN1250_germandbls	0xdf		/*  223		*/
#   define WIN1250_racute	0xe0		/*  224		*/
#   define WIN1250_aacute	0xe1		/*  225		*/
#   define WIN1250_acircumflex	0xe2		/*  226		*/
#   define WIN1250_abreve	0xe3		/*  227		*/
#   define WIN1250_adieresis	0xe4		/*  228		*/
#   define WIN1250_lacute	0xe5		/*  229		*/
#   define WIN1250_cacute	0xe6		/*  230		*/
#   define WIN1250_ccedilla	0xe7		/*  231		*/
#   define WIN1250_ccaron	0xe8		/*  232		*/
#   define WIN1250_eacute	0xe9		/*  233		*/
#   define WIN1250_eogonek	0xea		/*  234		*/
#   define WIN1250_edieresis	0xeb		/*  235		*/
#   define WIN1250_ecaron	0xec		/*  236		*/
#   define WIN1250_iacute	0xed		/*  237		*/
#   define WIN1250_icircumflex	0xee		/*  238		*/
#   define WIN1250_dcaron	0xef		/*  239		*/
#   define WIN1250_dcroat	0xf0		/*  240		*/
#   define WIN1250_nacute	0xf1		/*  241		*/
#   define WIN1250_ncaron	0xf2		/*  242		*/
#   define WIN1250_oacute	0xf3		/*  243		*/
#   define WIN1250_ocircumflex	0xf4		/*  244		*/
#   define WIN1250_ohungarumlaut 0xf5		/*  245		*/
#   define WIN1250_odieresis	0xf6		/*  246		*/
#   define WIN1250_divide	0xf7		/*  247		*/
#   define WIN1250_rcaron	0xf8		/*  248		*/
#   define WIN1250_uring	0xf9		/*  249		*/
#   define WIN1250_uacute	0xfa		/*  250		*/
#   define WIN1250_uhungarumlaut 0xfb		/*  251		*/
#   define WIN1250_udieresis	0xfc		/*  252		*/
#   define WIN1250_yacute	0xfd		/*  252		*/
#   define WIN1250_tcedilla	0xfe		/*  254		*/
#   define WIN1250_dotaccent	0xff		/*  255		*/
