#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<Xm/Form.h>
#   include	<Xm/DrawingA.h>
#   include	<X11/cursorfont.h>

#   include	<sioStdio.h>

#   include	<appFindTool.h>
#   include	<appSpellTool.h>

#   include	"tedApp.h"
#   include	"tedRuler.h"
#   include	"docPs.h"

#   include	<debugon.h>

/************************************************************************/
/*									*/
/*  Ted, callbacks for the DrawingArea.					*/
/*									*/
/*  0)  Allocate the background color for selections.			*/
/*  1)  Try to merge as many expose events for this widget as possible.	*/
/*  2)  Clear background.						*/
/*  2b) If the selected area overlaps with the exposed region, draw the	*/
/*	selection background.						*/
/*  3)  Draw text.							*/
/*  4)  Draw I bar if necessary.					*/
/*									*/
/************************************************************************/
void tedDrawingExpose(	Widget		w,
			XtPointer	voided,
			XtPointer	voidcbs	)
    {
    XmDrawingAreaCallbackStruct *	cbs;
    Boolean				ignored;

    cbs= (XmDrawingAreaCallbackStruct *)voidcbs;

    tedExposeHandler( w, voided, cbs->event, &ignored );

    return;
    }

void tedDrawRectangle(	Widget			w,
			EditDocument *		ed,
			DocumentRectangle *	drClip,
			int			ox,
			int			oy,
			Window			win,
			GC			gc )
    {
    Pixel			selPixel;
    Pixel			linkFore;
    Pixel			tableFrame;

    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    AppDrawingData *		add= &(ed->edDrawingData);
    AppColors *			ac= &(ed->edColors);
    EditApplication *		ea= ed->edApplication;
    double			magnifiedPixelsPerTwip;

    if  ( td->tdVisibleSelectionCopied )
	{ selPixel= td->tdXSelColor.pixel;		}
    else{ selPixel= td->tdSelColor.pixel;		}

    linkFore= td->tdFieldColor.pixel;
    tableFrame= td->tdTableColor.pixel;

    magnifiedPixelsPerTwip= ea->eaMagnifiedPixelsPerTwip;

    /*  2,3,4  */
    tedRedrawRectangle( w, td, drClip, add, ac, ox, oy,
			    selPixel, linkFore, tableFrame, win, gc );
    }

void tedExposeHandler(	Widget			w,
			void *			voided,
			XEvent *		event,
			Boolean *		pRefused )
    {
    EditDocument *		ed= (EditDocument *)voided;

    Display *			display= XtDisplay( w );
    Window			win= XtWindow( w );
    GC				gc= ed->edGc;

    int				ox= ed->edVisibleRect.drX0;
    int				oy= ed->edVisibleRect.drY0;

    DocumentRectangle		drClip;

    /*  1  */
    appCollectExposures( &drClip, ox, oy, display, win, gc, event );

    /*  2,3,4  */
    tedDrawRectangle( w, ed, &drClip, ox, oy, win, gc );

    XSetClipMask( display, ed->edGc, None );

    return;
    }

/************************************************************************/
/*									*/
/*  Scrolling callbacks.						*/
/*									*/
/************************************************************************/

void tedMoveObjectWindows(	Widget			w,
				EditDocument *		ed )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    Display *			display= XtDisplay( w );
    Window			win= XtWindow( w );

    BufferItem *		bi;
    TextLine *			tl;
    TextParticule *		tp;
    InsertedObject *		io;

    int				ox= ed->edVisibleRect.drX0;
    int				oy= ed->edVisibleRect.drY0;

    if  ( tedGetObjectSelection( td, &bi, &tl, &tp, &io ) )
	{ LDEB(1); return;	}

    tedSetObjectWindows( td, bi, tl, tp, ox, oy, display, win );
    }

void tedDocHorizontalScrollbarCallback(	Widget		w,
					XtPointer	voided,
					XtPointer	voidscbs )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    appDocHorizontalScrollbarCallback( w, voided, voidscbs );

    if  ( td->tdObjectSelected )
	{ tedMoveObjectWindows( w, ed );	}
    }

void tedDocVerticalScrollbarCallback(	Widget		w,
					XtPointer	voided,
					XtPointer	voidscbs )
    {
    EditDocument *		ed= (EditDocument *)voided;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    appDocVerticalScrollbarCallback( w, voided, voidscbs );

    if  ( td->tdObjectSelected )
	{ tedMoveObjectWindows( w, ed );	}
    }

/************************************************************************/
/*									*/
/*  Last phase in building a document window.				*/
/*									*/
/************************************************************************/
int tedFinishDocumentSetup(	EditApplication *	ea,
				EditDocument *		ed )
    {
    Window		win= XtWindow( ed->edDocumentWidget );
    TedDocument *	td= (TedDocument *)ed->edPrivateData;
    BufferDocument *	bd= td->tdDocument;

    char *	selColorName= "LightSteelBlue";
    char *	xselColorName= "gray70";
    char *	tableColorName= "gray80";

    if  ( appFinishDocumentSetup( ea, ed ) )
	{ LDEB(1); return -1;	}

    if  ( appAllocateColors( ea->eaDisplay, &ed->edColors ) )
	{ LDEB(1); return -1;	}

    if  ( ed->edColors.acDepth < 4 )
	{
	if  ( appColorRgb( &td->tdSelColor, &ed->edColors, 0, 0, 0 ) )
	    { LDEB(ed->edColors.acDepth); return -1;	}

	if  ( appColorRgb( &td->tdXSelColor, &ed->edColors, 0, 0, 0 ) )
	    { LDEB(ed->edColors.acDepth); return -1;	}

	if  ( appColorRgb( &td->tdFieldColor, &ed->edColors, 0, 0, 0 ) )
	    { LDEB(ed->edColors.acDepth); return -1;	}

	if  ( appColorRgb( &td->tdTableColor, &ed->edColors, 0, 0, 0 ) )
	    { LDEB(ed->edColors.acDepth); return -1;	}
	}
    else{
	if  ( appColorNamed( &td->tdSelColor, &ed->edColors, selColorName ) )
	    {
	    if  ( appColorFindRgb( &td->tdSelColor,
					   &ed->edColors, 176, 196, 222 ) )
		{ SDEB(selColorName); return -1;	}
	    }

	if  ( appColorNamed( &td->tdXSelColor, &ed->edColors, xselColorName ) )
	    {
	    if  ( appColorFindRgb( &td->tdXSelColor,
					    &ed->edColors, 176, 176, 176 ) )
		{ SDEB(xselColorName); return -1;	}
	    }

	if  ( appColorRgb( &td->tdFieldColor, &ed->edColors, 0, 0, 200 ) )
	    {
	    if  ( appColorFindRgb( &td->tdFieldColor,
					   &ed->edColors, 0, 0, 255 ) )
		{ LDEB(1); return -1;	}
	    }

	if  ( appColorNamed( &td->tdTableColor,
					    &ed->edColors, tableColorName ) )
	    {
	    if  ( appColorFindRgb( &td->tdTableColor,
					   &ed->edColors, 176, 176, 176 ) )
		{ SDEB(tableColorName); return -1;	}
	    }
	}

    if  ( tedOpenItemObjects( &(bd->bdItem), &ed->edColors, &(bd->bdFontList),
				    &(ed->edDrawingData), win, ed->edGc ) )
	{ LDEB(1);	}

    if  ( ed->edIsReadonly )
	{ tedMakeDocumentReadonly( ed );	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Make the document widget and the rulers.				*/
/*									*/
/*  0)  Remove the space between the scrollbars and the contents. looks	*/
/*	better.								*/
/*  1)  Calculate the different width of the margins.			*/
/*  2)  Insert an XmForm in the scrolled window.			*/
/*  3)  Insert the top ruler in the form.				*/
/*  4)  Insert the bottom ruler in the form.				*/
/*  5)  Insert the left ruler in the form.				*/
/*  6)  Insert the right ruler in the form.				*/
/*  7)  Insert the document widget in the form.				*/
/*									*/
/************************************************************************/
static void tedFreeDocument(		TedDocument *		td )
    {
    if  ( td->tdDocument )
	{ docFreeDocument( td->tdDocument ); }

    sioMemoryClean( &(td->tdCopiedSelection) );
    sioMemoryClean( &(td->tdCopiedFont) );
    sioMemoryClean( &(td->tdCopiedRuler) );

    appCleanBitmapImage( &(td->tdCopiedImage) );

    free( td );
    }

static void tedDestroyEditDocument(	Widget			w,
					XtPointer		voided,
					XtPointer		callData )
    {
    EditDocument *		ed= (EditDocument *)voided;
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    Display *			display= XtDisplay( w );

    tedStopCursorBlink( ea->eaContext, ed );

    if  ( td )
	{
	BufferDocument *	bd= td->tdDocument;

	if  ( bd )
	    {
	    docCloseItemObjects( bd, &(bd->bdItem),
					(void *)display, tedCloseObject );
	    }
	}

    if  ( ed->edLeftRuler )
	{ tedFreeRuler( display, ed->edLeftRuler ); }
    if  ( ed->edTopRuler )
	{ tedFreeRuler( display, ed->edTopRuler ); }
    if  ( ed->edRightRuler )
	{ tedFreeRuler( display, ed->edRightRuler ); }
    if  ( ed->edBottomRuler )
	{ tedFreeRuler( display, ed->edBottomRuler ); }

    if  ( ed->edGc )
	{ XFreeGC( display, ed->edGc ); }
    if  ( ed->edInputContext )
	{ XDestroyIC( ed->edInputContext ); }

    if  ( td )
	{ tedFreeDocument( td ); }

    appFreeDocument( ea, ed );

    if  ( ed == TED_ManualDocument )
	{ TED_ManualDocument= (EditDocument *)0;	}

    return;
    }

int tedMakeDocumentWidget(	EditApplication *	ea,
				EditDocument *		ed,
				Widget			scrollw )
    {
    Arg			al[20];
    int			ac= 0;

    Widget		form;

    Display *		display= ea->eaDisplay;
    int			screen= ea->eaScreen;
    Pixel		blackPixel= BlackPixel( display, screen );
    Pixel		whitePixel= WhitePixel( display, screen );

    /*  0  */
    XtVaSetValues( scrollw, XmNspacing, 0, NULL );

    /*  1  */
    ed->edLeftRulerWidth= (int)( 5.0 * DisplayWidth( display, screen )/
					DisplayWidthMM( display, screen ) );
    ed->edTopMargin= (int)( 12.0* DisplayHeight( display, screen )/
					DisplayHeightMM( display, screen ) );
    ed->edRightRulerWidth= (int)( 5.0 * DisplayWidth( display, screen )/
					DisplayWidthMM( display, screen ) );
    ed->edBottomMargin= (int)( 5.0* DisplayHeight( display, screen )/
					DisplayHeightMM( display, screen ) );

    ed->edTopMargin= 6* ( ( ed->edTopMargin+ 5 )/ 6 );

    /*  2  */
    form= XmCreateForm( scrollw, WIDGET_NAME, al, ac );

    /*  3  */
    ac= 0;
    XtSetArg( al[ac],	XmNforeground,		blackPixel ); ac++;
    XtSetArg( al[ac],	XmNtraversalOn,		False ); ac++;
    XtSetArg( al[ac],	XmNleftAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNleftOffset,		0 ); ac++;
    XtSetArg( al[ac],	XmNtopAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNtopOffset,		0 ); ac++;
    XtSetArg( al[ac],	XmNrightAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNrightOffset,		0 ); ac++;
    XtSetArg( al[ac],	XmNbottomAttachment,	XmATTACH_OPPOSITE_FORM ); ac++;
    XtSetArg( al[ac],	XmNbottomOffset,	-ed->edTopMargin ); ac++;

    ed->edTopRulerWidget= XmCreateDrawingArea( form, WIDGET_NAME, al, ac );

    /*  4  */
    ac= 0;
    XtSetArg( al[ac],	XmNforeground,		blackPixel ); ac++;
    XtSetArg( al[ac],	XmNtraversalOn,		False ); ac++;
    XtSetArg( al[ac],	XmNleftAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNleftOffset,		0 ); ac++;
    XtSetArg( al[ac],	XmNtopAttachment,	XmATTACH_OPPOSITE_FORM ); ac++;
    XtSetArg( al[ac],	XmNtopOffset,		-ed->edBottomMargin ); ac++;
    XtSetArg( al[ac],	XmNrightAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNrightOffset,		0 ); ac++;
    XtSetArg( al[ac],	XmNbottomAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNbottomOffset,	0 ); ac++;

    ed->edBottomRulerWidget= XmCreateDrawingArea( form, WIDGET_NAME, al, ac );

    /*  5  */
    ac= 0;
    XtSetArg( al[ac],	XmNforeground,		blackPixel ); ac++;
    XtSetArg( al[ac],	XmNtraversalOn,		False ); ac++;

    XtSetArg( al[ac],	XmNleftAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNleftOffset,		0 ); ac++;

    XtSetArg( al[ac],	XmNtopAttachment,	XmATTACH_WIDGET ); ac++;
    XtSetArg( al[ac],	XmNtopWidget,		ed->edTopRulerWidget ); ac++;
    XtSetArg( al[ac],	XmNtopOffset,		0 ); ac++;

    XtSetArg( al[ac],	XmNrightAttachment,	XmATTACH_OPPOSITE_FORM ); ac++;
    XtSetArg( al[ac],	XmNrightOffset,		-ed->edLeftRulerWidth ); ac++;

    XtSetArg( al[ac],	XmNbottomAttachment,	XmATTACH_WIDGET ); ac++;
    XtSetArg( al[ac],	XmNbottomWidget,	ed->edBottomRulerWidget ); ac++;
    XtSetArg( al[ac],	XmNbottomOffset,	0 ); ac++;

    ed->edLeftRulerWidget= XmCreateDrawingArea( form, WIDGET_NAME, al, ac );

    /*  6  */
    ac= 0;
    XtSetArg( al[ac],	XmNforeground,		blackPixel ); ac++;
    XtSetArg( al[ac],	XmNtraversalOn,		False ); ac++;
    XtSetArg( al[ac],	XmNleftAttachment,	XmATTACH_OPPOSITE_FORM ); ac++;
    XtSetArg( al[ac],	XmNleftOffset,		-ed->edRightRulerWidth ); ac++;
    XtSetArg( al[ac],	XmNtopAttachment,	XmATTACH_WIDGET ); ac++;
    XtSetArg( al[ac],	XmNtopWidget,		ed->edTopRulerWidget ); ac++;
    XtSetArg( al[ac],	XmNtopOffset,		0 ); ac++;
    XtSetArg( al[ac],	XmNrightAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNrightOffset,		0 ); ac++;
    XtSetArg( al[ac],	XmNbottomAttachment,	XmATTACH_WIDGET ); ac++;
    XtSetArg( al[ac],	XmNbottomWidget,	ed->edBottomRulerWidget ); ac++;
    XtSetArg( al[ac],	XmNbottomOffset,	0 ); ac++;

    ed->edRightRulerWidget= XmCreateDrawingArea( form, WIDGET_NAME, al, ac );

    /*  7  */
    ac= 0;
    XtSetArg( al[ac],	XmNtraversalOn,		True ); ac++;

    XtSetArg( al[ac],	XmNbackground,		whitePixel ); ac++;
    XtSetArg( al[ac],	XmNleftAttachment,	XmATTACH_WIDGET ); ac++;
    XtSetArg( al[ac],	XmNleftWidget,		ed->edLeftRulerWidget ); ac++;
    XtSetArg( al[ac],	XmNleftOffset,		0 ); ac++;
    XtSetArg( al[ac],	XmNtopAttachment,	XmATTACH_WIDGET ); ac++;
    XtSetArg( al[ac],	XmNtopWidget,		ed->edTopRulerWidget ); ac++;
    XtSetArg( al[ac],	XmNtopOffset,		0 ); ac++;
    XtSetArg( al[ac],	XmNrightAttachment,	XmATTACH_WIDGET ); ac++;
    XtSetArg( al[ac],	XmNrightWidget,		ed->edRightRulerWidget ); ac++;
    XtSetArg( al[ac],	XmNrightOffset,		0 ); ac++;
    XtSetArg( al[ac],	XmNbottomAttachment,	XmATTACH_WIDGET ); ac++;
    XtSetArg( al[ac],	XmNbottomWidget,	ed->edBottomRulerWidget ); ac++;
    XtSetArg( al[ac],	XmNbottomOffset,	0 ); ac++;

    ed->edDocumentWidget= XmCreateDrawingArea( form, WIDGET_NAME, al, ac );

    XtAddCallback( ed->edDocumentWidget,
		    XmNdestroyCallback, tedDestroyEditDocument, (void *)ed );

    XtManageChild( ed->edTopRulerWidget );
    XtManageChild( ed->edLeftRulerWidget );
    XtManageChild( ed->edRightRulerWidget );
    XtManageChild( ed->edBottomRulerWidget );
    XtManageChild( ed->edDocumentWidget );
    XtManageChild( form );

    if  ( ! ea->eaDocumentCursor )
	{
	ea->eaDocumentCursor= XCreateFontCursor( ea->eaDisplay, XC_xterm );
	if  ( ! ea->eaDocumentCursor )
	    { LDEB(ea->eaDocumentCursor);	}
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Find out whether a document uses just one code page.		*/
/*									*/
/************************************************************************/

static int tedDetermineCodepage(	BufferDocument *	bd,
					const AppDrawingData *	add )
    {
    PostScriptFont *		fontList= (PostScriptFont *)0;
    int				fontCount= 0;
    int				i;

    int				encoding= -1;
    int				multipleEncodings= 0;

    if  ( docPsPrintGetItemFonts( &(bd->bdItem),
				(&bd->bdFontList), &(add->addPhysicalFontList),
				&fontList, &fontCount ) )
	{ LDEB(1); return -1;	}

    for ( i= 0; i < fontCount; i++ )
	{
	AfmFontInfo *	afi= fontList[i].psfAfi;

	if  ( encoding < 0 )
	    { encoding= afi->afiEncoding;	}
	else{
	    if  ( encoding != afi->afiEncoding )
		{ multipleEncodings= 1;	}
	    }
	}

    if  ( fontList )
	{ free( fontList );	}

    if  ( multipleEncodings )
	{ return -1;	}

    switch( encoding )
	{
	case ENCODINGpsISO_8859_1:
	    return 1252;

	case ENCODINGpsISO_8859_2:
	    return 1250;

	default:
	    LDEB(encoding); return -1;
	}

    }

/************************************************************************/
/*									*/
/*  Make a new empty document.						*/
/*									*/
/************************************************************************/

int tedNewDocument(	EditApplication *	ea,
			EditDocument *		ed,
			const char *		filename )
    {
    TedDocument *		td;
    BufferDocument *		bd;

    unsigned int		updMask;
    TextAttribute		taNew;

    char *			familyName;

    char			scratch[120];

    td= (TedDocument *)ed->edPrivateData;

    strcpy( scratch, ea->eaDefaultFont );
    if  ( appFontGetAttributes( scratch, &familyName, &updMask, &taNew ) )
	{ SDEB(ea->eaDefaultFont); return -1;	}

    if  ( ! ( updMask & TAmaskFONTSIZE ) || taNew.taFontSizeHalfPoints < 4 )
	{
	LDEB(taNew.taFontSizeHalfPoints);
	taNew.taFontSizeHalfPoints= 24; updMask |= TAmaskFONTSIZE;
	}

    bd= docNewFile( familyName, 10* taNew.taFontSizeHalfPoints );
    if  ( ! bd )
	{ XDEB(bd); return -1;	}

    ed->edFormat= 0; /* rtf */
    bd->bdGeometry= ea->eaDefaultDocumentGeometry;
    td->tdDocument= bd;

    if  ( filename )
	{
	const char *	slash= strrchr( filename, '/' );
	const char *	dot;

	if  ( slash )
	    { dot= strrchr( slash+ 1, '.' );	}
	else{ dot= strrchr( filename, '.' );	}

	if  ( dot && ! strcmp( dot, ".rtf" ) )
	    { ed->edFormat= 0;	}
	if  ( dot && ! strcmp( dot, ".txt" ) )
	    { ed->edFormat= 1;	}
	}

    if  ( ea->eaAuthor )
	{ bd->bdAuthor= (unsigned char *)strdup( ea->eaAuthor ); }

    return 0;
    }

/************************************************************************/
/*									*/
/*  Perform the setup of the editing environment for a document.	*/
/*									*/
/*  8)  Determine the code page of the document.			*/
/*  9)  Do not use the 1252 cidepage as an explicit setting: It is	*/
/*	almost certainly returned by a default 'Ted' installation, and	*/
/*	is almost impossible to get rid of.				*/
/*									*/
/************************************************************************/

int tedSetupDocument(	EditApplication *	ea,
			EditDocument *		ed	)
    {
    Display *			display= ea->eaDisplay;
    int				screen= ea->eaScreen;

    double			horPixPerMM;
    double			verPixPerMM;
    double			xfac;
    double			yfac;

    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;
    DocumentGeometry *		dg= &(bd->bdGeometry);
    AppDrawingData *		add= &(ed->edDrawingData);

    Dimension			width;
    Dimension			height;

    appGetFactors( ea, &horPixPerMM, &verPixPerMM, &xfac, &yfac );
    tedSetRectangles( ed, dg, xfac, yfac );

    if  ( ea->eaMagnifiedPixelsPerTwip == 0 )
	{ ea->eaMagnifiedPixelsPerTwip= xfac; }

    add->sgTabInterval= TWIPStoPIXELS( xfac,
				    bd->bdProperties.dpTabIntervalTwips );

    add->sgMagnification= ea->eaMagnification;
    add->addMagnifiedPixelsPerTwip= ea->eaMagnifiedPixelsPerTwip;
    add->addAfmDirectory= ea->eaAfmDirectory;
    add->addDisplay= ea->eaDisplay;

    if  ( tedLayoutDocument( ed, bd ) )
	{ LDEB(1); return -1;	}

    appSetShellConstraints( ed );

    width= add->addPaperRect.drX1- add->addPaperRect.drX0;
    height= add->addPaperRect.drY1- add->addPaperRect.drY0;

    if  ( width > ( 5* ea->eaScreenPixelsWide )/ 6 )
	{ width=( 5* ea->eaScreenPixelsWide )/ 6; }
    if  ( height > ( 5* ea->eaScreenPixelsHigh )/ 6 )
	{ height=( 5* ea->eaScreenPixelsHigh )/ 6; }

    XtVaSetValues( ed->edDocumentWidget,
	    XmNforeground,	BlackPixel( display, screen ),
	    XmNborderWidth,	0,
	    XmNshadowThickness,	0,
	    XmNwidth,		width,
	    XmNheight,		height,
	    XmNuserData,	(void *)ed,
	    NULL );

    XtAddEventHandler( ed->edDocumentWidget,
			    FocusChangeMask, False, tedObserveFocus, ed );
    XtAddEventHandler( ed->edDocumentWidget,
			    PropertyChangeMask, True, tedSelectionInput, ed );

    XtAddCallback( ed->edDocumentWidget,
				XmNexposeCallback, tedDrawingExpose, ed );
    XtAddCallback( ed->edDocumentWidget,
				XmNinputCallback, tedDrawingInput, ed );

    ed->edVisibleRect.drX0= add->addPaperRect.drX0;
    ed->edVisibleRect.drY0= add->addPaperRect.drY0;
    ed->edVisibleRect.drX1= add->addPaperRect.drX1;
    ed->edVisibleRect.drY1= add->addPaperRect.drY1;

    tedDocSetTopRuler( ed, add->addPaperRect.drX1- add->addPaperRect.drX0,
		ed->edTopMargin, horPixPerMM,
		ea->eaUnitInt, display, screen );

    {
    BufferPosition	bp;

    if  ( ! tedFirstPosition( add, bd, &bp ) )
	{
	td->tdSelection.bsBegin=
		    td->tdSelection.bsEnd=
		    td->tdSelection.bsAnchor= bp;

	td->tdCurrentTextAttribute=
		bp.bpBi->biParaParticules[bp.bpParticule].tpTextAttribute;
	td->tdCurrentPhysicalFont=
		bp.bpBi->biParaParticules[bp.bpParticule].tpPhysicalFont;


	td->tdSelection.bsDirection= 0;

	tedSelectionRectangle( &(td->tdSelectedRectangle),
						 add, &(td->tdSelection) );

	tedAdaptToolsToPosition( ed, 0 );
	}
else{
docListItem(0,&bd->bdItem);
}
    }

    /*  8  */
    if  ( bd->bdItem.biDocAnsiCodePage < 0 )
	{
	bd->bdItem.biDocAnsiCodePage= tedDetermineCodepage( bd, add );

	/*  9  */
	if  ( bd->bdItem.biDocAnsiCodePage == 1252 )
	    { bd->bdItem.biDocAnsiCodePage= -1;	}
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Save a document.							*/
/*									*/
/************************************************************************/

int tedSaveDocument(	const EditApplication *		ea,
			const EditDocument *		ed,
			int				format,
			const char *			filename )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    SimpleOutputStream *	sos;
    const int			saveBookmarks= 1;

    sos= sioOutStdioOpen( filename );
    if  ( ! sos )
	{ /* SXDEB(filename,sos); */ return -1;	}

    switch( format )
	{
	case 0:
	    if  ( docRtfSaveDocument( sos,
			td->tdDocument, (BufferSelection *)0, saveBookmarks ) )
		{ SDEB(filename); sioOutClose( sos ); return -1;	}
	    break;
	case 1:
	    if  ( docPlainSaveDocument( sos,
				td->tdDocument, (BufferSelection *)0, 1, 1 ) )
		{ SDEB(filename); sioOutClose( sos ); return -1;	}
	    break;
	case 2:
	    if  ( docHtmlSaveDocument( sos, td->tdDocument, filename ) )
		{ SDEB(filename); sioOutClose( sos ); return -1;	}
	    break;
	default:
	    LDEB(format); break;
	}

    sioOutClose( sos );
    
    return 0;
    }


/************************************************************************/
/*									*/
/*  Allocate private data for a document.				*/
/*									*/
/************************************************************************/

int tedSetPrivateData(	EditApplication *	ea,
			EditDocument *		ed )
    {
    TedDocument *	td;

    td= (TedDocument *)malloc( sizeof(TedDocument) );
    if  ( ! td )
	{ XDEB(td); return -1;	}

    td->tdDocument= (BufferDocument *)0;
    docInitTextAttribute( &(td->tdCurrentTextAttribute) );
    td->tdCurrentPhysicalFont= -1;

    td->tdFormatMenu= (Widget)0;
    td->tdFormatMenuButton= (Widget)0;
    td->tdFormatOneParaOption= (Widget)0;

    td->tdCopyWidget= (Widget)0;
    td->tdCutWidget= (Widget)0;
    td->tdPasteWidget= (Widget)0;

    td->tdInsertMenu= (Widget)0;
    td->tdInsertMenuButton= (Widget)0;
    td->tdInsPictOption= (Widget)0;
    td->tdInsFileOption= (Widget)0;
    td->tdInsSymbolWidget= (Widget)0;
    td->tdInsHyperlinkWidget= (Widget)0;
    td->tdInsBookmarkWidget= (Widget)0;
    td->tdInsInsertTableWidget= (Widget)0;

    td->tdTableMenu= (Widget)0;
    td->tdTableMenuButton= (Widget)0;
    td->tdTabInsertTableOption= (Widget)0;
    td->tdTabAddRowOption= (Widget)0;
    td->tdTabAddColumnOption= (Widget)0;

    td->tdSelectTableWidget= (Widget)0;
    td->tdSelectRowWidget= (Widget)0;
    td->tdSelectColumnWidget= (Widget)0;
    td->tdDrawTableGridWidgetWidget= (Widget)0;

    td->tdFontMenu= (Widget)0;
    td->tdFontMenuButton= (Widget)0;
    td->tdFontBoldOption= (Widget)0;
    td->tdFontItalicOption= (Widget)0;
    td->tdFontUnderlinedOption= (Widget)0;
    td->tdFontSuperscriptOption= (Widget)0;
    td->tdFontSubscriptOption= (Widget)0;

    td->tdToolsMenu= (Widget)0;
    td->tdToolsMenuButton= (Widget)0;

    docInitSelection( &(td->tdSelection) );
    docInitRectangle( &(td->tdSelectedRectangle) );

    td->tdVisibleSelectionCopied= 0;
    td->tdCanReplaceSelection= 0;

    td->tdCopiedSelectionClosed= 0;
    sioMemoryInit( &(td->tdCopiedSelection) );
    sioMemoryInit( &(td->tdCopiedFont) );
    sioMemoryInit( &(td->tdCopiedRuler) );

    appInitBitmapImage( &(td->tdCopiedImage) );

    td->tdHideIBarId= (XtIntervalId)0;
    td->tdShowIBarId= (XtIntervalId)0;

    ed->edPrivateData= (void *)td;

    td->tdObjectWindow= None;
    td->tdObjectBottomWindow= None;
    td->tdObjectRightWindow= None;
    td->tdObjectCornerWindow= None;
    td->tdObjectSelected= 0;

    td->tdDrawTableGrid= 1;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Keep track of focus.						*/
/*									*/
/************************************************************************/
void tedObserveFocus(	Widget		w,
			void *		voided,
			XEvent *	event,
			Boolean *	pRefused	)
    {
    EditDocument *	ed= (EditDocument *)voided;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;
    EditApplication *	ea= ed->edApplication;

    if  ( event->type == FocusIn )
	{
	if  ( ea->eaCurrentDocument != ed )
	    {
	    appSetCurrentDocument( ea, ed );

	    if  ( ea->eaFontsTool )
		{ tedAdaptFontsToolToDocument( ea, ed ); }

	    if  ( ea->eaFindTool )
		{ appFindToolTextReadonly( ea->eaFindTool, ed->edIsReadonly ); }

	    if  ( ea->eaSpellTool )
		{ appEnableSpellTool( ea->eaSpellTool, ! ed->edIsReadonly ); }

	    tedAdaptPageToolToDocument( ea, ed );

	    if  ( TED_FormatTool )
		{ tedAdaptFormatToolToDocument( TED_FormatTool, ed );	}
	    }

	if  ( tedHasIBarSelection( td ) )
	    { tedStartCursorBlink( ea->eaContext, ed );	}
	}

    if  ( event->type == FocusOut )
	{ tedStopCursorBlink( ea->eaContext, ed ); }

    *pRefused= True;
    }

/************************************************************************/
/*									*/
/*  Follow a link.							*/
/*									*/
/*  1)  As a HACK, invoke netscape for all links with a protocol	*/
/*	different from 'file:'.						*/
/*  2)  Theoretically, mailcap/mimecap should have been consulted for	*/
/*	the application corresponding to the extension of the file.	*/
/*									*/
/************************************************************************/

/*  1  */
static int tedCallNetscape(	const char *		fileName,
				int			fileSize,
				const char *		markName,
				int			markSize )
    {
    char *	scratch;
    int		rval= 0;
    int		size;
    char *	to;

    size= 0;
    size += 60+ fileSize+ 1+ markSize;
    size += 4;
    size += 11+ fileSize+ 1+ markSize;
    size += 2+ 1;

    to= scratch= malloc( size );
    if  ( ! scratch )
	{ XDEB(scratch); return -1;	}

    strcpy( to, "netscape -noraise -remote 'openUrl(" );
    to += strlen( to );
    memcpy( to, fileName, fileSize ); to += fileSize;
    if  ( markSize > 0 )
	{
	*(to++)= '#';
	memcpy( to, markName, markSize ); to += markSize;
	}
    strcpy( to, ",new-window)' 2>/dev/null" ); to += strlen( to );

    strcpy( to, " || " ); to += strlen( to );

    strcpy( to, "netscape '" ); to += strlen( to );

    memcpy( to, fileName, fileSize ); to += fileSize;
    if  ( markSize > 0 )
	{
	*(to++)= '#';
	memcpy( to, markName, markSize ); to += markSize;
	}

    strcpy( to, "' &" ); to += strlen( to );

    if  ( system( scratch ) )
	{ SDEB(scratch); rval= -1;	}

    free( scratch );
    return rval;
    }

int tedFollowLink(	Widget			relative,
			Widget			option,
			EditDocument *		edFrom,
			const char *		fileName,
			int			fileSize,
			const char *		markName,
			int			markSize )
    {
    int			rval= 0;
    EditApplication *	ea= edFrom->edApplication;

    char *		slash= (char *)0;
    EditDocument *	edTo;

    char *		scratch= (char *)0;

    if  ( fileSize > 0 )
	{
	const int	readonly= 1;
	int		absolute= fileName[0] == '/';

	int		protocolSize;

	protocolSize= 0;
	while( protocolSize < fileSize && isalpha( fileName[protocolSize] ) )
	    { protocolSize++;	}

	/*  1  */
	if  ( protocolSize < fileSize && fileName[protocolSize] == ':' )
	    {
	    if  ( protocolSize == 4			&&
		  ! strncmp( fileName, "file", 4 )	)
		{
		fileName += 5;
		fileSize -= 5;
		absolute= fileName[0] == '/';
		}
	    else{
		return tedCallNetscape( fileName, fileSize,
							markName, markSize );
		}
	    }

	if  ( edFrom->edFilename )
	    { slash= strrchr( edFrom->edFilename, '/' ); }

	if  ( absolute || ! slash )
	    {
	    scratch= (char *)malloc( fileSize+ 1 );
	    if  ( ! scratch )
		{ XDEB(scratch); return -1;	}

	    strncpy( scratch, fileName, fileSize )[fileSize]= '\0';

	    edTo= appOpenDocument( ea, relative, option, readonly, scratch );
	    if  ( ! edTo )
		{ SXDEB(scratch,edTo);	}
	    }
	else{
	    int	dir= ( slash- edFrom->edFilename )+ 1;
	    int	len= dir+ fileSize+ 1;

	    scratch= (char *)malloc( len );
	    if  ( ! scratch )
		{ LXDEB(len,scratch); return -1;	}

	    strncpy( scratch, edFrom->edFilename, dir );
	    strncpy( scratch+ dir, fileName, fileSize )[fileSize]= '\0';

	    edTo= appOpenDocument( ea, relative, option, readonly, scratch );
	    if  ( ! edTo )
		{ /* SXDEB(scratch,edTo); */ rval= -1;	}
	    }
	}
    else{ edTo= edFrom;	}

    if  ( edTo && markSize > 0 )
	{ tedGoToBookmark( edTo, markName, markSize );	}

    if  ( scratch )
	{ free( scratch );	}

    return rval;
    }

