/************************************************************************/
/*									*/
/*  Postscript printing and formatting related data structures.		*/
/*									*/
/************************************************************************/

#   include	<psFont.h>
#   include	"appPs.h"

typedef struct ParticuleData
    {
    int			pdX0;
    int			pdWidth;
    int			pdVisibleWidth;
    int			pdTabNumber;
    int			pdTabKind;
    int			pdTabPosition;
    const AfmFontInfo *	pdAfi;

    int			pdVisiblePixels;
    int			pdWhiteUnits;
    int			pdCorrectBy;
    } ParticuleData;

typedef struct LineBox
    {
    int				lbSpaceAboveLine;
    int				lbTableMarginAboveLine;
    const BorderProperties *	lbBorderAboveLine;

    int				lbSpaceBelowLine;
    int				lbTableMarginBelowLine;
    const BorderProperties *	lbBorderBelowLine;

    int				lbLineAscent;
    int				lbLineHeight;
    int				lbLeading;
    int				lbLineDistance;

    int				lbX0Twips;
    int				lbVisibleX1Twips;
    int				lbStringX1Twips;
    } LineBox;

#   define	BETWEEN_MARGINS( dg )			\
			    ((dg)->dgPaperHighTwips-	\
			     (dg)->dgTopMarginTwips-	\
			     (dg)->dgBottomMarginTwips )

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern int psPrintDocument(	FILE *			f,
				EditDocument *		ed );

extern int docPsLineBox(	LineBox *			lb,
				const BufferItem *		bi,
				int				part,
				int				atTop,
				const int			paraAscent,
				const int			paraDescent,
				const DocumentGeometry *	dg,
				int				tabInterval,
				const DocumentFontList *	dfl,
				AppPhysicalFontList *		apfl,
				const TextParticule *		tp,
				ParticuleData *			pd,
				int				x0,
				const FormattingFrame *		ff );

extern AfmFontInfo * docPsPrintGetAfi(	const AppPhysicalFontList *	apfl,
					int				physf );

extern int docPsClaimParticuleData(	const BufferItem *	bi,
					ParticuleData **	pData );

extern int docPsParagraphLineExtents(	int *			pParaAscent,
					int *			pParaDescent,
					const AppPhysicalFontList *	apfl,
					const BufferItem *		bi );

extern void docPsInitLineBox(	LineBox *	lb );

extern int docPsPrintGetItemFonts(	const BufferItem *		bi,
					DocumentFontList *		dfl,
					const AppPhysicalFontList *	apfl,
					PostScriptFont **		pFntLst,
					int *				pCount );
