

define euc_to_sjis(high, low)
{
   variable ret_hi, ret_lo;
   
   ret_hi = high & 0x7f;
   ret_lo = low & 0x7f;
   
   if( ret_hi & 1)
     ret_lo += 0x1f;
   else
     ret_lo = 0x7d;
   
   if(ret_lo >= 0x7f)
     ret_lo++;
   
   ret_hi -= 0x21;
   ret_hi = (ret_hi / 2);
   ret_hi += 0x81;
   
   if(ret_hi > 0x9f)
     ret_hi += 0x40;
   
   return (ret_hi, ret_lo);
}

define sjis_to_jis(src_high, src_low)
{
   variable high, low;
   
   high = src_high & 0xff;
   low = src_low & 0xff;
   if(high <= 0x9f)
     high -= 0x71;
   else
     high -= 0xb1;
   high = high * 2 + 1;
   if(low > 0x7f)
     low--;
   if(low >= 0x9e)
     {
	low -= 0x7d;
	high--;
     }
   else
     {
	low -= 0x1f;
     }
   
   return  (high, low);
}

define sjis_to_euc(src_high, src_low)
{
   variable high, low;
   
   (high, low) = sjis_to_jis(src_high, src_low);
   
   high = high | 0x80;
   low = low | 0x80;
   
   return  (high, low);
}

define jis_to_sjis(high, low)
{
   return euc_to_sjis(high, low);
}

define jis_to_euc(high, low)
{
   high = high | 0x80;
   low = low | 0x80;
   
   return  (high, low);
}

define euc_to_jis(high, low)
{
   high = high & 0x7f;
   low = low & 0x7f;
   
   return  (high, low);
}

%#ifdef TEST

define print_euccode()
{
   variable high, low;
   
   low = jwhat_char();
   high = low / 256;
   low = low & 0xff;
   (high, low) = sjis_to_euc(high, low);
   
   message (Sprintf("This code is %x %x [EUC]", high, low, 2));
}


define print_sjis_to_euc(high, low)
{
   variable ch_high, ch_low;

   (ch_high, ch_low) = sjis_to_euc(high, low);
   
   message(Sprintf("This char is %x %x", ch_high, ch_low, 2));
}
   

define print_euc_to_sjis(high, low)
{
   variable ch_high, ch_low;

   (ch_high, ch_low) = euc_to_sjis(high, low);
   
   message(Sprintf("This char is %x %x", ch_high, ch_low, 2));
}
%#endif
	   


% This function is the same function as "iskanji" function.
% define is_kanji (code)
% {
% 	if( SLang_code == SJIS ) {
% 		if((128 < code) and (code < 160))	return TRUE;
% 		if((223 < code) and (code < 253))	return TRUE;
% 	}
% 	else if (SLang_code == EUC) {
% 		if((160 < code) and (code < 255))	return TRUE;
% 	}
% 	else if (SLang_code == JIS) {
% 		if((32 < code) and (code < 127))	return TRUE;
% 	}
% 	return FALSE;
% }


