/* vi:set ts=8 sts=0 sw=8:
 * $Id: win.h,v 1.35 2000/02/16 17:20:58 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __WIN_H__
#define __WIN_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <glib.h>
#include <gtk/gtk.h>
#include "main.h"
#include "search.h"

/* the main window */
typedef struct {
#ifdef APP_DEBUG
	unsigned	id;		/* window id */
#endif
	unsigned	rownum;		/* row # in window list popup */
	GtkWidget *	toplev;		/* top-level window */
	GtkWidget *	mainbox;	/* main box to hold all widgets */
	GtkWidget *	menubar;	/* menus */
	GtkWidget *	menubar_h;	/* menubar handle for floating menus */
#ifdef USE_GNOME
	GSList *	menuwgts;	/* toggle/radio buttons in menus */
#else
# ifdef GTK_HAVE_FEATURES_1_1_0
	GtkItemFactory *mainfact;
# else
	GtkMenuFactory *mainfact;
# endif
#endif	/* USE_GNOME */
#if defined(WANT_PROJECT) && defined(APP_GNP)
	GtkWidget *	prjbar;		/* project status bar */
#endif	/* WANT_PROJECT */
#ifdef USE_TOOLBARS
	GSList *	tblist;		/* list of all toolbars */
	GSList *	tbhlist;	/* list of all toolbar handles */
	GtkWidget *	main_tb;	/* toolbar */
# ifdef USE_HTMLTAGS
	GSList *	html_tblist;	/* list of HTML related toolbars */
	GtkWidget *	html_tb_h;	/* html toolbar handle */
	GtkWidget *	html_dlg;	/* for HTML tag insertion dialogs */
	GtkWidget *	tagchooser;	/* top-level tag chooser window */
	GtkWidget *	tc_nb;		/* tag chooser's notebook */
	int		tc_row;		/* tag chooser's selected row */
# endif
#endif	/* USE_TOOLBARS */
	GtkWidget *	nb;		/* notebook which contains docs */
#ifndef USE_GNOME
	GtkWidget *	hbox_bot;	/* holds msgbar and docinfo button */
#endif
	GtkWidget *	msgbar;		/* message bar */
#ifdef USE_FILEINFO
	GtkWidget *	docinfo;	/* docinfo button */
	GtkWidget *	docinfo_label;	/* docinfo label  */
#endif
	char *		lastmsg;	/* last message shown */
	int		timeout_id;	/* msgbar timeout id */
	GtkWidget *	quickmenu;	/* popup menu on right mouse click */
#ifdef USE_RANDOMTIPS
	int		rtips_timeout;	/* random tips timeout id */
#endif	/* USE_RANDOMTIPS */

	/* document related info.  note that we alreays track the current
	   document in curdoc whenever a doc is opened/closed.  this is to
	   avoid constantly traversing the doclist, like another gtk/gnome
	   editor does in a braindead fashion */
	GSList *	doclist;	/* doc_t list */
	gpointer	curdoc;		/* ptr to doclist->data (doc_t *) */
	guint		numdoc;		/* number of docs */
#ifdef APP_GNP
	bool_t		allclosed;	/* indicate all docs were closed */
#endif	/* APP_GNP */
#ifdef USE_RECENT
	GSList *	recentlist;	/* this window's recent doc list */
#endif	/* USE_RECENT */

	/* file selection dialog boxes; one per window */
	GtkWidget *	saveas;		/* save-as file selector */
	GtkWidget *	filesel;	/* open file selector */

#ifdef USE_DOCLIST
	/* the following are used for the doc list popup window */
	GtkWidget *	dlw;		/* doc list window */
	GtkWidget *	dlw_data;	/* doc list window data */
#endif	/* USE_DOCLIST */
#if defined(WANT_PROJECT) && defined(APP_GNP)
	GSList *	prjlist;	/* projects list */
	GtkWidget *	prjsel;		/* open project selector */
	GtkWidget *	prjlw;		/* projects list window */
	GtkWidget *	prjlw_data;	/* projects list window data */
#endif	/* WANT_PROJECT */
#ifdef USE_SEARCH
	search_t	*srg;		/* search/replace and goto line info */
#endif	/* USE_SEARCH */
} win_t;


#ifdef USE_AUTOSAVE
extern int	win_autosave(gpointer cbdata);
extern void	win_autosave_init(void);
extern void	win_autosave_reset(void *);
#endif	/* USE_AUTOSAVE */
extern void	win_close_all_cb(GtkWidget *wgt, gpointer cbdata);
extern void	win_close_cb(GtkWidget *wgt, gpointer cbdata);
extern void	win_doc_foreach(void (*func)(void *));
extern void	win_foreach(void (*func)(void *));
extern void	win_list_show(GtkWidget *wgt, gpointer cbdata);
extern win_t *	win_new(void);
extern void	win_new_with_doc(GtkWidget *wgt, gpointer cbdata);
extern void	win_dtab_toggle(GtkWidget *wgt, gpointer cbdata);
extern void	win_dtab_top(GtkWidget *wgt, gpointer cbdata);
extern void	win_dtab_bot(GtkWidget *wgt, gpointer cbdata);
extern void	win_dtab_left(GtkWidget *wgt, gpointer cbdata);
extern void	win_dtab_right(GtkWidget *wgt, gpointer cbdata);
extern void	win_redraw_doc_tab(void *);
#ifdef APP_GNP
extern void	win_wwrap_toggle(GtkWidget *wgt, gpointer cbdata);
#endif	/* APP_GNP */
extern void	win_doc_reset_style(gpointer data);
#ifdef USE_WINLIST
extern void	win_list_set_curdoc(win_t *w);
extern void	win_list_set_numdoc(win_t *w);
#else
# define	win_list_set_curdoc(w)
# define	win_list_set_numdoc(w)
#endif


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __WIN_H__ */
