/*
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
 * 	 and Andrew Lumsdaine
 *
 * This file is part of XMPI
 *
 * You should have received a copy of the License Agreement for XMPI 
 * along with the software; see the file LICENSE.  If not, contact 
 * Office of Research, University of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 *
 * Additional copyrights may follow.

 *
 *	$Id: xmpi.h,v 1.7 1999/11/11 18:10:09 bbarrett Exp $
 *
 *	Function:	- XMPI templates and constants
 */

#ifndef _XMPI_H
#define _XMPI_H

#include <X11/Intrinsic.h>
#include <limits.h>
#include <stdio.h>

#include "xmpi_sys.h"

/*
 * version number of XMPI
 */
#define XMPI_VERSION "2.2"


/*
 * application resources
 */
#define XtNhelp		"help"
#define XtCHelp		"Help"
#define XtNbuffers	"buffers"
#define XtCBuffers	"Buffers"
#define XtNrankFont	"rankFont"
#define XtCRankFont	"RankFont"
#define XtNmsgFont	"msgFont"
#define XtCMsgFont	"MsgFont"
#define XtNlcomCol	"lcomCol"
#define XtCLcomCol	"LcomCol"
#define XtNrcomCol	"rcomCol"
#define XtCRcomCol	"RcomCol"
#define XtNbandCol	"bandCol"
#define XtCBandCol	"BandCol"
#define XtNbandDash	"bandDash"
#define XtCBandDash	"BandDash"
#define XtNbandWidth	"bandWidth"
#define XtCBandWidth	"BandWidth"
#define XtNhelpCmd	"helpCmd"
#define XtCHelpCmd	"HelpCmd"
#define XtNinfoLabel	"infoLabel"
#define XtCInfoLabel	"InfoLabel"

typedef struct {
	Boolean		ap_help;	/* prints help info */
	int		ap_buffers;	/* # msg status buffers */
	XFontStruct	*ap_rankfont;	/* process rank font */
	XFontStruct	*ap_msgfont;	/* message count font */
	Pixel		ap_lcomcol;	/* communicator local group colour */
	Pixel		ap_rcomcol;	/* communicator remote group colour */
	Pixel		ap_bandcol;	/* colour of rubber band */
	Boolean		ap_banddash;	/* use dashed rubber band */
	int		ap_bandwidth;	/* width of rubber band */
	char		*ap_helpcmd;	/* help invocation command line */
	char		*ap_infolbl;	/* label for info string display */
} AppData, *AppDataPtr;

/*
 * resources
 */
#define XMPI_RANKFONT	"-*-helvetica-bold-r-normal--*-140-*-*-*-*-*-*"
#define XMPI_MSGFONT	"-*-helvetica-medium-r-normal--*-120-*-*-*-*-*-*"

#define XMPI_HELPCMD 	"netscape http://www.osc.edu/Lam/lam/xmpi-help.html"
#define XMPI_INFOLABEL 	"Boot"

/*
 * rubber band resources
 */
#define	XMPI_BANDCOLOUR	"cyan"		/* rubber band colour */
#define XMPI_BANDDASH	False		/* rubber band line style */
#define	XMPI_BANDWIDTH	1		/* rubber band line width */

/*
 * fixed colours
 */
#define XMPI_BLKCOLOUR	"red"		/* blocked process colour */
#define XMPI_SYSCOLOUR	"yellow"	/* system overhead colour */
#define XMPI_RUNCOLOUR	"green"		/* running process colour */
#define XMPI_LBLCOLOUR	"white"		/* plot labeling colour */
#define XMPI_LCOMCOLOUR	"cyan"		/* communicator local group colour */
#define XMPI_RCOMCOLOUR	"plum"		/* communicator remote group colour */

/*
 * constants
 */
#define XMPI_VWXNPROCS	4		/* def. view # horiz. procs */
#define XMPI_VWYNPROCS	4		/* def. view # vert. procs */
#define XMPI_VWRADIUS	50		/* view hexagon radius */
#define XMPI_VWXMARGIN	20		/* view horizontal margins */
#define XMPI_VWYMARGIN	20		/* view vertical margins */
#define XMPI_VWXWIDTH	4		/* extra view width */
#define XMPI_VWXHEIGHT	4		/* extra view height */
#define XMPI_VWLNWIDTH	2		/* view drawing line width */
#define XMPI_VWXRANK	-4		/* view horiz. rank displacement */
#define XMPI_VWYRANK	30		/* view vert. rank displacement */
#define XMPI_VWXLIGHT	-30		/* view horiz. light displacement */
#define XMPI_VWYLIGHT	-17		/* view vert. light displacement */
#define XMPI_VWXMESG	5		/* view horiz. msg displacement */
#define XMPI_VWYMESG	-17		/* view vert. msg displacement */
#define XMPI_VWXNMSG	17		/* view horiz. #msg displacement. */
#define XMPI_VWYNMSG	3		/* view vert. #msg displacement. */
#define XMPI_VWBFSMAX	200		/* message status table size */

#define XMPI_FOTITLE	25		/* focus title bar size */
#define XMPI_FOBORDER	10		/* focus border size */

#define XMPI_SHOWNONE	0		/* showing no datatype */
#define XMPI_SHOWPROC	1		/* showing process datatype */
#define XMPI_SHOWMESG	2		/* showing message datatype */

#define XMPI_DTINDENT   8		/* indentation level for datatypes */

#define XMPI_KVDEFSIZE	200		/* Kiviat def. window size */
#define XMPI_KVBORDER	20		/* Kiviat border size */
#define XMPI_KVTEXT	10		/* Kiviat text size */

#define XMPI_TRNVIEW	3		/* trace # cached views */
#define XMPI_TRWIDTH	400		/* trace width */
#define XMPI_TRHEIGHT	10		/* trace height */
#define XMPI_TRMINWIDTH	300		/* trace min. width */
#define XMPI_TRDISP	30		/* trace displacement */
#define XMPI_TRNPROCS	8		/* # visible trace processes */
#define XMPI_TRSCALE	1024		/* pixels/second scale factor */
#define XMPI_TRVCRPLAY	50		/* VCR play speed timeout */
#define XMPI_TRVCRFWD	5		/* VCR forward speed timeout */

#define XMPI_MTLNWIDTH	2		/* matrix line width */
#define XMPI_MTMINPROC	4		/* matrix default window size */
#define XMPI_MTMAXPROC	16		/* matrix scrollbar threshold */
#define XMPI_MTCELLSIZE	24		/* matrix single cell size */
#define XMPI_MTCNTINSET	4		/* matrix source count inset */
#define XMPI_MTCNTMAX	7		/* matrix max source count */

#define XMPI_FLUSHDELAY 2

#ifdef _POSIX_PATH_MAX
#define XMPI_PATHMAX	_POSIX_PATH_MAX
#else
#define XMPI_PATHMAX	255
#endif

#define SQRT3		((double) 1.73205)
#ifndef PI
#define PI		((double) 3.14159)
#endif

/*
 * button/menu actions
 */
#define XMPI_BSNAPSHOT	1
#define XMPI_BTRACE	2
#define XMPI_BKIVIAT	3
#define XMPI_BMATRIX	4
#define XMPI_BRERUN	5
#define XMPI_BCLEAN	6

/*
 * efficiency macros
 */
#define	al_prev_m(l,p) \
	((void *) (((struct al_head *) (p) - 1)->al_prev))

#define	al_next_m(l,p) \
	((((struct al_head *) (p) - 1)->al_next) ? \
		(void *) al_body(((struct al_head *) (p) - 1)->al_next) : \
		(void *) 0)

struct xmfocus {
	int		xmf_myrank;	/* my rank for callback */
	Widget		xmf_window;	/* focus window */
	Widget		xmf_rank;	/* rank label */
	Widget		xmf_light;	/* light label */
	Widget		xmf_func;	/* function label */
	Widget		xmf_pr_rt;	/* peer or root label */
	Widget		xmf_peer;	/* peer (src/dest) label */
#define xmf_root	xmf_peer	/* root (src/dest) label */
	Widget		xmf_com;	/* communicator label */
	Widget		xmf_compb;	/* communicator push button */
	Widget		xmf_dtb;	/* datatype push button */
	Widget		xmf_tag;	/* tag label */
	Widget		xmf_cnt;	/* count label */
	Widget		xmf_msgsrc;	/* message source label */
	Widget		xmf_msgcom;	/* message comm. label */
	Widget		xmf_msgcompb;	/* message comm. push button */
	Widget		xmf_msgtag;	/* message tag label */
	Widget		xmf_msgdtb;	/* message datatype push button */
	Widget		xmf_msgcnt;	/* message count */
	Widget		xmf_nmsg;	/* # messages label */
	Widget		xmf_nmsgpb;	/* # messages push button */
	struct xmproc	*xmf_proc;	/* ptr process structure */
};

struct xmtrace {
	int		xmt_rank;	/* process global rank */
	int		xmt_state;	/* process state */
	double		xmt_time;	/* start time (sec) */
	double		xmt_lapse;	/* time lapse (sec) */
};

struct xmarrow {
	int		xma_srank;	/* sender global rank */
	int		xma_rrank;	/* receiver global rank */
	double		xma_stime;	/* sender time */
	double		xma_rtime;	/* receiver time */
};

/*
 * globally used variables
 */
extern XtAppContext	app;			/* application context */
extern AppData		app_res;		/* application resources */
extern Widget		xmpi_shell;		/* top level app. shell */
extern char		xmpi_info[];		/* information string */

/*
 * prototypes
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern void	xmpi_bail __ARGS((void));
extern void	xmpi_busy __ARGS((void));
extern void	xmpi_cleanup __ARGS((void));
extern void	xmpi_unbusy __ARGS((void));
extern Widget	xmpi_wmshell __ARGS((Widget));
extern void	xmpi_setsize __ARGS((int , int));
extern void	xmpi_setminmax __ARGS((int , int , int , int));
extern void	xmpi_seticon __ARGS((Pixmap));

extern void	xmpi_aschema_dialog __ARGS((Widget));
extern void	xmpi_aschema_busy __ARGS((void));
extern void	xmpi_aschema_unbusy __ARGS((void));
		
extern void	xmpi_browse_build __ARGS((Widget));
extern void	xmpi_browse_fill __ARGS((Widget));
		
extern Widget	xmpi_ctl_build __ARGS((Widget));
extern void	xmpi_ctl_clean __ARGS((void));
extern void	xmpi_ctl_resetinfo __ARGS((void));
extern void	xmpi_ctl_setapp __ARGS((char *));
extern void	xmpi_ctl_setinfo __ARGS((char *));
extern void	xmpi_ctl_setsensitive __ARGS((int, Boolean));

extern Widget	xmpi_vw_create __ARGS((Widget));
extern void	xmpi_vw_init __ARGS((void));
extern void	xmpi_vw_clear __ARGS((void));
extern void	xmpi_vw_dbsetmode __ARGS((int));
extern void	xmpi_vw_update __ARGS((int));
extern void	xmpi_vw_commplot __ARGS((struct _gps *, int, int, int));
extern int	xmpi_vw_dbmode __ARGS((void));
extern int	xmpi_vw_getnprocs __ARGS((void));
extern struct xmproc *
		xmpi_vw_getprocs __ARGS((void));

extern void	xmpi_fo_busy __ARGS((void));
extern void	xmpi_fo_toggle __ARGS((Widget, int, struct xmproc *));
extern void	xmpi_fo_destroy __ARGS((int));
extern void	xmpi_fo_destroy_all __ARGS((void));
extern void	xmpi_fo_reset __ARGS((void));
extern void	xmpi_fo_update __ARGS((int));
extern void	xmpi_fo_unbusy __ARGS((void));
		
extern void	xmpi_kv_busy __ARGS((void));
extern void	xmpi_kv_popup __ARGS((void));
extern void	xmpi_kv_popdown __ARGS((void));
extern void	xmpi_kv_unbusy __ARGS((void));
extern void	xmpi_kv_update __ARGS((void));
		
extern int	xmpi_run __ARGS((char *, Widget));
extern void	xmpi_run_cleanup __ARGS((void));
extern void	xmpi_run_delete __ARGS((void));
extern void	xmpi_run_dialog __ARGS((Widget));
extern void	xmpi_run_rerun __ARGS((void));
extern void	xmpi_run_set_nodes __ARGS((char *));
extern void	xmpi_run_set_prog __ARGS((char *, char *));
extern void	xmpi_run_busy __ARGS((void));
extern void	xmpi_run_unbusy __ARGS((void));
		
extern Widget	xmpi_copies_create __ARGS((Widget));
extern char *	xmpi_copies_get __ARGS((void));
		
extern int	xmpi_db_getgpeer __ARGS((int, int, int));
extern int	xmpi_db_getlpeer __ARGS((int, int, int));
extern int	xmpi_db_getload __ARGS((int, double *, double *));
extern int	xmpi_db_getnprocs __ARGS((void));
extern int	xmpi_db_gettraces __ARGS((double, double, struct xmtrace **));
extern int	xmpi_db_getarrows __ARGS((double, double, struct xmarrow **));
extern double	xmpi_db_getmaxtime __ARGS((void));
extern double	xmpi_db_getmintime __ARGS((void));
extern double	xmpi_db_getminlapse __ARGS((void));
extern int	xmpi_db_getmaxtraces __ARGS((void));
extern int	xmpi_db_getstat __ARGS((int, struct xmproc *));
extern void	xmpi_db_settime __ARGS((double));
extern void	*xmpi_db_getdtype __ARGS((int, int));
extern void	xmpi_db_getcomm __ARGS((int, int, struct _gps **,
						int *, int *, int *));

extern void	xmpi_parse_tracefile __ARGS((FILE *));
extern void	xmpi_db_free __ARGS((void));
extern int	xmpi_db_internals __ARGS((void));

extern void	xmpi_dt_busy __ARGS((void));
extern void	xmpi_dt_create __ARGS((Widget));
extern void	xmpi_dt_update __ARGS((int, struct xmfocus *, int));
extern void	xmpi_dt_clear __ARGS((void));
extern void	xmpi_dt_msg __ARGS((int, struct xmfocus *, int));
extern void	xmpi_dt_proc __ARGS((int, struct xmfocus *, int));
extern void	xmpi_dt_setrank __ARGS((int, char *));
extern void	xmpi_dt_popdown __ARGS((void));
extern void	xmpi_dt_popup __ARGS(());
extern void	xmpi_dt_unbusy __ARGS((void));

extern void	xmpi_tr_busy __ARGS((void));
extern void	xmpi_tr_create __ARGS((void));
extern void	xmpi_tr_destroy __ARGS((void));
extern int	xmpi_tr_vcron __ARGS((void));
		
extern void	xmpi_tr_select __ARGS((Widget));
extern void	xmpi_tr_dump __ARGS((Widget));
extern void	xmpi_tr_express __ARGS((Widget));
extern void	xmpi_tr_cleanup __ARGS((void));
extern void	xmpi_tr_unbusy __ARGS((void));
extern void	xmpi_tr_file  __ARGS((Widget));
          
extern void	xmpi_options_busy __ARGS((void));
extern void	xmpi_options_set __ARGS((Widget));
extern void	xmpi_options_unbusy __ARGS((void));

extern void	xmpi_mat_popup __ARGS((void));
extern void	xmpi_mat_destroy __ARGS((void));
extern void	xmpi_mat_update __ARGS((struct xmproc *));
extern void	xmpi_mat_busy __ARGS((void));
extern void	xmpi_mat_unbusy __ARGS((void));

extern void	xmpi_atexit __ARGS((void (*)()));
extern void	xmpi_fail __ARGS((char *));
extern void	xmpi_flush __ARGS((void));
extern void	xmpi_busy_widget __ARGS((Widget));
extern void	xmpi_unbusy_widget __ARGS((Widget));
extern void	xmpi_setlabel __ARGS((Widget, char *));
extern void	xmpi_vstr_extent __ARGS((char *, XFontStruct *, int *, int *));
extern void	xmpi_vstr_draw __ARGS((Display *, Drawable, GC, int, int,
				char *, XFontStruct *));
extern Widget	xmpi_mklabel __ARGS((Widget, char *, int, int));
extern Widget	xmpi_mkcolpixbutton __ARGS((Widget, void (*)(),
				char *, void (*)(), char *, void (*)(),
				char *, char *[], int));
extern Widget	xmpi_mkpixbutton __ARGS((Widget, void (*)(),
				char *, void (*)(), char *, void (*)(),
				char *, unsigned char *, int, int, int));
extern void	xmpi_formattach __ARGS((Widget, int, int, int, int));
extern void	xmpi_nosash __ARGS((Widget));
extern int	xmpi_yesno __ARGS((Widget, char *));
extern int	xmpi_coll2pt __ARGS((int));

extern void	xmpi_nodes_build __ARGS((Widget));
extern void	xmpi_about __ARGS((Widget));
extern void	xmpi_error __ARGS((Widget, char *));
extern void	xmpi_help __ARGS((void));
extern void	xmpi_add_pophelp __ARGS((Widget, char *));

extern Pixmap	xpm_build __ARGS((Widget, char *[], Pixel,
				Pixmap *, int *, int *));

#ifdef __cplusplus
}
#endif

#endif	/* _XMPI_H */
