(**
  A dialog to select a internal frame.
**)

MODULE VOFrmSelDlg;

(*
    A dialog to select a internal frame.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT A  := VOArray,
       B  := VOButton,
       BR := VOButtonRow,
       F  := VOFrame,
       G  := VOGUIObject,
       KH := VOKeyHandler,
       L  := VOLabel,
       O  := VOObject,
       P  := VOPanel,
       PL := VOPlate,
       Q  := VOQuickHelp,
       S  := VOSpace,
       T  := VOText,
       W  := VOWindow,
       WG := VOWindowGroup;

CONST
  setMsg * = 0;

  okId     = 100;
  cancelId = 101;

TYPE
  FrmSelDlg*     = POINTER TO FrmSelDlgDesc;

  (**
    A custom dialog that lets you select one of all internally supported
    frames.
  **)

  FrmSelDlgDesc* = RECORD (W.WindowDesc)
                     frame-   : LONGINT;
                     tmpFrame : LONGINT;
                     current  : F.Frame;
                   END;

  SetMsg*        = POINTER TO SetMsgDesc;
  SetMsgDesc*    = RECORD (O.MessageDesc)
                     frame* : LONGINT;
                   END;

  (**
    Initializes an instance.
  **)

  PROCEDURE (d : FrmSelDlg) Init*;

  VAR
    keyHandler : KH.KeyHandler;

  BEGIN
    d.Init^;

    d.CreateAllways(TRUE);

    d.frame:=F.double3DOut;
    d.current:=NIL;

    NEW(keyHandler);
    keyHandler.Init;
    d.AddKeyHandler(keyHandler);

    d.SetModal;
    d.SetTitle("Frame select dialog");
  END Init;

  (**
    Fills the window with all necessary objects.
  **)

  PROCEDURE (d : FrmSelDlg) PreInit*;

  VAR
    panel   : P.Panel;
    array   : A.Array;
    button  : B.Button;
    plate   : PL.Plate;
    row     : BR.ButtonRow;
    frame   : F.Frame;
    space   : S.Space;
    label   : L.Label;
    wGroup  : WG.WindowGroup;
    i       : LONGINT;

  BEGIN
    d.tmpFrame:=d.frame;

    NEW(panel);
    panel.Init;
    panel.Set(P.vertical);

      NEW(array);
      array.Init;
      array.SetFlags({G.horizontalFlex});
      array.Set(4,TRUE);
      array.SetSpace(TRUE,TRUE);

      FOR i:=0 TO F.internalFrameCount-1 DO
        NEW(button);
        button.Init;

          NEW(plate);
          plate.Init;
            NEW(frame);
            frame.Init;
            frame.SetFlags({G.horizontalFlex,G.verticalFlex});
            frame.SetMinWidth(G.sizeFontRel,2);
            frame.SetMinHeight(G.sizeFontRel,2);
             frame.SetInternalFrame(i);
          plate.Add(frame);

        button.SetImage(plate);
        button.SetHelpObject(Q.InitHelp(d.display,T.MakeLeftText(F.internalFrames[i]),button));
        d.keyHandler.AddFocusObject(button);
        button.SetId(i);
        button.Forward(B.pressedMsg,d);

        array.Add(button);
      END;
    panel.Add(array);

      NEW(space);
      space.Init;
      space.Set(TRUE,S.normal);
    panel.Add(space);

      NEW(label);
      label.Init;
        NEW(plate);
        plate.Init;
          NEW(frame);
          frame.Init;
          frame.SetMinWidth(G.sizeFontRel,3);
          frame.SetMinHeight(G.sizeFontRel,3);
          frame.SetInternalFrame(d.frame);
          d.current:=frame;
        plate.Add(frame);
      label.AddTextLabel("Current value:",plate);
    panel.Add(label);


      NEW(space);
      space.Init;
      space.Set(TRUE,S.normal);
    panel.Add(space);

      NEW(row);
      row.Init;
      row.SetFlags({G.horizontalFlex});

        NEW(button);
        button.Init;
        button.SetFlags({G.horizontalFlex,G.verticalFlex});
        button.SetLabelText("_Ok*",d.keyHandler);
        button.SetId(okId);
        button.Forward(B.pressedMsg,d);
        d.keyHandler.AddFocusObject(button);
      row.Add(button);

        NEW(button);
        button.Init;
        button.SetFlags({G.horizontalFlex,G.verticalFlex});
        button.SetLabelText("_Cancel^",d.keyHandler);
        button.SetId(cancelId);
        button.Forward(B.pressedMsg,d);
        d.keyHandler.AddFocusObject(button);
      row.Add(button);
    panel.Add(row);

    NEW(wGroup);
    wGroup.Init;
    wGroup.Set(NIL,panel,TRUE);

    d.SetTop(wGroup);

    d.Forward(W.closeMsg,d);

    d.PreInit^;
  END PreInit;

  PROCEDURE (d : FrmSelDlg) Receive*(message : O.Message);

  VAR
    set : SetMsg;

  BEGIN
    WITH
      message : B.PressedMsg DO
        CASE message.source.id OF
          okId:
            d.frame:=d.tmpFrame;
            d.Close;
            NEW(set);
            set.frame:=d.frame;
            d.Send(set,setMsg);
        | cancelId:
            d.Close;
        ELSE
          d.tmpFrame:=message.source.id;
          d.current.SetInternalFrame(d.tmpFrame);
        END;
    | message : W.CloseMsg DO
        d.Close;
    ELSE
      d.Receive^(message);
    END;
  END Receive;

  (**
    Sets the given frame as the select one.
  **)

  PROCEDURE (d : FrmSelDlg) SetFrame*(frame : LONGINT);

  BEGIN
    d.frame:=frame;
    IF d.current#NIL THEN
      d.current.SetInternalFrame(d.frame);
    END;
  END SetFrame;

END VOFrmSelDlg.