/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.7
 * September 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include <vdkb/vdkb_plugin.h>
#include <vdkb/vdkb_types.h>
#include <stdio.h>
#define VERBOSE 0
#define EXPORT_FUNCTION "GetExportClass"

static char buff[256];

typedef VDKBAbstractComponentInterface* (*get_class) (void);
/*
    - get shared libpath and libname
    - assign <module_name> using g_module_build_path()
    - try to open shared lib using g_module_open ()
    - if fails set <module> == NULL and set <error> with g_module_error ()
    - else
    - set <interface> calling GetExportClass() using g_module_symbol()
    - if fails set <module> == NULL and set <error> with g_module_error ()
    - else
    - assign <icon> calling interface->Icon()
    - assign <tip> calling interface->Tip()
    - assign id to 0 (will be  PLUGIN_TOOL_BEGIN + ordinal number of the item
    into plugin list).
*/

VDKBPlugin::VDKBPlugin(char* libpath, char* libname):
  module(NULL),lib_path(libpath),lib_name(libname),
  icon(NULL),interface(NULL),id(0)
{
 
}

/*
destructor
*/
VDKBPlugin::~VDKBPlugin()
{

}

bool
VDKBPlugin::DlOpen()
{
  get_class foo;
  // assign <module_name>
  module_name = g_module_build_path((char*) lib_path, (char*) lib_name);
#if VERBOSE
  printf("\nVDKBPlugin::VDKBPlugin - module name:%s",(char*) module_name);
  fflush(stdout);
#endif
  // try to open shared lib
  module = g_module_open (module_name, G_MODULE_BIND_LAZY);
  if(!module)
    {
      // set error
      module = NULL;
      interface = NULL;
      error = g_module_error ();
#if VERBOSE
      printf("\nVDKBPlugin::VDKBPlugin - fail to load - %s",(char*) error);
      fflush(stdout);
#endif
      return false;
    }
  // get interface
  void** foo_address = (void**) &foo;
  if (!g_module_symbol (module,EXPORT_FUNCTION, foo_address))
    {
      // set module invalid and error
      module = NULL;
      interface = NULL;
      error = g_module_error ();
#if VERBOSE
      printf("\nVDKBPlugin::VDKBPlugin - fail to map - %s",(char*) error);
      fflush(stdout);
#endif
      return false;
    }
  interface = foo();
#if VERBOSE
  printf("\nVDKBPlugin::VDKBPlugin - got %s interface - %p",
	 (char*) module_name, interface);
  fflush(stdout);
#endif
  // set component icon and tip
  icon = interface->Icon();
  tip = (char*) interface->Tip();
  // set id to default 0
  // will be set to PLUGIN_TOOL_BEGIN + ordinal number
  // by plugin list.
  id = 0;
  return true;
}
/*
 */
bool
VDKBPlugin::DlClose()
{
#if VERBOSE
      printf("\nVDKBPlugin::~VDKBPlugin - closing - %s",(char*) module_name);
      fflush(stdout);
#endif
if(module &&  (!g_module_close (module)))
  {
    printf ("\nerror: %s", g_module_error ());
    fflush(stdout);
    return false;
  }
 else
   {
     if(interface)
       delete interface;
     return true;
   }
}
//=============== PLUGIN LIST ======================

bool
VDKBPluginList::Load(char* file)
{
FILE* fp = fopen(file,"r");
if(!fp)
  return false;
while(fgets(buff,sizeof(buff),fp))
  {
    int n =  strlen(buff)-1;
    buff[n] = buff[n] == '\n' ? '\0' : buff[n];
    char* p = strchr(buff,',');
    if(p)
      {
	*p ='\0';
	p++;
	VDKBPlugin plugin(buff,p);
	add(plugin);
      }
    else
      return false;
  }
 fclose(fp);
 return true;
}
/*
 */
bool
VDKBPluginList::DlOpen()
{
int t = 0;
bool result = true;
VDKBPluginListIterator li(*this);
for(;li;li++)
  {
    if(li.current().DlOpen())
      {
      // assign id
      li.current().Id(PLUGIN_TOOL_BEGIN+t);
      t++;
      }
    else
      result = false;
  }
return result;
}
/*
 */
bool
VDKBPluginList::DlClose()
{
  bool result = true;
  VDKBPluginListIterator li(*this);
  for(;li;li++)
    if(!li.current().DlClose())
      result = false;
return result;
}
/*
  returns the interface of the loaded
  <id> plugin.
  NULL on failure
  Note:
  id are PLUGIN_TOOL_BEGIN+ordinal number of
  valid interfaces.
*/
VDKBAbstractComponentInterface* 
VDKBPluginList::Interface(int id)
{
  VDKBAbstractComponentInterface* interface = NULL;
  VDKBPluginListIterator li(*this);
  for(;li;li++)
    {
      if(li.current().IsValid() && 
	 li.current().Id() == id)
	{
	  interface = li.current().Interface();
	  break;
	}
    }
  return interface;
}

VDKBAbstractComponentInterface* 
VDKBPluginList::Interface(char *classname)
{
  VDKBAbstractComponentInterface* interface = NULL;
  VDKBPluginListIterator li(*this);
  for(;li;li++)
    {
      if(li.current().IsValid() && 
	 li.current().Interface())
	{
	  if(!strcmp(classname,li.current().Interface()->VDKName()))
	    {
	      interface = li.current().Interface();
	      break;
	    }
	}
    }
  return interface;
}
