/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#include <vdkb/vdkb_evcontain.h>
#include <vdkb/vdkb_labelbutton.h>
#include <vdkb/vdkb_form.h>
#include <vdk/vdk.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_prjman.h>
#include <vdkb/vdkb_objinspect.h>
#include <stdlib.h>
#include <vdkb/vdkb_paned.h>
#include <vdkb/vdkb_fixed.h>
/*
================================
symbolic constants to templatize
a bit
================================
*/
// for methods and other stuff
#define CLASS VDKBPaned
// put here vdk class name string
#define VDK_CLASS "VDKPaned"
// put here vdk class name
#define VDK_ANCESTOR  VDKPaned
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "paned"

static char buff[128];
int CLASS::Counter = 0;

DEFINE_EVENT_LIST(CLASS,VDKBEventContainer);
DEFINE_SIGNAL_LIST(CLASS,VDKBEventContainer);


/*
 */
bool
CLASS:: DelBox(VDKObject* sender)
{
  // destroy inner gtk+ placeholder widget
  gtk_widget_destroy(container);
  // call ancestor delete box
  VDKBEventContainer::DelBox(sender);
  // notify to inspector that object was deleted
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      VDKBProjectManager* prjman =
	dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
      if(prjman && prjman->objInspector)
	prjman->objInspector->SetActive(NULL);
    }
return true;
}

/*
 */
bool
CLASS::SetBoxSize(VDKObject* sender)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      ownerform->SetBoxSize(NULL);
    }
  return true;
}

//===========================================
/*
 */
CLASS::CLASS(char* name, VDKForm* owner, int mode):
  VDKBEventContainer(name,owner)
{
  Counter++;
  VDKBObject::object = this;
  VDKBEventContainer::mode = mode;
  Init();
}

/*
 */
CLASS::CLASS(char* name,VDKBEventContainer* outer, int mode):
    VDKBEventContainer(name,outer->Owner())
{
  VDKBObject::object = this;
  Counter++;
  outerbox = outer;
  VDKBEventContainer::mode = mode;
  Init();
 }
/*
 */
void
CLASS::Init()
{
  AddBox();
  //AddCanvas(w,h);
  // makes a pop menu
  popmenu = new VDKBContainerPopMenu(this);
  delBox = new VDKMenuItem(popmenu,"Remove paned");
  setsize = new VDKMenuItem(popmenu,"Set min size");
  selectparent =  new VDKMenuItem(popmenu,"Select parent container");
  SignalConnect(selectparent,"activate",
		    &CLASS::SelectParentContainer);
  SignalConnect(delBox,"activate",&CLASS::DelBox);
  SignalConnect(setsize,"activate",&CLASS::SetBoxSize);

  /* assign this as parent so this can receive signals  */
  popmenu->Parent(this);
  popmenu->Setup();
  /*
    better add it to owner, so will be surely
    destroyed even if never popped
  */
  Owner()->AddItem(popmenu);
  CONNECT_COMMON_EVENTS;
  SetSize(100,100);
}
/*
 */
void
CLASS::AddBox()
{
  widget = sigwid = container =
    mode == v_box ? gtk_vpaned_new() : gtk_hpaned_new();
  gtk_widget_show(container);
}

/*
extra args unused
 */
void
CLASS::AddWidget(VDKObject* obj, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
  if(justify == r_justify)
    gtk_paned_add2(GTK_PANED(container),obj->Widget());
  else
    gtk_paned_add1(GTK_PANED(container),obj->Widget());
  VDKBEventContainer::Add(obj,justify,expand,fill,padding);
}
/*
extra args used
 */
void
CLASS::Add(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
AddWidget(wid,justify, expand, fill , padding,forceArgs);
}
/*
  This method is called by global MakeWidget() in vdkb_design.cc
  MakeWidget() scans a table that maps class id's with each
  static MakeWidget() for each class. Class id's are generated
  during clicks on widget palette.
  On return:
  0 - successfull
  1 - unsupported widget
  2 - target is not a container
  3 - no active widget
  4 - unuseful call
*/
int
CLASS::MakeWidgetH(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable frame counter
  // to ensure unicity
  int result = 0;
  CLASS* paned = NULL;
  VDKBEventBox *box1 = NULL;
  VDKBEventBox *box2 = NULL;
  if(owner->Active)
    {
      for(sprintf(buff,"%s%d",VDK_WIDGET,CLASS::Counter);
	  owner->ChildWithName(buff)!= (VDKObject*) NULL;
	  CLASS::Counter++)
	sprintf(buff,"%s%d",VDK_WIDGET,CLASS::Counter);
      paned = new CLASS(buff,owner,h_box);
      for(sprintf(buff,"vbox%d",VDKBEventBox::Counter);
	  owner->ChildWithName(buff) != (VDKObject*) NULL;
	  VDKBEventBox::Counter++)
	sprintf(buff,"vbox%d",VDKBEventBox::Counter);
      box1 = new VDKBEventBox(buff,paned);
      box1->SetPropValue(JUSTIFY_INTERNAL,"c_justify");
      // to pane 1
      paned->AddWidget(box1,c_justify,true,true,true,true);
      for(sprintf(buff,"vbox%d",VDKBEventBox::Counter);
	  owner->ChildWithName(buff) != (VDKObject*) NULL;
	  VDKBEventBox::Counter++)
	sprintf(buff,"vbox%d",VDKBEventBox::Counter);
      box2 = new VDKBEventBox(buff,paned);
      box2->SetPropValue(JUSTIFY_INTERNAL,"2");
      // to pane 2
      paned->AddWidget(box2,r_justify,true,true,true,true);
      VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(owner->Active);
      if(container)
	{
	  if(ev && dynamic_cast<VDKBFixed*>(container))
	    {
	      GdkEventButton* event = (GdkEventButton*) ev;
	      sprintf(buff,"%d",int(event->x));
	      paned->SetPropValue(JUSTIFY_INTERNAL,buff);
	      sprintf(buff,"%d",int(event->y));
	      paned->SetPropValue( EXPAND_INTERNAL,buff);
	      // others than justify and flag unuseful
	      container->AddWidget(paned,int(event->x),
				   int(event->y),
				   true,true,true);
	    }
	  else
	    container->AddWidget(paned);
	  paned->outerbox = container;
	}
      else if(! owner->Active->AddToParent(paned,ev))
	// target isn't a container
	result =  2;
    }
  else
    // no active widget
    result = 3;
  // 0 on success
  if(result && paned)
    paned->Destroy();
 return result;
}
int
CLASS::MakeWidgetV(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable frame counter
  // to ensure unicity
  int result = 0;
  CLASS* paned = NULL;
  VDKBEventBox *box1 = NULL;
  VDKBEventBox *box2 = NULL;
  for(sprintf(buff,"%s%d",VDK_WIDGET,CLASS::Counter);
      owner->ChildWithName(buff)!= (VDKObject*) NULL;
      CLASS::Counter++)
    sprintf(buff,"%s%d",VDK_WIDGET,CLASS::Counter);
  paned = new CLASS(buff,owner,v_box);
  for(sprintf(buff,"vbox%d",VDKBEventBox::Counter);
      owner->ChildWithName(buff) != (VDKObject*) NULL;
      VDKBEventBox::Counter++)
    sprintf(buff,"vbox%d",VDKBEventBox::Counter);
  box1 = new VDKBEventBox(buff,paned);
  box1->SetPropValue(JUSTIFY_INTERNAL,"1");
  // to pane 1
  paned->AddWidget(box1,c_justify,true,true,true,true);
  for(sprintf(buff,"vbox%d",VDKBEventBox::Counter);
      owner->ChildWithName(buff) != (VDKObject*) NULL;
      VDKBEventBox::Counter++)
    sprintf(buff,"vbox%d",VDKBEventBox::Counter);
  box2 = new VDKBEventBox(buff,paned);
  box2->SetPropValue(JUSTIFY_INTERNAL,"r_justify");
  // to pane 2
  paned->AddWidget(box2,r_justify,true,true,true,true);
  if(owner->Active)
    {
      VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(owner->Active);
      if(container)
	{
	  if(ev && dynamic_cast<VDKBFixed*>(container))
	    {
	      GdkEventButton* event = (GdkEventButton*) ev;
	      sprintf(buff,"%d",int(event->x));
	      paned->SetPropValue(JUSTIFY_INTERNAL,buff);
	      sprintf(buff,"%d",int(event->y));
	      paned->SetPropValue( EXPAND_INTERNAL,buff);
	      // others than justify and flag unuseful
	      container->AddWidget(paned,int(event->x),
				   int(event->y),
				   true,true,true);
	    }
	  else
	    container->AddWidget(paned);
	  paned->outerbox = container;
	}
      else if(! owner->Active->AddToParent(paned,ev))
	// target isn't a container
	result =  2;
    }
  else
    // no active widget
    result = 3;
  // 0 on success
  if(result)
    {
      if(box1) box1->Destroy();
      if(box2) box2->Destroy();
      if(paned) paned->Destroy();
    }
 return result;
}
////////////////////////////////////////////////////////////////////
/*
 */
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\tmode:%s;", mode == v_box ? "v_box" : "h_box");
  fprintf(fp,"\n\tBorderWidth:%s;", (char*) GetProp("BorderWidth"));
}

char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_mode[16];
  char obj_name[128];
  char obj_parent[128];
  char temp[256];
  char bw[16];
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_mode,buffer,"mode:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return NULL;
  else
    source = new char[1024];
  sprintf(temp,"\n%s = new VDKPaned(this,%s);" ,obj_name,obj_mode);
  strcpy(source,temp);
  // get size
  VDKPoint size = parser.Size(buffer);
  if(size.X() > 0 || size.Y() > 0)
    {
      sprintf(temp,"\n%s->SetSize(%d,%d);",obj_name,size.X(),size.Y());
      strcat(source,temp);
    }
  if(strcmp(obj_parent,NIHIL_PROP))
    sprintf(temp,"\n%s->Add(%s",obj_parent,obj_name);
  else
    sprintf(temp,"\nAdd(%s",obj_name);
  strcat(source,temp);
  // prepares arguments for add widget to container
  char justify[16],expand[16],fill[16],padding[16];
  if(parser.GetParam(justify,buffer,PROP_JUSTIFY_INTERNAL) &&
     parser.GetParam(expand,buffer,PROP_EXPAND_INTERNAL) &&
     parser.GetParam(fill,buffer,PROP_FILL_INTERNAL) &&
     parser.GetParam(padding,buffer,PROP_PADDING_INTERNAL))
    {
      sprintf(temp,",%s,%s,%s,%s);",
	      justify,expand,fill,padding);
      strcat(source,temp);
    }
  else
    {
      sprintf(temp,");");
      strcat(source,temp);
    }

  if(parser.GetParam(bw,buffer,"BorderWidth:") &&
     strcmp(bw,NIHIL_PROP))
    {
      sprintf(temp,"\n%s->BorderWidth(%s);",obj_name,bw);
      strcat(source,temp);
    }
  return source;
}
/*
 */
bool
CLASS::CreateWidget(VDKBGuiForm* owner, char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char obj_mode[16];
  CLASS* box;
  int mode;
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_mode,buffer,"mode:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return false;
  // get mode and size
  mode = !strcmp(obj_mode,"h_box") ? h_box : v_box;
  VDKPoint size = parser.Size(buffer);
  // get packing args
  int justification = l_justify;
  int expand=0,fill=0,padding=0;
  int bw; // border width
  char arg[32];
  if(parser.GetParam(arg,buffer,PROP_JUSTIFY_INTERNAL))
    justification = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_EXPAND_INTERNAL))
    expand = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_FILL_INTERNAL))
    fill = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_PADDING_INTERNAL))
    padding = atoi(arg);
  if(parser.GetParam(arg,buffer,"BorderWidth:") &&
     strcmp(arg,NIHIL_PROP))
    bw = atoi(arg);
  else
    bw = -1;
  // no parent, widget will be added to owner form innerbox
  if(!strcmp(obj_parent,NIHIL_PROP))
    {
      box = new CLASS(obj_name,owner->InnerBox(),mode);
      owner->AddWidget(box,justification,expand,fill,padding);
    }
  // get parent container address
  else
    {
      VDKObject* p = owner->ChildWithName(obj_parent);
      VDKBEventContainer* container = p ?
	dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
      if(container)
	{
	  box = new CLASS(obj_name,container,mode);
	  container->AddWidget(box,justification,expand,fill,padding,true);
	  box->outerbox = container;
	}
      else
	// FIX ME: user warning
	return false;
    }
  // call ancestor to set common properties
  VDKBObject::CreateWidget(box,buffer,parser);
  if(size.X() > 0 || size.Y() > 0)
    box->ObjectFromVDK()->SetSize(size.X(),size.Y());
  if(bw >= 0)
    {
      box->BorderWidth(bw);
      box->SetPropValue("BorderWidth",arg);
    }
return true;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
This is called by object inspector when a widget
is selected by user, thus to allow widget to set
his own property controls.
 */

VDKObjectContainer*
CLASS::ExtraWidget(VDKBObjectInspector* isp)
{
  inspector = isp;
  VDKFrame* bframe = new VDKFrame(inspector,NULL,h_box,shadow_etched_in);
  bframe->Add(new VDKLabel(inspector,"Border Widht: "),
	      l_justify,false,false,false);
  int bw = atoi( (char*) GetProp("BorderWidth"));
  border = new VDKSpinButton(inspector, bw, 0, 20 , 1 ,0 );
  bframe->Add(border,l_justify,false,false,false);
    // FIX ME: lang support
  VDKLabelButton* button = new VDKLabelButton(inspector,"Change border width");
  bframe->Add(button,l_justify,false,false,false);
  // vdk sygnal system is so flexible
  // that permits to a widget to answer to another widget signal..
  button->Parent(this);
  SignalConnect(button,"clicked",&CLASS::OnBorderWidth);
  return bframe;
}
/*
 */
bool
CLASS::OnBorderWidth(VDKObject*)
{
  sprintf(buff,"%d",(int) border->ValueAsInt);
  SetPropValue("BorderWidth",buff);
  BorderWidth((int) border->ValueAsInt);
  inspector->FormNeedToBeChanged();
  return true;
}





