/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */
#include <vdkb/vdkb_objinspect.h>
#include <vdkb/vdkb.h>
#include <vdkb/vdkb_signal.h>
#include <vdkb/vdkb_form.h>
#include <ctype.h>
#include <vdkb/vdkb_evbox.h>
#include <vdkb/vdkb_textlabel.h>
#include <vdkb/vdkb_menuitem.h>
#include <vdkb/vdkb_menubar.h>
#include <vdkb/vdkb_paned.h>
#include <vdkb/vdkb_notebook.h>
#include <vdkb/vdkb_toolbar.h>
#include <vdkb/vdkb_locale.h>
#include <vdkb/vdkb_handlebox.h>
#include <vdkb/vdkb_rbgroup.h>
#include <vdkb/vdkb_guicanvas.h>
#include <vdk/vdkcolorbrowser.h>
#include <vdkb/vdkb_packer.h>
#include <vdkb/vdkb_pholder.h>
#include <vdkb/vdkb_fixed.h>
#include <vdkb/vdkb_clipdlg.h>
#include <vdkb/vdkb_widclip.h>
void create_font_selection (void);
void font_selection_ok (GtkWidget *w, GtkFontSelectionDialog *fs);
void font_selection_cancel (GtkWidget *w, GtkFontSelectionDialog *fs);
char* selected_font = NULL;
extern VDKBWidgetClipboard* WidgetClipboard;
static char buff[256];
static VDKBGuiForm* activeOwner = NULL;
static char *color_states[] =
{
NORMALBACKGROUND,PRELIGHTBACKGROUND,
INSENSITIVEBACKGROUND,ACTIVEBACKGROUND,
SELECTEDBACKGROUND,FOREGROUND,0
};

char *justifications[] =
{ "l_justify",
"c_justify",
"r_justify",
0
};
static char* sides[] =
{
"top","bottom","left","right",0
};
static char*anchors[] =
{
"center","north","nort-west","north-east",
"south","south-west","south-east",
"west","east",0
};
/*
 */
// in vdkb_design.cc
extern FormEventHandlers evTableItems [];

//////////////////////////////////////////////
DEFINE_SIGNAL_LIST(VDKBObjectInspector,VDKForm);

DEFINE_EVENT_LIST(VDKBObjectInspector,VDKForm);

DEFINE_SIGNAL_MAP(VDKBObjectInspector,VDKForm)
  ON_SIGNAL(nameButton,clicked_signal,SetWidgetName),
  ON_SIGNAL(name,activate_signal,SetWidgetName),
  ON_SIGNAL(nbook,switch_page_signal,OnPageSwitch),
  ON_SIGNAL(sigtable,select_row_signal,OnSelectTable),
  ON_SIGNAL(evtable,select_row_signal,OnSelectEventTable),
  ON_SIGNAL(evtable,click_column_signal,OnJumpToFormEventHandler),
  ON_SIGNAL(sigtable,click_column_signal,OnSelectTable),
  ON_SIGNAL(fontButton,clicked_signal,OnSelectFont),
  ON_SIGNAL(enabled,toggled_signal,OnSelectEnabled),
  ON_SIGNAL(visible,toggled_signal,OnSelectVisible),
  ON_SIGNAL(preview,toggled_signal,OnSelectPreview),
  ON_SIGNAL(repackButton,clicked_signal,RepackWidget),
  ON_SIGNAL(tipButton,clicked_signal,SetWidgetTip),
  ON_SIGNAL(tip,activate_signal,SetWidgetTip),
  ON_SIGNAL(colorButton,clicked_signal,OnChangeColor),
  ON_SIGNAL(mul_connect,clicked_signal,OnMultipleConnect),
  ON_SIGNAL(WidgetsTree,select_node_signal,OnSelectWidgetsTree),
  ON_SIGNAL(WidgetsTree,click_column_signal,OnClickColumnWidgetsTree),
  ON_SIGNAL(add_remove_event,clicked_signal,ConnectToFormEvent),
  ON_SIGNAL(tagButton,clicked_signal,SetWidgetTag),
  ON_SIGNAL(tag,activate_signal,SetWidgetTag),
  ON_SIGNAL(reconfigure,clicked_signal,ReconfigurePackerWidget),
  ON_SIGNAL(treeToolbar,clicked_signal,OnToolbarClicked)
END_SIGNAL_MAP


/*
 */
bool
VDKBObjectInspector::OnClickColumnWidgetsTree(VDKObject*)
{
if(activeOwner)
  LoadTree(activeOwner);
return true;
}
/*
 */
void
VDKBObjectInspector::SelectWidgetByTree(VDKBObject* object)
{
VDKTreeNode node = NULL;
// calling with <object> == NULL
// selects root (form)
if(object)
    node = gtk_ctree_find_by_row_data (GTK_CTREE(WidgetsTree->CustomWidget()),
				       NULL,
				       (gpointer)  object);
 WidgetsTree->SelectedNode = node;
 gtk_ctree_node_moveto (GTK_CTREE(WidgetsTree->CustomWidget()),
			   node,  0,  0.5, -1.0);
}
/*
 */
bool
VDKBObjectInspector::OnSelectWidgetsTree(VDKObject*)
{
  VDKBObject* selected_object = NULL;
  VDKTreeNode node = WidgetsTree->SelectedNode;
  if(! node) return true;
  // retrieve widget address stored by LoadTree()
  gpointer gp =
    gtk_ctree_node_get_row_data(GTK_CTREE(WidgetsTree->CustomWidget()),
				node);
  // cast it to a VDKBObject
  selected_object = reinterpret_cast<VDKBObject*> (gp);
  // unmark active widget if any
  if(active)
    active->ClearMark();
  // form inner box was selected
  // since LoadTree set NULL into row data at root level (form)
  if(! selected_object)
    {
	if(activeOwner && dynamic_cast<VDKBObject*>(activeOwner))
	    selected_object = activeOwner;
	activeOwner->Raise();
    }
  // set owner active widget
  if(activeOwner && selected_object)
    {
      activeOwner->Active  = selected_object;
      // activates inspector on selected widget
      SetActive(selected_object,false);
      // mark it
      if(active)
	active->Mark();
    }
  else
    DisableInspector();
  // enable/disable toolbar
  if( (!WidgetsTree->SelectedNode) ||
      (!activeOwner) ||
      (!selected_object) ||
      (selected_object == activeOwner)
      )
    {
      GtkWidgetList* widlist = treeToolbar->ButtonList;
      for(int t = 0; t < widlist->size(); t++)
	(*treeToolbar)[t]->Enabled = false;
    }
  else
    {
      // cut
      (*treeToolbar)[0]->Enabled = true;
      // copy
      (*treeToolbar)[1]->Enabled = selected_object &&
	!dynamic_cast<VDKBEventContainer*>(selected_object);
      // paste
      (*treeToolbar)[2]->Enabled = WidgetClipboard->size() > 0;
      // paste others
      (*treeToolbar)[3]->Enabled = WidgetClipboard->size() > 1;

    }
  return true;
}

/*
 */
bool
VDKBObjectInspector::SetWidgetTip(VDKObject*)
{
  if(!active)
    return true;
  active->SetPropValue("Tip", strlen(tip->Text) > 0 ? tip->Text : (char*) NIHIL_PROP);
  FormNeedToBeChanged();
  return true;
}
/*
 */
bool
VDKBObjectInspector::SetWidgetTag(VDKObject*)
{
  if(!active)
    return true;
  active->SetPropValue("Tag", strlen(tag->Text) > 0 ? tag->Text : NIHIL_PROP);
  FormNeedToBeChanged();
  return true;
}
/*
 */
void
VDKBObjectInspector::FormNeedToBeChanged()
{
  VDKBGuiForm* owner_form = NULL;
  if(!active)
    return ;
  if( (owner_form = dynamic_cast<VDKBGuiForm*>(active)) )
    owner_form->Changed = true;
  else
    {
      VDKObject* vdkobj = dynamic_cast<VDKObject*>(active);
      if(vdkobj)
	{
	  owner_form = dynamic_cast<VDKBGuiForm*>(vdkobj->Owner());
	  if(owner_form)
	    owner_form->Changed = true;
	}
    }
}

/*
 */
bool
VDKBObjectInspector::OnSelectPreview(VDKObject* )
{
  GtkPackType packtype =
    justification->Selected == 2  ? GTK_PACK_END : GTK_PACK_START;
  if(!active)
    return true;

  VDKBEventBox *box = dynamic_cast<VDKBEventBox*>(active);
  if(!box)
    return true;
  else
    box->PreviewFlag = (bool) preview->Checked;

  EventBoxListIterator li(box->boxlist);
  for(;li;li++)
    {
      VDKBObject* vdkbobj = dynamic_cast<VDKBObject*>(li.current());
      if(vdkbobj)
	{
	  int propExpand = atoi(vdkbobj->GetProp( EXPAND_INTERNAL));
	  int propFill = atoi(vdkbobj->GetProp("_Fill"));
	  int propPadding = atoi(vdkbobj->GetProp("_Padding"));
	  gtk_box_set_child_packing(GTK_BOX(box->Container()),
				    vdkbobj->ObjectFromVDK()->WrappedWidget(),
				    preview->Checked ? propExpand : 0,
				    preview->Checked ? propFill : 0,
				    propPadding,
				    packtype);
	}
    }
  return true;
}
/*
 */
bool
VDKBObjectInspector::ReconfigurePackerWidget(VDKObject* obj)
{
  if(!active)
     return true;
  VDKBPacker* packer = dynamic_cast<VDKBPacker*>(active->ObjectFromVDK()->Parent());
  if(!packer)
    return true;
  int sidesel = side->Selected;
  int anchorsel = anchor->Selected;
  int fill_x = fillx->Checked ? int(GTK_FILL_X) : 0;
  int fill_y = filly->Checked ? int(GTK_FILL_Y) : 0;
  int expanded = p_expand->Checked ? int(GTK_PACK_EXPAND) : 0;
  // justify or side in packer
  sidesel = sidesel < 0 ? 0 : sidesel;
  sprintf(buff,"%d",sidesel);
  active->SetPropValue(JUSTIFY_INTERNAL,buff);
  // expand or anchor in packer
  anchorsel = anchorsel < 0 ? 0 : anchorsel;
  sprintf(buff,"%d",anchorsel);
  active->SetPropValue( EXPAND_INTERNAL,buff);
  // fill or options in packer
  sprintf(buff,"%d",int(fill_x | fill_y | expanded));
  active->SetPropValue("_Fill", buff);
  gtk_packer_set_child_packing(GTK_PACKER(packer->Container()),
			       active->ObjectFromVDK()->Widget(),
			       (GtkSideType) sidesel,
			       (GtkAnchorType) anchorsel,
			       (GtkPackerOptions) (fill_x | fill_y | expanded),
			       0,
			       0, // pad_x,
			       0, // pad_y,
			       0, // i_pad_x,
			       0 // i_pad_y
			       );
  FormNeedToBeChanged();
  return true;
}
/*
 */
bool
VDKBObjectInspector::RepackWidget(VDKObject* obj)
{
  if(!active)
     return true;
  GtkPackType packtype =
    justification->Selected == 2  ? GTK_PACK_END : GTK_PACK_START;
  sprintf(buff,"%d",(int) padding->ValueAsInt);
  active->SetPropValue("_Padding",buff);
  int paddingtype  =  atoi(buff);
  bool filltype =  fill->Checked;
  bool expandtype =  expand->Checked;
  active->SetPropValue(JUSTIFY_INTERNAL,
		       justification->Selected == 0 ? (char*) "0" :
		       justification->Selected == 1 ? (char*) "1" :
		       (char*) "2");
  active->SetPropValue("_Fill", filltype ? (char*) "1" : (char*) "0");
  active->SetPropValue( EXPAND_INTERNAL,expandtype ? (char*) "1" :
			(char*) "0");
  FormNeedToBeChanged();
  /* there are some exceptions, ... not good OOP here  :-(
  */
  // menu item is an exception
  VDKBMenuItem* menuitem = dynamic_cast<VDKBMenuItem*>(active);
  if(menuitem)
    {
      if(packtype == GTK_PACK_END)
	gtk_menu_item_right_justify(
		    (GTK_MENU_ITEM(active->ObjectFromVDK()->WrappedWidget())));
      else
	  GTK_MENU_ITEM(menuitem->ObjectFromVDK()->
			WrappedWidget())->right_justify = 0;
    }
  // VDKBEventBox and most of containers: normally packed
  VDKBEventBox* box = dynamic_cast<VDKBEventBox*>(active->ObjectFromVDK()->Parent());
  if(box)
    {
      gtk_box_set_child_packing(GTK_BOX(box->Container()),
				active->ObjectFromVDK()->WrappedWidget(),
				expandtype,filltype,paddingtype,packtype);
      return true;
    }
  // VDKBMenubar differently packed
  // since casting from menubar to box fails.
  VDKBMenubar* bar =  dynamic_cast<VDKBMenubar*>(active->ObjectFromVDK()->Parent());
  if(bar)
    {
      if (GTK_WIDGET_DRAWABLE (bar->WrappedWidget()))
        {
          gtk_widget_queue_clear (GTK_WIDGET (bar->WrappedWidget()));
        }
      gtk_widget_queue_resize (GTK_WIDGET (bar->WrappedWidget()));
      return true;
    }
  return true;
}
/*
 */
bool
VDKBObjectInspector::OnSelectVisible(VDKObject*)
{
if(!active)
  return true;
 bool flag =  visible->Checked;
 active->SetPropValue(VISIBLE,flag ? CHECK_TRUE : CHECK_FALSE);
 FormNeedToBeChanged();
 return true;
}
/*
 */
bool
VDKBObjectInspector::OnSelectEnabled(VDKObject*)
{
if(!active)
  return true;
 bool flag =  enabled->Checked;
 active->SetPropValue(ENABLED,flag ? CHECK_TRUE : CHECK_FALSE);
 FormNeedToBeChanged();
return true;
}
/*
 */
bool
VDKBObjectInspector::OnSelectFont(VDKObject*)
{
create_font_selection ();
if(selected_font)
  {
    font->Text = selected_font;
    VDKObject* vdkobj = dynamic_cast<VDKObject*>(active);
    if(vdkobj)
      {
	VDKBGuiForm* owner_form = dynamic_cast<VDKBGuiForm*>(vdkobj->Owner());
	if(owner_form)
	  {
	    VDKFont* newfont = new VDKFont(owner_form,selected_font);
	    if( (char*) *newfont) // valid font
	      {
		active->ObjectFromVDK()->Font = newfont;
		active->SetPropValue( FONT,selected_font);
	      }
	    else
	      newfont->Destroy();
	  }
      }
    g_free(selected_font);
  }
FormNeedToBeChanged();
return true;
}
/*
 */
bool
VDKBObjectInspector::OnJumpToFormEventHandler(VDKObject*)
{
  int ndx = evtable->Selected.Row();
  if( (ndx < 0) || ( ndx >= (evtable->Tuples.size())) )
    return true;
  VDKString True = CHECK_TRUE;
  VDKBGuiForm* owner_form = dynamic_cast<VDKBGuiForm*>(active);
  if(owner_form)
    {
      VDKBProjectManager* prjman =
	dynamic_cast<VDKBProjectManager*>(owner_form->Owner());
      if(prjman)
	{
	  char textname[256];
	  sprintf(textname,"%s.cc",(char*) owner_form->Name());
	  prjman->DefineFormEventHandler(textname,evtable->Tuples[ndx][0]);
	}
    }
  return true;
}
/*
 */
bool
VDKBObjectInspector::ConnectToFormEvent(VDKObject*)
{
  bool write_response = false;
  if(!active)
    return true;
  int ndx = evtable->Selected.Row();
  if( (ndx < 0) || ( ndx >= (evtable->Tuples.size())) )
    return true;
  VDKString True = CHECK_TRUE;
  VDKBGuiForm* owner_form =
	dynamic_cast<VDKBGuiForm*>(active);
  if(owner_form)
    {
      VDKString prop = owner_form->GetProp((char*) evtable->Tuples[ndx][0]);
      // toggles property
      if(prop == True)
	{
	  owner_form->SetPropValue((char*) evtable->Tuples[ndx][0],CHECK_FALSE);
	  evTableItems[ndx].items[1] = CHECK_NO;
	  add_remove_event->Caption = "Connect form to selected event";
	  evtable->Titles[0]->Enabled = true;
	}
      else
	{
	  owner_form->SetPropValue((char*)evtable->Tuples[ndx][0],CHECK_TRUE);
	  add_remove_event->Caption = "Disconnect form to selected event";
	  write_response = true;
	  evTableItems[ndx].items[1] = CHECK_YES;
	  evtable->Titles[0]->Enabled = false;
	}
      evtable->UpdateRow(ndx,evTableItems[ndx].items);
      VDKBProjectManager* prjman =
	dynamic_cast<VDKBProjectManager*>(owner_form->Owner());
      if(write_response && prjman)
	{
	  char textname[256];
	  sprintf(textname,"%s.cc",(char*) owner_form->Name());
	  prjman->DefineFormEventHandler(textname,evtable->Tuples[ndx][0]);
	}
    }
  FormNeedToBeChanged();
  return true;
}
// call project manager to write or jump to
// response method
bool
VDKBObjectInspector::OnSelectEventTable(VDKObject*)
{
  if(!active)
    return true;
  int ndx = evtable->Selected.Row();
  if( (ndx < 0) || ( ndx >= (evtable->Tuples.size())) )
    return true;
  VDKString True = CHECK_TRUE;
  VDKBGuiForm* owner_form =
	dynamic_cast<VDKBGuiForm*>(active);
  if(owner_form)
    {
      VDKString prop = owner_form->GetProp((char*) evtable->Tuples[ndx][0]);
      if( prop == True)
	{
	  add_remove_event->Caption = "Disconnect form to selected event";
	  evtable->Titles[0]->Enabled = true;
	}
      else
	{
	  add_remove_event->Caption = "Connect form to selected event";
	  evtable->Titles[0]->Enabled = false;
	}
    }
  return true;
}
/*
 */
// call project manager to write or jump to
// response method
bool
VDKBObjectInspector::OnSelectTable(VDKObject*)
{
  if(!active)
    return true;
  int ndx = sigtable->Selected.Row();
  if( (ndx <= 0) || ( ndx >= (sigtable->Tuples.size()-1)) )
    return true;
  VDKObject* vdkobj = dynamic_cast<VDKObject*>(active);
  if(vdkobj)
    {
      VDKBGuiForm* owner_form =
	dynamic_cast<VDKBGuiForm*>(vdkobj->Owner());
      if(owner_form)
	{
	  VDKBProjectManager* prjman =
	    dynamic_cast<VDKBProjectManager*>(owner_form->Owner());
	  if(prjman)
	    {
	      char textname[256];
	      sprintf(textname,"%s.cc",(char*) owner_form->Name());
	      prjman->
		DefineResponseMethod(textname,
				     owner_form->SignalList[ndx-1].slot);
	    }
	}
    }
  FormNeedToBeChanged();
  return true;
}

/*
 */
bool
VDKBObjectInspector::DeleteConnection(VDKObject* sender)
{
  if(!active)
    return true;
  int ndx = sigtable->Selected.Row();
  VDKObject* vdkobj = dynamic_cast<VDKObject*>(active);
  if(vdkobj)
    {
      VDKBGuiForm* owner_form =
	dynamic_cast<VDKBGuiForm*>(vdkobj->Owner());
      if(owner_form)
	{
	  // firs sigtable row unused
	  owner_form->SignalList.unlink(ndx-1);
	  LoadStaticTable();
	}
    }
  FormNeedToBeChanged();
  return true;
}
// into vdkb_design.cc
extern char*
WidgetClassName(int action_target);
extern OpState  OperationalState;
/*
 */
bool
VDKBObjectInspector::OnWidgetsTreeButtonPress(VDKObject* sender,
					     GdkEvent* event)
{
  // FIX ME: language support
  GdkEventButton* ev = (GdkEventButton*) event;
  if(ev->button != 3)
    return true;
  if(OperationalState.state == op_stand_by &&
     OperationalState.action == act_add_widget &&
     OperationalState.target == NULL)
    {
      // can do if is a container or form is selected
      bool canDo  = dynamic_cast<VDKBEventContainer*>(active) || !active;
      if(canDo)
	{
	  char* name = WidgetClassName(OperationalState.action_target);
	  char* targetname = active ? (char*) active->Name() :
	    activeOwner ? (char*) activeOwner->Name() : (char*) "unknown";
	  sprintf(buff,"Drops a <%s> into %s",
		  name ? name : "unknow", targetname);
	  dropwidget->Caption = buff;
	  treepopmenu->Popup();
	}
    }
  else if(active)
    active->PopMenu();
return true;
}
/*
 */
bool
VDKBObjectInspector::DropWidget(VDKObject* sender)
{
  GdkEventButton event;
  event.type = GDK_BUTTON_PRESS;
  event.button = 1;
  VDKBGuiForm* ownerform = active ?
    dynamic_cast<VDKBGuiForm*>(active->ObjectFromVDK()->Owner()) :
    activeOwner ? activeOwner : NULL;
  if(ownerform)
    {
      // call active widget owner form that makes the job
      // calling with NULL add to innerbox
      VDKObject* target = active ? active->ObjectFromVDK(): NULL;
      ownerform->OnButtonPress( target, (GdkEvent*) &event);
    }
  return true;
}
/*
 */
bool
VDKBObjectInspector::OnSignalListButtonPress(VDKObject* sender,
					     GdkEvent* event)
{
  if(!active)
    return true;

GdkEventButton* ev = (GdkEventButton*) event;
if(ev->button != 3)
  return true;
else
  {
    int ndx = sigtable->Selected.Row();
    if( (ndx > 0) && ( ndx < (sigtable->Tuples.size()-1)) )
      popmenu->Popup();
  }
return true;
}
/*
 */
bool
VDKBObjectInspector::OnActivateSlotName(VDKObject* sender)
{
    if(!active)
    return true;
  // looks on entries array
  int t;
  for(t = 0; t < sigEntries.size(); t++)
    if(sender == sigEntries[t])
      break;
  // freezes the slot
  if(t < sigEntries.size())
    {
      active->SignalList()[t].Slot(sigEntries[t]->Text);
      active->SignalList()[t].SlotFixed(true);
    }
  FormNeedToBeChanged();
  return true;
}
/*
 */
bool
VDKBObjectInspector::OnMultipleConnect(VDKObject*)
{
  int sel;
  if(!active)
    return true;
  else
    sel = sigcombo->Selected;
  if(sel < 0)
    return true;
  VDKString slot = (sigcombo->GetPopdownStrings())[sel];
  printf("\nselected:%s", (char*) slot);
  fflush(stdout);
  // find signal with that slot
  VDKObject* vdkobj = dynamic_cast<VDKObject*>(active);
  if(vdkobj)
    {
      VDKBConnectionList* list = NULL;
      VDKBGuiForm *owner_form =
	dynamic_cast<VDKBGuiForm*>(vdkobj->Owner());
      if(owner_form)
	list = &(owner_form->SignalList);
      else
	return true;
      VDKBConnectionListIterator li(*list);
      for(;li;li++)
	{
	  VDKString list_slot = li.current().slot;
	  if ( list_slot == slot)
	    {
	      VDKBConnection c(active->Name(),
			       (char*) li.current().signal,
			       (char*) list_slot, false);
	      if(!owner_form->SignalList.find(c))
		{
		  owner_form->SignalList.add(c);
		  LoadStaticTable();
		  return true;
		}
	      else
		{
		Application()->MessageBox(APPNAME, "Duplicated connection",
					  MB_OK| MB_ICONINFORMATION);
		return true;
		}
	    }
	}
    }
  Application()->MessageBox(APPNAME, "Connection not found",
			  MB_OK| MB_ICONINFORMATION);
  return true;
}
/*
 */
bool
VDKBObjectInspector::OnConnectSignal(VDKObject* sender)
{
    if(!active)
    return true;

  // looks on button array
  int t;
  for(t = 0; t < connectButtons.size(); t++)
    if(sender == connectButtons[t])
      break;
  if(t < connectButtons.size())
    {
      VDKBConnection c(active->SignalList()[t].Sender()->Name(),
		       active->SignalList()[t].Signal(),
		       active->SignalList()[t].Slot());
      VDKObject* vdkobj = dynamic_cast<VDKObject*>(active);
      if(vdkobj)
	{
	  VDKBGuiForm* owner_form =
	    dynamic_cast<VDKBGuiForm*>(vdkobj->Owner());
	  if(owner_form )
	    {
	      if(!owner_form->SignalList.find(c))
		{
		  owner_form->SignalList.add(c);
		  LoadStaticTable();
		}
	      else
		Application()->MessageBox(APPNAME,
					  "Duplicated response function",
					  MB_OK| MB_ICONINFORMATION);
	    }
	}
    }
  FormNeedToBeChanged();
  return true;
}
/*
 */
void
VDKBObjectInspector::LoadStaticTable()
{
    if(!active)
    return ;

  int t = 0;
  VDKBConnectionList* list = NULL;
  VDKBGuiForm* owner_form = NULL;
  char* p = buff;
  char formname[128];
  VDKObject* vdkobj = dynamic_cast<VDKObject*>(active);
  if(vdkobj)
    {
      owner_form =
	dynamic_cast<VDKBGuiForm*>(vdkobj->Owner());
      if(owner_form)
	list = &(owner_form->SignalList);
      else
	return;
    }
  else
    return;
  sigtable->Clear();
  strcpy(formname,owner_form->Name());
  formname[0] = toupper(formname[0]);
  sprintf(buff,"DEFINE_SIGNAL_MAP(%sForm,VDKForm)",formname);
  sigtable->AddRow(&p);
  VDKBConnectionListIterator li(*list);
  StringList sl;
  for(;li;li++,t++)
    {
      if(li.current().declare)
	sl.add(li.current().slot);
      sprintf(buff,"ON_SIGNAL(%s,%s,%s),",
	      (char*) li.current().sender,
	      (char*) li.current().signal,
	      (char*) li.current().slot);
      if(t == (list->size()-1) )
	buff[strlen(buff)-1] = '\0';
      sigtable->AddRow(&p);
    }
  sprintf(buff,"END_SIGNAL_MAP");
  sigtable->AddRow(&p);
  sigcombo->ClearList();
  if(sl.size() > 0)
    sigcombo->PopdownStrings = sl;
}
/*
 */
bool
VDKBObjectInspector::OnPageSwitch(VDKObject*)
{
  if(!active)
    return true;

  int activePage = nbook->ActivePage;
  if(activePage < 0 || activePage >= nbook->Pages.size())
    return true;
  switch(activePage)
    {
    case 1: // signal page
      SetSlotEntries();
      break;
    }
return true;
}
/*
 */
void
VDKBObjectInspector::SetSlotEntries()
{
  if( !active || (active->SignalList().size() <= 0 ) )
    return;
  int t;
  for(t=0; t < sigEntries.size();t++)
    {
      if(! active->SignalList()[t].SlotFixed())
	{
	  sprintf(buff,"On%s%s",
		  (char*) active->SignalList()[t].Sender()->Name(),
		  (char*) active->SignalList()[t].Nickname());
	  sigEntries[t]->Text = buff;
	  active->SignalList()[t].Slot(buff);
	}
    }
}
/*
 */
bool
VDKBObjectInspector::SetWidgetName(VDKObject*)
{
  if(!active)
    return true;

  VDKObject* vdkobj = dynamic_cast<VDKObject*>(active);
  if(vdkobj)
    {
      VDKBGuiForm* owner_form = dynamic_cast<VDKBGuiForm*>(vdkobj->Owner());
      if(owner_form && owner_form->ChildWithName((char*) name->Text))
	// FIX ME: language support
	Application()->MessageBox(APPNAME,
				  "Duplicated name",
				  MB_OK| MB_ICONINFORMATION);
      else if(owner_form && (strlen((char*) name->Text) > 0))
	{
	  // widget name is changed so it's
	  // necessary to update also signal table
	  VDKString oldname = oldWidgetName;
	  VDKString newname = (char*) name->Text;
	  active->Name((char*) name->Text);
	  // changes widget name
	  owner_form->ChangeConnectionSenderName(newname,oldname);
	  // update signal table
	  SetSlotEntries();
	  oldWidgetName = newname;
	  // reactivate inspector
	  SetActive(active);
	  LoadTree(owner_form);
	  FormNeedToBeChanged();
	}
      else
	{
	  // widget name can't be empty
	  // FIX ME: language support
	  Application()->MessageBox(APPNAME,
				    "Widget name can't be cancelled",
				    MB_OK| MB_ICONINFORMATION);
	  name->Text = (char*) oldWidgetName;
	}

    }
return true;
}
/*
 */
/*
 */
bool
VDKBObjectInspector::OnChangeColor(VDKObject*)
{
  int ndx;
  char color[32];
  VDKColorBrowserParms parms;
  if(!active)
    return true;
  else
    {
      ndx = colortypecombo->Selected;
      if(ndx < 0)
	return true;
      VDKColorBrowser* child = new VDKColorBrowser(this,&parms);
      child->Setup();
      child->ShowModal();
      if(parms.rgb.red < 0)
	return true;
    }
  VDKRgb newcolor(parms.rgb.red, parms.rgb.green, parms.rgb.blue);
  sprintf(color,"%d,%d,%d", newcolor.red, newcolor.green, newcolor.blue);

  switch(ndx)
    {
    case 0: // normal background
      active->ObjectFromVDK()->NormalBackground = newcolor;
      active->SetPropValue(NORMALBACKGROUND,color);
      break;
    case 1: // prelight background
      active->ObjectFromVDK()->PrelightBackground = newcolor;
      active->SetPropValue(PRELIGHTBACKGROUND,color);
      break;
    case 2: // InsensitiveBackground
      active->ObjectFromVDK()->InsensitiveBackground = newcolor;
      active->SetPropValue(INSENSITIVEBACKGROUND,color);
      break;
    case 3: // ActiveBackground
      active->ObjectFromVDK()->ActiveBackground = newcolor;
      active->SetPropValue(ACTIVEBACKGROUND,color);
      break;
    case 4:
      active->ObjectFromVDK()->SelectedBackground = newcolor;
      active->SetPropValue(SELECTEDBACKGROUND,color);
      break;
    case 5: // Foreground
      active->ObjectFromVDK()->Foreground = newcolor;
      active->SetPropValue(FOREGROUND,color);
      break;
    }
  // here an exception, since canvas do not display immediately changes
  VDKBGuiCanvas* canvas;
  VDKBPlaceHolder* pholder;
  if( (canvas = dynamic_cast<VDKBGuiCanvas*>(active)) )
    {
      ((VDKCanvas*)canvas->ObjectFromVDK())->Clear();
       ((VDKCanvas*)canvas->ObjectFromVDK())->Redraw();
    }
  else if( (pholder = dynamic_cast<VDKBPlaceHolder*>(active)) )
    {
      ((VDKCanvas*)pholder->ObjectFromVDK())->Clear();
      ((VDKCanvas*)pholder->ObjectFromVDK())->Redraw();
    }
  FormNeedToBeChanged();
  return true;
}

/*
 */
VDKBObjectInspector::VDKBObjectInspector(VDKForm* owner, VDKBObject* active,
					 char* title,
					 int mode,
					 GtkWindowType display):
  VDKForm(owner,title,mode,display),active(active)
{
  active = NULL;
  ForceToClose = false;
  extrawidget = NULL;
  sigpageBox = evpageBox = NULL;
}
/*
 */
VDKBObjectInspector::~VDKBObjectInspector()
{
}
/*
 */
bool
VDKBObjectInspector::CanClose()
{
return ForceToClose == true;
}


/*
 */
void
VDKBObjectInspector::OnShow(VDKForm*)
{
  // modifyng window policy and or window position
  // on modals makes XServer die :-(
  if(!IsModal())
    {
      VDKPoint ownerPos = Owner()->Position;
      VDKPoint ownerSize = Owner()->Usize;
      VDKPoint p(ownerPos.X() + 30, ownerPos.Y() + 50);
      Position = p;
      // does not allow to shrink or grow
      VDKString Yes = CHECK_YES;
      if(VDKBuilder::ideDefaults.project.wi_resizeable != Yes)
	gtk_window_set_policy(GTK_WINDOW(Window()),false,false,true);
    }
  else
    ForceToClose = true;
}
/*
Tries to load
/var/X11R6/lib/rgb.txt colors database
Unused, substituted with VDKColorBrowser
 */
bool
VDKBObjectInspector::LoadRGB(StringList& colors)
{
printf("\ncall to unused VDKBObjectInspector::LoadRGB()");
fflush(stdout);
  /*
    colors.flush();
    int red,green,blue;
    char colorname[64];
    FILE* fp = fopen("/var/X11R6/lib/rgb.txt","r");
    if(!fp)
    return false;
    // jump first line
    fgets(buff,sizeof(buff),fp);
    while(fgets(buff,sizeof(buff),fp))
    {
    buff[strlen(buff)-1] = '\0';
    sscanf(buff,"%d %d %d %s",&red,&green,&blue,colorname);
    colors.insert(VDKString(colorname));
    }
    fclose(fp);
  */
return true;
}
/*
 */
void
VDKBObjectInspector::Setup()
{
  sprintf(buff,"Inspector: no object");
  Title = buff;
  mainpane = new VDKPaned(this,h_box);
  mainpane->Pack(MakeWidgetsTreePage(),1,true,true);
  nbook = new VDKNotebook(this);
  nbook->AddPage(mainbox = MakePropertiesPage(),"Properties");
  // set signal page container to NULL
  sigpageBox = NULL;
  // set signal table to NULL
  sigtable = NULL;
  // set pop menu
  popmenu = new VDKMenu(this);
  // FIX ME: lang support
  VDKMenuItem *nop = new VDKMenuItem(popmenu,"Nop");
  nop->Enabled = false;
  delConnection = new VDKMenuItem(popmenu,"Delete signal response");
  SignalConnect(delConnection,"activate",
		&VDKBObjectInspector::DeleteConnection);
  /*
    better add it to owner, so will be surely
    destroyed even if never popped
  */
  AddItem(popmenu);
  mainpane->Pack(nbook,2,true,false);
  Add(mainpane);
}
/*
 */
VDKBox*
VDKBObjectInspector::MakePropertiesPage()
{
  // main page box
  int t;
  VDKBox* Nbook0_Page0 = new VDKBox(this,v_box);
  CommonPropertiesFrame =
    new VDKFrame(this,"CommonPropertiesFrame",v_box,shadow_etched_in);
  CommonPropertiesFrame->Label = "Common properties";
  CommonPropertyTable = new VDKTable(this,15,2,true);
  CommonPropertyTable->RowSpacing = 0;
  CommonPropertyTable->ColSpacing = 0;
  CommonPropertyTable->SetSize(210,300);
  // widget name
  nameButton = new VDKLabelButton(this,"Set widget name");
  CommonPropertyTable->AddToCell(nameButton,0,0);
  nameButton->Enabled = false;
  name = new VDKEntry(this,0);
  name->SetTip("Widget names must follow C++ naming rules");
  CommonPropertyTable->AddToCell(name,0,1);
  // widget state
  VDKLabel* Label0 = new VDKLabel(this,"Widget state");
  Label0->Justify =  (GtkJustification) 1;
  CommonPropertyTable->AddToCell(Label0,1,0);
  colortypecombo = new VDKCombo(this,NORMALBACKGROUND);
  CommonPropertyTable->AddToCell(colortypecombo,1,1);
  StringList sc = colortypecombo->PopdownStrings;
  for(t=0; color_states[t]; t++)
    sc.add(VDKString(color_states[t]));
  colortypecombo->PopdownStrings = sc;
  colortypecombo->SelectItem(0);
  // widget color
  colorButton = new VDKCustomButton(this,"Set color");
  colorButton->Enabled = false;
  CommonPropertyTable->AddToCell(colorButton,2,0);
  // widget font
  fontButton = new VDKLabelButton(this,"Set font");
  fontButton->Enabled = false;
  CommonPropertyTable->AddToCell(fontButton,3,0);
  font = new VDKEntry(this,0);
  font->Editable = false;
  CommonPropertyTable->AddToCell(font,3,1);
  // visible
  visible = new VDKCheckButton(this,VISIBLE);
  visible->Enabled = false;
  CommonPropertyTable->AddToCell(visible,4,0);
  // enabled
  enabled = new VDKCheckButton(this,ENABLED);
  enabled->Enabled = false;
  CommonPropertyTable->AddToCell(enabled,4,1);
  // justification
  VDKLabel* justifyLabel = new VDKLabel(this,"Justification");
  CommonPropertyTable->AddToCell(justifyLabel,5,0);
  justification = new VDKCombo(this);
  CommonPropertyTable->AddToCell(justification,5,1);
  StringList sj = justification->PopdownStrings;
  for(t=0;justifications[t];t++)
	sj.add(VDKString(justifications[t]));
  justification->PopdownStrings = sj;
  // packing flags
  expand = new VDKCheckButton(this,"Expand");
  CommonPropertyTable->AddToCell(expand,6,0);
  fill = new VDKCheckButton(this,"Fill");
  fill->Enabled = false;
  CommonPropertyTable->AddToCell(fill,6,1);
  expand->Enabled = false;
  VDKBox* lhbox = new VDKBox(this,h_box);
  lhbox->Add(new VDKLabel(this,"Padding:"),l_justify,false,false,false);
  padding = new VDKSpinButton(this, 0, 0, 20 , 1 ,0 );
  lhbox->Add(padding,l_justify,false,false,false);
  padding->Enabled = false;
  CommonPropertyTable->AddToCell(lhbox,7,0);

  repackButton = new VDKLabelButton(this,"Repack");
  repackButton->Enabled = false;
  CommonPropertyTable->AddToCell(repackButton,7,1);
  // box preview
  preview = new VDKCheckButton(this,"Box Preview");
  CommonPropertyTable->AddToCell(preview,8,0);
  // params for packer
  CommonPropertyTable->AddToCell(new VDKLabel(this,"Side"),9,0);
  side = new VDKCombo(this,sides[0]);
  StringList sl;
  for(t=0;sides[t];t++)
    sl.add(VDKString(sides[t]));
  side->PopdownStrings = sl;
  CommonPropertyTable->AddToCell(side,9,1);
  CommonPropertyTable->AddToCell(new VDKLabel(this,"Anchor"),10,0);
  anchor = new VDKCombo(this,anchors[0]);
  StringList sa;
  for(t=0;anchors[t];t++)
    sa.add(VDKString(anchors[t]));
  anchor->PopdownStrings = sa;
  CommonPropertyTable->AddToCell(anchor,10,1);
  CommonPropertyTable->AddToCell(p_expand =
				 new VDKCheckButton(this,"Expand"),11,0);
  CommonPropertyTable->AddToCell(fillx =
				 new VDKCheckButton(this,"Fill X"),11,1);
  CommonPropertyTable->AddToCell(filly =
				 new VDKCheckButton(this,"Fill Y"),12,0);
  CommonPropertyTable->AddToCell(reconfigure =
				 new VDKCustomButton(this,"Reconfigure"),12,1);
  // widget tip
  tipButton = new VDKLabelButton(this,"Set widget tooltip");
  tipButton->Enabled = false;
  CommonPropertyTable->AddToCell(tipButton,13,0);
  tip = new VDKEntry(this,0);
  CommonPropertyTable->AddToCell(tip,13,1);
  // widget tag
  tagButton = new VDKLabelButton(this,"Set widget tag");
  tagButton->Enabled = false;
  CommonPropertyTable->AddToCell(tagButton,14,0);
  tag = new VDKEntry(this,0);
  CommonPropertyTable->AddToCell(tag,14,1);
  //
  CommonPropertiesFrame->Add(CommonPropertyTable,l_justify,true,true,false);
  Nbook0_Page0->Add(CommonPropertiesFrame,l_justify,true,true,false);
  return Nbook0_Page0;
}

/*
 */
void
VDKBObjectInspector::DisableInspector()
{

  active = NULL;
  name->Text = "";
  tip->Text = "";
  //colortypecombo->ClearList();
  if(sigpageBox)
    {
      int t;
      // disconnects signals
      for(t=0; t < slots.size();t++)
	if (slots[t] > 0)
	  SignalDisconnect(slots[t]);
      //
      connectTable->RemoveObjects();
      sigpageBox->RemoveObjects();
      // remove notebook signal page
      if(nbook->Pages.size() > 1)
	nbook->RemovePage(1);
      sigpageBox = NULL;
    }
  else if(evpageBox)
    {
      evpageBox->RemoveObjects();
      // remove notebook event page
      if(nbook->Pages.size() > 1)
	nbook->RemovePage(1);
      evpageBox = NULL;
    }
  // disable all
  nameButton->Enabled = false;
  colorButton->Enabled = false;
  fontButton->Enabled = false;
  enabled->Enabled = false;
  visible->Enabled = false;
  justification->Enabled = false;
  expand->Enabled = false;
  fill->Enabled = false;
  padding->Enabled = false;
  tipButton->Enabled = false;
  tagButton->Enabled = false;
  repackButton->Enabled = false;
  side->Enabled = false;
  anchor->Enabled = false;
  p_expand->Enabled = false;
  fillx->Enabled = false;
  filly->Enabled = false;
  reconfigure->Enabled = false;

  // set title
  // FIX ME: lang support
  sprintf(buff,"Inspector: disabled");
  Title = buff;
  return;
}
/*
 */
void
VDKBObjectInspector::RemoveExtraWidget()
{
  if (mainbox && extrawidget)
    {
      extrawidget->RemoveObjects();
      mainbox->RemoveObject(extrawidget);
      extrawidget= NULL;
    }
}
/*
normally called by a gui object to
add his own properties widget to inspector.
 */
void
VDKBObjectInspector::AddExtraWidget(VDKObjectContainer* wid)
{
if(mainbox && wid)
  {
    mainbox->Add(wid);
    extrawidget = wid;
  }
}

/*
activate inspector
with a gui object selected by user
 */
void
VDKBObjectInspector::SetActive(VDKBObject* act, bool loadWidgetsTree)
{
  //  int t;
  if(act == NULL)
    {
      DisableInspector();
      // clear widgets tree
      WidgetsTree->Clear();
      // disable toolbar
      GtkWidgetList* widlist = treeToolbar->ButtonList;
      for(int t = 0; t < widlist->size(); t++)
	(*treeToolbar)[t]->Enabled = false;
      return;
    }
  // avoid unuseful wi reloads
  else if(active == act)
    return;
  else
      active = act;
  if(active)
    RemoveExtraWidget();
  // some useful flag (thanks c++ for dyna casting)
  bool isForm = dynamic_cast<VDKBGuiForm*>(act) != NULL;
  bool isContainer = dynamic_cast<VDKBEventContainer*>(active) != NULL;
  bool isNotebook = dynamic_cast<VDKBGuiNotebook*>(active)!= NULL;
  bool isToolbar = dynamic_cast<VDKBToolbar*>(active)!= NULL;
  bool isLabel = dynamic_cast<VDKBTextLabel*>(active)!= NULL;
  bool isHandle = dynamic_cast<VDKBHandleBox*>(active)!= NULL;
  bool isRadioButtonGroup = dynamic_cast<VDKBRadioButtonGroup*>(active)!= NULL;
  VDKBEventBox* isBox = dynamic_cast<VDKBEventBox*>(active);
  bool cantJustify =
    dynamic_cast<VDKBPaned*>(active->ObjectFromVDK()->Parent())!= NULL;
  bool parentIsPacker =
    dynamic_cast<VDKBPacker*>(active->ObjectFromVDK()->Parent())!= NULL;
  bool parentIsFixed =
    dynamic_cast<VDKBFixed*>(active->ObjectFromVDK()->Parent())!= NULL;
  // const true and nihil
  VDKString True = CHECK_TRUE;
  VDKString Nihil = NIHIL_PROP;
  // set widget and widget old name
  name->Text = active->Name();
  oldWidgetName = active->Name();
  VDKString _font = active->GetProp( FONT);
  font->Text =  strcmp(_font,NIHIL_PROP) ? (char*) _font : (char*) "";
  // set font also as entry tips
  font->SetTip(_font);
  // set prop values
  if(active->GetProp(ENABLED) != Nihil)
    enabled->Checked = active->GetProp(ENABLED) == True;
  if(active->GetProp(VISIBLE) != Nihil)
    visible->Checked = active->GetProp(VISIBLE) == True;
  if(isBox)
    {
      preview->Enabled = true;
      preview->Checked = isBox->PreviewFlag;
    }
  else
      preview->Enabled = false;
  // packing args
  int justarg = atoi(active->GetProp(JUSTIFY_INTERNAL));
  int exparg = atoi(active->GetProp( EXPAND_INTERNAL));
  int fillarg = atoi(active->GetProp(FILL_INTERNAL));
  int paddarg = atoi(active->GetProp(PADDING_INTERNAL));
  justification->SelectItem(justarg);
  side->SelectItem(justarg);
  expand->Checked = exparg != 0;
  anchor->SelectItem(exparg);
  padding->ValueAsFloat = float(paddarg);
  fill->Checked = fillarg != 0;
  GtkPackerOptions opts = (GtkPackerOptions) fillarg;
  fillx->Checked = opts & GTK_FILL_X;
  filly->Checked = opts & GTK_FILL_Y;
  p_expand->Checked = opts & GTK_PACK_EXPAND;

  if(!isContainer && !isLabel)
    {
      if(active->GetProp(TIP) != Nihil)
	tip->Text = (char*) active->GetProp(TIP);
      else
	tip->Text = "";
    }
  else
    tip->Text = "";

  if(!isForm)
    {
      if(active->GetProp(TAG) != Nihil)
	tag->Text = (char*) active->GetProp(TAG);
      else
	tag->Text = "";
    }
  else
    tag->Text = "";

  // remove notebook page widgets && disconnect signals
  int ndx = nbook->ActivePage;
  if(sigpageBox)
    {
      int t;
      // disconnects signals
      for(t=0; t < slots.size();t++)
	if (slots[t] > 0)
	  SignalDisconnect(slots[t]);
      //
      connectTable->RemoveObjects();
      sigpageBox->RemoveObjects();
      sigpageBox = NULL;
    }
  // remove notebook event page
  if(evpageBox)
    {
      evpageBox->RemoveObjects();
      evpageBox = NULL;
    }
  // remove notebook page (sigpageBox included) and reload
  // a new one
  if(nbook->Pages.size() > 1)
    nbook->RemovePage(1);

  // make signals page for all widgets except:
  // forms, labels, containers
  // above widgets do not have any signal provided
  // with these exceptions:
  // notebook,toolbar,handle, radiobutton group

  if((!isForm && !isContainer && !isLabel) ||
     isNotebook ||
     isToolbar ||
     isHandle ||
     isRadioButtonGroup)
    {
      nbook->AddPage(sigpageBox = MakeSignalsPage(),"Signals");
      nbook->ActivePage = ndx;
    }
  else
    // no signals at all
    // makes two empty arrays
    {
      sigEntries = VDKArray<VDKEntry*>(0);
      slots = VDKArray<int>(0);
    }
  // makes default events page for forms
  if(isForm)
    {
      nbook->AddPage(evpageBox = MakeFormEventsPage(),"Form events");
      nbook->ActivePage = ndx;
    }

  // enable what can be enabled
  nameButton->Enabled = !isForm;
  fontButton->Enabled = !isContainer;
  enabled->Enabled = !isContainer && !isLabel;
  visible->Enabled = !isContainer;
  repackButton->Enabled =
    (!cantJustify) && (!isForm) && !(parentIsPacker) && !(parentIsFixed);
  justification->Enabled = (!cantJustify) && (!isForm) && !(parentIsPacker);
  expand->Enabled = !isForm && !(parentIsPacker) && !(parentIsFixed) ;
  fill->Enabled = !isForm && !(parentIsPacker) && !(parentIsFixed);
  padding->Enabled = !isForm && !(parentIsPacker) && !(parentIsFixed);
  tipButton->Enabled =  !isContainer && !isLabel && !isForm;
  tagButton->Enabled = !isForm;
  side->Enabled = parentIsPacker;
  anchor->Enabled = parentIsPacker;
  p_expand->Enabled = parentIsPacker;
  fillx->Enabled = parentIsPacker;
  filly->Enabled = parentIsPacker;
  reconfigure->Enabled = parentIsPacker;
  colorButton->Enabled = !isContainer;
  /*
    call selected object to let it
    add his own widget here.
    All gui widgets should implement ExtraWidget(),
    otherwise an unuseful root class call will be made.
    (ExtraWidget is virtual on VDKBObject)
   */
  AddExtraWidget(active->ExtraWidget(this));
  // set title
  VDKObject* vdkobj = dynamic_cast<VDKObject*>(active);
  if(vdkobj)
    {
      VDKBGuiForm* ownerform = NULL;
      if(!isForm)
	ownerform = dynamic_cast<VDKBGuiForm*>(vdkobj->Owner());
      else
	ownerform = dynamic_cast<VDKBGuiForm*>(active);
      if(ownerform)
	{
	  char name[128];
	  strcpy(name,(char*) ownerform->Name());
	  name[0] = toupper(name[0]);
	  sprintf(buff,"%sForm->%s::%s",
		  name,
		  active->VDKName(),
		  (char*) active->Name()
		  );
	  Title = buff;
	  if(loadWidgetsTree)
	    LoadTree(ownerform);
	}
    }
}

static char *colTitle = "Write or jump to response method";
static char *evcolTitle[] =
{
"Jump to event handler",
"Connected"
};
/*
 */
VDKBox*
VDKBObjectInspector::MakeFormEventsPage()
{
  int t = 0;
  VDKString True = CHECK_TRUE;
  VDKBox* vbox = new VDKBox(this);
  evtable = new VDKCustomList(this,2,evcolTitle);
  evtable->AutoResize = true;
  evtable->ActiveTitle(1,false);
  evtable->Titles[0]->Enabled = false;
  VDKBGuiForm* owner_form =
	dynamic_cast<VDKBGuiForm*>(active);
  if(owner_form)
    {
      for(t=0;evTableItems[t].items[0];t++)
	{
	  VDKString prop = owner_form->GetProp(evTableItems[t].items[0]);
	  if(prop == True)
	    evTableItems[t].items[1] = CHECK_YES;
	  else
	    evTableItems[t].items[1] = CHECK_NO;
	}
    }	
  for(t=0;evTableItems[t].items[0];t++)
    evtable->AddRow(evTableItems[t].items);
  vbox->Add(evtable);
  add_remove_event = new VDKLabelButton(this,
					 "Connect form to selected event");
  vbox->Add(add_remove_event,l_justify,false,false,false);
  return vbox;
}
/*
 */
VDKBox*
VDKBObjectInspector::MakeSignalsPage()
{
  VDKBox* vbox = new VDKBox(this);
  const int rows = active->SignalList().size();
  const int cols = 2;
  int t,z = 0;
  // FIX ME with lang support
  // connecting table

  connectTable = new VDKTable(this,rows+2,cols);
  connectTable->ColSpacing = 1;
  connectTable->RowSpacing = 1;
  sigEntries = VDKArray<VDKEntry*>(rows);
  connectButtons = VDKArray<VDKLabelButton*>(rows);
  slots = VDKArray<int>(rows*2);
  VDKBSListIterator li(active->SignalList());
  // FIX ME: lang support
  connectTable->AddToCell(new VDKLabel(this,"Signals"),0,0);
  connectTable->AddToCell(new VDKLabel(this,"Class response method"),0,1);
  connectTable->AddToCell(new VDKSeparator(this),1,0);
  connectTable->AddToCell(new VDKSeparator(this),1,1);
  for(t=0;li;li++,t++)
    {
      bool isContainer = dynamic_cast<VDKBEventContainer*>(active) != NULL;
      connectButtons[t] = new VDKLabelButton(this,li.current().Signal());
      sigEntries[t] = new VDKEntry(this,0,li.current().Slot());
      sigEntries[t]->SetSize(130,-1);
      slots[z++] = SignalConnect(sigEntries[t],"activate",
		    &VDKBObjectInspector::OnActivateSlotName);
      slots[z++] = SignalConnect(connectButtons[t],"clicked",
		    &VDKBObjectInspector::OnConnectSignal);
      connectTable->AddToCell(connectButtons[t],t+2,0);
      connectTable->AddToCell(sigEntries[t],t+2,1);
      if(t==0 && isContainer)
	{
	  connectButtons[t]->Enabled = false;
	  sigEntries[t]->Enabled = false;
	}
    }
  vbox->Add(connectTable,l_justify,false,false,false);
  // make and load static signal table (a list)
  sigtable = new VDKCustomList(this,1,&colTitle,GTK_SELECTION_EXTENDED);
  sigtable->ActiveTitles(true);
  EventConnect(sigtable,"button_press_event",
	       &VDKBObjectInspector:: OnSignalListButtonPress);
  vbox->Add(sigtable);
  // make and load combo signal list
  VDKBox* hbox = new VDKBox(this,h_box);
  mul_connect = new VDKLabelButton(this,"Reuse this");
  hbox->Add(mul_connect,l_justify,false,false,false);
  hbox->Add(sigcombo = new VDKCombo(this),l_justify,false,false,false);
  sigcombo->SetSize(150,-1);
  vbox->Add(hbox,l_justify,false,false,false);
    // FIX ME: lang support
  LoadStaticTable();
  return vbox;
}

///////////////////////////////////////////////
// WIDGET TREE
//////////////////////////////////////////////
extern char *newform_xpm[];
static char *container_xpm[];
static char *widget_xpm[];
static char *copy_xpm[];
static char *cut_xpm[];
static char *paste_xpm[];
static char*paste_others_xpm[];
static char *trash_xpm[];
extern VDKBWidgetClipboard* WidgetClipboard;

bool
VDKBObjectInspector::OnToolbarClicked(VDKObject* sender)
{
  gpointer gp = NULL;
  VDKBObject* selected_object = NULL;
  int button = treeToolbar->ButtonPressed;
  VDKTreeNode node = WidgetsTree->SelectedNode;
  if(! node)
    return true;
  else
    {
      // retrieve widget address stored by LoadTree()
      gp =
	gtk_ctree_node_get_row_data(GTK_CTREE(WidgetsTree->CustomWidget()),
				    node);
      // cast it to a VDKBObject
      selected_object = reinterpret_cast<VDKBObject*> (gp);
    }
  if(!selected_object)
    return true;

  switch(button)
    {
    case 0:// cut
      WidgetClipboard->CutWidget(selected_object->ObjectFromVDK());
      break;
    case 1:// copy
      WidgetClipboard->CopyWidget(selected_object->ObjectFromVDK());
      break;
    case 2:// paste
        WidgetClipboard->PasteWidget(selected_object->ObjectFromVDK(),0);
      break;
    case 3:// paste others
      PasteOthers(selected_object);
      break;
    }
  return true;
}
/*
paste others widgets on stack.
An empty array is passed to dialog,
it returns the array filled with widget
to be pasted, or an empty array id user
press cancel button.
 */
void
VDKBObjectInspector::PasteOthers(VDKBObject* selected_object)
{
  VDKBWidgetClipboardArray cliparray;
  VDKBWidgetClipboardDialog* child =
    new VDKBWidgetClipboardDialog(this,&cliparray, NULL);
  child->Setup();
  child->ShowModal(GTK_WIN_POS_MOUSE);
  if(cliparray.size() > 0)
    {
      if(cliparray.size() == 1)
	{
	  VDKBWidgetClipboardItem item = cliparray[0];
	  // finds widget ordinal position
	  // into clipboard
	  int ndx = WidgetClipboard->at(item);
	  if(ndx >= 0)
	    // paste widget resetting WI
	    WidgetClipboard->PasteWidget(selected_object->ObjectFromVDK(),ndx, true);
	}
      else
	{
	  int z = 0;
	  for(; z < cliparray.size(); z++)
	    {
	      VDKBWidgetClipboardItem item = cliparray[z];
	      int ndx = WidgetClipboard->at(item);
	      // finds widget ordinal position
	      // into clipboard
	      if(ndx >= 0)
		// reset WI only on last item
		WidgetClipboard->PasteWidget(selected_object->ObjectFromVDK(),
					     ndx,
					     z < (cliparray.size()-1) ?
					     false: true);
	    }
	}
    }
}

/*
 */
void
VDKBObjectInspector::OnTreeMove (GtkCTree *wid,
		 GtkCTreeNode *child,
		 GtkCTreeNode *parent,
		 GtkCTreeNode *sibling,
		 gpointer data)
{
  gpointer gp;
  VDKBObject* source,*target,*sibling_target;
  g_return_if_fail(wid != NULL);
  g_return_if_fail(data != NULL);
  VDKCustomTree* tree = reinterpret_cast<VDKCustomTree*>(data);
  gp =  gtk_ctree_node_get_row_data(GTK_CTREE(tree->CustomWidget()),
				    child);
  source = reinterpret_cast<VDKBObject*> (gp);
  gp = gtk_ctree_node_get_row_data(GTK_CTREE(tree->CustomWidget()),
				    parent);
  target = reinterpret_cast<VDKBObject*> (gp);
  if(sibling)
    {
      gp = gtk_ctree_node_get_row_data(GTK_CTREE(tree->CustomWidget()),
				       sibling);
      sibling_target = reinterpret_cast<VDKBObject*> (gp);
    }
  else
    sibling_target = NULL;
  gtk_signal_emit_stop_by_name(GTK_OBJECT(wid),"tree_move");
  if(!source || !target)
      return;
#if 0
  printf("\nsource:%s - target:%s - sibling:%s",
	 (char*) source->Name(),
	 (char*) target->Name(),
	 sibling_target ? (char*) sibling_target->Name() : "nihil");
  fflush(stdout);
#endif
  if(activeOwner)
    {
      // cut source and paste it to target
      WidgetClipboard->CutWidget(source->ObjectFromVDK());
      // set target or sibling as active
      if(sibling_target && dynamic_cast<VDKBEventContainer*>(sibling_target))
	activeOwner->Active = sibling_target;
      else
	activeOwner->Active = target;
      WidgetClipboard->PasteWidget(target->ObjectFromVDK(),0);
      // reload tree
      tree->SignalEmit(click_column_signal);
    }

}

/*
 */
VDKBox*
VDKBObjectInspector::MakeWidgetsTreePage()
{
  char * title = "Refresh widgets tree";
  VDKBox* box = new VDKBox(this);
  treeToolbar = new VDKToolbar(this);
  treeToolbar->AddButton(cut_xpm,"Cut");
  treeToolbar->AddButton(copy_xpm,"Copy");
  treeToolbar->AddButton(paste_xpm,"Paste");
  treeToolbar->AddButton(paste_others_xpm,"Paste others");
  treeToolbar->Style = GTK_TOOLBAR_ICONS;
  box->Add(treeToolbar,l_justify,false,false,2);
  GtkWidgetList* widlist = treeToolbar->ButtonList;
  for(int t = 0; t < widlist->size(); t++)
    (*treeToolbar)[t]->Enabled = false;
  box->Add(new VDKSeparator(this),l_justify,false,false,2);
  WidgetsTree  = new VDKCustomTree(this,1,&title);
  WidgetsTree->SetSize(200,-1);
  WidgetsTree->AutoResize = true;
  gtk_clist_set_reorderable (GTK_CLIST(WidgetsTree->CustomWidget()),
			     true);
  box->Add(WidgetsTree);
  gtk_signal_connect (GTK_OBJECT (WidgetsTree->CustomWidget()),
		      "tree_move",
		      GTK_SIGNAL_FUNC(VDKBObjectInspector::OnTreeMove),
		      (gpointer) WidgetsTree);
  EventConnect(WidgetsTree,"button_press_event",
	       &VDKBObjectInspector::OnWidgetsTreeButtonPress);
  treepopmenu = new VDKMenu(this);
  // FIX ME: lang support
  VDKMenuItem *nop = new VDKMenuItem(treepopmenu,"Nop");
  nop->Enabled = false;
  dropwidget = new VDKMenuItem(treepopmenu,"Drop widget");
  SignalConnect(dropwidget,"activate",
		&VDKBObjectInspector::DropWidget);
  /*
    better explicitely add it to owner, so will be surely
    destroyed even if never popped
  */
  AddItem(treepopmenu);
  return box;
}

/*
 */
void
RecursiveLoadTree( EventBoxList& list,
		   VDKCustomTree* tree,
		   VDKTreeNode root)
{
  char *objname;
  if(list.size() == 0)
    return;
  // iterates on boxes
  EventBoxListIterator li(list);
  for(;li;li++)
    {
      bool hasChilds = false;
      VDKTreeNode child = NULL;
      VDKBEventContainer* box = NULL;
      VDKBMenuItem* mi = NULL;
      VDKObject* object = li.current();
      VDKBObject* vdkobj = dynamic_cast<VDKBObject*>(object);
      if(vdkobj)
	{
	  box = dynamic_cast<VDKBEventContainer*>(vdkobj);
	  if(!box)
	    mi = dynamic_cast<VDKBMenuItem*>(vdkobj);
	  if(box)
	    hasChilds = box->boxlist.size() > 0;
	  else if(mi)
	    hasChilds = mi->boxlist.size() > 0;
	}
      // gui widgets inner canvases must be neglected
       if(vdkobj && vdkobj->isA() != vdkbcanvas_class)
	 {
	   objname = (char*) vdkobj->Name();
	   child = tree->AddNode(&objname,
				       root,
				       hasChilds ? true : false,
				       hasChilds ? false : true,
				       box ? container_xpm : widget_xpm,
				       box ? container_xpm : widget_xpm);
	   if(child)
	     gtk_ctree_node_set_row_data(GTK_CTREE(tree->CustomWidget()),
					 child,
					 (gpointer) vdkobj);
	 }
       // recurs on inner boxes or menu items (if any)
       if(vdkobj && box && hasChilds)
	 {
	   VDKBEventContainer* box = (VDKBEventContainer*) vdkobj;
	   RecursiveLoadTree(box->boxlist,tree,child);
	 }
       else if(vdkobj && mi && hasChilds)
	 RecursiveLoadTree(mi->boxlist,tree,child);
       else  if(vdkobj && dynamic_cast<VDKBMenuItem*>(vdkobj))
	 {
	   VDKBMenuItem* item = (VDKBMenuItem*) vdkobj;
	   if(item)
	     RecursiveLoadTree(item->boxlist,tree,child);
	 }
    }
}
/*
 */
void
VDKBObjectInspector::LoadTree(VDKBGuiForm* owner)
{
  char *objname, *formname;
  char  name[128];
  strcpy(name,(char*) owner->Name());
  name[0] = toupper(name[0]);
  formname = name;
  // set static activeOwner
  activeOwner = owner;
  WidgetsTree->Clear();
  WidgetsTree->Freeze();
  VDKTreeNode root = WidgetsTree->AddNode(&formname,
	NULL,
	owner->InnerBox()->boxlist.size() > 0 ? true : false,
	owner->InnerBox()->boxlist.size() > 0 ? false : true,
	newform_xpm,
	newform_xpm);
  if(root)
    gtk_ctree_node_set_row_data(GTK_CTREE(WidgetsTree->CustomWidget()),
				root,
				(gpointer) NULL);
  EventBoxListIterator li(owner->InnerBox()->boxlist);
  for(;li;li++)
    {
      bool hasChilds = false;
      VDKTreeNode child = NULL;
      VDKBEventContainer* box = NULL;
      VDKBMenuItem* mi = NULL;
      VDKObject* object = li.current();
      VDKBObject* vdkobj = dynamic_cast<VDKBObject*>(object);
      if(vdkobj)
	{
	  box = dynamic_cast<VDKBEventContainer*>(vdkobj);
	  if(!box)
	    mi = dynamic_cast<VDKBMenuItem*>(vdkobj);
	  if(box)
	    hasChilds = box->boxlist.size() > 0;
	  else if(mi)
	    hasChilds = mi->boxlist.size() > 0;
	}
      if(vdkobj && vdkobj->isA() != vdkbcanvas_class)
	{
	  objname = (char*) vdkobj->Name();
	  child = WidgetsTree->AddNode(&objname,
				       root,
				       hasChilds ? true : false,
				       hasChilds ? false : true,
				       box ? container_xpm : widget_xpm,
				       box ? container_xpm : widget_xpm);
	  if(child)
	    gtk_ctree_node_set_row_data(GTK_CTREE(WidgetsTree->CustomWidget()),
				      child,
				      (gpointer) vdkobj);
	}
      if(box && hasChilds)
	RecursiveLoadTree(box->boxlist,WidgetsTree,child);
      else if(mi && hasChilds)
	RecursiveLoadTree(mi->boxlist,WidgetsTree,child);
    }
  WidgetsTree->Thaw();
}

////////////////////////////////////////////////////////////////////////
/*
 * GtkFontSelection
 */

void
font_selection_ok (GtkWidget *w,
		   GtkFontSelectionDialog *fs)
{
  selected_font = gtk_font_selection_dialog_get_font_name (fs);
  gtk_widget_destroy (GTK_WIDGET (fs));
  /* This is needed to get out of gtk_main */
  gtk_main_quit ();

}
/*
 */
void
font_selection_cancel (GtkWidget *w,
		   GtkFontSelectionDialog *fs)
{
  selected_font = NULL;
  gtk_widget_destroy (GTK_WIDGET (fs));
  gtk_main_quit ();
}
void
create_font_selection (void)
{
  GtkWidget *window = NULL;
  window = gtk_font_selection_dialog_new ("Font Selection Dialog");
  //  gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC(gtk_widget_destroyed),
		      &window);
  gtk_signal_connect (
		      GTK_OBJECT (GTK_FONT_SELECTION_DIALOG
				  (window)->ok_button),"clicked",
		      GTK_SIGNAL_FUNC(font_selection_ok),
		      GTK_FONT_SELECTION_DIALOG (window)
		      );
  gtk_signal_connect (
		      GTK_OBJECT (GTK_FONT_SELECTION_DIALOG
				  (window)->cancel_button),"clicked",
		      GTK_SIGNAL_FUNC(font_selection_cancel),
		      GTK_FONT_SELECTION_DIALOG (window)
		      );
  /* Set window as modal */
  gtk_window_set_modal (GTK_WINDOW(window),TRUE);
  if(window)
    gtk_widget_show (window);
    /* wait until dialog get destroyed */
  gtk_main();
}

/// some pixmaps
/* XPM */
char *container_xpm[] = {
"16 16 5 1",
". c #000000",
"# c #808000",
"a c #c0c000",
"b c #ffffc0",
"c c None",
/* pixels */
"ccccc..ccc.ccccc",
"ccc..bb...b..ccc",
"c..bb..#a..bb..c",
".bb..###aaa..bb.",
"...#####aaaaa...",
"c.b..###aaa...cc",
"c.bbb..#a..aa.cc",
"c.bbbbb..aaaa.cc",
"c.bbbbbbaaaaa.cc",
"c.bbbbbbaaaaa.cc",
"c.bbbbbbaaaaa.cc",
"c.bbbbbbaaaaa.cc",
"c.abbbbbaaaa..cc",
"cc..abbbaa..cccc",
"cccc..ab..cccccc",
"cccccc..cccccccc"
};
/* XPM */
char *widget_xpm[]={
"16 16 14 1",
"# c #000000",
"c c #008000",
"d c #00c000",
"g c #008080",
"h c #00c0c0",
"f c #00ffff",
"k c #808000",
"l c #c0c000",
"j c #ffff00",
"a c #c0ffc0",
"e c #c0ffff",
"i c #ffffc0",
"b c #00ff00",
". c None",
".....##.........",
"....#aa##.......",
"...#aaabb#......",
"..#bbbbbc###....",
"..#ddbbcc#ee##..",
"..#dddcc#eeeff#.",
"..#dddc#fffffg#.",
"...###c#hhffgg#.",
"...#ii##hhhggg#.",
"..#iiijj#hhgg#..",
".#jjjjjk##hg#...",
".#lljjkk#.##....",
".#lllkkk#.......",
".#lllkk#........",
"..##lk#.........",
"....##.........."};
/* XPM */
char *copy_xpm[] = {
/* width height num_colors chars_per_pixel */
"20 22 4 1",
/* colors */
". c #000000",
"# c #000040",
"a c none",
"b c #ffffff",
/* pixels */
"aaaaaaaaaaaaaaaaaaaa",
"aaaaaaaaaaaaaaaaaaaa",
"aaaaaaaaaaaaaaaaaaaa",
"aaaaaaaaaaaaaaaaaaaa",
"aaaaaaaaaaaaaaaaaaaa",
"aaa......aaaaaaaaaaa",
"aaa.bbbb..aaaaaaaaaa",
"aaa.bbbb.b.aaaaaaaaa",
"aaa.b..b.######aaaaa",
"aaa.bbbbb#bbbb##aaaa",
"aaa.b....#bbbb#b#aaa",
"aaa.bbbbb#b..b####aa",
"aaa.b....#bbbbbbb#aa",
"aaa.bbbbb#b.....b#aa",
"aaa......#bbbbbbb#aa",
"aaaaaaaaa#b.....b#aa",
"aaaaaaaaa#bbbbbbb#aa",
"aaaaaaaaa#########aa",
"aaaaaaaaaaaaaaaaaaaa",
"aaaaaaaaaaaaaaaaaaaa",
"aaaaaaaaaaaaaaaaaaaa",
"aaaaaaaaaaaaaaaaaaaa"
};
/* XPM */
char *cut_xpm[] = {
/* width height num_colors chars_per_pixel */
" 21 23 3 1",
/* colors */
". c #000000",
"# c #000040",
"a c none",
/* pixels */
"aaaaaaaaaaaaaaaaaaaaa",
"aaaaaaaaaaaaaaaaaaaaa",
"aaaaaaaaaaaaaaaaaaaaa",
"aaaaaaaaaaaaaaaaaaaaa",
"aaaaaaaaaaaaaaaaaaaaa",
"aaaaaaa.aaa.aaaaaaaaa",
"aaaaaaa.aaa.aaaaaaaaa",
"aaaaaaa.aaa.aaaaaaaaa",
"aaaaaaa..a..aaaaaaaaa",
"aaaaaaaa.a.aaaaaaaaaa",
"aaaaaaaa...aaaaaaaaaa",
"aaaaaaaaa.aaaaaaaaaaa",
"aaaaaaaa#.#aaaaaaaaaa",
"aaaaaaaa#a###aaaaaaaa",
"aaaaaa###a#aa#aaaaaaa",
"aaaaa#aa#a#aa#aaaaaaa",
"aaaaa#aa#a#aa#aaaaaaa",
"aaaaa#aa#aa##aaaaaaaa",
"aaaaaa##aaaaaaaaaaaaa",
"aaaaaaaaaaaaaaaaaaaaa",
"aaaaaaaaaaaaaaaaaaaaa",
"aaaaaaaaaaaaaaaaaaaaa",
"aaaaaaaaaaaaaaaaaaaaa"
};
/* XPM */
char *paste_xpm[] = {
/* width height num_colors chars_per_pixel */
"20 21 8 1",
/* colors */
". c #000000",
"# c #000040",
"a c #606000",
"b c #606040",
"c c #a0a080",
"d c None",
"e c #ffff00",
"f c #ffffff",
/* pixels */
"dddddddddddddddddddd",
"dddddddddddddddddddd",
"dddddddddddddddddddd",
"dddddddddddddddddddd",
"ddddddd....ddddddddd",
"ddd.....ee.....ddddd",
"dd.aba.e..e.bab.dddd",
"dd.bb.cccccc.ba.dddd",
"dd.ab........bb.dddd",
"dd.babababababa.dddd",
"dd.ababa#######.dddd",
"dd.babab#fffff##dddd",
"dd.ababa#fffff#f#ddd",
"dd.babab#f###f####dd",
"dd.ababa#ffffffff#dd",
"dd.babab#f######f#dd",
"ddd.....#ffffffff#dd",
"dddddddd##########dd",
"dddddddddddddddddddd",
"dddddddddddddddddddd",
"dddddddddddddddddddd"
};
/* XPM */
char*paste_others_xpm[]={
"20 21 8 1",
"c c #606040",
"d c #a0a080",
"# c #000000",
"a c #ffff00",
". c None",
"e c #000040",
"b c #606000",
"f c #ffffff",
"....................",
"....................",
"....................",
"....................",
".......####.........",
"...#####aa#####.....",
"..#bcb#a##a#cbc#....",
"..#cc#dddddd#cb#....",
"..#bc########cc#....",
"..#cbcbcbcbcbcb#....",
"..#baacbeeeeeee#....",
"..#caabcefffffee....",
"..#baacbefffffefe...",
"..#caabcefeeefeeee..",
"..#bcbcbeffffffffe..",
"..#caabcefeeeeeefe..",
"...#####effffffffe..",
"........eeeeeeeeee..",
"....##..............",
"....##.#f#f#f#f#f#..",
"...................."};
