/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include <config.h>
#include <vdkb/vdkb_locale.h>
#include <vdkb/vdkb_utils.h>
#include "pixmaps/newprj.xpm"
#include "pixmaps/newunit.xpm"
#include "pixmaps/newform.xpm"
#include "pixmaps/loadprj.xpm"
#include "pixmaps/loadfile.xpm"
#include "pixmaps/savefile.xpm"
#include "pixmaps/saveprj.xpm"
#include "pixmaps/viewunits.xpm"
#include "pixmaps/viewforms.xpm"
#include "pixmaps/addtoprj.xpm"
#include "pixmaps/remfromprj.xpm"
#include "pixmaps/toggleformunits.xpm"
#include "pixmaps/run.xpm"
#include "pixmaps/selector.xpm"
#include "pixmaps/search.xpm"
#include "pixmaps/acsupport.xpm"
// container widgets pixmaps
#include "pixmaps/vbox.xpm"
#include "pixmaps/hbox.xpm"
#include "pixmaps/frame.xpm"
#include "pixmaps/table.xpm"
#include "pixmaps/vpaned.xpm"
#include "pixmaps/hpaned.xpm"
#include "pixmaps/notebook.xpm"
#include "pixmaps/handlebox.xpm"
#include "pixmaps/coolbar.xpm"
#include "pixmaps/scrolledwindow.xpm"
#include "pixmaps/menubar.xpm"
#include "pixmaps/rbgroup.xpm"
#include "pixmaps/packer.xpm"
#include "pixmaps/fixed.xpm"
// button widgets pixmaps
#include "pixmaps/button.xpm"
#include "pixmaps/pixbutton.xpm"
#include "pixmaps/spinbutton.xpm"
#include "pixmaps/checkbutton.xpm"
#include "pixmaps/radiobutton.xpm"
// text widget pixmaps
#include "pixmaps/label.xpm"
#include "pixmaps/entry.xpm"
#include "pixmaps/text.xpm"
// misc widgets pixmaps
#include "pixmaps/canvas.xpm"
#include "pixmaps/pixmap.xpm"
#include "pixmaps/progressbar.xpm"
#include "pixmaps/scale.xpm"
#include "pixmaps/statusbar.xpm"
#include "pixmaps/timer.xpm"
#include "pixmaps/list.xpm"
#include "pixmaps/combo.xpm"
#include "pixmaps/hseparator.xpm"
#include "pixmaps/vseparator.xpm"
#include "pixmaps/tree.xpm"
#include "pixmaps/grid.xpm"
#include "pixmaps/ghost.xpm"
// gnome widgets pixmaps
#include "pixmaps/gnomededit.xpm"
#include "pixmaps/gnomeentry.xpm"
// dialogs widgets pixmaps
#include "pixmaps/openfiledlg.xpm"
#include "pixmaps/savefiledlg.xpm"
#include "pixmaps/colorseldialog.xpm"
#include "pixmaps/fontseldialog.xpm"
// prj man pixmaps
#include "pixmaps/new_prj_big.xpm"
#include "pixmaps/remove_big.xpm"
#include "pixmaps/activate_big.xpm"
#include "pixmaps/prj_node.xpm"
#include "pixmaps/unit_node.xpm"
#include "pixmaps/exec.xpm"
#include "pixmaps/formprops.xpm"
// about dialog xpm's
#include "pixmaps/simpson1.xpm"
#include "pixmaps/simpson2.xpm"
// project wizard xpm's
#include "pixmaps/app_wiz.xpm"
#include "pixmaps/compo_wiz.xpm"
#include "pixmaps/wizard_wiz.xpm"
// maker pixmaps
#include "pixmaps/maker.xpm"
#include "pixmaps/makerkill.xpm"

static char buffer[256];
extern void create_nonvdk_modal_window (char* prompt);
//////////// INTERFACE PROMPTS AND PIXMAPS ////////////
// main toolbar pixmaps (upper side)
char ** main_toolbar_pixmaps[] =
{
newprj_xpm,newunit_xpm,newform_xpm,
loadprj_xpm,loadfile_xpm,saveprj_xpm,
savefile_xpm,
0
};
char ** main_toolbar1_pixmaps[] =
{
toggleformunits_xpm,run_xpm,selector_xpm,
0
};

// main toolbar tips (upper side)
char *main_toolbar_tips[MAIN_TOOLBAR_TIPS+1];
char *main_toolbar1_tips[MAIN_TOOLBAR1_TIPS+1];
// main menu pixmaps
char **main_menu_pixmaps[] =
{
  newprj_xpm,newunit_xpm,newform_xpm, //0 1 2
  loadprj_xpm,loadfile_xpm, // 3 4
  savefile_xpm,saveprj_xpm, // 5 6
  viewunits_xpm,viewforms_xpm, // 7 8
  addtoprj_xpm,remfromprj_xpm, // 9 10
  search_xpm,acsupport_xpm, //11 12
0
};
// main toolbar tips
char *main_menu_prompts[MAIN_MENU_PROMPTS+1];
// widget folder titles
char *folder_widget_titles[FOLDER_WIDGET_TITLES+1];
// container widgets pixmaps
char **container_widgets_pixmaps[] =
{
  vbox_xpm,hbox_xpm,frame_xpm, // 0 1 2
  table_xpm,vpaned_xpm,hpaned_xpm, // 3 4 5
  notebook_xpm,handlebox_xpm,coolbar_xpm,  // 6 7 8
  scrolledwindow_xpm, menubar_xpm, rbgroup_xpm, // 9 10 11
  packer_xpm, fixed_xpm //12 13
};
// container widgets tips
char *container_widgets_tips[CONTAINER_WIDGETS_TIPS+1];
// button widgets pixmaps
char **button_widgets_pixmaps[] =
{
  button_xpm,pixbutton_xpm,spinbutton_xpm, // 0 1 2
  checkbutton_xpm,radiobutton_xpm,pixbutton_xpm // 3 4 5
};
// button widgets tips
char *button_widgets_tips[BUTTON_WIDGETS_TIPS+1];
// text widgets pixmaps
char **text_widgets_pixmaps[] =
{
  label_xpm,entry_xpm,text_xpm // 0 1 2
};
// text widgets tips
char *text_widgets_tips[TEXT_WIDGETS_TIPS+1];
// misc widgtes pixmpas
// used by VDKBPixmap gui object in vdkb_pixmap.cc
char** default_pixmap = pixmap_xpm;
char **misc_widgets_pixmaps[] =
{
  canvas_xpm,pixmap_xpm,progressbar_xpm, // 0 1 2
  scale_xpm,statusbar_xpm,timer_xpm, // 3 4 5
  list_xpm,combo_xpm,tree_xpm, // 6 7 8
  hseparator_xpm, vseparator_xpm, // 9 10
  grid_xpm, ghost_xpm // 11 12
};
// misc widgets tips
char *misc_widgets_tips[MISC_WIDGETS_TIPS+1];

// gnome widgets tips
char *gnome_widgets_tips[GNOME_WIDGETS_TIPS+1];
char **gnome_widgets_pixmaps[] =
{
  statusbar_xpm,gnomededit_xpm,gnomeentry_xpm  // 0 1 2
};
// dlg widgets pixmaps
char **dlg_widgets_pixmaps[] =
{
  openfiledlg_xpm,openfiledlg_xpm,savefiledlg_xpm, // 0 1 2
  colorseldialog_xpm,fontseldialog_xpm // 3 4
};
// dlg widgets tips
char *dlg_widgets_tips[DLG_WIDGETS_TIPS+1];
// VDKB status
char *vdkb_status[VDKB_STATUS+1];
// about dialog texts
char *about_dlg_text[ABOUT_DLG_TEXT+1];
////////////////// USER MESSAGES ///////////////
char* user_messages[USER_MESSAGES+1];
////////////////// EDITOR PROMPTS
char *editor_prompts[EDITOR_PROMPTS+1];
//////////////////// PRJMAN /////////////////
char **prjman_pixmaps[] =
{
NULL,new_prj_big_xpm,addtoprj_xpm,
remfromprj_xpm,activate_big_xpm,
form_props_xpm
};
char *prjman_prompts[PRJMAN_PROMPTS+1];
char *prj_status[PRJ_STATUS+1];
char *file_dialog_prompts[FILE_DIALOG_PROMPTS+1];
char *prjwiz_prompts[PRJWIZ_PROMPTS+1];
char *vdkbmaker_prompts[VDKBMAKER_PROMPTS+1];
char *prjoptions_prompts[PRJOPTIONS_PROMPTS+1];
char *search_dialog_prompts[SEARCH_DIALOG_PROMPTS+1];
char *replace_dialog_prompts[REPLACE_DIALOG_PROMPTS+1];
///////////////////////////////////
// locale parser routines
///////////////////////////////////
static char *languages[] =
{ "lang/it.lan",
  "lang/en.lan",
  "lang/fr.lan",
  "lang/sp.lan",
  "lang/de.lan",
  0
};

static char *avoid = "\"\r\n\t";
/*
 */
void
LoadInternational(int language, char* home)
{

char* file;
char* buff,*p,*lines;
struct stat info;
sprintf(buffer,"%s/.vdkb/%s",home,languages[language]);
if (stat(buffer,&info) == -1)
  sprintf(buffer,"%s/%s",VDKB_DATADIR,languages[language]);
file = buffer;
if(stat(file,&info) == -1)
{
  sprintf(buffer,
	  "locale language file:%s/%s missed\nprogram will be aborted",
	  VDKB_DATADIR,
	  languages[language]);
  create_nonvdk_modal_window (buffer);
  exit(1);
}
FILE* fp = fopen(file,"r");
if(fp)
  {
    int c;
    buff = p = new char[info.st_size+1];
    while( (c = fgetc(fp)) != EOF)
      {
      if (!strchr (avoid, c))
	*p++ = (char) c;
      }
    /*
     */
    *p = '\0';
    fclose(fp);
  }
else
  return;

if((lines =ExtractSection(buff,"DLG_WIDGETS_TIPS_SECTION","END_SECTION")) )
   LoadSection(lines,dlg_widgets_tips,DLG_WIDGETS_TIPS);

if((lines =ExtractSection(buff,"MISC_WIDGETS_TIPS_SECTION","END_SECTION")) )
   LoadSection(lines,misc_widgets_tips,MISC_WIDGETS_TIPS);

if((lines =ExtractSection(buff,"TEXT_WIDGETS_TIPS_SECTION","END_SECTION")) )
   LoadSection(lines,text_widgets_tips,TEXT_WIDGETS_TIPS);

if((lines =ExtractSection(buff,"GNOME_WIDGETS_TIPS_SECTION","END_SECTION")) )
   LoadSection(lines,gnome_widgets_tips,GNOME_WIDGETS_TIPS);

if((lines =ExtractSection(buff,"BUTTON_WIDGETS_TIPS_SECTION","END_SECTION")) )
   LoadSection(lines,button_widgets_tips,BUTTON_WIDGETS_TIPS);

 if((lines =ExtractSection(buff,"CONTAINER_WIDGETS_TIPS_SECTION","END_SECTION")) )
   LoadSection(lines,container_widgets_tips,CONTAINER_WIDGETS_TIPS);

 if((lines =ExtractSection(buff,"FOLDER_WIDGET_TITLES_SECTION","END_SECTION"))  )
   LoadSection(lines,folder_widget_titles,FOLDER_WIDGET_TITLES);

 if((lines =ExtractSection(buff,"MAIN_MENU_PROMPTS_SECTION","END_SECTION"))  )
   LoadSection(lines,main_menu_prompts,MAIN_MENU_PROMPTS);

 if((lines =ExtractSection(buff,"MAIN_TOOLBAR_TIPS_SECTION","END_SECTION"))  )
   LoadSection(lines,main_toolbar_tips,MAIN_TOOLBAR_TIPS);

 if((lines =ExtractSection(buff,"MAIN_TOOLBAR1_TIPS_SECTION","END_SECTION"))  )
   LoadSection(lines,main_toolbar1_tips,MAIN_TOOLBAR1_TIPS);

 if((lines =ExtractSection(buff,"VDKB_STATUS_SECTION","END_SECTION"))  )
   LoadSection(lines,vdkb_status,VDKB_STATUS);

  if((lines =ExtractSection(buff,"ABOUT_DLG_TEXT_SECTION","END_SECTION"))  )
   LoadSection(lines,about_dlg_text,ABOUT_DLG_TEXT);

  if((lines =ExtractSection(buff,"USER_MESSAGE_SECTION","END_SECTION"))  )
   LoadSection(lines,user_messages,USER_MESSAGES);

  if((lines =ExtractSection(buff,"EDITOR_PROMPTS_SECTION","END_SECTION"))  )
   LoadSection(lines,editor_prompts,EDITOR_PROMPTS);

  if((lines =ExtractSection(buff,"PRJMAN_PROMPTS_SECTION","END_SECTION"))  )
   LoadSection(lines,prjman_prompts,PRJMAN_PROMPTS);

  if((lines =ExtractSection(buff,"PRJ_STATUS_SECTION","END_SECTION"))  )
   LoadSection(lines,prj_status,PRJ_STATUS);

  if((lines =ExtractSection(buff,"FILE_DIALOG_SECTION","END_SECTION"))  )
   LoadSection(lines,file_dialog_prompts,FILE_DIALOG_PROMPTS);

  if((lines =ExtractSection(buff,"PRJWIZ_SECTION","END_SECTION"))  )
   LoadSection(lines,prjwiz_prompts,PRJWIZ_PROMPTS);

  if((lines =ExtractSection(buff,"VDKBMAKER_SECTION","END_SECTION"))  )
   LoadSection(lines,vdkbmaker_prompts,VDKBMAKER_PROMPTS);

  if((lines =ExtractSection(buff,"PRJOPTIONS_SECTION","END_SECTION"))  )
   LoadSection(lines,prjoptions_prompts,PRJOPTIONS_PROMPTS);

  if((lines =ExtractSection(buff,"SEARCH_DIALOG_SECTION","END_SECTION"))  )
   LoadSection(lines,search_dialog_prompts,SEARCH_DIALOG_PROMPTS);

  if((lines =ExtractSection(buff,"REPLACE_DIALOG_SECTION","END_SECTION"))  )
   LoadSection(lines,replace_dialog_prompts,REPLACE_DIALOG_PROMPTS);

 delete[] buff;
}

/*
 */
void
FreeInternational()
{
  int t = 0;

  for(t=0;main_toolbar_tips[t]; t++)
    delete[] main_toolbar_tips[t];

  for(t=0;main_toolbar1_tips[t]; t++)
    delete[] main_toolbar1_tips[t];

  for(t=0;main_menu_prompts[t] ;t++)
    delete[] main_menu_prompts[t];

  for(t=0;folder_widget_titles[t] ;t++)
    delete[] folder_widget_titles[t];

  for(t=0;container_widgets_tips[t] ;t++)
    delete[] container_widgets_tips[t];

  for(t=0;button_widgets_tips[t] ;t++)
    delete[] button_widgets_tips[t];

  for(t=0;text_widgets_tips[t] ;t++)
    delete[] text_widgets_tips[t];

  for(t=0;misc_widgets_tips[t] ;t++)
    delete[] misc_widgets_tips[t];

  for(t=0;dlg_widgets_tips[t] ;t++)
    delete[] dlg_widgets_tips[t];

  for(t=0;vdkb_status[t] ;t++)
    delete[] vdkb_status[t];

  for(t=0;about_dlg_text[t] ;t++)
    delete[] about_dlg_text[t];

  for(t=0;user_messages[t] ;t++)
    delete[] user_messages[t];

  for(t=0;editor_prompts[t] ;t++)
    delete[] editor_prompts[t];

  for(t=0;prjman_prompts[t] ;t++)
    delete[] prjman_prompts[t];

  for(t=0;prj_status[t] ;t++)
    delete[] prj_status[t];

  for(t=0;file_dialog_prompts[t] ;t++)
    delete[] file_dialog_prompts[t];

  for(t=0;prjwiz_prompts[t] ;t++)
    delete[] prjwiz_prompts[t];

  for(t=0;vdkbmaker_prompts[t] ;t++)
    delete[] vdkbmaker_prompts[t];

  for(t=0;prjoptions_prompts[t] ;t++)
    delete[] prjoptions_prompts[t];

  for(t=0;search_dialog_prompts[t] ;t++)
    delete[] search_dialog_prompts[t];

  for(t=0;replace_dialog_prompts[t] ;t++)
    delete[] replace_dialog_prompts[t];

}

