
#include <vdkb/vdkb_envdlg.h>
#include <vdkb/vdkb.h>

DEFINE_SIGNAL_MAP(Vdkb_envdlgForm,VDKForm)
ON_SIGNAL(QuitButton,clicked_signal,OnQuitButtonClick),
ON_SIGNAL(EditorSetFontButton,clicked_signal,OnEditorSetFontButtonClick),
ON_SIGNAL(CppSourceButton,clicked_signal,OnCppSourceButtonClick),
ON_SIGNAL(CppHeaderButton,clicked_signal,OnCppHeaderButtonClick),
ON_SIGNAL(ObjectFilesButton,clicked_signal,OnObjectFilesButtonClick),
ON_SIGNAL(StartUpDirButton,clicked_signal,OnStartUpDirButtonClick),
ON_SIGNAL(EditorMinVSizeButton,clicked_signal,OnEditorMinVSizeButtonClick),
ON_SIGNAL(EditorMinHSizeButton,clicked_signal,OnEditorMinHSizeButtonClick),
ON_SIGNAL(SyntaxTokenList,select_row_signal,OnSyntaxTokenListSelectRow),
ON_SIGNAL(SyntaxFontButton,clicked_signal,OnSyntaxFontButtonClick),
ON_SIGNAL(SyntaxSampleText,realize_signal,OnRealizeSampleText),
ON_SIGNAL(EditorFgButton,clicked_signal,OnEditorFgButtonClicked),
ON_SIGNAL(EditorBgButton,clicked_signal,OnEditorBgButtonClicked),
ON_SIGNAL(SyntaxColorsButton,clicked_signal,OnSyntaxColorsButtonClicked),
ON_SIGNAL(HideOnRunCheck,toggled_signal,OnHideOnRunCheckToggled),
ON_SIGNAL(WiResizeableCheck,toggled_signal,OnWiResizeableCheckToggled),
ON_SIGNAL(AutosaveCheck,toggled_signal,OnAutosaveCheckToggled),
ON_SIGNAL(TimedAutosaveSpinButton,value_changed_signal,
	  OnTimedAutosaveSpinButtonChanged),
ON_SIGNAL(BackupCheck,toggled_signal,OnBackupCheck),
ON_SIGNAL(setTabButton,clicked_signal,OnSetEditorTab)
END_SIGNAL_MAP
/*
main form setup
*/
void
Vdkb_envdlgForm::GUISetup(void)
{
	SetSize(400,280);
	Title = "Customizing VDKBuilder environment";
Nbook = new VDKNotebook(this);
Add(Nbook,l_justify,true,true,false);
Nbook->PopUp = true;
Nbook0_Page0 = new VDKBox(this,v_box);
Nbook0_Page0->SetSize(374,235);
Nbook->AddPage(Nbook0_Page0,"General");
Hbox29 = new VDKBox(this,h_box);
Nbook0_Page0->Add(Hbox29,l_justify,true,true,false);
Hbox29->BorderWidth(0);
Hbox31 = new VDKBox(this,h_box);
Hbox29->Add(Hbox31,l_justify,true,true,false);
Hbox31->BorderWidth(0);
Vframe2 = new VDKFrame(this,"General settings",v_box,shadow_etched_in);
Vframe2->SetSize(202,280);
Hbox31->Add(Vframe2,l_justify,true,true,false);
Vbox33 = new VDKBox(this,v_box);
Vbox33->SetSize(189,230);
Vframe2->Add(Vbox33,l_justify,true,true,false);
Vbox33->BorderWidth(0);
Table2 = new VDKTable(this,6,2,true);
Table2->RowSpacing = 2;
Table2->ColSpacing = 2;
Vbox33->Add(Table2,l_justify,true,true,false);
Vbox43 = new VDKBox(this,v_box);
Table2->AddToCell(Vbox43,0,0);
CppSourceButton = new VDKLabelButton(this,"Set C++ source");
Vbox43->Add(CppSourceButton,l_justify,true,true,false);
Vbox44 = new VDKBox(this,v_box);
Table2->AddToCell(Vbox44,0,1);
//
CppSourceEntry = new VDKEntry(this);
CppSourceEntry->SetSize(60,0);
Vbox44->Add(CppSourceEntry,l_justify,true,true,false);

Vbox45 = new VDKBox(this,v_box);
Table2->AddToCell(Vbox45,1,0);
CppHeaderButton = new VDKLabelButton(this,"Set C++ header");
Vbox45->Add(CppHeaderButton,l_justify,true,true,false);
Vbox46 = new VDKBox(this,v_box);
Table2->AddToCell(Vbox46,1,1);
//
CppHeaderEntry = new VDKEntry(this);
CppHeaderEntry->SetSize(60,0);
Vbox46->Add(CppHeaderEntry,l_justify,true,true,false);

Vbox47 = new VDKBox(this,v_box);
Table2->AddToCell(Vbox47,2,0);
ObjectFilesButton = new VDKLabelButton(this,"Set Object files");
Vbox47->Add(ObjectFilesButton,l_justify,true,true,false);
Vbox48 = new VDKBox(this,v_box);
Table2->AddToCell(Vbox48,2,1);
//
ObjectEntry = new VDKEntry(this);
ObjectEntry->SetSize(60,0);
Vbox48->Add(ObjectEntry,l_justify,true,true,false);

Vbox49 = new VDKBox(this,v_box);
Table2->AddToCell(Vbox49,3,0);
Label10 = new VDKLabel(this,"Builder");
Vbox49->Add(Label10,l_justify,true,true,false);
Vbox50 = new VDKBox(this,v_box);
Table2->AddToCell(Vbox50,3,1);
HideOnRunCheck = new VDKCheckButton(this,"Hides on run");
HideOnRunCheck->SetTip("Hides builder when running application");
Vbox50->Add(HideOnRunCheck,l_justify,true,true,false);
Vbox51 = new VDKBox(this,v_box);
Table2->AddToCell(Vbox51,4,0);
//
StartUpDirButton = new VDKLabelButton(this,"Start up dir");
Vbox51->Add(StartUpDirButton,l_justify,true,true,false);
Vbox52 = new VDKBox(this,v_box);
Table2->AddToCell(Vbox52,4,1);
StartupDirEntry = new VDKEntry(this);
Vbox52->Add(StartupDirEntry,l_justify,true,true,false);
// wi resize
Vbox53 = new VDKBox(this,v_box);
QuitButton = new VDKLabelButton(this,"Quit");

Table2->AddToCell(Vbox53,5,0);
Vbox53->Add(QuitButton,l_justify,true,true,false);

Vbox54 = new VDKBox(this,v_box);
WiResizeableCheck = new VDKCheckButton(this,"WI resizeable");
Vbox54->Add(WiResizeableCheck,l_justify,true,true,false);
Table2->AddToCell(Vbox54,5,1);

//
Hbox32 = new VDKBox(this,h_box);
Hbox29->Add(Hbox32,l_justify,true,true,false);
Hbox32->BorderWidth(0);
Vframe3 = new VDKFrame(this,"Editor settings",v_box,shadow_etched_in);
Vframe3->SetSize(162,280);
Hbox32->Add(Vframe3,l_justify,true,true,false);
Vbox34 = new VDKBox(this,v_box);
Vframe3->Add(Vbox34,l_justify,true,true,false);
Vbox34->BorderWidth(0);
Table3 = new VDKTable(this,8,2,true);
Table3->RowSpacing = 2;
Table3->ColSpacing = 2;
Vbox34->Add(Table3,l_justify,true,true,false);
Vbox55 = new VDKBox(this,v_box);
Table3->AddToCell(Vbox55,0,0);
EditorSetFontButton = new VDKLabelButton(this,"Set font");
Vbox55->Add(EditorSetFontButton,l_justify,true,true,false);
Vbox56 = new VDKBox(this,v_box);
Table3->AddToCell(Vbox56,0,1);
EditorFontEntry = new VDKEntry(this,0,"default");
Vbox56->Add(EditorFontEntry,l_justify,true,true,false);
Vbox57 = new VDKBox(this,v_box);
Table3->AddToCell(Vbox57,1,0);
EditorFgButton = new VDKCustomButton(this,"Set fore");


Vbox57->Add(EditorFgButton,l_justify,true,true,false);
Vbox58 = new VDKBox(this,v_box);
Table3->AddToCell(Vbox58,1,1);
EditorFgCanvas = new VDKCanvas(this, 40,25);
Vbox58->Add(EditorFgCanvas,l_justify,true,true,false);
//
Vbox59 = new VDKBox(this,v_box);
Table3->AddToCell(Vbox59,2,0);
EditorBgButton = new VDKCustomButton(this,"Set back");

Vbox59->Add(EditorBgButton,l_justify,true,true,false);
Vbox60 = new VDKBox(this,v_box);
Table3->AddToCell(Vbox60,2,1);

EditorBgCanvas = new VDKCanvas(this, 40,25);
Vbox60->Add(EditorBgCanvas,l_justify,true,true,false);
//
Vbox61 = new VDKBox(this,v_box);
Table3->AddToCell(Vbox61,3,0);
EditorMinVSizeButton = new VDKLabelButton(this,"Min V size");
Vbox61->Add(EditorMinVSizeButton,l_justify,true,true,false);
Vbox62 = new VDKBox(this,v_box);
Table3->AddToCell(Vbox62,3,1);
EditorMinVSizeEntry = new VDKEntry(this,0,"500");
Vbox62->Add(EditorMinVSizeEntry,l_justify,true,true,false);
Vbox63 = new VDKBox(this,v_box);
Table3->AddToCell(Vbox63,4,0);
EditorMinHSizeButton = new VDKLabelButton(this,"Min H size");
Vbox63->Add(EditorMinHSizeButton,l_justify,true,true,false);
Vbox64 = new VDKBox(this,v_box);
Table3->AddToCell(Vbox64,4,1);
EditorMinHSizeEntry = new VDKEntry(this,0,"400");
Vbox64->Add(EditorMinHSizeEntry,l_justify,true,true,false);
Vbox65 = new VDKBox(this,v_box);
Table3->AddToCell(Vbox65,5,0);
Label17 = new VDKLabel(this,"Changed files");
Vbox65->Add(Label17,l_justify,true,true,false);
Vbox66 = new VDKBox(this,v_box);
Table3->AddToCell(Vbox66,5,1);
AutosaveCheck = new VDKCheckButton(this,"Autosave");
AutosaveCheck->SetTip("Modified files saved without user warning");
Vbox66->Add(AutosaveCheck,l_justify,true,true,false);


int timedsave = atoi((char*) VDKBuilder::ideDefaults.editor.timedsave);
Vbox165 = new VDKBox(this,v_box);
Table3->AddToCell(Vbox165,6,0);
Label117 = new VDKLabel(this,"Timed saving");
Vbox165->Add(Label117,l_justify,true,true,false);
Vbox166 = new VDKBox(this,v_box);
Table3->AddToCell(Vbox166,6,1);
TimedAutosaveSpinButton = new VDKSpinButton(this,
					    double(timedsave),
					    0.0,20.0,1.0,0.0);
TimedAutosaveSpinButton->SetTip(
"Saves modified text files each <n> minutes (0 = disabled)");
TimedAutosaveSpinButton->Digits = 0;
Vbox166->Add(TimedAutosaveSpinButton,l_justify,true,true,false);


Vbox265 = new VDKBox(this,v_box);
Table3->AddToCell(Vbox265,7,0);
Label217 = new VDKLabel(this,"Make file backups");
Vbox265->Add(Label217,l_justify,true,true,false);
Vbox266 = new VDKBox(this,v_box);
Table3->AddToCell(Vbox266,7,1);
BackupCheck = new VDKCheckButton(this,"Backup");
BackupCheck->SetTip("Makes a <filename.ext~> backup file");
Vbox266->Add(BackupCheck,l_justify,true,true,false);

#ifdef HAVE_SYNTAX
 Nbook0_Page1 = new VDKBox(this,v_box);
 Nbook->AddPage(Nbook0_Page1,"Syntax coloring");
 Hbox4 = new VDKBox(this,h_box);
 Hbox4->SetSize(374,80);
 Nbook0_Page1->Add(Hbox4,l_justify,true,true,false);
 Hbox4->BorderWidth(0);
 char* SyntaxTokenListTitles[] = { "Syntax tokens type" };
 SyntaxTokenList = new VDKCustomList(this,
				     1,
				     SyntaxTokenListTitles,
				     (GtkSelectionMode) 0);
 SyntaxTokenList->SetSize(151,92);
 Hbox4->Add(SyntaxTokenList,l_justify,true,true,false);
 SyntaxTokenList->AutoResize = true;
 Vbox6 = new VDKBox(this,v_box);
 Vbox6->SetSize(151,92);
 Hbox4->Add(Vbox6,l_justify,true,true,false);
 Vbox6->BorderWidth(0);
 Hbox11 = new VDKBox(this,h_box);
 Vbox6->Add(Hbox11,l_justify,true,true,false);
 Hbox11->BorderWidth(0);
 //
 SyntaxColorsButton = new VDKCustomButton(this,"Set color");
 Hbox11->Add(SyntaxColorsButton,l_justify);//,false,false,false);
 //

 SyntaxColorsCanvas = new VDKCanvas(this, 40,25);
 Hbox11->Add(SyntaxColorsCanvas,l_justify);//,false,false,false);
 //
 Hbox12 = new VDKBox(this,h_box);
 Vbox6->Add(Hbox12,l_justify);//,false,false,false);
 Hbox12->BorderWidth(0);
 SyntaxFontEntry = new VDKEntry(this,0);
 SyntaxFontEntry->Enabled = false;
 Hbox12->Add(SyntaxFontEntry,r_justify);//,true,true,false);
 SyntaxFontButton = new VDKLabelButton(this,"Set font");
 SyntaxFontButton->SetSize(83,32);
 Hbox12->Add(SyntaxFontButton,l_justify,true,true,false);
 Hbox5 = new VDKBox(this,h_box);
 Hbox5->SetSize(374,198);
 Nbook0_Page1->Add(Hbox5,l_justify,true,true,false);
 Hbox5->BorderWidth(1);
 SyntaxSampleText = new VDKEditor(this,true);

 SyntaxSampleText->WordWrap = true;
 Hbox5->Add(SyntaxSampleText,l_justify,true,true,false);
#endif // HAVE_SYNTAX
 // third page
 // makes a table
 Nbook0_Page2 = new VDKBox(this,v_box);
 Nbook->AddPage(Nbook0_Page2,"Miscellanous");
 VDKTable* miscTable = new VDKTable(this,4,4);
 // editor tabs spaces
 setTabButton = new VDKCustomButton(this,"Set tab spaces");
 miscTable->AddToCell(setTabButton,0,0,false);
 editortab = new VDKSpinButton(this,0.0,0.0,25.0,1,0.0);
 miscTable->AddToCell(editortab,0,1,false);
 editortab->Digits = 0;
 // add table to page
 Nbook0_Page2->Add(miscTable,l_justify,false,false,2);

}

