/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vdkb/vdkb_editor.h>
#include <vdkb/vdkb.h>
#include <vdkb/vdkb_locale.h>
#include <vdkb/vdkb_utils.h>
#include <vdk/FileDialog.h>
#include <vdk/FileSaveAsDialog.h>
#include <vdkb/vdkb_search.h>
#include <vdkb/vdkb_replace.h>
#include <vdkb/vdkb_prjman.h>
#include <vdkb/vdkb_timebar.h>
static char buff[512];
/*
search stuff
*/
static int last_pos = 0;
static char* match = NULL;

/*
 */
#ifdef HAVE_HINTS
char*
VDKBEditor::HintCallback (char *match, gpointer data)
{
  /*
  VDKBEditor* editor = (VDKBEditor*) data;
  VDKBHint hint,*found = NULL;
  hint.match = match;
  if(editor->hintDb)
    found = editor->hintDb->find(hint);
  return found ? (char*) found->text : NULL;
  */
  return (char*) NULL;
}
#endif

///////////////// signal stuff //////////
DEFINE_SIGNAL_LIST(VDKBEditor,VDKForm);
DEFINE_SIGNAL_MAP(VDKBEditor,VDKForm)
  ON_SIGNAL(nbook,switch_page_signal,OnPageChanged),
  ON_SIGNAL(messages,select_row_signal,JumpToError),
  ON_SIGNAL(closePage,activate_signal,OnClosePage),
  ON_SIGNAL(toggleHeader,activate_signal,OnToggleHeader),
  ON_SIGNAL(fileSave,activate_signal,FileSave),
  ON_SIGNAL(fileSaveAs,activate_signal,FileSaveAs),
  ON_SIGNAL(search,activate_signal,Search),
  ON_SIGNAL(repeatsearch,activate_signal,RepeatSearch),
  ON_SIGNAL(hilite,activate_signal,Hilite)
END_SIGNAL_MAP
//////////////////////////////////////////////////
// in gtkeditor-regex.c
extern "C" void gtk_editor_set_queue_hack(int flag);
/*
 */
VDKBEditor::VDKBEditor(VDKForm* owner):
  VDKForm(owner)
{
  //  struct stat info;
  ForceToClose = false;
  // unset msg queue hacking during syntax colouring
  gtk_editor_set_queue_hack(0);
  /*
    #ifdef HAVE_HINTS
    // load hints database
    hintDb = new HintDb;
    VDKBuilder *app = (VDKBuilder*) Application();
    VDKString user = app->user_home;
    sprintf(buff,"%s/.vdkb/lang/%s.%s",
    (char*) user,"vdkhints","en");
    if (stat(buff,&info) == -1)
    sprintf(buff,"%s/lang/%s.%s",
    VDKB_DATADIR,"vdkhints","en");
    if (LoadHintDb(buff))
    {
    #ifdef VDKBDEBUG
    printf("\n%s successfully loaded",buff);
    fflush(stdout);
    #endif
    ;
    }
    else
    {
    #ifdef VDKBDEBUG
    printf("\n%s error loading",buff);
    fflush(stdout);
    #endif
    ;
    }
    #endif
  */
}
/*
 */
VDKBEditor::~VDKBEditor()
{
#ifdef HAVE_HINTS
  /*
    if(hintDb)
    delete hintDb;
  */
#endif
}
/*
 */
void
VDKBEditor::Setup()
{
  Title = editor_prompts[0];
  VDKPaned* paned = new VDKPaned(this);
  nbook = new VDKBNotebook(this);
  paned->Pack(nbook,1,true,true);
  VDKPoint size = VDKBuilder::ideDefaults.editor.size;
  nbook->SetSize(size.X(),size.Y());
  messages = new VDKCustomList(this,1,NULL,GTK_SELECTION_EXTENDED);
  messages->SetSize(50,-1);
  paned->Add(messages,2,true,true);
  Add(paned);
  bar =  new VDKPanelbar(this,3);
  bar->Panels()[2]->Justify = GTK_JUSTIFY_RIGHT;
  Add(bar,r_justify,false,false,false);
  // makes a pop menu
  popmenu = new VDKMenu(this);
  toggleHeader = new VDKMenuItem(popmenu,editor_prompts[3]);
  closePage = new VDKMenuItem(popmenu,editor_prompts[4]);
  fileSave = new VDKMenuItem(popmenu,editor_prompts[9]);
  fileSaveAs = new VDKMenuItem(popmenu,editor_prompts[5]);
  popmenu->Separator();
  search = new VDKMenuItem(popmenu,main_menu_prompts[30]);
  sprintf(buff,"%s  (F3)",main_menu_prompts[31]);
  repeatsearch = new VDKMenuItem(popmenu,buff);
  sprintf(buff,"%s  (Alt-Backspace)",main_menu_prompts[33]);
  undo = new VDKMenuItem(popmenu,buff);
  sprintf(buff,"%s  (F5)",main_menu_prompts[34]);
  redo = new VDKMenuItem(popmenu,buff);
  hilite = new VDKMenuItem(popmenu,main_menu_prompts[35]);
  // since redo capability isn't yet  implemented, set as disabled
  redo->Enabled = false;
  // hilite enabled in HAVE_SYNTAX only
#ifndef HAVE_SYNTAX
  hilite->Enabled = false;
#endif

  /*
     since popmenu could never be popped
     better add it to form items even if VDKMenu::Popup()
     does the job. VDKList::add() will ensure won't be added twice
     and GC will detect it even if never popped.
  */
  AddItem(popmenu);
  /*
    Signals will come up from one of VDKBText's
    contained into VDKBNotebook pages.
    Since these signals are not provided by gtk+
    put <gtk> arg as false, so will be dispatched by VDK
  */
  SignalConnect(nbook,"text_changed",&VDKBEditor::OnTextChanged,false);
  SignalConnect(nbook,"line_changed",&VDKBEditor::OnLineChanged,false);
  SignalConnect(nbook,"pop_menu",&VDKBEditor::OnPopMenu,false);
  SignalConnect(nbook,"repeat_search_text",&VDKBEditor::RepeatSearch,false);
  SignalConnect(nbook,"no_more_undo",&VDKBEditor::NoMoreUndo,false);
  SignalConnect(nbook,"hilite_text",&VDKBEditor::Hilite,false);
  /*
    makes a timer for timed auto save
  */
  unsigned int autosavetime =
    atoi((char*) VDKBuilder::ideDefaults.editor.timedsave);
  if(autosavetime > 0)
    {
      autosavetimer = new VDKTimer(this,5000);
      autosavetimer->Parent(this);
      SignalConnect(autosavetimer,"timer_tick_signal",
		    &VDKBEditor::OnAutosaveTimer,false);
    }
  else
    autosavetimer = NULL;
}
/*
 */
void
VDKBEditor::OnShow(VDKForm*)
{
  VDKBMainForm* owner = dynamic_cast<VDKBMainForm*>(Owner());
  if(owner)
    {
      int w,h;
      VDKPoint ownerPos = owner->Position;
      VDKBProjectManager* prjman = owner->PrjManager();
      VDKPoint prjmanPos = prjman->Position;
      gdk_window_get_size(GTK_WIDGET(prjman->Window())->window, &w, &h);
      VDKPoint prjmanSize(w,h);
      gdk_window_get_size(GTK_WIDGET(owner->Window())->window, &w, &h);
      VDKPoint ownerSize(w,h);
      VDKPoint p(ownerPos.X()+prjmanSize.X()+5 ,ownerPos.Y()+ownerSize.Y()+5);
      Position = p;
    }
 }
/*
 */
bool
VDKBEditor::NewForm(char* name)
{
  char* cc_ext = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  // gets name without extension
  char* p = get_extension(name);
  int result = false;
  if(p)
    *p = '\0';

  // write .cc
  sprintf(buff,"%s.%s",name,cc_ext);
  FILE* fp = fopen(buff,"w+");
  if(!fp)
    return false;
  else
    result = WriteFormCC(name,fp);
  if(result)
    AddText(buff,true,true);
  else
    return result;

  // write .h
  sprintf(buff,"%s.%s",name,h_ext);
  fp = fopen(buff,"w+");
  if(!fp)
    return false;
  else
    result = WriteFormH(name,fp);
  if(result)
    AddText(buff,true,true);
  // write .frm
  sprintf(buff,"%s.%s",name,FORM_EXT);
  fp = fopen(buff,"w+");
  if(!fp)
    return false;
  else
    result = WriteFrm(name,fp);
  return result;
 }
/*
 */
void VDKBEditor::AddNewUnit()
{
  // read defaults
  char* cc_ext   = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  char* h_ext    = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  char* unit     = (char*) VDKBuilder::ideDefaults.unit.def_name;
  int   count    = VDKBuilder::ideDefaults.unit.count;
  //VDKBText *text;
  // add .cc
  sprintf(buff,"%s%d.%s",unit,count,cc_ext);
  AddText(buff,true,true);
    // add .h
  sprintf(buff,"%s%d.%s",unit,count,h_ext);
  AddText(buff,true,true);
  // finished, update unit count
  VDKBuilder::ideDefaults.unit.count += 1;
}
/*
 */
void VDKBEditor::AddText(char* text_name, bool editable,bool hilite)
{
  ((VDKBMainForm*)Owner())->MakeEditor();
  VDKBText *text = new VDKBText(this,editable,text_name);
  // add a text to textlist
  textlist.add(text);
#ifdef HAVE_HINTS
  text->InstallHints(VDKBEditor::HintCallback,this);
#endif
  nbook->AddText(text,text->ShortName(),hilite);
  nbook->ActivePage = textlist.size()-1;
}

//////////////////////// signal process ////////////////////
bool
VDKBEditor::OnAutosaveTimer(VDKObject* sender)
{
  static unsigned int elapsedSecs = 0;
  elapsedSecs += 5;
  unsigned int savetime =
    atoi((char*) VDKBuilder::ideDefaults.editor.timedsave);
  savetime *= 60;
  if(! (elapsedSecs%savetime))
    FileSave(sender);
  else
    {
      char local[64];
      sprintf(local,"%02u:%02u:%02u",
	      elapsedSecs/3600,
	      elapsedSecs/60,
	      elapsedSecs%60);
      bar->Panels()[1]->Caption = local;
    }
  return true;
}
/*
 */
bool
VDKBEditor::JumpToError(VDKObject* )
{
  char *tokens = "$%";
  int t,z;
  int row = messages->Selected.Row();
  if(row < 0 || row >= messages->Tuples.size())
    return true;
  VDKString errmess = messages->Tuples[row][0];
  VDKString file;
  int line = 0;
  char* err = new char[strlen((char*) errmess)+1];
  strcpy(err,(char*) errmess);
  // change first two ":" with tokens
  for(t = 0,z=0; err[t]; t++)
    {
      if( err[t] == ':')
	{
	  err[t] = tokens[z++];
	  if(!tokens[z])
	    break;
	}
    }
  char * p;
  if( (p = ExtractWord(err,buff,"","$")) )
    file = buff;
  if ( (p = ExtractWord(err,buff,"$","%")) )
    line = atoi(buff);
  if((line == 0) || access((char*) file ,F_OK) || ( ! GoToLine(file,line)) )
    {
      gdk_beep();
      bar->Panels()[0]->Caption = "no error to go";
    }
  delete[] err;
  return true;
}
/*
 */
bool
VDKBEditor::GoToLine(VDKString& file, int line)
{
int t;
TextListIterator li(textlist);
// activate or load a new text
for(t=0;li;li++,t++)
  {
    VDKString temp = li.current()->Filename();
    if( temp == file)
      {
	nbook->ActivePage = t;
	break;
      }
  }
// not found, so load a new text
if(t >= textlist.size())
  {
    AddText((char*) file, true,true);
    nbook->ActivePage = t;
  }
// finally goes to line
return textlist[t]->GoToLine(line);
}
/*
 */
bool
VDKBEditor::OnTextChanged(VDKObject* )
{
  // editor says that some text was changed
  // so let's user to know
  int activePage = nbook->ActivePage;
  char* p = textlist[activePage]->ShortName();
  if(textlist[activePage]->Changed)
    {
      sprintf(buff,"%s%s",editor_prompts[1],p);
      bar->Panels()[0]->Caption = buff;
    }
  int line = textlist[activePage]->CurrentLine;
  sprintf(buff,"%s%d",editor_prompts[2],line);
  bar->Panels()[2]->Caption = buff;
  return true;
}
/*
 */
bool
VDKBEditor::OnPageChanged(VDKObject* )
{
  char local[256];
  int activePage = nbook->ActivePage;
  if(activePage < 0 || activePage >= textlist.size())
    return true;
  char* p = textlist[activePage]->ShortName();
  if(textlist[activePage]->Changed)
    {
      sprintf(buff,"%s%s",editor_prompts[1],p);
      bar->Panels()[0]->Caption = buff;
    }
  else
    bar->Panels()[0]->Caption = " ";
  int line = textlist[activePage]->CurrentLine;
  sprintf(buff,"%s%d",editor_prompts[2],line);
  bar->Panels()[2]->Caption = buff;
  // set to 0 last pos in search.
  last_pos = 0;
  // enable/disable form/unit toggle
  strcpy(local,textlist[activePage]->Filename());
  char* e = get_extension(local);
  if(e)
    {
      VDKBMainForm* owner = dynamic_cast<VDKBMainForm*>(Owner());
      *e = '\0';
      sprintf(buff,"%s.frm",local);
      if(owner)
	owner->EnableToggleFormUnit(!access(buff,F_OK),buff);
    }
return true;
}
/*
 */
bool
VDKBEditor::OnLineChanged(VDKObject* )
{
  int activePage = nbook->ActivePage;
  if(activePage < 0 || activePage >= textlist.size())
    return true;
  int line = textlist[activePage]->CurrentLine;
  sprintf(buff,"%s%d",editor_prompts[2],line);
  bar->Panels()[2]->Caption = buff;
  return true;
}
/*
 */
bool
VDKBEditor::CanClose()
{
 UpdateFiles();
 // can be closed via mainform only.
 if(ForceToClose)
   {
     if(autosavetimer)
       autosavetimer->Stop();
     return true;
   }
 else
   {
     Visible = false;
     return false;
   }
}
/*
 */
extern int  AskUserToSaveFile(char* name);
void
VDKBEditor::UpdateFiles()
{
TextListIterator li(textlist);
for(;li;li++)
  {
    // has to be saved ?
    if(li.current()->Changed)
      {
	sprintf(buff,"%s",(char*) li.current()->Filename());
	if(AskUserToSaveFile(buff) == IDYES)
	  {
	    // never saved
	    // it's a new unit, changes sentinel in .h
	    if(access(li.current()->Filename(),F_OK))
	      {
		// ask to user
		FileStringArray selections;
		VDKFileSaveAsDialog *child =
		  new VDKFileSaveAsDialog(this,&selections,
					  file_dialog_prompts[3]);
		child->ShowModal();
		if(selections.size() > 0)
		  {
		    UpdateUnit(li.current(),selections[0]);
		    li.current()->SaveToFile(selections[0]);
		  }
	      }
	
	    // or unsaved ?
	    else
	      li.current()->SaveToFile((char*) li.current()->Filename());
	    li.current()->Changed = false;
	  }
	else
	  // user forced to be considered saved
	  li.current()->Changed = false;
      }
  }
}
/*
 */

void
VDKBEditor::FillMessages(VDKBStringList* list)
{
messages->Clear();
messages->Freeze();
VDKBStringListIterator li(*list);
for(;li;li++)
  {
    char* p = (char*) li.current();
    messages->AddRow(&p);
  }
messages->Thaw();
if(list->size() > 0)
  messages->SelectRow(0,0);
}

/*
 */
bool
VDKBEditor::OnPopMenu(VDKObject* )
{
  VDKBText* text;
  int activePage = nbook->ActivePage;
  if(activePage < 0 || activePage >= textlist.size())
    return true;
  else
    text = textlist[activePage];

  // sets menu item for not editable
  if(! text->Editable)
    {
      toggleHeader->Enabled = false;
      fileSave->Enabled = false;
      undo->Enabled = false;
      repeatsearch->Enabled = false;
#ifdef HAVE_SYNTAX
      hilite->Enabled = false;
#endif
    }
  // sets menu item for editable
  else
    {
      toggleHeader->Enabled = true;
      fileSave->Enabled = true;
      undo->Enabled = true;
      repeatsearch->Enabled = match != NULL;
#ifdef HAVE_SYNTAX
      hilite->Enabled = text->Hilite;
#endif

    }

  // pops menu
  popmenu->Popup();
  return TRUE;
}
/*
 */
bool
VDKBEditor::OnClosePage(VDKObject* )
{
int activePage = nbook->ActivePage;
VDKBText* text;
if(activePage < 0 || activePage >= textlist.size())
  return true;
else
  text = textlist[activePage];
//
if(text->Changed)
  {
    sprintf(buff,"%s", (char*) text->Filename());
    if(AskUserToSaveFile(buff) == IDYES)
      {
	// never saved
	if(access(text->Filename(),F_OK))
	  {
	    // ask to user
	    FileStringArray selections;
	    VDKFileSaveAsDialog *child =
	      new VDKFileSaveAsDialog(this,&selections,
				      file_dialog_prompts[3]);
	    child->ShowModal();
	    if(selections.size() > 0)
	      {
		UpdateUnit(text,selections[0]);
		text->SaveToFile(selections[0]);
	      }
	  }
	
	// or unsaved ?
	else
	    text->SaveToFile((char*) text->Filename());
	text->Changed = false;
      }
  }
if(textlist.unlink(activePage))
  nbook->RemovePage(activePage);
// hide editor if no more pages
if(textlist.size() > 0)
  OnPageChanged(NULL);
else
  Hide();
return true;
}

/*
 */
void
VDKBEditor::UpdateUnit(VDKBText* text, VDKString& rep_s)
{
  //  char* cc_ext   = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  char* h_ext    = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  VDKString ext;
  VDKString name = text->ShortName();
  VDKString replace;
  char *z = get_shortfilename(rep_s);
  if(z)   replace = z;
  else  return;
  if(!name.isNull())
    {
      // extract name and extension
      char *p = get_extension((char*) name);
      if(p)  { *p = '\0'; p++; ext = p; }
      else  return;
      p = get_extension(replace);
      if(p) *p = '\0';
      else return;
    }
  else
    return;
  // change sentinel
  if(!strcmp(ext,h_ext))
    {

      sprintf(buff,"_%s_h",(char*) name);
      VDKString match = buff;
      sprintf(buff,"_%s_h",(char*) replace);
      replace = buff;
      int pos = text->Search(match, 0, true);
      if(pos>=0)
	{
	  pos = Replace(text,pos,match,replace);
	  pos = text->Search(match, pos, true);
	}
      if(pos>=0)
	pos = Replace(text,pos,match,replace);
    }
}
int
VDKBEditor::Replace(VDKBText* text, int pos, char* match, char* replace)
{
  text->Pointer = pos;
  text->ForwardDelete(strlen(match));
  text->Pointer = pos;
  text->TextInsert(replace);
  return pos+strlen(replace);
}
/*
 */
bool
VDKBEditor::OnToggleHeader(VDKObject* )
{
char* cc_ext   = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
char* h_ext   = (char*) VDKBuilder::ideDefaults.unit.h_ext;
int activePage = nbook->ActivePage;
VDKBText* text;
if(activePage < 0 || activePage >= textlist.size())
  return true;
else
  text = textlist[activePage];
// look for that
VDKString name = text->Filename();
VDKString ext;
char* p = get_extension((char*) name);
if(p)
  {
    *p++ = '\0';
    ext = p;
    sprintf(buff,"%s.%s",(char*) name,
	    (!strcmp(ext,cc_ext)) || (!strcmp(ext,"c")) ?
	    h_ext :
	    cc_ext);
    name = buff;
  }
else
  return true;

// search in list
int t = 0;
bool found = false;
bool exists =  !access(name,F_OK);

TextListIterator li(textlist);
for(;li;li++,t++)
{
  if(! strcmp(li.current()->Filename(),name))
    {
      found = true;
      break;
    }
}

if(found && exists)
{
  nbook->ActivePage = t;
  return true;
}
else if(! found && exists)
{
  AddText(name,true,true);
  nbook->ActivePage = textlist.size()-1;
}
else if(! exists)
{
  FileStringArray selections;
  VDKFileDialog *child = new VDKFileDialog(this,&selections,
					   file_dialog_prompts[0]);
  sprintf(buff,"*.%s",
	  (!strcmp(ext,cc_ext)) || (!strcmp(ext,"c")) ?
	  h_ext :
	  cc_ext);
  child->Filter = buff;
  child->ShowModal();
  if(selections.size() > 0)
    AddText(selections[0],true,true);
}
return true;
}
 /*
  * Simple save the file and set it as unchanged
  */
bool
VDKBEditor::FileSave(VDKObject* obj)
{
  int activePage = nbook->ActivePage;  //identify the active page
  if(activePage < 0 || activePage >= textlist.size())
    // called with obj = NULL by main form main menu or toolbar
  return obj == NULL ? false : true;

  VDKBText* text = textlist[activePage];
  // check if never saved
  if(access(text->Filename(),F_OK))
    {
      // ask to user
      FileStringArray selections;
      VDKFileSaveAsDialog *child =
 	new VDKFileSaveAsDialog(this,&selections,
 				file_dialog_prompts[4]);
      child->ShowModal();
      if(selections.size() > 0)
 	{
 	  UpdateUnit(text,selections[0]);
 	  text->Filename(selections[0]);
	  nbook->Pages[activePage]->TabLabel->Caption = text->ShortName();
 	}
      else
 	{
 	  return true;
 	}
    }
  if(text->Changed)
    {
      text->SaveToFile((char*) text->Filename());      //save text to file
      text->Changed = false;                           //set it as unchanged
      sprintf(buff,"%s:%s",
	      editor_prompts[8],
	      (char*) text->Filename());
      bar->Panels()[0]->Caption = buff;
#ifdef VDKBDEBUG
      printf("\nsaved:%s", (char*) text->Filename());
      fflush(stdout);
#endif
    }
  return true;
}
/*
 */
bool
VDKBEditor::FileSaveAs(VDKObject* )
{
  int activePage = nbook->ActivePage;
  FileStringArray selections;

  if(activePage < 0 || activePage >= textlist.size())
    return true;

  VDKFileSaveAsDialog *child =
    new VDKFileSaveAsDialog(this,&selections,
			    file_dialog_prompts[4]);
  child->ShowModal();
  if(selections.size() <= 0)
    return true;
  VDKBText* text = textlist[activePage];
  text->Filename(selections[0]);
  text->SaveToFile((char*) text->Filename());
  text->Changed = false;

  sprintf(buff,"%s:%s",
	  editor_prompts[8],
	  (char*) text->Filename());
  bar->Panels()[0]->Caption = buff;

#ifdef VDKBDEBUG
  printf("\nsaved:%s",(char*) text->Filename());
  fflush(stdout);
#endif
  nbook->Pages[activePage]->TabLabel->Caption = text->ShortName();
return true;
}
/*
 */
bool
VDKBEditor::Search(VDKObject*)
{
  char* st = NULL;
  int activePage = nbook->ActivePage;
  if(activePage < 0 || activePage >= textlist.size())
    return true;
  VDKBSearchForm *dlg = new VDKBSearchForm(this,&st);
  dlg->Setup();
  dlg->ShowModal();
  // dlg return st to search newly allocated (or NULL)
  if(st)
    {
      last_pos = 0;
      if(match)
	delete[] match;
      match = new char[strlen(st)+1];
      strcpy(match,st);
      delete[] st;
      VDKBText* text;
      text = textlist[activePage];
      last_pos = text->Search(match, last_pos, true);
      last_pos = last_pos > 0 ? last_pos + strlen(match): last_pos;
    }
  return true;
}
/*
 */
bool
VDKBEditor::RepeatSearch(VDKObject*)
{
  VDKBText* text;
  int activePage = nbook->ActivePage;
  if(! match || activePage < 0 || activePage >= textlist.size())
    return true;
  text = textlist[activePage];
  int pos = text->Search(match, last_pos, true);
  sprintf(buff,"%s\n%s",
	  search_dialog_prompts[19],
	  search_dialog_prompts[20]);
  if(pos >= 0)
    last_pos = pos+strlen(match);
  else if(Application()->MessageBox(APPNAME,
				 buff,
				 MB_ICONQUESTION|MB_YESNO,
				 user_messages[user_ok],
				 user_messages[user_no]) == IDYES)
    {
      last_pos = 0;
      RepeatSearch(NULL);
    }
  return true;
}
/*
 */
bool
VDKBEditor::NoMoreUndo(VDKObject*)
{
  sprintf(buff,"%s",editor_prompts[6]);
  bar->Panels()[0]->Caption = buff;
  gdk_beep();
return true;
}
/*
 */
void
VDKBEditor::ReplaceText(void)
{
  VDKBText* text;
  int activePage = nbook->ActivePage;
  if(activePage < 0 || activePage >= textlist.size())
    return ;
  else
    text = textlist[activePage];
  VDKBReplaceForm *dlg = new VDKBReplaceForm(this,text);
  dlg->Setup();
  dlg->ShowModal();
}
/*
 */
/*
 */
bool
VDKBEditor::Hilite(VDKObject* )
{
  VDKBText* text;
  int activePage = nbook->ActivePage;
  if(activePage < 0 || activePage >= textlist.size())
    return true;
  else
    text = textlist[activePage];
#ifdef HAVE_SYNTAX
  /*
    here a timebar addes to panelbar shows
    time-consuming syntax colouring operations
    when job is finished disappears
  */
  // set msg queue hacking during syntax colouring
  gtk_editor_set_queue_hack(1);
  sprintf(buff,"%s %s..",editor_prompts[7],text->Filename());
  bar->Panels()[0]->Caption = buff;
  VDKBTimebar *timebar = new VDKBTimebar(Owner(),0,60,500);
  bar->Add(timebar,l_justify,false,false,0);
  gtk_editor_hilite_buffer (GTK_EDITOR(text->WrappedWidget()));
  bar->RemoveObject(timebar);
  bar->Panels()[0]->Caption = editor_prompts[8];
  // unset msg queue hacking
  gtk_editor_set_queue_hack(0);
#endif
  return true;
}



#ifdef HAVE_HINTS
/*
 */
bool
VDKBEditor::LoadHintDb(char* fn)
{
  /*
    VDKBHint hint;
    char line[1024],*p;
    int c;
    char match[128],text[1024];
    if(! hintDb)
    return false;
    FILE *fp = fopen(fn,"r");
    if(!fp )
    return false;
    p = line;
    while ((c = fgetc(fp)) != EOF )
    {
    // only tab is used to format hints
    if(c != '\t')
    *p++ = (char) c;
    if(c == '}')
    {
    *++p = '\0';
    p = line;
    if(ExtractWord(line,match,"[","]")  &&
    ExtractWord(line,text,"{","}") )
    {
    hint.match = match;
    hint.text = text;
    hintDb->add(hint);
    }
    }
    }
    fclose(fp);
  */
    return true;
}
#endif























