/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.7
 * September 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */

/*
--------
OVERVIEW
--------
- This file should be considered as a template for constructing vdkbuilder
plugin components. Users should copy/paste and easily adapt this file
to their own components.
- See also plugins.txt into /plugins directory for further informations.
*/


// write here your component include file
#define COMPO_INCLUDE <vdkb/vdkb_calendar.h>
// leave it as is
#define INTERFACE_INCLUDE <vdkb/vdkb_interface.h>
// write how vdkbuilder will name components pointers,
// pointer names  will be suffixed with a number
// i.e: databox0
#define VDK_WIDGET "calendar"
// write here your interface name
// normally: CLASS+ComponentInterface
#define INTERFACE  VDKBCalendarComponentInterface
// tip displayed into builder tool palette
// change with your own
#define COMPO_TIP "VDKCalendar"


//////////////////////
#include COMPO_INCLUDE
#include INTERFACE_INCLUDE
#include <vdkb/vdkb_evbox.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_form.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_objinspect.h>
#include <vdkb/vdkb_prjman.h>
#include <stdlib.h>
////////////////////////
/*
icon to be displayed on toolbar palette
*/
/*
 change to your own icon, do not change COMPO_XPM,
 change string constants instead.
*/
static const char * COMPO_XPM[] =
{
/* width height num_colors chars_per_pixel */
"    40    24       13            1",
/* colors */
". c none",
"# c #000000",
"a c #0000ff",
"b c #ff0000",
"c c #ffffff",
"d c #87cefa",
"e c #000080",
"f c #2f4f4f",
"g c #ffffe0",
"h c #d9d9d9",
"i c #8b7765",
"j c #b3b3b3",
"k c #d2b48c",
/* pixels */
"........................................",
"........................................",
".......#bbbbbbbbbbbb.......ccaaaaa......",
"......##bbbbbbbbbbbb......acdaaaaa......",
"......##bbbbbbbbbbbb....adddddddaaaa....",
"......##bbbbbbbbbbbb....eeeeeeeeeeee....",
"......##ggggggggggg#.....aaaahhaaaa.....",
"......#i#gggggegggg#....aahhhhhhjjaa....",
"......#k#geegegeggg#....ahhhheehjjhaa...",
"......#k#geegggeegg#..aahhhhheehhhjhaa..",
"......#k#gegggeggegg.faahhhhheehhhjjha..",
"......#k#gegegggggegffahhhhhheehhhhjjaa.",
"......#k#gggeeggggegffhhhhhhhhhhhhhjjha.",
"......#k#ggggegeeeegfahhhhhhhhhhhhhhjha.",
"......#k##ggggegggggfahhhhhhhhhhhhhhjha.",
"......#k#kggggggggggfahhhhhhhhhehhhhjha.",
"......#k###gggggggggffahhhhhhhhhehhhhaa.",
"......#k##k#gggg#gggffahhhhhhhhhhehhhaa.",
"......#kkkgkj##ggg###faahhhhhhhhhhhhaa..",
"......#ik#k#kkj####j##ffahhhhhhhhhhaa...",
"......#ii#g#kkkkkgg##.ffaahhhhhhhhaa....",
"......#iiikkkkkkkki#...fafaaahhaaaaa....",
"......##############...fafffaaaafaffa...",
"......................fa...........ff..."
};
////////////////////////
/*
Interface class for builder widget
leave it as is
 */
class INTERFACE : public VDKBAbstractComponentInterface
   {
public:
     INTERFACE() {}
     virtual ~INTERFACE()
    {
    }
     // write vdk code to create component
     char* CreateSource(char* buffer,VDKBParser& parser)
    {
      return CLASS::CreateSource(buffer,parser);
    }
     // parse .frm file to make the component
     bool CreateWidget(VDKBGuiForm* owner,
		       char* buffer,VDKBParser& parser)
    {
      return CLASS::CreateWidget(owner,buffer,parser);
    }
     // make and add a new component to edit form
     int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL)
   {
     return CLASS::MakeWidget(owner,ev);
   }
     // return component icon to be inserted
     // into vdkbuilder tool palette
     const char** Icon() { return COMPO_XPM; }
     // icon tip
     const char* Tip() { return COMPO_TIP; }
     // return component vdk class name
     const char* VDKName()
    {
      return (const char*) VDK_CLASS;
    }
};
// get a new interface object
// this is called by plugin object from builder
extern "C"
VDKBAbstractComponentInterface* GetExportClass()
{
  return new INTERFACE;
}

/*
 component properties, change here with your own or leave array empty
 like this:
 static char* vdk_props[] = { 0 };
 if your component does not have any property to be set with the WI
*/
#define PROPERTY1     "DisplayOptions"
/*
  #define PROPERTY2     "Cross"
  #define PROPERTY3     "Scrollbars"
*/

static char* vdk_props[] =
{
  PROPERTY1,
  /*
    PROPERTY2,
    PROPERTY3,
  */
  0
};

/*
 component provided signals, change here signal provided for your component
 or  leave array empty like this:
 static char* vdk_signals[] = { 0 };
 if your component does not have any signal provided
*/
#define SIGNAL1   "day_select_signal"
#define SIGNAL2   "day_selected_double_click"
/*
  #define SIGNAL3   "databox_selection_started_signal"
  #define SIGNAL4   "databox_selection_changed_signal"
  #define SIGNAL5   "databox_selection_stopped_signal"
  #define SIGNAL6   "databox_selection_canceled_signal"
*/


static char* vdk_signals[] =
{
  SIGNAL1,
  SIGNAL2,
  /*
    SIGNAL3,
    SIGNAL4,
    SIGNAL5,
    SIGNAL6,
  */
  0
};

/*
 component signal nicknames, they will be used to make signal response
 signatures like this:
 bool On<componentname><signal nickname>(VdkObject* sender);
 e.g.
 Ondatabox1Zoomed(VDKObject* sender);
 Change here nicknames for your component or leave array empty like this:
 static char* vdk_nicknames[] = { 0 };
 if your component does not have any signal provided
*/
#define NICK1  "DaySelected"
#define NICK2  "DoubleClickDaySelected"
/*
  #define NICK3  "SelectionStarted"
  #define NICK4  "SelectionChanged"
  #define NICK5  "SelectionStopped"
  #define NICK6  "SelectionCanceled"
*/

static char* vdk_nicknames[] =
{
  NICK1,
  NICK2,
  /*
    NICK3,
    NICK4,
    NICK5,
    NICK6,
  */
  0
};

/*
local buffer
*/
static char buff[256];
/*
  used to autogenerate default
  component names
*/
int CLASS::Counter = 0;


// dynamic tables
// leave it as is
DEFINE_SIGNAL_LIST(CLASS,VDK_ANCESTOR);
DEFINE_EVENT_LIST(CLASS,VDK_ANCESTOR);
///////////////////////////////////////////////////

//////////////////////////////////////////////////////////////
/*
  - constructor
 */
CLASS::CLASS(char* name, VDKForm* owner):
  VDK_ANCESTOR(owner),VDKBObject(name)
{
  int t = 0;
  // newly constructed component counter is incremented
  // each time
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add component specific properties to VDKBObject properties list
  for(t = 0; vdk_props[t]; t++)
    proplist.add(VDKBProperty(vdk_props[t]));
  // add component specifi signal to VDKBObject signal list
  for(t = 0; vdk_signals[t]; t++)
    siglist.add(VDKBSignal(vdk_signals[t], this, vdk_nicknames[t]));
  /*
    here you may want set some default value for some property:
    SetPropValue(<"property name">,<"property value">);
    e.g:
    //set a reasonable size fro the widget in the case
    // it will be dropped into a fixed container
    sprintf(buff,"%d,%d",150,110);
    SetPropValue("Usize",buff);
  */
  sprintf(buff,"%d",GTK_CALENDAR_SHOW_HEADING);
  SetPropValue("DisplayOptions",buff);
  //set a reasonable size fro the widget in the case
  // it will be dropped into a fixed container
  sprintf(buff,"%d,%d",150,110);
  SetPropValue("Usize",buff);
  // connects component common events.
  CONNECT_COMMON_EVENTS;
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
  // a reasonable initial size (mainly for adding the component
  // to a fixed container)
  // change to your own size
  SetSize(100,100);
}
///////////////////////////////////////////////
//
//    WRITE WIDGET DESCRIPTION TO .FRM FILE
//
///////////////////////////////////////////////
/*
  Writes a .frm format representation of the component
  This virtual function is called by VDKBForm::WriteBoxesOnFrm()
  a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  int t;
  // first call ancestor to write common properties values
  VDKBObject::WriteOnFrm(fp,parentobj);
  // now we write component specific properties values.
  for( t = 0; vdk_props[t]; t++)
      fprintf(fp,"\n\t%s:%s;", vdk_props[t],(char*) GetProp(vdk_props[t]));
}
////////////////////////////////////////
//
//               PREPARE GUI WIDGETS
//
////////////////////////////////////////
/*
  This method is called by global MakeWidget() in vdkb_design.cc
  triggered when user wants drop a widget into a form.
 */
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable counter
  // to ensure unicity
  CLASS* component;
  // component name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2;
  else
    {
      // actually makes component
      // <buff> contains component pointer name (autogenerated)
      // may be your constructor is different
      // patch if necessary
      ////////////////////////////////////////
      component = new CLASS(buff,owner);
      ////////////////////////////////////////
    }
  /*
    in this part we write some widget specific initailization code,
    patch or comment out if not applicable to your widget
  */
  ////////////////////////////////////////////
  // add component to form
  return owner->AddToSelf(component,ev);
}
/*
  This is called by a global CreateSource() in vdkb_parser.cc.
*/
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  char tmp[256];
  // gets component name and parent name
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return NULL;
  source = new char[4096];
  // writes code to make the component
  // may be your constructor is different
  // patch if necessary
  ///////////////////////////////////////////////////////
  sprintf(tmp,"\n%s = new %s(this);",obj_name,VDK_CLASS);
  ///////////////////////////////////////////////////////
  strcpy(source,tmp);
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }
  /*
    in this part we write some component specific initialization code,
    reading properties values from .frm file and setting them
    to into widget.
  */
  ///////////////////////////////////////////////////////////////
  char local[64];
  int t = 0;
  for( t = 0; vdk_props[t]; t++)
    {
      /*
	since in .frm file property is suffixed with colon
	we have to precisely write it in order to be correctly
	parsed by parser.GetParam()
      */
      sprintf(local,"%s:",vdk_props[t]);
      if(parser.GetParam(arg,buffer,local) && strcmp(arg,NIHIL_PROP) )
	{
	  sprintf(tmp,"\n%s->%s = %s %s;",
		  obj_name,
		  vdk_props[t],
		  !strcmp(PROPERTY1,vdk_props[t]) ?
		  "(GtkCalendarDisplayOptions) " : "",
		  arg);
	  strcat(source,tmp);
	}
    }
  //////////////////////////////////////////////////////////////
  // get code that adds component to container
  parser.WriteCodeToPack(obj_parent,obj_name,source,buffer,tmp);
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}
/*
  Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
  reading .frm file.
  MakeGuiObjects() scans .frm file and call a global CreateWidget()
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner,
			      char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char arg[64],local[64];
  CLASS* component;
  // get component name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
    return false;

  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ?
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      // actually makes component
      // <obj_name> contains component pointer name (autogenerated)
      // may be your constructor is different
      // patch if necessary
      ///////////////////////////////////////////
      component = new CLASS(obj_name,owner);
      ///////////////////////////////////////////
      /*
	in this part we write some component specific initialization code,
	and we can't use vdk_props[] loop.
	Patch or comment out if not applicable to your widget
      */
      // set DisplayOptions property
      sprintf(local,"%s:",PROPERTY1);
      if(
	 parser.GetParam(arg,buffer,local) &&
	 strcmp(arg,NIHIL_PROP)
	 )
	{
	  component->DisplayOptions  = (GtkCalendarDisplayOptions) atoi(arg);
	  component->SetPropValue(PROPERTY1,arg);
	}
      ////////////////////////////////////////////
      // pack widget to container
      return owner->PackToSelf(component, container, buffer, parser);
    }
  else
    return false;
}
////////////////////////////
//   WIDGET INSPECTOR STUFF
////////////////////////////
/*
  This part of code is dedicated to widget inspector
  management. All widget described here have the
  purpose to let the end-user set component properties
  that will be showed at the bottom of the WI when end-user
  selects your component.
  So this part of code is only a footstep, you have to
  write your own, anyway i hope will be useful.
  I suggest to initially write components without this part
  and add it after you have checked component works
  properly withou properties setting.
*/
static  GtkCalendarDisplayOptions calOptions[CHECK_BUTTONS_NUMBER] =
{
  GTK_CALENDAR_SHOW_HEADING,
  GTK_CALENDAR_SHOW_DAY_NAMES,
  GTK_CALENDAR_NO_MONTH_CHANGE,
  GTK_CALENDAR_SHOW_WEEK_NUMBERS,
  GTK_CALENDAR_WEEK_START_MONDAY
};

static char *cbCaptions[CHECK_BUTTONS_NUMBER] = {
"Heading","Day names","No month change",
"Week numbers","Week start on monday"
};
/*
  This is called by Widget Inspector when end-user selects
  your component on edit form.
*/
VDKObjectContainer*
CLASS::ExtraWidget(VDKBObjectInspector* isp)
{
  // assign inspector for later use
  inspector = isp;
  /*
    generally we make a frame and fill it with widgets.
    Frame will be returned to widget inspector and
    showed at his bottom
  */
  VDKFrame* bframe = new VDKFrame(inspector,NULL,v_box,shadow_etched_in);
  /*
    now we make a table that will accomodate all widgets
    since we have 5 check buttons and a set button
    we will use a 3 rows - 2 columns  table like this:
    |-----------------------------|
    | <> show head  |  <> show day|
    |-------------- |-------------|
    | <> no ch month| <> show week|
    |-----------------------------|
    | <> start mond | Set button  |
    |-----------------------------|
  */
  VDKTable* table = new VDKTable(inspector,3,2,true);
  table->SetSize(219,-1);
  setButton = new VDKCustomButton(inspector,"Set");
  table->AddToCell(setButton,2,1);
  // set component as parent
  setButton->Parent(this);
  // now we connect "clicked" signal with signal response
  SignalConnect(setButton,"clicked",&CLASS::OnSetProperties);
  // makes all check buttons
  GtkCalendarDisplayOptions options = DisplayOptions;
  int t = 0;
  for(;t < CHECK_BUTTONS_NUMBER; t++)
    {
      checkButtons[t] = new VDKCheckButton( inspector, cbCaptions[t]);
      checkButtons[t]->Checked = options & calOptions[t];
    }
  // add cb to table
  table->AddToCell(checkButtons[0],0,0);
  table->AddToCell(checkButtons[1],0,1);
  table->AddToCell(checkButtons[2],1,0);
  table->AddToCell(checkButtons[3],1,1);
  table->AddToCell(checkButtons[4],2,0);
  /*
    we have finished, now add table to frame and return it
  */
  bframe->Add(table,l_justify,false,false,false);
  return bframe;
}
/*
signal response to clicked signal on setButton
*/
bool
CLASS::OnSetProperties(VDKObject* sender)
{
  GtkCalendarDisplayOptions options = (GtkCalendarDisplayOptions) 0;
  int t = 0;
  for(; t < CHECK_BUTTONS_NUMBER; t++)
    if(checkButtons[t]->Checked == true)
      {
	unsigned int o = (unsigned int) options;
	unsigned int ored = (unsigned int) calOptions[t];
	o |= ored;
	options = (GtkCalendarDisplayOptions) o;
      }
  sprintf(buff,"%u", (unsigned int) options);
  SetPropValue(PROPERTY1, buff);
  DisplayOptions =  options;
  inspector->FormNeedToBeChanged();
  // returning true, signal is stopped here.
  return true;
}






