/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * February 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_replace_h
#define _vdkb_replace_h
#include <vdk/vdk.h>
#include <vdkb/vdkb_locale.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_text.h>
#include <vdk/combo.h>
typedef VDKValueList<VDKString> SearchList;
typedef VDKValueListIterator<VDKString> SearchListIterator;

/*
 */
class VDKBReplaceForm: public VDKForm
{
  VDKCombo *find_combo,*replace_combo;
  VDKCheckButton *casesens,*wholeword,*regex,*prompt;
  VDKRadioButtonGroup *direction,*scope,*origin;
  VDKLabelButton *ok,*replaceall,*cancel;
  VDKBText* text;
  static SearchList find_history;
  static SearchList replace_history;
  int ReplaceText(int pos, char* match, char* rep);
 public:
  VDKBReplaceForm(VDKForm* owner, VDKBText* text);
  virtual ~VDKBReplaceForm();
  void Setup();
  bool Ok(VDKObject*);
  bool Cancel(VDKObject*);
  bool ReplaceAll(VDKObject*);
  DECLARE_SIGNAL_MAP(VDKBReplaceForm);
};
/*
 */
class VDKBReplaceDialog: public VDKForm
{
  VDKLabel *label;
  VDKLabelButton *ok,*cancel,*no_button;
  int *answer;
  char *match,*rep;;
 public:
  VDKBReplaceDialog(VDKForm* owner, 
		  char *match,
		  char* rep,
		  int *answer);
  virtual ~VDKBReplaceDialog();
  void Setup();
  bool Ok(VDKObject*);
  bool No(VDKObject*);
  bool Cancel(VDKObject*);  
  DECLARE_SIGNAL_MAP(VDKBReplaceDialog);
};

#endif
