/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_pixmap_h
#define _vdkb_pixmap_h
#include <vdk/vdk.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_widpopmenu.h>


class VDKBGuiForm;
class VDKBParser;
class VDKBPixmap: public VDKPixmap, public VDKBObject
{

 protected:
  bool OnEnter(VDKObject* sender,GdkEvent* ev);
  bool OnLeave(VDKObject* sender,GdkEvent* ev);
  bool ButtonPressed(VDKObject* sender,GdkEvent* ev);
  VDKBWidgetPopMenu *popmenu;
  VDKMenuItem *setsize,*delwidget;
  VDKEntry *pixfile;
  VDKLabelButton *shortname;
  VDKBObjectInspector* inspector; // object inspector
 public:
  static int Counter;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  VDKBPixmap(char* name,VDKForm* owner, char* file);
  VDKBPixmap(char* name, VDKForm* owner, char** pixdata);
  virtual ~VDKBPixmap() {}
  virtual int Type() { return vdkbclass_pixmap; }
  virtual char* VDKName() { return "VDKPixmap"; }
  virtual int isA() { return vdkbclass_pixmap; }
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  bool DelWidget(VDKObject*);
  bool SetWidgetSize(VDKObject* sender);
  void PopMenu() { popmenu->Popup(); }
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  bool OnSetGlyph(VDKObject*);
  bool OnSetShortName(VDKObject*);
  DECLARE_SIGNAL_LIST(VDKBPixmap);
  DECLARE_EVENT_LIST(VDKBPixmap);
};
#endif
