/*
 * Copyright (C) 1999 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jrh@jrhudson.demon.co.uk>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef  _vdkinput_h_
#define  _vdkinput_h_
#include <vdk/vdkobj.h>

#define INP_SIGNAL (user_signal+1)

class VDKInput: public VDKObject
{
protected:
  static void HandleIO(gpointer obj, gint source, GdkInputCondition condition);
  gint tag;
  int fd;
  GdkInputCondition condition;
    
public:
  VDKInput (VDKForm* obj, int fd,GdkInputCondition condition = GDK_INPUT_READ);
  virtual ~VDKInput();
  int getfd(void) {return fd;}
  void connect(int fd)
  {
      if(tag == 0)
          tag = gdk_input_add(fd, condition, VDKInput::HandleIO, this);
  };

  void release(void)
  {
      if(tag)
          gdk_input_remove(tag);
      tag = 0;
  }
};
#endif
