/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMCustomMethod.h,v 1.19 1998/01/05 01:12:39 tiggr Exp $  */

#import "OTMMethod.h"

@class OTMLabel;

@interface OTMCustomMethod: OTMMethod
{
  /* Iff !nil, the definition is a foreign one.  This specifies how
     foreign.  Most of the time probably "C".  */
  id <TLString> foreign;

  /* The body of this method, if it was defined (and not foreign).  */
  OTMCompound *body;

  /* The precondition, if specified.  */
  OTMExpr *precondition;

  /* The postcondition, if specified.  */
  OTMExpr *postcondition;

  /* Extensions of SELF for which the variable struct pointer has been
     output.  */
  TLSet *declared_extension_pointers;

  /* Iff !0, all arguments referencing objects.  */
  TLVector *referencing_args;

  /* Iff !0, the expression of variables containing the return value.  */
  OTMExpr *return_value;

  /* Iff !nil, the user specification of the return variables.  This is
     only used (searched) while we do not have a body.  When we get a
     body, these variables will be added to it.  */
  OTMTuple *return_vars;

  /* The first number of the arguments in the return value which are not a
     normal argument.  */
  int first_return_arg;

  /* Iff !NIL, this method employs a return statement, which jumps to this
     label.  */
  OTMLabel *return_label;

  /* Iff !0, the function epilogue should unprotect the stack.  */
  unsigned int stack_protected: 1;

  /* Iff !0, we need the thread-local variables pointer.  */
  unsigned int uses_thread_locals: 1;
}

#if CACHE_EXTENSION_POINTER
-(void) compileExtensionPointerDefinitions;
-(void) declareExtensionPointer: (OTMExtension *) ext;
#endif

-(id <TLString>) foreign;
-(void) setForeign: (id <TLString>) f;

-(OTMCompound *) body;

-(void) setBody: b;

-(void) setPrecondition: (OTMExpr *) prec;
-(OTMExpr *) precondition;

-(void) setPostcondition: (OTMExpr *) post;
-(OTMExpr *) postcondition;

-(TLVector *) collectPreconditions;
-(TLVector *) collectPostconditions;

-(TLVector *) referencingArguments;

-(OTMTuple *) returnVariables;
-(void) setReturnVariables: (OTMTuple *) tup;
-(BOOL) isReturnVariable: (OTMArgument *) v;

-(OTMExpr *) returnValue;
-(void) setReturnValue: (OTMExpr *) e;

-(OTMLabel *) setHaveReturnStatement;
-(BOOL) haveReturnStatement;

-(void) compile;

-(BOOL) stackProtected;
-(void) setStackProtected;

-(void) setNeedLocalPointer;

#ifdef OTMCUSTOMMETHOD_DECLARE_PRIVATE_METHODS

/* Return the result of formac'ing to S a cast, sans parenthesis, to this
   method's output function type.  */
-(id) outputCast: (id) s
   forInvocation: (OTMInvocation *) inv;

-(id) outputStartOfInvocation: (OTMInvocation *) inv;

#endif

@end
