/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMCast.m,v 1.15 1998/04/25 15:52:26 tiggr Exp $  */

#import "OTMCast.h"
#import "OTMType.h"

@implementation OTMCast

+(OTMCast *) castWithExpr: (OTMExpr *) e type: (OTMType *) t
{
  return [[self gcAlloc] initWithExpr: e type: t];
}

-(void) compile
{
  [expr compile];
  [super compile];
}

-(void) compileAssignment: (OTMExpr *) rhs
{
  [expr compileAssignment: rhs];

  /* ??? */
  /* formac (of, @"%@%@ = %@;", [self nlPlain], [expr outputReference],
	  [rhs result]); */
}

-(id) elaborate
{
  expr = [expr elaborate];

  return self;
}

-(void) gcReference
{
  MARK (expr);

  [super gcReference];
}

-initWithExpr: (OTMExpr *) e type: (OTMType *) t
{
  desired_type = t;
  expr = e;

  return [super initWithType: nil];
}

-(id) precompile
{
  expr = [expr precompile];
  desired_type = [desired_type precompile];

  return [super precompile];
}

-(id) resolveInContext: (OTMMeta *) current
{
  expr = [expr resolveInContext: current];

  return self;
}

-(TLCons *) resolveWithExpected: (TLCons *) expected
		    convertible: (OTMType *) to
			context: (OTMType *) cxt
			indices: (int *) indices
			  index: (int) index
{
  if (!type)
    {
      OTMType *t;

      expr = resolve_expr (expr, nil, desired_type, cxt);

      t = [expr type];
      if (t)
	{
	  OTMType *st = [t actualSelfNonPosing: cxt];
	  OTMType *dst = [desired_type actualSelfNonPosing: cxt];

	  if (![st validCastTo: dst]
	      && ![[st actualSelf: cxt] validCastTo: [dst actualSelf: cxt]])
	    error_for (self, @"invalid cast from %@ to %@",
		       type_name (t), type_name (desired_type));
	}

      type = desired_type;

      return CONS (expected
		   ? types_element_of (type, expected, cxt, indices, index, 1)
		   : type, nil);
    }

  return [super resolveWithExpected: expected convertible: to context: cxt
		indices: indices index: index];
}

-(id <TLString>) result
{
  return formac (nil, @"((%@) (%@))", type ? [type outputTypeName]
		 : [desired_type outputTypeName], [expr result]);
}

@end
