<copyright> Singly linked lists.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Cons.t,v 1.14 1998/08/17 14:56:37 tiggr Exp $</id>  </copyright>

implementation class
Cons: State

<doc> Return a newly allocated instance with the {a} and {d} as the {car}
    and {cdr}, respectively.  </doc>
instance (id)
  with (All, All) (a, d)
{
  = [[self alloc] init (a, d)];
}

<doc> Return a newly allocated instance with the {a} and {d} as the {car}
    and {cdr}, respectively.  The cdr {d} defaults to {nil}.  </doc>
instance (id)
  cons All a
     : All d = nil
{
  = [[self alloc] init (a, d)];
}

end;

implementation instance
Cons
{
  <doc> The element contained in this {Cons} cell, and the remainder of
      the list.  </doc>
  public Any car, cdr;
}

<doc> Designated initializer.  </doc>
protected id (self)
  init (All, All) (a, d)
{
  (car, cdr) = (Any (a), Any (d));
}

<doc> Return {YES}.  </doc>
boolean
  consp
{
  = TRUE;
}

<doc> Return the {(car, cdr)} in a tuple.  </doc>
(Any, Any)
  decons
{
  = (car, cdr);
}

<doc> Set the {car} to the object {c}.  </doc>
void
  set_car All c
{
  car = Any (c);
}

<doc> Set the {cdr} to the object {c}.  </doc>
void
  set_cdr All c
{
  cdr = Any (c);
}

<doc> Encode the receiving object to the {coder}.  </doc>
void
  encodeUsingCoder Encoder coder
{
  if (![coder hasBeenCodedFor [Cons self]])
    {
      [super encodeUsingCoder coder];
      [coder encode car];
      [coder encode cdr];
    }
}

<doc> Return {TRUE} if the receiving list is equal to the {other} list.
    Elements are compared with {equal}.  </doc>
boolean
  equal id other
{
  if (self == other)
    return TRUE;
  if (!other)
    return FALSE;

  All oa, od;
  (oa, od) = [other decons];

  if (!car != !oa || !cdr != !od)
    return FALSE;

  if (car != nil && ![oa equal car])
    return FALSE;

  = !cdr ? TRUE : [od equal cdr];
}

<doc> Use the {car} and {cdr} to compute a hash value for this {Cons} cell.
    </doc>
int (value)
  hash
{
  if (car != nil)
    value += [car hash];
  if (cdr != nil)
    value += [cdr hash];
}

<doc> Decode the receiving object from the {coder}.  </doc>
void
  initWithCoder Decoder coder
{
  if (![coder hasBeenCodedFor [Cons self]])
    {
      [super initWithCoder coder];
      (car, cdr) = ([coder decode], [coder decode]);
    }
}

<doc> Return the Cons cell whose car is {equal} to the {object}.  </doc>
id
  member All object
{
  if ((!object && !car) || (!object == !car) && [object equal car])
    = self;
  else if (cdr != nil)
    = [cdr member object];
}

<doc> Like {member}, but the element is identified on reference equality.
    </doc>
id
  memq All object
{
  if (object == car)
    = self;
  else if (cdr != nil)
    = [cdr memq object];
}

<doc> Output the list, of which the receiving {Cons} cell is the start, to
    the stream {s}.  </doc>
OutputStream
  write OutputStream s
{
  s = [["(" write s] print car];

  if (cdr == nil)
    s = [")" write s];
  else
    s = [cdr writeListElement s];

  = s;
}

<doc> Continue outputing the list, of which the receiving {Cons} cell is
    an element and not the head, to the stream {s}.  </doc>
OutputStream
  writeListElement OutputStream s
{
  s = [[" " write s] print car];

  if (cdr == nil)
    s = [")" write s];
  else
    s = [cdr writeListElement s];

  = s;
}

end;
