/* Interface to TLDictionary class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLDictionary.h,v 1.1 1998/01/08 16:13:12 tiggr Exp $  */

/* Hashtable for object values and object keys.  The keys respond to `hash'
   and `compare:'.  */

#import "TLObject.h"
#import "TLEnumerator.h"

/* A dictionary enumerator is one which you can ask for the key or the value
   of the current `object'.  The return value of the `-nextObject' is the
   key.  */
@protocol TLDictionaryEnumerator <TLEnumerator>

-key;
-value;

@end

@interface TLDictionary: TLObject
{
  /* The number of buckets.  */
  unsigned int nbucket;

  /*i The number of objects.  */
  unsigned int nobject;

  /*i The buckets.  */
  struct element **buckets;
}

/******************** creation ********************/

/* Return a new empty dictionary.  */
+(TLDictionary *) dictionary;

-(int) length;

/******************** enumeration ********************/

/* This is handy, but less safe than the other two enumerators.  */
-(id <TLDictionaryEnumerator>) enumerator;

/* Return an enumerator for the keys or values of this dictionary.  */
-(id <TLEnumerator>) keyEnumerator;
-(id <TLEnumerator>) valueEnumerator;

/******************** modification ********************/

/* Like `-objectForKey:', but return T if the value is NIL.  */
-member: k;

/* Return the object associated with the key K, or NIL if it could not be
   found.  */
-objectForKey: k;

/* Remove and return the association for K.  */
-removeKey: k;

/* Set O to be the object keyed on K and return the previous value.  There
   is no protection against O being NIL.  */
-setObject: o forKey: k;

#ifdef TLDICTIONARY_DECLARE_PRIVATE_METHODS

-(boolean) _bucketBeyondEnd: (int) bucket;

-(struct element *) _elementAtIndex: (int *) bucket : (int *) depth;

-_keyAtIndex: (int *) bucket : (int *) depth;

-_valueAtIndex: (int *) bucket : (int *) depth;

/* Resize the dictionary, by doubling + 1 its capacity.  This is expensive,
   since all (key, value) pairs basically are re-inserted.  */
-(void) reconfigure;

#endif

@end
