/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTISelector.m,v 1.12 1998/01/05 00:57:14 tiggr Exp $  */

#define LTISELECTOR_DECLARE_PRIVATE_METHODS
#import "LTISelector.h"

/* The registered selectors, on increasing identity.  */
TLVector *lti_numeric_selectors;

/* The numeric unique identity of the next selector to be allocated.  */
static int next_identity;

@implementation LTTSelector (Semantics)

+(id) semanticsForSelector: (LTTSelector *) sel
{
  LTISelector *s = [[CO_LTISelector gcAlloc] initWithSelector: sel];

  [lti_numeric_selectors addElement: s];

  return s;
} /* +semanticsForSelector: */

@end

@implementation LTISelector

+initialize
{
  if (!lti_numeric_selectors)
    {
      lti_numeric_selectors = [TLVector vector];
      [lti_numeric_selectors gcLock];
    }

  return self;
} /* +initialize */

+(int) numSelectors
{
  return next_identity;
} /* +numSelectors */

+(LTISelector *) selectorIdentified: (int) ident
{
  return [lti_numeric_selectors _elementAtIndex: ident];
} /* +selectorIdentified: */

+(TLVector *) selectors
{
  return lti_numeric_selectors;
}

-(void) addMethod: (LTIMethod *) m
{
  [methods addElement: m];
}

-equal: (LTISelector *) other
{
  return self == other ? Qt : nil;
}

-(void) gcReference
{
  MARK (structure);
  MARK (methods);

  [super gcReference];
}

-(int) identity
{
  return identity;
}

-initWithSelector: (LTTSelector *) sel
{
  if (![super init])
    return nil;

  structure = sel;
  methods = [TLVector vector];
  identity = next_identity++;

  return self;
}

-(TLVector *) methods
{
  return methods;
}

-(void) print: (id <TLMutableStream>) stream quoted: (BOOL) qp
{
  const char *s = class_get_class_name (isa);

  formac (stream, @"(%s %x %@)", s, self, [[structure lttName] internal]);
}

-(LTTSelector *) structure
{
  return structure;
}

@end
