/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTIMeta.h,v 1.13 1998/01/05 00:57:09 tiggr Exp $  */

#import <ltt/ltt.h>

@class LTIClass, LTIExtension, LTIInstance, LTIMethod;

/* Information on all classes and instances, for which
	FORALL i, j: i < j: x[i] isSuperof x[j]
   Only set after `+generateClassSequences'.  */
TLVector *ordered_instances, *ordered_classes;
TLVector *ordered_state_instances, *ordered_state_classes;

@interface LTIMeta: LTTTop
{
  /* Our structural information.  */
  LTTMeta *structure;

  /* Why is this here, if only tr is going to use it?  We want extensions
     that can add instance variables!  :-) (Or easy posing, or simply
     better methods to do allocation.  But adding extensions is so much
     easier that subclassing, be it posing or not, or method protocols.)  */
  id imps;

  /* Same question.  Super references.  */
  TLSet *ref_supers;

  /* When searching or something similar, this is the mark.  */
  int mark;

  /* Deferred methods declared by this meta.  */
  TLSet *deferred_methods;

  /* All deferred selectors, self-declared and inherited.  */
  TLSet *deferred_selectors;

  /* Various flags, for your pleasure.  */
  unsigned int defined: 1;

  /* Iff !0, we've declared the type of references to ourselves.  */
  unsigned int declared_ref: 1;
  /* Iff !0, we've declared the structure of the object layout as we
     currently know it.  */
  unsigned int declared_str: 1;
  unsigned int flag0: 1, flag1: 1, flag2: 1;
}

+(void) generateClassSequences;

-(void) addSuperReference: (LTIMeta *) m;

-(void) addDeferredMethod: (LTIMethod *) m;

-(BOOL) classp;

-(BOOL) haveDeferredMethods;

-(TLSet *) deferredSelectors;

-(id) implementations;

-(LTTMeta *) structure;

#ifdef LTIMETA_DECLARE_PRIVATE_METHODS

-(TLCons *) generateClassSequence: (TLCons *) list
			stateOnly: (BOOL) statep
			     mark: (int) k;

-initWithStructure: (LTTMeta *) str;

#endif

@end
