/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1999 David Baum.
 * All Rights Reserved.
 */



#ifndef __IncDecExpr_h
#define __IncDecExpr_h

#ifndef __Expr_h
#include "Expr.h"
#endif


class IncDecExpr : public Expr
{
public:
			IncDecExpr(int var, bool inc, bool pre);
			~IncDecExpr();

	virtual IncDecExpr*	Clone(Mapping *b) const;
	virtual bool		Contains(int var) const;
	virtual RCX_Value	EmitAny_(Bytecode &b, const LexLocation *loc) const;
	virtual bool		EmitTo_(Bytecode &b, int dst, const struct LexLocation *loc) const;
	virtual bool		EmitSide_(Bytecode &b, const struct LexLocation *loc) const;

private:
	int			fVar;
	bool		fInc;
	bool		fPre;
};



#endif
