/* 
 *   $Id: get_amode.c,v 1.2 1998/06/02 19:01:12 thakur Exp $    
 *
 *   Copyright (C) 1997 University of Chicago. 
 *   See COPYRIGHT notice in top-level directory.
 */

#include "mpioimpl.h"

/*@
    MPI_File_get_amode - Returns the file access mode

Input Parameters:
. fh - file handle (handle)

Output Parameters:
. amode - access mode (integer)

.N fortran
@*/
int MPI_File_get_amode(MPI_File fh, int *amode)
{
    if ((fh <= (MPI_File) 0) || (fh->cookie != ADIOI_FILE_COOKIE)) {
	printf("MPI_File_get_amode: Invalid file handle\n");
	MPI_Abort(MPI_COMM_WORLD, 1);
    }

    *amode = fh->access_mode;
    return MPI_SUCCESS;
}
