/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollBar;
import com.sun.java.swing.JSlider;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.event.ChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.PrintJob;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class Histwin
extends JFrame
implements ActionListener {
    ClogDisplay parent;
    HistCanvas canvas;
    public CLOG_STATE stateDef;
    JSlider binSlider;
    JScrollBar hbar;
    JLabel stateNameLabel;
    MyTextField numInstField;
    MyTextField maxLenField;
    MyTextField leastLenField;
    MyTextField statesInViewField;
    MyTextField pcInViewField;
    MyTextField areaField;
    MyTextField bAreaField;
    MyTextField startLenField;
    MyTextField endLenField;
    MyTextField numBinsField;
    MyTextField maxNumBinsField;
    MyTextField zFacField;
    MyTextField cursorField;
    JMenu regionsMenu;

    public Histwin(CLOG_STATE cLOG_STATE, ClogDisplay clogDisplay) {
        super("Histogram: " + cLOG_STATE.description.desc);
        this.parent = clogDisplay;
        this.stateDef = cLOG_STATE;
        this.setup();
    }

    void setup() {
        this.waitCursor();
        Dimension dimension = new Dimension(((Window)((Object)this)).getToolkit().getScreenSize());
        ((Component)((Object)this)).setSize(new Dimension(dimension.width / 2, dimension.height / 2));
        this.setupCanvas();
        this.setupPanels();
        ((Component)((Object)this)).setVisible(true);
        this.drawCanvas();
        this.setupEventHandlers();
        this.normalCursor();
    }

    void setupEventHandlers() {
        this.hbar.addAdjustmentListener((AdjustmentListener)this.canvas);
        this.binSlider.addChangeListener((ChangeListener)this.canvas);
        this.startLenField.addActionListener(this.canvas);
        this.startLenField.setActionCommand("Change Start Len");
        this.endLenField.addActionListener(this.canvas);
        this.endLenField.setActionCommand("Change End Len");
        this.numBinsField.addActionListener(this.canvas);
        this.numBinsField.setActionCommand("Change numBins");
        this.maxNumBinsField.addActionListener(this.canvas);
        this.maxNumBinsField.setActionCommand("Change maxNumBins");
        this.zFacField.addActionListener(this.canvas);
        this.zFacField.setActionCommand("Change Zoom Fac");
        ((Window)((Object)this)).addWindowListener(new 1());
    }

    void setupCanvas() {
        this.canvas = new HistCanvas(this);
    }

    void drawCanvas() {
        this.canvas.init();
    }

    void setupPanels() {
        this.getContentPane().setLayout(new BorderLayout());
        Border border = BorderFactory.createLoweredBevelBorder();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel = new JPanel((LayoutManager)new GridBagLayout());
        JPanel jPanel2 = new JPanel((LayoutManager)new GridBagLayout());
        Border border2 = BorderFactory.createEmptyBorder((int)4, (int)4, (int)2, (int)2);
        jPanel2.setBorder((Border)BorderFactory.createCompoundBorder((Border)border2, (Border)border));
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)new JLabel("cursor"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.cursorField = new MyTextField("", 10, false);
        jPanel2.add((Component)((Object)this.cursorField), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel2.add((Component)new JLabel("sec"), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)new JLabel("Total number of instances"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.numInstField = new MyTextField(10, false);
        jPanel2.add((Component)((Object)this.numInstField), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)new JLabel("Duration of shortest instance "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.leastLenField = new MyTextField(10, false);
        jPanel2.add((Component)((Object)this.leastLenField), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel2.add((Component)new JLabel("sec"), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)new JLabel("Duration of longest instance"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.maxLenField = new MyTextField(10, false);
        jPanel2.add((Component)((Object)this.maxLenField), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel2.add((Component)new JLabel("sec"), gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel((LayoutManager)new GridBagLayout());
        border2 = BorderFactory.createEmptyBorder((int)4, (int)2, (int)2, (int)4);
        jPanel3.setBorder((Border)BorderFactory.createCompoundBorder((Border)border2, (Border)border));
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 0.0;
        jPanel3.add((Component)new JLabel("States in View"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.statesInViewField = new MyTextField("", 10, false);
        jPanel3.add((Component)((Object)this.statesInViewField), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        jPanel3.add((Component)new JLabel("Percent of total states "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.pcInViewField = new MyTextField("", 10, false);
        jPanel3.add((Component)((Object)this.pcInViewField), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel3.add((Component)new JLabel("%"), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        jPanel3.add((Component)new JLabel("Start state length"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.startLenField = new MyTextField("", 10, true);
        jPanel3.add((Component)((Object)this.startLenField), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel3.add((Component)new JLabel("sec"), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        jPanel3.add((Component)new JLabel("End state length"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.endLenField = new MyTextField("", 10, true);
        jPanel3.add((Component)((Object)this.endLenField), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel3.add((Component)new JLabel("sec"), gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "North");
        JPanel jPanel4 = new JPanel((LayoutManager)new BorderLayout());
        JPanel jPanel5 = new JPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        this.stateNameLabel = new JLabel();
        jPanel5.add((Component)this.stateNameLabel, gridBagConstraints);
        this.stateNameLabel.setFont(new Font("Serif", 1, 18));
        this.stateNameLabel.setBorder(BorderFactory.createEmptyBorder((int)2, (int)4, (int)2, (int)2));
        JPanel jPanel6 = new JPanel((LayoutManager)new GridBagLayout());
        border2 = BorderFactory.createEmptyBorder((int)2, (int)4, (int)2, (int)2);
        jPanel6.setBorder((Border)BorderFactory.createCompoundBorder((Border)border2, (Border)border));
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        jPanel6.add((Component)new JLabel("Zoom Factor "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.zFacField = new MyTextField("", 5, true);
        jPanel6.add((Component)((Object)this.zFacField), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        JPanel jPanel7 = new JPanel((LayoutManager)new GridLayout(1, 3));
        jPanel7.add((Component)((Object)new MyButton("In", "Zoom In Horizontally", this.canvas)));
        jPanel7.add((Component)((Object)new MyButton("Out", "Zoom Out Horizontally", this.canvas)));
        jPanel7.add((Component)((Object)new MyButton("Reset", "Draw entire data in viewport", this.canvas)));
        jPanel6.add((Component)jPanel7, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        jPanel5.add((Component)jPanel6, gridBagConstraints);
        gridBagConstraints.fill = 0;
        JPanel jPanel8 = new JPanel((LayoutManager)new GridBagLayout());
        border2 = BorderFactory.createEmptyBorder((int)2, (int)4, (int)2, (int)2);
        jPanel8.setBorder((Border)BorderFactory.createCompoundBorder((Border)border2, (Border)border));
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel8.add((Component)new JLabel("Max Number of bins "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.maxNumBinsField = new MyTextField("", 5, true);
        jPanel8.add((Component)((Object)this.maxNumBinsField), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.binSlider = new JSlider();
        jPanel8.add((Component)this.binSlider, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel8.add((Component)new JLabel("Number of bins"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.numBinsField = new MyTextField("", 5, true);
        jPanel8.add((Component)((Object)this.numBinsField), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        jPanel5.add((Component)jPanel8, gridBagConstraints);
        gridBagConstraints.fill = 0;
        JPanel jPanel9 = new JPanel((LayoutManager)new BorderLayout());
        border2 = BorderFactory.createEmptyBorder((int)2, (int)4, (int)2, (int)2);
        jPanel9.setBorder((Border)BorderFactory.createCompoundBorder((Border)border2, (Border)border));
        jPanel9.add((Component)new JLabel("Regions (Top X %) assuming normal distribution"), "North");
        JPanel jPanel10 = new JPanel((LayoutManager)new GridLayout(3, 3));
        jPanel10.add((Component)((Object)new MyButton("1%", this.canvas.tAL)));
        jPanel10.add((Component)((Object)new MyButton("5%", this.canvas.tAL)));
        jPanel10.add((Component)((Object)new MyButton("10%", this.canvas.tAL)));
        jPanel10.add((Component)((Object)new MyButton("20%", this.canvas.tAL)));
        jPanel10.add((Component)((Object)new MyButton("30%", this.canvas.tAL)));
        jPanel10.add((Component)((Object)new MyButton("50%", this.canvas.tAL)));
        this.areaField = new MyTextField("", 4, false);
        jPanel10.add((Component)((Object)this.areaField), gridBagConstraints);
        jPanel9.add((Component)jPanel10, "South");
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        jPanel5.add((Component)jPanel9, gridBagConstraints);
        jPanel9 = new JPanel((LayoutManager)new BorderLayout());
        border2 = BorderFactory.createEmptyBorder((int)2, (int)4, (int)2, (int)2);
        jPanel9.setBorder((Border)BorderFactory.createCompoundBorder((Border)border2, (Border)border));
        jPanel9.add((Component)new JLabel("Regions (Bottom X %) assuming normal distribution"), "North");
        jPanel10 = new JPanel((LayoutManager)new GridLayout(3, 3));
        jPanel10.add((Component)((Object)new MyButton("1%", this.canvas.bAL)));
        jPanel10.add((Component)((Object)new MyButton("5%", this.canvas.bAL)));
        jPanel10.add((Component)((Object)new MyButton("10%", this.canvas.bAL)));
        jPanel10.add((Component)((Object)new MyButton("20%", this.canvas.bAL)));
        jPanel10.add((Component)((Object)new MyButton("30%", this.canvas.bAL)));
        jPanel10.add((Component)((Object)new MyButton("50%", this.canvas.bAL)));
        this.bAreaField = new MyTextField("", 4, false);
        jPanel10.add((Component)((Object)this.bAreaField), gridBagConstraints);
        jPanel9.add((Component)jPanel10, "South");
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        jPanel5.add((Component)jPanel9, gridBagConstraints);
        jPanel4.add((Component)jPanel5, "North");
        jPanel4.add((Component)new JPanel(), "Center");
        this.getContentPane().add((Component)jPanel4, "West");
        JPanel jPanel11 = new JPanel((LayoutManager)new BorderLayout());
        border2 = BorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)4);
        jPanel11.setBorder((Border)BorderFactory.createCompoundBorder((Border)border2, (Border)border));
        JPanel jPanel12 = new JPanel((LayoutManager)new BorderLayout());
        jPanel12.add((Component)((Object)this.canvas), "Center");
        jPanel11.add((Component)jPanel12, "Center");
        this.hbar = new JScrollBar(0);
        jPanel11.add((Component)this.hbar, "South");
        this.getContentPane().add((Component)jPanel11, "Center");
        JPanel jPanel13 = new JPanel((LayoutManager)new GridLayout(1, 5));
        border2 = BorderFactory.createEmptyBorder((int)2, (int)4, (int)4, (int)4);
        jPanel13.setBorder((Border)BorderFactory.createCompoundBorder((Border)border2, (Border)border));
        jPanel13.add((Component)((Object)new MyButton("Resize to fit", "Set height of histograms to fit display", this.canvas)));
        jPanel13.add((Component)((Object)new MyButton("Blink states", "Blink states in histogram in time lines display", this.canvas)));
        JMenuBar jMenuBar = new JMenuBar();
        this.regionsMenu = new JMenu("Selected Regions", true);
        this.regionsMenu.setToolTipText("Contains list of all selected regions. Click on selected region to disable blinking");
        jMenuBar.add(this.regionsMenu);
        jPanel13.add((Component)jMenuBar);
        MyButton myButton = new MyButton("Print", "Print display to file or printer", this);
        jPanel13.add((Component)((Object)myButton));
        jPanel13.add((Component)((Object)new MyButton("Close", "Close window", this)));
        this.getContentPane().add((Component)jPanel13, "South");
    }

    private void Print() {
        this.waitCursor();
        if (this.parent.checkPrintAllowed()) {
            String string = "Jumpshot:" + this.parent.parent.logFileName;
            PrintJob printJob = ((Window)((Object)this)).getToolkit().getPrintJob((Frame)((Object)this), string, this.parent.printPrefs);
            if (printJob != null) {
                PrintDlg printDlg = this.parent.getPrintDlg();
                printDlg.reset(printJob, this);
            }
        }
        this.normalCursor();
    }

    void waitCursor() {
        ((Component)((Object)this)).setCursor(new Cursor(3));
    }

    void normalCursor() {
        ((Component)((Object)this)).setCursor(new Cursor(0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Close")) {
            this.kill();
            return;
        }
        if (string.equals("Print")) {
            this.Print();
        }
    }

    void kill() {
        if (this.canvas != null) {
            this.canvas.unmarkBlinkAll();
            this.parent.canvas.Refresh();
            this.canvas.kill();
            this.canvas = null;
        }
        ((Window)((Object)this)).dispose();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            Histwin.this.kill();
        }

        /* synthetic */ 1() {
        }
    }
}

