/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.SpinnerUI;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import com.sun.java.swing.plaf.basic.Spinner;
import com.sun.java.swing.plaf.basic.StringSpinner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;

public class BasicSpinnerUI
extends SpinnerUI
implements Serializable {
    static final Border defaultBorder = BorderFactory.createLoweredBevelBorder();
    protected Dimension d;
    protected int ascent;
    protected FontMetrics fm;
    protected static SpinnerUI spinnerUI;

    public static ComponentUI createUI(JComponent jComponent) {
        if (spinnerUI == null) {
            spinnerUI = new BasicSpinnerUI();
        }
        return spinnerUI;
    }

    public void installUI(JComponent jComponent) {
        ((Component)jComponent).setFont(BasicGraphicsUtils.controlFont);
        if (jComponent.getBorder() == null) {
            jComponent.setBorder(defaultBorder);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.resetKeyboardActions();
        if (jComponent.getBorder() == defaultBorder) {
            jComponent.setBorder(null);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Spinner spinner = (Spinner)jComponent;
        this.getMinimumSize(jComponent);
        Insets insets = spinner.getBorder().getBorderInsets(spinner);
        graphics.setColor(spinner.getBackgroundColor());
        graphics.fillRect(insets.left, insets.top, this.d.width - (insets.left + insets.right), this.d.height - (insets.top + insets.bottom));
        if (spinner.hasFocus()) {
            graphics.setColor(new Color(0, 0, 150));
            graphics.fillRect(insets.left + 2, insets.top + 2, this.d.width - (insets.left + insets.right + 4), this.d.height - (insets.top + insets.bottom + 4));
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        if (spinner instanceof StringSpinner) {
            StringSpinner stringSpinner = (StringSpinner)spinner;
            String string = String.valueOf(stringSpinner.getValueName()) + (stringSpinner.getText() != null ? stringSpinner.getText() : "");
            if (stringSpinner.getTypedString() == null) {
                graphics.drawString(string, insets.left + 2, this.ascent + insets.top + 2);
                return;
            }
            graphics.setColor(Color.lightGray);
            graphics.drawString(string, insets.left + 2, this.ascent + insets.top + 2);
            graphics.setColor(Color.white);
            graphics.drawString(string.substring(0, stringSpinner.getTypedString().length()), insets.left + 2, this.ascent + insets.top + 2);
            return;
        }
        String string = Integer.toString(spinner.getValue());
        if (spinner.getLeadingPad() != -1) {
            int n = spinner.getDigits() - string.length();
            String string2 = Integer.toString(spinner.getLeadingPad());
            int n2 = 0;
            while (n2 < n) {
                string = String.valueOf(string2) + string;
                ++n2;
            }
        }
        string = String.valueOf(string) + (spinner.getText() != null ? spinner.getText() : "");
        graphics.drawString(string, this.d.width - this.fm.stringWidth(string) - insets.right - 2, this.ascent + insets.bottom + 2);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Serializable serializable;
        Spinner spinner = (Spinner)jComponent;
        this.fm = spinner.getFontMetrics(spinner.getFont());
        int n = 0;
        if (spinner instanceof StringSpinner) {
            serializable = (StringSpinner)spinner;
            String[] stringArray = serializable.getNameArray();
            int n2 = stringArray.length;
            while (--n2 >= 0) {
                int n3 = this.fm.stringWidth(stringArray[n2]);
                if (n3 <= n) continue;
                n = n3;
            }
        } else {
            n = this.fm.stringWidth("0") * spinner.getDigits();
        }
        if (spinner.getText() != null) {
            n += this.fm.stringWidth(spinner.getText());
        }
        serializable = spinner.getBorder().getBorderInsets(spinner);
        this.d = new Dimension(n + ((Insets)serializable).left + ((Insets)serializable).right + 4, this.fm.getHeight() + ((Insets)serializable).top + ((Insets)serializable).bottom + 4);
        this.ascent = this.fm.getAscent();
        return this.d;
    }
}

