open GtkObj
open GtkEasy.Layout

(* A more sophisticated "hello world" *)

let hello_label = label_new "hello world!" 

let hello_button = button_new_with_label "hello!"

let quit_button = button_new_with_label "quit" 

let window_structure = 
  Box(Vert,
      [ Widget( hello_label :> widget ),  fill_5  ;
        Widget( hello_button :> widget ), fixed_5 ;
        Widget( quit_button :> widget ),  fixed_5 ])
    (* We define here a more complete structure,
       with two additional buttons.  All three widgets
       are aligned in a vertical box.  The hello_label
       widget will fill the remaining available 
       vertical space if there is any *)

let window = make_window_from_structure window_structure "Hello world window" 
       
let _ = window #connect_delete_event( fun () -> Gtk.main_quit(); false )

let say_hello () = hello_label #set_text "Yes, hello!"
    
let _ = hello_button #connect_clicked say_hello

let _ = quit_button #connect_clicked Gtk.main_quit 

let _ = window #set_usize 150 250 ;;
  (* This is one of the ways to make the window bigger
     than it would otherwise be at start-up.
     Actually, set_usize sets the minimum dimensions
     the user will be allowed to resize the window to.
     The method #set_usize can be used individually with
     any widget.  *)

let _ = window #show


let _ = GtkThr.main ()
  (* And at last enter the event loop. *)

