! 1 
! 1 /* express.c - expression parsing routines for bcc */
! 2 
! 3 /* Copyright (C) 1992 Bruce Evans */
! 4 
! 5 #include "bcc.h"
! 1 
! 1 /* Copyright (C) 1997 Robert de Bath <robert@mayday.cix.co.uk>
! 2  * This file is part of the Linux-8086 Development environment and is
! 3  * distributed under the GNU General Public License. */
! 4 
! 5 #ifdef _AIX
! 6 #include <sys/types.h>	/* AIX 4.1 + GCC seems to need this */
! 7 #endif
! 8 
! 9 /* Ansi C has certain guarentees ... except under MSdross :-( */
! 10 
! 11 #ifdef __STDC__
! 12 #ifndef MSDOS
! 13 #include <stdlib.h>
! 14 #include <unistd.h>
! 15 #include <string.h>
! 16 #include <fcntl.h>
! 17 #endif
! 18 
! 19 #define P(x)	x
! 20 
! 21 #else
! 22 #define P(x)	()
! 23 #endif
! 24 
! 25 #include "const.h"
! 1 
! 1 /* const.h - constants for bcc */
! 2 
! 3 /* Copyright (C) 1992 Bruce Evans */
! 4 
! 5 #ifdef __STDC__
! 6 #include <stdlib.h>
! 7 #else
! 8 #include <malloc.h>
! 1 
! 1 
! 2 #ifndef __MALLOC_H
! 3 #define __MALLOC_H
! 4 #include <features.h>
! 1 
! 1 
! 2 #ifndef __FEATURES_H
! 3 #define __FEATURES_H
! 4 
! 5 #ifdef __STDC__
! 6 
! 7 #define __P(x) x
! 8 #define __const const
! 9 
! 10 /* Almost ansi */
! 11 #if __STDC__ != 1
! 12 #define const
! 13 #define volatile
! 14 #endif
! 15 
! 16 #else /* K&R */
! 17 
! 18 #define __P(x) ()
! 19 #define __const
! 20 #define const
! 21 #define volatile
! 22 
! 23 #endif
! 24 
! 25 /* Pick an OS sysinclude directory */
! 26 /* Use with #include __SYSINC__(errno.h) */
! 27 
! 28 #ifdef __ELKS__
! 29 #define __SYSINC__(_h_file_) <linuxmt/_h_file_>
! 30 #endif
! 31 
! 32 #ifdef __linux__
! 33 #undef linux	/* Eyuk! */
! 34 #define __SYSINC__(_h_file_) <linux/_h_file_>
! 35 #endif
! 36 
! 37 #ifdef __MSDOS__
! 38 #define __SYSINC__(_h_file_) <msdos/_h_file_>
! 39 #endif
! 40 
! 41 #ifndef __SYSINC__
! 42 #define __SYSINC__(_h_file_) <generic/_h_file_>
! 43 #endif
! 44 
! 45 /* No C++ */
! 46 #define __BEGIN_DECLS
! 47 #define __END_DECLS
! 48 
! 49 /* GNUish things */
! 50 #define __CONSTVALUE
! 51 #define __CONSTVALUE2
! 52 
! 53 #include <sys/cdefs.h>
! 1 
! 1 
! 2 #ifndef __SYS_CDEFS_H
! 3 #define __SYS_CDEFS_H
! 4 #include <features.h>
! 1 
! 1 
! 2 #ifndef __FEATURES_H
! 3 #define __FEATURES_H
! 4 
! 5 #ifdef __STDC__
! 6 
! 7 #define __P(x) x
! 8 #define __const const
! 9 
! 10 /* Almost ansi */
! 11 #if __STDC__ != 1
! 12 #define const
! 13 #define volatile
! 14 #endif
! 15 
! 16 #else /* K&R */
! 17 
! 18 #define __P(x) ()
! 19 #define __const
! 20 #define const
! 21 #define volatile
! 22 
! 23 #endif
! 24 
! 25 /* Pick an OS sysinclude directory */
! 26 /* Use with #include __SYSINC__(errno.h) */
! 27 
! 28 #ifdef __ELKS__
! 29 #define __SYSINC__(_h_file_) <linuxmt/_h_file_>
! 30 #endif
! 31 
! 32 #ifdef __linux__
! 33 #undef linux	/* Eyuk! */
! 34 #define __SYSINC__(_h_file_) <linux/_h_file_>
! 35 #endif
! 36 
! 37 #ifdef __MSDOS__
! 38 #define __SYSINC__(_h_file_) <msdos/_h_file_>
! 39 #endif
! 40 
! 41 #ifndef __SYSINC__
! 42 #define __SYSINC__(_h_file_) <generic/_h_file_>
! 43 #endif
! 44 
! 45 /* No C++ */
! 46 #define __BEGIN_DECLS
! 47 #define __END_DECLS
! 48 
! 49 /* GNUish things */
! 50 #define __CONSTVALUE
! 51 #define __CONSTVALUE2
! 52 
! 53 #include <sys/cdefs.h>
! 54 
! 55 #endif
! 56 
! 56 
! 57 
! 5 
! 6 #if defined (__STDC__) && __STDC__
! 7 
! 8 #define	__CONCAT(x,y)	x ## y
! 9 #define	__STRING(x)	#x
! 10 
! 11 /* This is not a typedef so `const __ptr_t' does the right thing.  */
! 12 #define __ptr_t void *
! 13 typedef long double __long_double_t;
! 14 
! 15 #else
! 16 
! 17 #define	__CONCAT(x,y)	x/**/y
! 18 #define	__STRING(x)	"x"
! 19 
! 20 #define __ptr_t char *
! 21 
! 22 #ifndef __HAS_NO_FLOATS__
! 23 typedef double __long_double_t;
! 24 #endif
! 25 
! 26 #endif
! 27 
! 28 /* No C++ */
! 29 #define __BEGIN_DECLS
! 30 #define __END_DECLS
! 31 
! 32 /* GNUish things */
! 33 #define __CONSTVALUE
! 34 #define __CONSTVALUE2
! 35 
! 36 #endif
! 37 
! 37 
! 38 
! 54 
! 55 #endif
! 56 
! 56 
! 57 
! 5 #include <sys/types.h>
! 1 
! 1 #include <features.h>
! 1 
! 1 
! 2 #ifndef __FEATURES_H
! 3 #define __FEATURES_H
! 4 
! 5 #ifdef __STDC__
! 6 
! 7 #define __P(x) x
! 8 #define __const const
! 9 
! 10 /* Almost ansi */
! 11 #if __STDC__ != 1
! 12 #define const
! 13 #define volatile
! 14 #endif
! 15 
! 16 #else /* K&R */
! 17 
! 18 #define __P(x) ()
! 19 #define __const
! 20 #define const
! 21 #define volatile
! 22 
! 23 #endif
! 24 
! 25 /* Pick an OS sysinclude directory */
! 26 /* Use with #include __SYSINC__(errno.h) */
! 27 
! 28 #ifdef __ELKS__
! 29 #define __SYSINC__(_h_file_) <linuxmt/_h_file_>
! 30 #endif
! 31 
! 32 #ifdef __linux__
! 33 #undef linux	/* Eyuk! */
! 34 #define __SYSINC__(_h_file_) <linux/_h_file_>
! 35 #endif
! 36 
! 37 #ifdef __MSDOS__
! 38 #define __SYSINC__(_h_file_) <msdos/_h_file_>
! 39 #endif
! 40 
! 41 #ifndef __SYSINC__
! 42 #define __SYSINC__(_h_file_) <generic/_h_file_>
! 43 #endif
! 44 
! 45 /* No C++ */
! 46 #define __BEGIN_DECLS
! 47 #define __END_DECLS
! 48 
! 49 /* GNUish things */
! 50 #define __CONSTVALUE
! 51 #define __CONSTVALUE2
! 52 
! 53 #include <sys/cdefs.h>
! 54 
! 55 #endif
! 56 
! 56 
! 57 
! 2 #include <stddef.h>
! 1 
! 1 /* Copyright (C) 1996 Robert de Bath <rdebath@cix.compulink.co.uk>
! 2  * This file is part of the Linux-8086 C library and is distributed
! 3  * under the GNU Library General Public License.
! 4  */
! 5 /* We don't care, ignore GCC's __need hackery */
! 6 
! 7 #ifndef __STDDEF_H
! 8 #define __STDDEF_H
! 9 
! 10 #include <sys/types.h>
! 1 
! 1 #include <features.h>
! 1 
! 1 
! 2 #ifndef __FEATURES_H
! 3 #define __FEATURES_H
! 4 
! 5 #ifdef __STDC__
! 6 
! 7 #define __P(x) x
! 8 #define __const const
! 9 
! 10 /* Almost ansi */
! 11 #if __STDC__ != 1
! 12 #define const
! 13 #define volatile
! 14 #endif
! 15 
! 16 #else /* K&R */
! 17 
! 18 #define __P(x) ()
! 19 #define __const
! 20 #define const
! 21 #define volatile
! 22 
! 23 #endif
! 24 
! 25 /* Pick an OS sysinclude directory */
! 26 /* Use with #include __SYSINC__(errno.h) */
! 27 
! 28 #ifdef __ELKS__
! 29 #define __SYSINC__(_h_file_) <linuxmt/_h_file_>
! 30 #endif
! 31 
! 32 #ifdef __linux__
! 33 #undef linux	/* Eyuk! */
! 34 #define __SYSINC__(_h_file_) <linux/_h_file_>
! 35 #endif
! 36 
! 37 #ifdef __MSDOS__
! 38 #define __SYSINC__(_h_file_) <msdos/_h_file_>
! 39 #endif
! 40 
! 41 #ifndef __SYSINC__
! 42 #define __SYSINC__(_h_file_) <generic/_h_file_>
! 43 #endif
! 44 
! 45 /* No C++ */
! 46 #define __BEGIN_DECLS
! 47 #define __END_DECLS
! 48 
! 49 /* GNUish things */
! 50 #define __CONSTVALUE
! 51 #define __CONSTVALUE2
! 52 
! 53 #include <sys/cdefs.h>
! 54 
! 55 #endif
! 56 
! 56 
! 57 
! 2 #include <stddef.h>
! 1 
! 1 /* Copyright (C) 1996 Robert de Bath <rdebath@cix.compulink.co.uk>
! 2  * This file is part of the Linux-8086 C library and is distributed
! 3  * under the GNU Library General Public License.
! 4  */
! 5 /* We don't care, ignore GCC's __need hackery */
! 6 
! 7 #ifndef __STDDEF_H
! 8 #define __STDDEF_H
! 9 
! 10 #include <sys/types.h>
! 11 
! 12 #ifndef NULL
! 13 #define NULL ((void*)0)
! 14 #endif
! 15 
! 16 #endif /* __STDDEF_H */
! 17 
! 17 
! 18 
! 3 #include __SYSINC__(types.h)
! 1 
! 1 #ifndef __LINUXMT_TYPES_H
! 2 #define __LINUXMT_TYPES_H
! 3 
! 4 #include <asm/types.h>
! 1 
! 1 
! 2 /* asm/types.h - Basic sized C data types. */
! 3 
! 4 #ifndef __ASM_8086_TYPES
! 5 #define __ASM_8086_TYPES
! 6 	
! 7 /* First we define all of the __u and __s types...*/
! 8 
! 9 typedef unsigned char __u8;
! 10 typedef unsigned char * __pu8;
! 11 
! 12 #ifndef __BCC__		/* NOTE! BCC does _not_ have a signed char type! */
! 13 typedef char __s8;
! 14 typedef char * __ps8;
! 15 #endif
! 16 
! 17 typedef unsigned short __u16;
! 18 typedef unsigned short * __pu16;
! 19 typedef short __s16;
! 20 typedef short * __ps16;
! 21 
! 22 typedef unsigned long __u32;
! 23 typedef unsigned long * __pu32;
! 24 typedef long __s32;
! 25 typedef long * __ps32;
! 26 
! 27 /* __uint == 16bit on 8086 32bit on i386 */
! 28 
! 29 typedef unsigned int __uint;
! 30 typedef int __sint;
! 31 typedef unsigned int * __puint;
! 32 typedef int * __psint;
! 33 
! 34 #endif
! 35 
! 35 
! 36 
! 5 
! 6 typedef __u32 off_t;
! 7 typedef __u16 pid_t;
! 8 typedef __u16 uid_t;
! 9 typedef __u16 gid_t;
! 10 typedef __u32 time_t;
! 11 typedef __u16 umode_t;
! 12 typedef __u16 nlink_t;
! 13 typedef __u16 mode_t;
! 14 typedef __u32 loff_t;
! 15 typedef __u32 speed_t;
! 16 typedef __u16 size_t;
! 17 
! 18 typedef __u16 dev_t;
! 19 typedef __uint ino_t;
! 20 typedef __u32 tcflag_t;
! 21 typedef __u8  cc_t;
! 22 
! 23 typedef int   ptrdiff_t;
! 24 
! 25 #endif
! 26 
! 27 
! 27 
! 28 
! 4 
! 4 
! 5 
! 11 
! 12 #ifndef NULL
! 13 #define NULL ((void*)0)
! 14 #endif
! 15 
! 16 #endif /* __STDDEF_H */
! 17 
! 17 
! 18 
! 3 #include __SYSINC__(types.h)
! 1 
! 1 #ifndef __LINUXMT_TYPES_H
! 2 #define __LINUXMT_TYPES_H
! 3 
! 4 #include <asm/types.h>
! 5 
! 6 typedef __u32 off_t;
! 7 typedef __u16 pid_t;
! 8 typedef __u16 uid_t;
! 9 typedef __u16 gid_t;
! 10 typedef __u32 time_t;
! 11 typedef __u16 umode_t;
! 12 typedef __u16 nlink_t;
! 13 typedef __u16 mode_t;
! 14 typedef __u32 loff_t;
! 15 typedef __u32 speed_t;
! 16 typedef __u16 size_t;
! 17 
! 18 typedef __u16 dev_t;
! 19 typedef __uint ino_t;
! 20 typedef __u32 tcflag_t;
! 21 typedef __u8  cc_t;
! 22 
! 23 typedef int   ptrdiff_t;
! 24 
! 25 #endif
! 26 
! 27 
! 27 
! 28 
! 4 
! 4 
! 5 
! 6 
! 7 /*
! 8  * Mini malloc allows you to use a less efficient but smaller malloc the
! 9  * cost is about 100 bytes of code in free but malloc (700bytes) doesn't
! 10  * have to be linked. Unfortunatly memory can only be reused if everything
! 11  * above it has been freed
! 12  * 
! 13  */
! 14 
! 15 extern void free __P((void *));
! 16 extern void *malloc __P((size_t));
! 17 extern void *realloc __P((void *, size_t));
! 18 extern void *alloca __P((size_t));
! 19 
! 20 extern void *(*__alloca_alloc) __P((size_t));
! 21 
! 22 #ifdef __LIBC__
! 23 #define __MINI_MALLOC__
! 24 #endif
! 25 
! 26 #ifdef __MINI_MALLOC__
! 27 #define malloc(x) ((*__alloca_alloc)(x))
! 28 #endif
! 29 
! 30 #endif
! 31 
! 31 
! 32 
! 9 #endif
! 10 
! 11 /* switches for code generation */
! 12 
! 13 #if !defined(I8088) && !defined(MC6809)
! 14 /* The default compiler type ... */
! 15 #define I8088			/* target processor is Intel 8088 thru 80386 */
! 16 #undef  MC6809			/* target processor is Motorola 6809 */
! 17 
! 18 #endif
! 19 
! 20 #ifdef __AS386_16__
! 21 #define VERY_SMALL_MEMORY
! 22 #endif
! 23 
! 24 #define SELFTYPECHECK		/* check calculated type = runtime type */
! 25 
! 26 #ifndef VERY_SMALL_MEMORY
! 27 #define DEBUG			/* generate compiler-debugging code */
! 28 #endif
! 29 
! 30 #ifdef I8088
! 31 # define FRAMEPOINTER		/* index locals off frame ptr, not stack ptr */
! 32 # define HOLDSTRINGS		/* hold strings for dumping at end
! 33 				 * since assembler has only 1 data seg */
! 34 # define DYNAMIC_LONG_ORDER 1	/* long word order spec. at compile time */
! 35 
! 36 #ifdef VERY_SMALL_MEMORY
! 37 
! 38 /* Humm, now this is nasty :-) */
! 39 #define float	no_hope
! 40 #define double	no_hope
! 41 #define atof	atol
! 42 #define NOFLOAT
! 43 typedef long no_hope;
! 44 
! 45 #else
! 46 #ifndef NO_I80386
! 47 # define I80386			/* Little BCC doesn't need 386 */
! 48 #endif
! 49 #endif
! 50 #endif
! 51 
! 52 #ifdef MC6809
! 53 # define DYNAMIC_LONG_ORDER 0	/* have to define it so it works in #if's */
! 54 # define OP1			/* logical operators only use 1 byte */
! 55 # define POSINDEPENDENT		/* position indep code can (also) be gen */
! 56 #endif
! 57 
! 58 /* switches for source and target operating system dependencies */
! 59 
! 60 /*#define SOS_EDOS*/		/* source O/S is EDOS */
! 61 /*#define SOS_MSDOS*/		/* source O/S is MSDOS */
! 62 /*#define TOS_EDOS*/		/* target O/S is EDOS */
! 63 
! 64 #ifdef MSDOS
! 65 #define SOS_MSDOS
! 66 #endif
! 67 
! 68 /* switches for source machine dependencies */
! 69 
! 70 /* Unportable alignment needed for specific compilers */
! 71 #ifndef VERY_SMALL_MEMORY
! 72 # define S_ALIGNMENT (sizeof(long)) /* A little safer */
! 73 #endif
! 74 
! 75 /* local style */
! 76 
! 77 #ifndef NULL
! 78 #define NULL 0
! 79 #endif
! 80 #define FALSE 0
! 81 #define TRUE 1
! 82 
! 83 #define EXTERN extern
! 84 #define FORWARD static
! 85 #define PRIVATE static
! 86 #define PUBLIC
! 87 
! 87 
! 88 
! 26 #include "types.h"
! 1 
! 1 /* types.h - type definitions for bcc */
! 2 
! 3 /* Copyright (C) 1992 Bruce Evans */
! 4 
! 5 /*
! 6   source types big enough to handle target quantities
! 7   these have to be match the source compiler and target machine
! 8   this is impossible if the source long type is too small
! 9 */
! 10 
! 11 typedef unsigned char char_t;	/* target char */
! 12 typedef long value_t;		/* target ints, longs and offsets */
! 13 typedef unsigned long uvalue_t;	/* target unsigned ints, longs and offsets */
! 14 
! 15 #ifdef I8088
! 16 typedef long offset_T;		/* target machine offset */
! 17 typedef unsigned long uoffset_T;	/* target unsigned machine offset */
! 18 #define outuvalue outhex
! 19 #define outvalue outshex
! 20 #endif
! 21 #ifdef MC6809
! 22 typedef int offset_T;
! 23 typedef unsigned uoffset_T;
! 24 #endif
! 25 
! 26 
! 27 /*
! 28   storage class type must hold all the flags defined elsewhere
! 29   it must have a few more bits than the target has registers
! 30 */
! 31 
! 32 #ifdef I8088
! 33 typedef unsigned store_pt;	/* promoted store_t */
! 34 typedef unsigned store_t;	/* storage class flags */
! 35 #endif
! 36 #ifdef MC6809
! 37 #ifdef __STDC__
! 38 typedef int store_pt;
! 39 # else
! 40 typedef unsigned store_pt;
! 41 # endif
! 42 typedef unsigned char store_t;
! 43 #endif
! 44 
! 45 
! 46 /*
! 47   types for library routines
! 48 */
! 49 
! 50 typedef int fd_t;		/* file descriptor */
! 51 
! 52 
! 53 /*
! 54   basic scalar types - may be tuned to suit machine
! 55 */
! 56 
! 57 typedef int fastin_pt;		/* promoted fastin_t */
! 58 				/* always an int - use to show that the */
! 59 				/* value may be accessed as a fastin_t */
! 60 typedef char fastin_t;		/* fast int - a small integer value */
! 61 				/* on some machines, chars can be accessed */
! 62 				/* more efficiently than ints for arithmetic */
! 63 				/* such as comparing and masking which */
! 64 				/* does not requiring promotion */
! 65 				/* change to int if chars are inefficient */
! 66 				/* or if char has < 8 bits */
! 67 typedef int smalin_pt;		/* promoted smalin_t */
! 68 typedef char smalin_t;		/* small int - a small integer value */
! 69 				/* on most machines, chars are stored in */
! 70 				/* less space than any other type */
! 71 				/* change to fastin_t if this is not true */
! 72 				/* or if char has < 8 bits */
! 73 				/* or if space is not a limiting factor */
! 74 #if
! 74 def __STDC__
! 75 typedef int smalu_pt;
! 76 #else
! 77 typedef unsigned smalu_pt;
! 78 #endif
! 79 typedef unsigned char smalu_t;
! 80 
! 81 
! 82 /*
! 83   derived scalar types
! 84   the types containing bit flags fit in an 8 bit smalin_t
! 85 */
! 86 
! 87 typedef fastin_pt bool_pt;	/* promoted bool_t */
! 88 typedef fastin_t bool_t;	/* boolean: TRUE if nonzero */
! 89 typedef fastin_pt ccode_pt;	/* promoted ccode_t */
! 90 typedef fastin_t ccode_t;	/* condition code code */
! 91 typedef smalu_pt constr_pt;	/* promoted constr_t */
! 92 typedef smalu_t constr_t;	/* type constructor flags */
! 93 typedef smalu_pt indn_pt;	/* promoted indn_t */
! 94 typedef smalu_t indn_t;		/* storage indirection count */
! 95 typedef unsigned label_no;	/* label number */
! 96 typedef smalu_t maclev_t;	/* macro expansion level */
! 97 typedef smalin_pt op_pt;	/* promoted op_t */
! 98 typedef smalin_t op_t;		/* operator code */
! 99 typedef smalu_t sc_t;		/* storage class flags */
! 100 typedef smalu_pt scalar_pt;	/* promoted scalar_t */
! 101 typedef smalu_t scalar_t;	/* type scalar flags */
! 102 typedef smalu_t scopelev_t;	/* scope level */
! 103 typedef fastin_pt sym_pt;	/* promoted sym_t */
! 104 typedef fastin_t sym_t;		/* symbol code from scanner */
! 105 typedef smalu_t weight_t;	/* expression tree node weight */
! 106 
! 107 
! 108 /*
! 109   derived structure types
! 110   the fields are ordered in a way that is most space-efficient
! 111   when smalin_t is char and smalu_t is unsigned char
! 112   the first element of the structures is the one most frequently accessed
! 113 */
! 114 
! 115 /*
! 116   expression table entry format
! 117 */
! 118 
! 119 struct nodestruct
! 120 {
! 121     op_t tag;
! 122     weight_t weight;
! 123     smalu_t flags;
! 124     struct typestruct *nodetype;
! 125     union nodeunion
! 126     {
! 127 	struct nodestruct *nodeptr;
! 128 	struct symstruct *symptr;
! 129     } left;
! 130     struct nodestruct *right;
! 131 };
! 132 
! 133 /*
! 134   symbol table entry format
! 135 */
! 136 
! 137 struct symstruct
! 138 {
! 139     store_t storage;
! 140     indn_t indcount;
! 141     sc_t flags;
! 142     scopelev_t level;
! 143     struct symstruct *next;
! 144     struct symstruct **prev;
! 145     struct typestruct *type;
! 146     union
! 147     {
! 148 	double *offd;		/* value for double constants */
! 149 	offset_T offi;		/* offset for register or global storage */
! 150 	label_no offlabel;	/* label number fo
! 150 r strings */
! 151 	char *offp;		/* to string for macro definitions */
! 152 	sym_pt offsym;		/* symbol code for keywords */
! 153 	value_t offv;		/* value for integral constants */
! 154     }
! 155      offset;
! 156     union
! 157     {
! 158 	label_no label;		/* label number for strings */
! 159 	char namea[1];		/* variable length array for declarations */
! 160 	char *namep;		/* to constant storage for exprs */
! 161     }
! 162      name;
! 163 };
! 164 
! 165 /*
! 166   type table entry format
! 167 */
! 168 
! 169 struct typestruct
! 170 {
! 171     scalar_t scalar;		/* scalar type flags u d f l i s c */
! 172     constr_t constructor;	/* constructed type flags a f p s/u */
! 173     char structkey[2];		/* unique prefix for member names */
! 174 				/* ranges from "\001\001" to "@\377" */
! 175 				/* avoiding nulls */
! 176     uoffset_T alignmask;	/* alignment mask, typesize - 1 for scalars */
! 177     uoffset_T typesize;		/* size of this type */
! 178     char *tname;		/* name of scalar type or constructor */
! 179     struct typelist *listtype;	/* list of member types */
! 180     struct typestruct *nexttype;
! 181 				/* next in list */
! 182     struct typestruct *prevtype;
! 183 				/* previous in list */
! 184     struct typestruct *sidetype;
! 185 				/* next in sideways list */
! 186 };
! 187 
! 188 /*
! 189   list of type structures
! 190 */
! 191 
! 192 struct typelist
! 193 {
! 194     struct typelist *tlnext;
! 195     struct typestruct *tltype;
! 196 };
! 197 
! 198 
! 199 /*
! 200   definitions to avoid passing raw NULLs to functions
! 201 */
! 202 
! 203 #define NULLNODE ((struct nodestruct *) NULL)
! 204 #define NULLTYPE ((struct typestruct *) NULL)
! 205 
! 205 
! 206 
! 27 #include "proto.h"
! 1 
! 1 /* proto.h - extern functions for bcc */
! 2 
! 3 /* Copyright (C) 1992 Bruce Evans */
! 4 
! 5 /* assign.c */
! 6 void assign P((struct symstruct *source, struct symstruct *target));
! 7 void cast P((struct typestruct *type, struct symstruct *target));
! 8 void extend P((struct symstruct *target));
! 9 
! 10 /* codefrag.c */
! 11 void adjsp P((label_no label));
! 12 void clrBreg P((void));
! 13 void comment P((void));
! 14 void ctoi P((void));
! 15 void defbyte P((void));
! 16 void deflong P((uoffset_T value));
! 17 void defword P((void));
! 18 void defdword P((void));
! 19 void even P((void));
! 20 void negDreg P((void));
! 21 void comDreg P((void));
! 22 void outadd P((void));
! 23 void outaddsp P((void));
! 24 void outcalladr P((void));
! 25 void outcmp P((void));
! 26 void outdec P((void));
! 27 void outdword P((void));
! 28 void outfail P((void));
! 29 void outinc P((void));
! 30 void outindleft P((void));
! 31 void outindright P((void));
! 32 void outindstackreg P((void));
! 33 void outldaccum P((void));
! 34 void outldmulreg P((void));
! 35 void outlea P((void));
! 36 void outleasp P((void));
! 37 void outload P((void));
! 38 void outmulmulreg P((void));
! 39 void outopsep P((void));
! 40 void outpshs P((void));
! 41 void outpuls P((void));
! 42 void outreturn P((void));
! 43 void outstore P((void));
! 44 void outsub P((void));
! 45 void outtest P((void));
! 46 void outword P((void));
! 47 void sctoi P((void));
! 48 void stoi P((void));
! 49 void ustoi P((void));
! 50 void outABX P((void));
! 51 void outdirectpage P((void));
! 52 void outextended P((void));
! 53 void outncspregname P((void));
! 54 void outindframereg P((void));
! 55 void adc0 P((void));
! 56 void addconst P((offset_T offset, store_pt reg));
! 57 void adjlc P((offset_T offset, store_pt reg));
! 58 void andconst P((offset_T offset));
! 59 void bssseg P((void));
! 60 label_no casejump P((void));
! 61 void common P((char *name));
! 62 void cseg P((void));
! 63 void defnulls P((uoffset_T nullcount));
! 64 label_no defstr P((char *sptr, char *stop, bool_pt dataflag));
! 65 bool_pt diveasy P((value_t divisor, bool_pt uflag));
! 66 void dpseg P((void));
! 67 void dseg P((void));
! 68 void equ P((char *name, char *string));
! 69 void equlab P((label_no label, offset_T offset));
! 70 void globl P((char *name));
! 71 void import P((char *name));
! 72 void itol P((store_pt reg));
! 73 void lcomm
! 73 lab P((label_no label));
! 74 void lcommon P((char *name));
! 75 void lea P((offset_T offset, store_pt sourcereg, store_pt targreg));
! 76 void loadconst P((offset_T offset, store_pt reg));
! 77 int lslconst P((value_t shift, store_pt reg));
! 78 int lsrconst P((value_t shift, store_pt reg, bool_pt uflag));
! 79 bool_pt modeasy P((value_t divisor, bool_pt uflag));
! 80 bool_pt muleasy P((uvalue_t factor, store_pt reg));
! 81 void negreg P((store_pt reg));
! 82 char *opstring P((op_pt op));
! 83 void outccname P((char *name));
! 84 void outhiaccum P((void));
! 85 void outimmadr P((offset_T offset));
! 86 void outimadj P((offset_T offset, store_pt targreg));
! 87 void outimmed P((void));
! 88 void outjumpstring P((void));
! 89 void outnccname P((char *name));
! 90 void outncimmadr P((offset_T offset));
! 91 void outoffset P((offset_T offset));
! 92 void public P((char *name));
! 93 void private P((char *name));
! 94 void regexchange P((store_pt sourcereg, store_pt targreg));
! 95 void regtransfer P((store_pt sourcereg, store_pt targreg));
! 96 void sbc0 P((void));
! 97 void set P((char *name, offset_T value));
! 98 void sl1 P((store_pt reg));
! 99 void slconst P((value_t shift, store_pt reg));
! 100 void srconst P((value_t shift, bool_pt uflag));
! 101 void uitol P((store_pt reg));
! 102 void restoreopreg P((void));
! 103 void saveopreg P((void));
! 104 
! 105 /* debug.c */
! 106 void dbitem P((struct symstruct *item));
! 107 void dbtype P((struct typestruct *type));
! 108 void debug P((struct nodestruct *exp));
! 109 void debugswap P((void));
! 110 
! 111 /* declare.c */
! 112 void colon P((void));
! 113 void decllist P((void));
! 114 void lparen P((void));
! 115 void needvarname P((void));
! 116 void program P((void));
! 117 void rbrace P((void));
! 118 void rbracket P((void));
! 119 void rparen P((void));
! 120 void semicolon P((void));
! 121 struct typestruct *typename P((void));
! 122 
! 123 /* express.c */
! 124 struct nodestruct *assignment_exp P((void));
! 125 struct nodestruct *expression P((void));
! 126 
! 127 /* exptree.c */
! 128 struct nodestruct *castnode P((struct typestruct *type,
! 129 			       struct nodestruct *nodeptr));
! 130 void etreeinit P((void));
! 131 struct nodestruct *leafnode P((struct symstruct *source));
! 132 struct nodestruct *node P((op_pt t, struct nodestruct *p1,
! 133 			   struct nodestruct *p2));
! 134 
! 135 /* 
! 135 floatop.c */
! 136 bool_pt f_indirect P((struct symstruct *target));
! 137 void float1op P((op_pt op, struct symstruct *source));
! 138 void floatop P((op_pt op, struct symstruct *source, struct symstruct *target));
! 139 void fpush P((struct symstruct *source));
! 140 void justpushed P((struct symstruct *target));
! 141 
! 142 /* function.c */
! 143 void call P((char *name));
! 144 void function P((struct symstruct *source));
! 145 void ldregargs P((void));
! 146 void loadretexpression P((void));
! 147 void listo P((struct symstruct *target, offset_T lastargsp));
! 148 void listroot P((struct symstruct *target));
! 149 void popframe P((void));
! 150 void reslocals P((void));
! 151 void ret P((void));
! 152 
! 153 /* gencode.c */
! 154 void bileaf P((struct nodestruct *exp));
! 155 fastin_pt bitcount P((uvalue_t number));
! 156 void codeinit P((void));
! 157 fastin_pt highbit P((uvalue_t number));
! 158 void makeleaf P((struct nodestruct *exp));
! 159 
! 160 /* genloads.c */
! 161 void addoffset P((struct symstruct *source));
! 162 void address P((struct symstruct *source));
! 163 void exchange P((struct symstruct *source, struct symstruct *target));
! 164 store_pt getindexreg P((void));
! 165 void indexadr P((struct symstruct *source, struct symstruct *target));
! 166 void indirec P((struct symstruct *source));
! 167 void load P((struct symstruct *source, store_pt targreg));
! 168 void loadany P((struct symstruct *source));
! 169 void loadreg P((struct symstruct *source, store_pt targreg));
! 170 void makelessindirect P((struct symstruct *source));
! 171 void movereg P((struct symstruct *source, store_pt targreg));
! 172 void onstack P((struct symstruct *target));
! 173 void outadr P((struct symstruct *adr));
! 174 void outcregname P((store_pt reg));
! 175 void outncregname P((store_pt reg));
! 176 void outnregname P((store_pt reg));
! 177 void outregname P((store_pt reg));
! 178 void outshortregname P((store_pt reg));
! 179 void pointat P((struct symstruct *target));
! 180 void poplist P((store_pt reglist));
! 181 void push P((struct symstruct *source));
! 182 void pushlist P((store_pt reglist));
! 183 void pushreg P((store_pt reg));
! 184 void storereg P((store_pt sourcereg, struct symstruct *target));
! 185 void struc P((struct symstruct *source, struct symstruct *target));
! 186 void transfer P((struct symst
! 186 ruct *source, store_pt targreg));
! 187 
! 188 /* glogcode.c */
! 189 void cmp P((struct symstruct *source, struct symstruct *target,
! 190 	    ccode_t *pcondtrue));
! 191 void condop P((struct nodestruct *exp));
! 192 void jumpfalse P((struct nodestruct *exp, label_no label));
! 193 void jumptrue P((struct nodestruct *exp, label_no label));
! 194 void logop P((struct nodestruct *exp));
! 195 
! 196 /* hardop.c */
! 197 void add P((struct symstruct *source, struct symstruct *target));
! 198 void incdec P((op_pt op, struct symstruct *source));
! 199 void neg P((struct symstruct *target));
! 200 void not P((struct symstruct *target));
! 201 void op1 P((op_pt op, struct symstruct *source, struct symstruct *target));
! 202 void ptrsub P((struct symstruct *source, struct symstruct *target));
! 203 void sub P((struct symstruct *source, struct symstruct *target));
! 204 
! 205 /* input.c */
! 206 void closein P((void));
! 207 void errorloc P((void));
! 208 void gch1 P((void));
! 209 void include P((void));
! 210 void openio P((int argc, char **argv));
! 211 void skipeol P((void));
! 212 void specialchar P((void));
! 213 void linecontol P((void));
! 214 
! 215 /* label.c */
! 216 void bumplc P((void));
! 217 void bumplc2 P((void));
! 218 void bumplc3 P((void));
! 219 void clearfunclabels P((void));
! 220 void clearlabels P((char *patchbuf, char *patchtop));
! 221 void clearswitchlabels P((void));
! 222 uoffset_T getlc P((void));
! 223 void deflabel P((label_no label));
! 224 label_no gethighlabel P((void));
! 225 label_no getlabel P((void));
! 226 void jump P((label_no label));
! 227 void lbranch P((ccode_pt cond, label_no label));
! 228 struct symstruct *namedlabel P((void));
! 229 void outcond P((ccode_pt cond));
! 230 void outlabel P((label_no label));
! 231 void outnlabel P((label_no label));
! 232 void sbranch P((ccode_pt cond, label_no label));
! 233 void unbumplc P((void));
! 234 
! 235 /* loadexp.c */
! 236 value_t constexpression P((void));
! 237 void initexpression P((struct typestruct *type));
! 238 struct typestruct *loadexpression P((store_pt targreg,
! 239 				     struct typestruct *targtype));
! 240 
! 241 /* longop.c */
! 242 void longop P((op_pt op, struct symstruct *source, struct symstruct *target));
! 243 void long1op P((op_pt op, struct symstruct *target));
! 244 void outlongendian P((void));
! 245 
! 246 /* output.c */
! 247 void bugerror P((char *message)
! 247 );
! 248 void closeout P((void));
! 249 void error P((char *message));
! 250 void error2error P((char *message1, char *message2));
! 251 void fatalerror P((char *message));
! 252 void finishup P((void));
! 253 void flushout P((void));
! 254 void limiterror P((char *message));
! 255 void initout P((void));
! 256 void openout P((char *oname));
! 257 void outbyte P((int ch));
! 258 void outcomma P((void));
! 259 void outcpplinenumber P((unsigned nr, char *fname, char *str));
! 260 void outhex P((uoffset_T num));
! 261 void outhexdigs P((uoffset_T num));
! 262 void outline P((char *s));
! 263 void outminus P((void));
! 264 void outnl P((void));
! 265 void outnbyte P((int byte));
! 266 void outnhex P((uoffset_T num));
! 267 void outnop1str P((char *s));
! 268 void outnop2str P((char *s));
! 269 void outnstr P((char *s));
! 270 void outop0str P((char *s));
! 271 void outop1str P((char *s));
! 272 void outop2str P((char *s));
! 273 void outop3str P((char *s));
! 274 void outplus P((void));
! 275 void outshex P((offset_T num));
! 276 void outstr P((char *s));
! 277 void outtab P((void));
! 278 void outudec P((unsigned num));
! 279 void outuvalue P((uvalue_t num));
! 280 void outvalue P((value_t num));
! 281 char *pushudec P((char *s, unsigned num));
! 282 void setoutbufs P((void));
! 283 
! 284 /* preproc.c */
! 285 void blanks P((void));
! 286 bool_pt blanksident P((void));
! 287 void checknotinif P((void));
! 288 void define P((void));
! 289 void definestring P((char *str));
! 290 void docontrol P((void));
! 291 void entermac P((void));
! 292 void ifinit P((void));
! 293 int  ifcheck P((void));
! 294 void leavemac P((void));
! 295 void predefine P((void));
! 296 char *savedlineptr P((void));
! 297 void skipcomment P((void));
! 298 void skipline P((void));
! 299 void undefinestring P((char *str));
! 300 
! 301 /* preserve.c */
! 302 void changesp P((offset_T newsp, bool_pt absflag));
! 303 void loadpres P((struct symstruct *source, struct symstruct *target));
! 304 void modstk P((offset_T newsp));
! 305 void pres2 P((struct symstruct *source, struct symstruct *target));
! 306 void preserve P((struct symstruct *source));
! 307 store_pt preslval P((struct symstruct *source, struct symstruct *target));
! 308 void recovlist P((store_pt reglist));
! 309 void savereturn P((store_pt savelist, offset_T saveoffset));
! 310 
! 311 /* sc.c */
! 312 int main P((int argc, char **argv));
! 313 
! 314 /* scan.c */
! 315 void cppscan P
! 315 ((int asmonly));
! 316 void eofin P((char *message));
! 317 bool_pt isident P((void));
! 318 void nextsym P((void));
! 319 void stringorcharconst P((void));
! 320 
! 321 /* softop.c */
! 322 void softop P((op_pt op, struct symstruct *source, struct symstruct *target));
! 323 
! 324 /* state.c */
! 325 void compound P((void));
! 326 void outswoffset P((offset_T offset));
! 327 void outswstacklab P((void));
! 328 
! 329 /* table.c */
! 330 struct symstruct *addglb P((char *name, struct typestruct *type));
! 331 struct symstruct *addloc P((char *name, struct typestruct *type));
! 332 struct symstruct *addlorg P((char *name, struct typestruct *type));
! 333 void addsym P((char *name, struct typestruct *type,
! 334 	       struct symstruct *symptr));
! 335 struct symstruct *constsym P((value_t intconst));
! 336 void delsym P((struct symstruct *symptr));
! 337 void dumpglbs P((void));
! 338 void dumplocs P((void));
! 339 void dumpstrings P((void));
! 340 struct symstruct *exprsym P((struct symstruct *symptr));
! 341 struct symstruct *findlorg P((char *name));
! 342 struct symstruct *findstruct P((char *name));
! 343 struct symstruct **gethashptr P((char *sname));
! 344 void growheap P((unsigned size));
! 345 void *growobject P((void *object, unsigned extra));
! 346 label_no holdstr P((char *sptr, char *stop));
! 347 void newlevel P((void));
! 348 void oldlevel P((void));
! 349 void ourfree P((void *ptr));
! 350 void *ourmalloc P((unsigned nbytes));
! 351 void outofmemoryerror P((char *message));
! 352 void *qmalloc P((unsigned size));
! 353 void swapsym P((struct symstruct *sym1, struct symstruct *sym2));
! 354 void syminit P((void));
! 355 
! 356 /* type.c */
! 357 struct typestruct *addstruct P((char *structname));
! 358 struct typestruct *iscalartotype P((scalar_pt scalar));
! 359 struct typestruct *newtype P((void));
! 360 void outntypechar P((struct typestruct *type));
! 361 struct typestruct *pointype P((struct typestruct *type));
! 362 struct typestruct *prefix P((constr_pt constructor, uoffset_T size,
! 363 			     struct typestruct *type));
! 364 struct typestruct *promote P((struct typestruct *type));
! 365 struct typestruct *tounsigned P((struct typestruct *type));
! 366 void typeinit P((void));
! 367 
! 368 
! 368 
! 369 
! 28 
! 29 #if !defined(__STDC__) || defined(MSDOS)
! 30 #include "sysproto.h"
! 1 
! 1 
! 2 /* library - fcntl.h */
! 3 int creat P((const char *_path, int _mode));
! 4 int open P((const char *_path, int _oflag, ...));
! 5 
! 6 /* library - stdlib.h */
! 7 double atof P((const char *_str));
! 8 void exit P((int _status));
! 9 
! 10 /* library - string.h */
! 11 void *memcpy P((void *_t, const void *_s, unsigned _length));
! 12 void *memset P((void *_s, int _c, unsigned _nbytes));
! 13 char *strcat P((char *_target, const char *_source));
! 14 char *strchr P((const char *_s, int _ch));
! 15 int strcmp P((const char *_s1, const char *_s2));
! 16 char *strcpy P((char *_target, const char *_source));
! 17 unsigned strlen P((const char *_s));
! 18 char *strncpy P((char *_target, const char *_source, unsigned _maxlength));
! 19 char *strrchr P((const char *_s, int _ch));
! 20 
! 21 /* library - unistd.h */
! 22 int close P((int _fd));
! 23 int isatty P((int _fd));
! 24 long lseek P((int _fd, long _offset, int _whence));
! 25 int read P((int _fd, char *_buf, unsigned _nbytes));
! 26 int write P((int _fd, char *_buf, unsigned _nbytes));
! 27 
! 28 
! 28 
! 29 
! 31 #endif
! 32 
! 33 
! 33 
! 34 
! 6 #include "gencode.h"
! 1 
! 1 /* gencode.h - code generation for bcc */
! 2 
! 3 /* Copyright (C) 1992 Bruce Evans */
! 4 
! 5 #ifdef MC6809
! 6 # define CANABXCUTOFF 7		/* favour ABX over MUL before this */
! 7 #endif
! 8 #define EXPRLEVEL 126		/* level for symbols in exptree, > real levs */
! 9 #define OFFKLUDGELEVEL 127	/* level for expr sym with offset from name */
! 10 #define OPERANDSEPARATOR ','	/* char separating operands */
! 11 #define OPSEPARATOR '\t'	/* char separating op string and operand */
! 12 
! 13 EXTERN uoffset_T arg1size;	/* size of 1st arg to function */
! 14 				/* zero after allocation of 1st arg */
! 15 EXTERN store_pt callee1mask;	/* calleemask with doubleregs masked if nec */
! 16 EXTERN uoffset_T dataoffset;	/* amount of initialized data so far */
! 17 #ifdef DEBUG
! 18 EXTERN bool_t debugon;		/* nonzero to print debugging messages */
! 19 				/* depends on zero init */
! 20 #endif
! 21 #ifdef FRAMEPOINTER
! 22 EXTERN store_pt framelist;	/* bit pattern for frame and saved regs */
! 23 EXTERN store_pt frame1list;	/* framelist with doubleregs masked if nec */
! 24 EXTERN offset_T framep;		/* hardware relative frame ptr */
! 25 #endif
! 26 EXTERN uoffset_T func1saveregsize;  /* choice of next two values */
! 27 EXTERN uoffset_T funcdsaveregsize;  /* funcsaveregsize adjusted for doubles */
! 28 EXTERN uoffset_T funcsaveregsize;  /* tot size of framelist/calleemask regs */
! 29 #ifdef I80386
! 30 EXTERN bool_t i386_32;		/* nonzero to generate 386 32 bit code */
! 31 				/* depends on zero init */
! 32 #endif
! 33 #ifdef DYNAMIC_LONG_ORDER
! 34 EXTERN bool_t long_big_endian;	/* nonzero if high long word is first */
! 35 				/* depends on zero init */
! 36 #endif
! 37 EXTERN offset_T lowsp;		/* low water sp (collects locals in switch) */
! 38 #ifdef POSINDEPENDENT
! 39 EXTERN bool_t posindependent;	/* nonzero to generate pos-independent code */
! 40 				/* depends on zero init */
! 41 #endif
! 42 EXTERN bool_t printf_fp;	/* nonzero if *printf called with FP arg  */
! 43 EXTERN bool_t regarg;		/* nonzero to show unloaded register arg */
! 44 				/* depends on zero init */
! 45 EXTERN store_t reguse;		/* registers in use */
! 46 EXTERN bool_t scanf_fp;		/* nonzero if *scanf called with ptr-to-FP */
! 47 EXTERN offset_T softsp;		/* software s
! 47 p (leads sp during declares) */
! 48 EXTERN offset_T sp;		/* hardware relative stack ptr */
! 49 				/* depends on zero init */
! 50 #ifdef FRAMEPOINTER
! 51 EXTERN bool_t stackarg;		/* nonzero to show function has arg on stack */
! 52 #endif
! 53 EXTERN struct switchstruct *switchnow;	/* currently active switch */
! 54 				/* depends on NULL init */
! 55 
! 56 /* variables to be initialised to nonzero */
! 57 
! 58 extern store_pt allindregs;	/* mask (in) for index registers */
! 59 extern store_pt allregs;	/* mask (in) for registers */
! 60 extern bool_t arg1inreg;	/* nonzero to pass 1st arg in reg */
! 61 extern store_pt calleemask;	/* mask (in) for regs to be saved by callee */
! 62 extern bool_t callersaves;	/* nonzero to make caller save regs */
! 63 extern char *callstring;	/* opcode string for call */
! 64 extern store_pt doubleargregs;	/* mask (in) for regs for 1st arg if double */
! 65 extern store_pt doubleregs;	/* mask (in) for regs to temp contain double */
! 66 extern store_pt doublreturnregs;  /* mask (in) for regs for returning double */
! 67 extern offset_T jcclonger;	/* amount jcc long jumps are longer */
! 68 extern offset_T jmplonger;	/* amount long jumps is longer */
! 69 extern char *jumpstring;	/* opcode string for jump */
! 70 extern char *regpulllist;	/* reg names and sizes (0 store_t bit first) */
! 71 extern char *regpushlist;	/* reg names and sizes (0 store_t bit last) */
! 72 extern store_pt regregs;	/* mask (in) for regs which can be reg vars */
! 73 
! 74 /* register names */
! 75 
! 76 extern char *acclostr;
! 77 extern char *accumstr;
! 78 extern char *badregstr;
! 79 #ifdef I8088
! 80 extern char *dreg1str;
! 81 extern char *dreg1bstr;
! 82 extern char *dreg2str;
! 83 #endif
! 84 extern char *ireg0str;
! 85 extern char *ireg1str;
! 86 extern char *ireg2str;
! 87 extern char *localregstr;
! 88 #ifdef I8088
! 89 extern char *stackregstr;
! 90 #endif
! 91 
! 92 /* register sizes */
! 93 
! 94 extern uoffset_T accregsize;
! 95 #ifdef FRAMEPOINTER
! 96 extern uoffset_T frameregsize;
! 97 #endif
! 98 extern uoffset_T maxregsize;
! 99 extern uoffset_T opregsize;
! 100 extern uoffset_T pshregsize;
! 101 extern uoffset_T returnadrsize;
! 102 
! 102 
! 103 
! 7 #include "parse.h"
! 1 
! 1 /* parse.h - parser for bcc */
! 2 
! 3 /* Copyright (C) 1992 Bruce Evans */
! 4 
! 5 /* possible scope levels */
! 6 
! 7 #define ARGLEVEL	1
! 8 #define GLBLEVEL	0
! 9 #define MAXLEVEL	125
! 10 #define MINLOCLEVEL	1
! 11 
! 12 /* possible node flags */
! 13 
! 14 #define LVALUE		(1 << 0)
! 15 
! 16 EXTERN struct nodestruct *etptr;     /* ptr to next entry in expression tree */
! 17 EXTERN struct symstruct *gvarsymptr; /* gsymptr for last identifier declared */
! 18 EXTERN scopelev_t level;	/* scope level */
! 19 				/* depends on zero init */
! 20 
! 20 
! 21 
! 8 #include "reg.h"
! 1 
! 1 /* reg.h - registers for bcc */
! 2 
! 3 /* Copyright (C) 1992 Bruce Evans */
! 4 
! 5 /*
! 6   The compiler generates "addresses" of the form
! 7       indirect(indcount) (rx + offset)
! 8   where
! 9       rx is a machine register (possibly null)
! 10       n is the indirection count (possibly 0)
! 11       offset is a constant.
! 12   It does not support more complicated formats like
! 13       indirect(indcount) (rx + index * scale + offset).
! 14 
! 15       The register is coded as bit flag in the  storage  component of
! 16   the symbol structure. This allows groups of registers to be tested
! 17   using bitwise "&". Throughout the compiler, the group of these bit
! 18   flags has the type  reg_t. If there are only a few registers, reg_t
! 19   can be an unsigned char. It must be unsigned if the high bit is
! 20   used, to avoid sign extension problems. For bootstrapping the compiler
! 21   from a compiler with no unsigned char, the unsigned type should be
! 22   used instead (with a signifigant waste of storage).
! 23 
! 24       The bit flags should really be defined as ((reg_t) whatever) but
! 25   then they would not (necessarily) be constant expressions and couldn't
! 26   be used in switch selectors or (worse) preprocessor expressions.
! 27 
! 28       The CONSTANT and GLOBAL (non-) register bits are almost
! 29   equivalent. A constant with nonzero indirection is marked as a
! 30   GLOBAL and not a CONSTANT. This makes it easier to test for a constant
! 31   CONSTANT. Globals which are formed in this way are converted to
! 32   constants if their indirection count is reset to 0 (by & operator).
! 33 */
! 34 
! 35 /* register bit flags */
! 36 
! 37 #define NOSTORAGE 0x000		/* structure/union member offsets */
! 38 #define CONSTANT  0x001		/* offsets are values */
! 39 #define BREG      0x002
! 40 #define DREG      0x004
! 41 #define INDREG0   0x008
! 42 #define INDREG1   0x010
! 43 #define INDREG2   0x020
! 44 #define LOCAL     0x040
! 45 #define GLOBAL    0x080		/* offsets from storage name or 0 */
! 46 #define CCREG     CONSTANT	/* arg to PSHS/PULS functions only */
! 47 #ifdef I8088
! 48 # ifdef FRAMEPOINTER
! 49 #  define FRAMEREG LOCAL
! 50 # endif
! 51 # define STACKREG 0x100
! 52 # define DATREG1  0x200
! 53 # define DATREG2  0x400
! 54 # defin
! 54 e DATREG1B 0x800
! 55 #endif
! 56 #ifdef MC6809
! 57 # define DPREG    LOCAL		/* arg to PSHS/PULS functions only */
! 58 # define PCREG    GLOBAL	/* arg to PSHS/PULS functions only */
! 59 #endif
! 60 
! 61 /* data for pushing and pulling registers */
! 62 
! 63 #define MINREGCHAR 'A'
! 64 #ifdef I8088
! 65 # define FLAGSREGCHAR 'f'
! 66 # define pushchar() pushlist(AXREG)
! 67 #endif
! 68 #ifdef MC6809
! 69 # define pushchar() pushlist(BREG)
! 70 #endif
! 71 
! 72 /* special registers */
! 73 
! 74 #ifdef I8088
! 75 # define ALREG    BREG
! 76 # define AXREG    DREG
! 77 # define DXREG    DATREG2
! 78 # define MULREG   DATREG1B
! 79 # define SHIFTREG DATREG1B
! 80 #endif
! 81 #ifdef MC6809
! 82 # define XREG INDREG0		/* XREG is special for ABX in index & switch */
! 83 # define YREG INDREG2		/* XREG and YREG allow LEA (Z test) in cmp() */
! 84 #endif
! 85 
! 86 /* groups of registers */
! 87 
! 88 #define ALLDATREGS (BREG|DREG)
! 89 #define CHARREGS BREG
! 90 #define MAXREGS 1		/* number of data registers */
! 91 #define WORKDATREGS (BREG|DREG)
! 92 
! 93 /* function call and return registers */
! 94 
! 95 #define ARGREG RETURNREG	/* for (1st) argument */
! 96 #define LONGARGREGS LONGRETURNREGS	/* for long or float arg */
! 97 #define LONGRETURNREGS (INDREG0|LONGREG2)
! 98 #define LONGREG2 DREG
! 99 #ifdef I8088
! 100 # define LONGRETSPECIAL	/* LONGRETURNREGS!=RETURNREG && RETURNREG==LONGREG2 */
! 101 # define RETURNREG DREG
! 102 #endif
! 103 #ifdef MC6809
! 104 # define RETURNREG INDREG0
! 105 #endif
! 106 
! 107 /* registers which can be pulled as a group with the program counter */
! 108 /* to perform an efficient function return */
! 109 
! 110 #ifdef MC6809
! 111 #define JUNK1REGS BREG		/* 1 bytes locals to discard */
! 112 #define JUNK2REGS INDREG2
! 113 #define JUNK3REGS (BREG|INDREG2)
! 114 #define JUNK4REGS (INDREG1|INDREG2)
! 115 #endif
! 116 
! 117 /* registers which can be pushed as a group with the first argument */
! 118 /* to perform an efficient function startup */
! 119 
! 120 #ifdef MC6809
! 121 # define LOC1REGS CCREG		/* 1 bytes local to allocate */
! 122 # define LOC2REGS DREG
! 123 # define LOC3REGS (CCREG|DREG)
! 124 # define LOC4REGS (CCREG|DREG|DPREG)
! 125 # endif
! 126 
! 127 /* registers to be used by software operations */
! 128 
! 129 #define OPREG INDREG0		/* 2nd reg for software ops (1st is DREG) */
! 130 #define OPWORKREG INDREG2	/* 3rd register for software ops */
! 131 
! 132 /* maximum indi
! 132 rection count for 1 instruction */
! 133 
! 134 #ifdef I8088
! 135 # define MAXINDIRECT 1
! 136 #endif
! 137 #ifdef MC6809
! 138 # define MAXINDIRECT 2
! 139 #endif
! 140 
! 140 
! 141 
! 9 #include "sc.h"
! 1 
! 1 /* sc.h - storage classes for bcc */
! 2 
! 3 /* Copyright (C) 1992 Bruce Evans */
! 4 
! 5 #ifdef MC6809
! 6 #define DIRECTPAGE  0x01	/* modifier on global to show in dpseg */
! 7 #endif
! 8 #define EXTERNAL    0x02	/* external */
! 9 #define STATIC      0x04
! 10 
! 11 /* symbols with flags above the 1st initialised value are not to be dumped */
! 12 
! 13 #define MAXDUMPFLAG 0x07
! 14 #define INITIALIZED 0x08	/* modifier on global to show initialized */
! 15 #define LABELLED    0x10	/* modifier on static to show labelled */
! 16 				/* and on STRING to show labelled */
! 17 
! 18 /* remaining "flags" are numbers, not flags */
! 19 /* they are disjoint from all combinations of flags above */
! 20 /* except STRING => LABELLED (and no other flags) */
! 21 
! 22 #define DEFINITION 0x20		/* #defined name */
! 23 #define KEYWORD    0x40		/* reserved word for C */
! 24 #define STRUCTNAME 0x60		/* struct/union name or member name */
! 25 #define REGVAR     0x80		/* register variable */
! 26 #define TEMP       0xa0		/* temporary on stack expression eval */
! 27 #define STRING     0xc0		/* string constant (=> LABELLED) */
! 28 
! 28 
! 29 
! 10 #include "scan.h"
! 1 
! 1 /* scan.h - scanner for bcc */
! 2 
! 3 /* Copyright (C) 1992 Bruce Evans */
! 4 
! 5 #define NAMESIZE	64	/* limit on identifier lengths */
! 6 #define SYMOFCHAR(ch)	(symofchar[(unsigned char) (ch)])
! 7 
! 8 /* scanner codes */
! 9 
! 10 enum scan_states
! 11 {
! 12 /* The first group of entries consists of all the values that occur in the
! 13    switch for cppscan().
! 14 */
! 15     IDENT,
! 16     INTCONST,
! 17 #define MAXIDSYM INTCONST	/* IDENT and INTCONST must be the only
! 18 				 * symofchar[] entries below this */
! 19     FLOATCONST,
! 20 #define MAXPPNUMSYM FLOATCONST	/* IDENT, INTCONST and FLOATCONST must be the
! 21 				 * only symofchar[] entries below this */
! 22     CHARCONST,
! 23     CONTROL,
! 24     SLASH,
! 25     SPECIALCHAR,
! 26     STRINGCONST,
! 27 
! 28 /* The next group of entries are all the rest of the values that occur in
! 29    symofchar[] and so in the switch for nextsym().
! 30 */
! 31     AMPERSAND,			/* ADDRESSOP or ANDOP */
! 32     BADCHAR,
! 33     COLON,			/* also COLONOP */
! 34     COMMA,			/* also COMMAOP */
! 35     DECSYM,			/* PREDECOP or POSTDECOP */
! 36     EOFSYM,
! 37     HYPHEN,			/* NEGOP or SUBOP */
! 38     INCSYM,			/* PREINCOP or POSTINCOP */
! 39     LBRACE,
! 40     LBRACKET,
! 41     LPAREN,
! 42     RBRACE,
! 43     RBRACKET,
! 44     RPAREN,
! 45     SEMICOLON,
! 46     STAR,			/* INDIRECTOP or MULOP */
! 47     WHITESPACE,
! 48 
! 49 /* The next group of entries consists of all operator codes.  These codes must
! 50    be contiguous so they can be used as (offsetted) array indexes.  The group
! 51    is ordered by operator-precedence (this is not necessary).  The first part
! 52    of it overlaps the previous group.
! 53 */
! 54 
! 55 /* Assign-abops (level 1) belong here but are at end to improve switch. */
! 56 
! 57 #define FIRSTOP CONDOP
! 58     CONDOP,			/* level 2 */
! 59 
! 60     OROP,			/* level 5 */
! 61 
! 62     EOROP,			/* level 6 */
! 63 
! 64     ANDOP,			/* level 7 */
! 65 
! 66     GTOP,			/* level 9 */
! 67     LTOP,
! 68 
! 69     ADDOP,			/* level 11 */
! 70 
! 71     DIVOP,			/* level 12 */
! 72     MODOP,
! 73 
! 74     LOGNOTOP,			/* level 13 */
! 75     NOTOP,
! 76 
! 77     STRUCELTOP,			/* level 14 */
! 78     STRUCPTROP,
! 79 
! 80 /* End of symbols that appear in symofchar[]. */
! 81 
! 82     ASSIGNOP,			/* level 1 - assign ops must be contiguous */
! 83     ADDABOP,
! 84     ANDABOP,
! 85     DIVABOP,
! 86     EORABOP,
! 87     M
! 87 ODABOP,
! 88     MULABOP,
! 89     ORABOP,
! 90     SLABOP,
! 91     SRABOP,
! 92     SUBABOP,
! 93 
! 94     COMMAOP,			/* level 0 */
! 95 
! 96     COLONOP,			/* level 2 */
! 97 
! 98     LOGOROP,			/* level 3 */
! 99 
! 100     LOGANDOP,			/* level 4 */
! 101 
! 102     EQOP,			/* level 8 */
! 103     NEOP,
! 104 
! 105     GEOP,			/* level 9 */
! 106     LEOP,
! 107 
! 108     SLOP,			/* level 10 */
! 109     SROP,
! 110 
! 111     SUBOP,			/* level 11 */
! 112 
! 113     MULOP,			/* level 12 */
! 114 
! 115     ADDRESSOP,			/* level 13 */
! 116     CASTOP,
! 117     INDIRECTOP,
! 118     NEGOP,
! 119     PREDECOP,
! 120     PREINCOP,
! 121     POSTDECOP,
! 122     POSTINCOP,
! 123 
! 124     FUNCOP,			/* level 14 */
! 125     LISTOP,
! 126     ROOTLISTOP,
! 127 
! 128     LEAF,			/* special */
! 129     PTRADDABOP,
! 130     PTRADDOP,
! 131     PTRSUBOP,
! 132 
! 133 /* end of operator codes (they must stay contiguous) */
! 134 
! 135 #define LASTOP PTRSUBOP
! 136 
! 137     ENUMDECL,
! 138     NULLDECL,
! 139     STRUCTDECL,
! 140     TYPEDECL,
! 141     TYPEDEFNAME,
! 142     UNIONDECL,
! 143     UNSIGNDECL,
! 144 
! 145     AUTODECL,
! 146     EXTERNDECL,
! 147     REGDECL,
! 148     STATICDECL,
! 149     TYPEDEFDECL,
! 150 
! 151     ASMSYM,
! 152     BREAKSYM,
! 153     CASESYM,
! 154     CONTSYM,
! 155     DEFAULTSYM,
! 156     DEFINEDSYM,
! 157     DOSYM,
! 158     ELSESYM,
! 159     FORSYM,
! 160     GOTOSYM,
! 161     IFSYM,
! 162     RETURNSYM,
! 163     SIZEOFSYM,
! 164     SWITCHSYM,
! 165     WHILESYM,
! 166 
! 167     ASMCNTL,
! 168     DEFINECNTL,
! 169     ENDASMCNTL,
! 170     INCLUDECNTL,
! 171     LINECNTL,
! 172     UNDEFCNTL,
! 173 
! 174     ELIFCNTL,			/* "IF" controls must be contiguous */
! 175     ELSECNTL,
! 176     ENDIFCNTL,
! 177     IFCNTL,
! 178     IFDEFCNTL,
! 179     IFNDEFCNTL
! 180 };
! 181 
! 182 EXTERN op_pt arg1op;		/* LISTOP, or ROOTLISTOP if arg1inreg */
! 183 EXTERN struct
! 184 {
! 185     union
! 186     {
! 187 	char *s;
! 188 	value_t v;
! 189 	double d;
! 190     }
! 191       value;
! 192     struct typestruct *type;
! 193 }
! 194  constant;			/* value of last constant scanned */
! 195 				/* sym tells type */
! 196 EXTERN char funcname[NAMESIZE];	/* name of current function for unique labels */
! 197 EXTERN char gs2name[2 + NAMESIZE];	/* 2 reserved for namespace keys */
! 198 #define gsname (gs2name + 2)	/* before last identifier */
! 199 EXTERN struct symstruct *gsymptr;	/* symbol ptr for last identifier */
! 200 EXTERN bool_t incppexpr;	/* nonzero while scanning cpp expression */
! 201 EXTERN sym_t sym;		/* current symbol */
! 202 extern sym_t symofchar[];	/* table to convert chars to their symbols */
! 203 
! 203 
! 204 
! 11 #include "table.h"		/* just for charptr for string constant */
! 1 
! 1 /* table.h - table handler for bcc */
! 2 
! 3 /* Copyright (C) 1992 Bruce Evans */
! 4 
! 5 EXTERN char *charptr;		/* next free spot in catchall table */
! 6 EXTERN char *chartop;		/* spot after last in table */
! 7 EXTERN char *char1top;		/* last character spot in table */
! 8 EXTERN char *char3top;		/* third last character spot in table */
! 9 EXTERN struct symstruct *exprptr;
! 10 				/* next entry in expression symbol table */
! 11 EXTERN struct symstruct *locptr;
! 12 				/* next entry in local symbol table */
! 13 extern struct symstruct locsyms[];
! 14 				/* local symbol table */
! 15 
! 16 #define TS1
! 17 #ifdef TS
! 18 uvalue_t ts_n_newtypelist;
! 19 uvalue_t ts_s_newtypelist;
! 20 uvalue_t ts_n_filename_term;
! 21 uvalue_t ts_s_filename_term;
! 22 uvalue_t ts_n_filename;
! 23 uvalue_t ts_s_filename;
! 24 uvalue_t ts_s_filename_tot;
! 25 uvalue_t ts_n_pathname;
! 26 uvalue_t ts_s_pathname;
! 27 uvalue_t ts_s_pathname_tot;
! 28 uvalue_t ts_n_inputbuf;
! 29 uvalue_t ts_s_inputbuf;
! 30 uvalue_t ts_s_inputbuf_tot;
! 31 uvalue_t ts_n_includelist;
! 32 uvalue_t ts_s_includelist;
! 33 uvalue_t ts_s_outputbuf;
! 34 uvalue_t ts_n_macstring_ident;
! 35 uvalue_t ts_n_macstring_ordinary;
! 36 uvalue_t ts_n_macstring_param;
! 37 uvalue_t ts_n_macstring_quoted;
! 38 uvalue_t ts_n_macstring_term;
! 39 uvalue_t ts_s_macstring;
! 40 uvalue_t ts_n_defines;
! 41 uvalue_t ts_s_defines;
! 42 uvalue_t ts_n_macparam;
! 43 uvalue_t ts_s_macparam;
! 44 uvalue_t ts_s_macparam_tot;
! 45 uvalue_t ts_n_macparam_string_ordinary;
! 46 uvalue_t ts_n_macparam_string_quoted;
! 47 uvalue_t ts_n_macparam_string_term;
! 48 uvalue_t ts_s_macparam_string;
! 49 uvalue_t ts_s_macparam_string_tot;
! 50 uvalue_t ts_s_macparam_string_alloced;
! 51 uvalue_t ts_s_macparam_string_alloced_tot;
! 52 uvalue_t ts_s_fakeline;
! 53 uvalue_t ts_s_fakeline_tot;
! 54 uvalue_t ts_n_string;
! 55 uvalue_t ts_n_case;
! 56 uvalue_t ts_n_case_realloc;
! 57 uvalue_t ts_s_case;
! 58 uvalue_t ts_s_case_tot;
! 59 uvalue_t ts_n_structname;
! 60 uvalue_t ts_s_structname;
! 61 uvalue_t ts_n_type;
! 62 uvalue_t ts_s_type;
! 63 uvalue_t ts_n_global;
! 64 uvalue_t ts_size_global;
! 65 uvalue_t ts_n_holdstr;
! 66 uvalue_t ts_size_holdstr;
! 67 uvalue_t ts_n_growobj;
! 68 uvalue_t ts_size_growobj_wasted;
! 69 uvalue_t ts_n_growheap;
! 70 uvalue_t ts_s_growheap;
! 71 #endif
! 72 
! 72 
! 73 
! 12 #include "type.h"
! 1 
! 1 /* type.h - types for bcc */
! 2 
! 3 /* Copyright (C) 1992 Bruce Evans */
! 4 
! 5 /*
! 6   A type is essentially a "constructor", a size, and a list of pointers
! 7   leading to a scalar type.
! 8   The type constructors are codes for the scalar types and (), [], *,
! 9   struct and union.
! 10   The scalar types are char, short, int, long, float and double.
! 11   The type lists are triply linked.
! 12 
! 13   Part of the type structure might look like
! 14 
! 15 			   int		(int)
! 16 			    =
! 17 	    func <-------> int		(int ())
! 18 	     |		    =
! 19 	      --> ptr <--> int		(int *)
! 20 
! 21   (the exact structure depends on the order of declarations).
! 22   This layout results from the pre-declared (int) and (int ()) followed by
! 23   a declaration using (int *).
! 24   The sideways link (from func to ptr here) allows all types leading to a
! 25   given type to be found.
! 26   This allows different declarations of (int *) to be recognised as the same.
! 27   Type equivalence is equality of type pointers.
! 28 */
! 29 
! 30 /*
! 31   flags for scalar types
! 32   up to 3 of the flags may be set (none for constructed types)
! 33   the 2nd and third flags can only be UNSIGNED or DLONG
! 34   UNSIGNED only applies to integral types
! 35   DLONG only applies to long and unsigned long types and says that these
! 36   are actually longer than an int
! 37 */
! 38 
! 39 #define	CHAR		0x01
! 40 #define	SHORT		0x02
! 41 #define	INT		0x04
! 42 #define	LONG		0x08
! 43 #define	FLOAT		0x10
! 44 #define DOUBLE		0x20
! 45 #define UNSIGNED	0x40
! 46 #define DLONG		0x80
! 47 
! 48 #define ISCALAR		(CHAR | SHORT | INT | LONG)
! 49 #define RSCALAR		(FLOAT | DOUBLE)
! 50 
! 51 /*
! 52   flags for type constructor
! 53   at most 1 of the flags may be set (none for scalar types)
! 54   flags are used for fast testing for array/pointer
! 55 */
! 56 
! 57 #define ARRAY		1
! 58 #define FUNCTION	2
! 59 #define POINTER		4
! 60 #define STRUCTU		8
! 61 #define VOID		0x10
! 62 
! 63 /* type sizes */
! 64 /* default sizes and long and float sizes are hard-coded into type data */
! 65 
! 66 extern uoffset_T ctypesize;
! 67 extern uoffset_T dtypesize;
! 68 extern uoffset_T ftypesize;
! 69 extern uoffset_T itypesize;
! 70 extern uoffset_T ptypesize;
! 71 extern uoffset_T stypesize;
! 72 
! 73 /* basic scalar types */
! 74 
! 75 EXTERN struct typestruct *dtype;
! 76 EXTERN struct typestruct *fl
! 76 type;
! 77 EXTERN struct typestruct *itype;
! 78 EXTERN struct typestruct *ltype;
! 79 EXTERN struct typestruct *sctype;
! 80 EXTERN struct typestruct *stype;
! 81 EXTERN struct typestruct *uctype;
! 82 EXTERN struct typestruct *uitype;
! 83 EXTERN struct typestruct *ultype;
! 84 EXTERN struct typestruct *ustype;
! 85 EXTERN struct typestruct *vtype;
! 86 
! 87 /* working type */
! 88 
! 89 EXTERN struct typestruct *ctype;
! 90 
! 91 /* constructed types */
! 92 
! 93 EXTERN struct typestruct *fitype;
! 94 EXTERN struct typestruct *pctype;
! 95 
! 96 /* return type of current function */
! 97 
! 98 EXTERN struct typestruct *returntype;
! 99 
! 99 
! 100 
! 13 
! 14 PRIVATE unsigned insizeof;	/* nest level for getsizeof */
! 15 				/* used to avoid aborting undefined idents */
! 16 				/* to 0 when they appear in a cpp expression */
! 17 				/* under sizeof */
! 18 
! 19 /* names of expression functions are related to the 15 precedence levels */
! 20 /* on p49 of K & R */
! 21 
! 22 FORWARD struct nodestruct *cast_exp P((void));
! 23 FORWARD struct nodestruct *exp2 P((void));
! 24 FORWARD struct nodestruct *exp3to12 P((fastin_pt lprecedence));
! 25 FORWARD struct nodestruct *listargs P((void));
! 26 FORWARD struct nodestruct *postfix_exp P((bool_pt seenlp));
! 27 FORWARD struct nodestruct *primary_exp P((void));
! 28 FORWARD struct nodestruct *unary_exp P((void));
! 29 
! 30 PRIVATE struct nodestruct *cast_exp()
! 31 {
_cast_exp:
! 32     struct nodestruct *nodeptr;
! 33     scalar_t scalar;
! 34     struct typestruct *vartype;
! 35 
! 36     if (sym != LPAREN)
push	bp
mov	bp,sp
push	di
push	si
add	sp,*-6
cmp	byte ptr [_sym],*$12
je  	.1
.2:
! 37 	return unary_exp();
call	_unary_exp
add	sp,*6
pop	si
pop	di
pop	bp
ret
! 38     nextsym();
.1:
call	_nextsym
! 39     if ((vartype = typename()) == NULL)
call	_typename
mov	-$A[bp],ax
test	ax,ax
jne 	.3
.4:
! 40 	return postfix_exp(TRUE);
mov	ax,*1
push	ax
call	_postfix_exp
inc	sp
inc	sp
add	sp,*6
pop	si
pop	di
pop	bp
ret
! 41     rparen();
.3:
call	_rparen
! 42     scalar = (nodeptr = cast_exp())->nodetype->scalar;
call	_cast_exp
mov	-6[bp],ax
mov	bx,ax
mov	bx,4[bx]
mov	al,[bx]
mov	-7[bp],al
! 43     if (vartype->scalar & INT && scalar & (CHAR | SHORT | INT)
! 44 	&& !((vartype->scalar ^ scalar) & UNSIGNED))
mov	bx,-$A[bp]
mov	al,[bx]
and	al,*4
je  	.5
.8:
mov	al,-7[bp]
and	al,*7
je  	.5
.7:
mov	bx,-$A[bp]
mov	al,[bx]
xor	al,-7[bp]
and	al,*$40
jne 	.5
.6:
! 45     {
! 46 	nodeptr->flags &= ~LVALUE;
mov	bx,-6[bp]
mov	al,2[bx]
and	al,#$FE
mov	2[bx],al
! 47 	return nodeptr;		/* skip casts that are default promotions */
mov	ax,-6[bp]
add	sp,*6
pop	si
pop	di
pop	bp
ret
! 48     }
! 49     return castnode(vartype, nodeptr);
.5:
push	-6[bp]
push	-$A[bp]
call	_castnode
add	sp,*4+6
pop	si
pop	di
pop	bp
ret
! 50 }
! 51 
! 52 PUBLIC struct nodestruct *assignment_exp()
! 53 {
export	_assignment_exp
_assignment_exp:
! 54     struct nodestruct *lhs;
! 55     op_pt op;
! 56 
! 57     lhs = exp2();
push	bp
mov	bp,sp
push	di
push	si
add	sp,*-4
call	_exp2
mov	-6[bp],ax
! 58     if (sym >= ASSIGNOP && sym <= SUBABOP)	/* assign-op syms in order! */
cmp	byte ptr [_sym],*$26
jb  	.9
.B:
cmp	byte ptr [_sym],*$30
ja  	.9
.A:
! 59     {
! 60 	op = sym;
mov	al,[_sym]
xor	ah,ah
mov	-8[bp],ax
! 61 	nextsym();
call	_nextsym
! 62 	lhs = node(op, lhs, assignment_exp());
call	_assignment_exp
push	ax
push	-6[bp]
push	-8[bp]
call	_node
add	sp,*6
mov	-6[bp],ax
! 63     }
! 64     return lhs;
.9:
mov	ax,-6[bp]
add	sp,*4
pop	si
pop	di
pop	bp
ret
! 65 }
! 66 
! 67 PUBLIC struct nodestruct *expression()
! 68 {
export	_expression
_expression:
! 69     struct nodestruct *lhs;
! 70 
! 71     lhs = assignment_exp();
push	bp
mov	bp,sp
push	di
push	si
dec	sp
dec	sp
call	_assignment_exp
mov	-6[bp],ax
! 72     while (sym == COMMA)
! 73     {
jmp .D
.E:
! 74 	nextsym();
call	_nextsym
! 75 	lhs = node(COMMAOP, lhs, assignment_exp());
call	_assignment_exp
push	ax
push	-6[bp]
mov	ax,*$31
push	ax
call	_node
add	sp,*6
mov	-6[bp],ax
! 76     }
! 77     return lhs;
.D:
cmp	byte ptr [_sym],*$B
je 	.E
.F:
.C:
mov	ax,-6[bp]
inc	sp
inc	sp
pop	si
pop	di
pop	bp
ret
! 78 }
! 79 
! 80 PRIVATE struct nodestruct *exp2()
! 81 {
_exp2:
! 82     struct nodestruct *lhs
! 82 ;
! 83     struct nodestruct *rhs;
! 84 
! 85     lhs = exp3to12(0);
push	bp
mov	bp,sp
push	di
push	si
add	sp,*-4
xor	ax,ax
push	ax
call	_exp3to12
inc	sp
inc	sp
mov	-6[bp],ax
! 86     if (sym == CONDOP)
cmp	byte ptr [_sym],*$19
jne 	.10
.11:
! 87     {
! 88 	nextsym();
call	_nextsym
! 89 	rhs = expression();
call	_expression
mov	-8[bp],ax
! 90 	colon();
call	_colon
! 91 	lhs = node(CONDOP, lhs, node(COLONOP, rhs, exp2()));
call	_exp2
push	ax
push	-8[bp]
mov	ax,*$32
push	ax
call	_node
add	sp,*6
push	ax
push	-6[bp]
mov	ax,*$19
push	ax
call	_node
add	sp,*6
mov	-6[bp],ax
! 92     }
! 93     return lhs;
.10:
mov	ax,-6[bp]
add	sp,*4
pop	si
pop	di
pop	bp
ret
! 94 }
! 95 
! 96 PRIVATE struct nodestruct *exp3to12(lprecedence)
! 97 fastin_pt lprecedence;
_exp3to12:
! 98 {
! 99     struct nodestruct *lhs;
! 100     op_pt op;
! 101     fastin_t rprecedence;
! 102 
! 103     lhs = cast_exp();
push	bp
mov	bp,sp
push	di
push	si
add	sp,*-6
call	_cast_exp
mov	-6[bp],ax
! 104     while (TRUE)
! 105     {
.14:
! 106 	rprecedence = 0;
xor	al,al
mov	-9[bp],al
! 107 	switch (sym)
mov	al,[_sym]
! 108 	{
br 	.17
! 109 	case LOGOROP:
! 110 	    if ((fastin_t) lprecedence <= 1)
.18:
cmp	byte ptr 4[bp],*1
ja  	.19
.1A:
! 111 		rprecedence = 2;
mov	al,*2
mov	-9[bp],al
! 112 	    break;
.19:
br 	.15
! 113 	case LOGANDOP:
! 114 	    if ((fastin_t) lprecedence <= 3)
.1B:
cmp	byte ptr 4[bp],*3
ja  	.1C
.1D:
! 115 		rprecedence = 4;
mov	al,*4
mov	-9[bp],al
! 116 	    break;
.1C:
br 	.15
! 117 	case OROP:
! 118 	    if ((fastin_t) lprecedence <= 5)
.1E:
cmp	byte ptr 4[bp],*5
ja  	.1F
.20:
! 119 		rprecedence = 6;
mov	al,*6
mov	-9[bp],al
! 120 	    break;
.1F:
br 	.15
! 121 	case EOROP:
! 122 	    if ((fastin_t) lprecedence <= 7)
.21:
cmp	byte ptr 4[bp],*7
ja  	.22
.23:
! 123 		rprecedence = 8;
mov	al,*8
mov	-9[bp],al
! 124 	    break;
.22:
br 	.15
! 125 	case AMPERSAND:
! 126 	    if ((fastin_t) lprecedence <= 9)
.24:
cmp	byte ptr 4[bp],*9
ja  	.25
.26:
! 127 	    {
! 128 		sym = ANDOP;
mov	al,*$1C
mov	[_sym],al
! 129 		rprecedence = 10;
mov	al,*$A
mov	-9[bp],al
! 130 	    }
! 131 	    break;
.25:
br 	.15
! 132 	case EQOP:
! 133 	case NEOP:
.27:
! 134 	    if ((fastin_t) lprecedence <= 11)
.28:
cmp	byte ptr 4[bp],*$B
ja  	.29
.2A:
! 135 		rprecedence = 12;
mov	al,*$C
mov	-9[bp],al
! 136 	    break;
.29:
br 	.15
! 137 	case GEOP:
! 138 	case GTOP:
.2B:
! 139 	case LEOP:
.2C:
! 140 	case LTOP:
.2D:
! 141 	    if ((fastin_t) lprecedence <= 13)
.2E:
cmp	byte ptr 4[bp],*$D
ja  	.2F
.30:
! 142 		rprecedence = 14;
mov	al,*$E
mov	-9[bp],al
! 143 	    break;
.2F:
br 	.15
! 144 	case SLOP:
! 145 	case SROP:
.31:
! 146 	    if ((fastin_t) lprecedence <= 15)
.32:
cmp	byte ptr 4[bp],*$F
ja  	.33
.34:
! 147 		rprecedence = 16;
mov	al,*$10
mov	-9[bp],al
! 148 	    break;
.33:
br 	.15
! 149 	case HYPHEN:
! 150 	    if ((fastin_t) lprecedence <= 17)
.35:
cmp	byte ptr 4[bp],*$11
ja  	.36
.37:
! 151 	    {
! 152 		sym = SUBOP;
mov	al,*$3B
mov	[_sym],al
! 153 		rprecedence = 18;
mov	al,*$12
mov	-9[bp],al
! 154 	    }
! 155 	    break;
.36:
br 	.15
! 156 	case ADDOP:
! 157 	    if ((fastin_t) lprecedence <= 17)
.38:
cmp	byte ptr 4[bp],*$11
ja  	.39
.3A:
! 158 		rprecedence = 18;
mov	al,*$12
mov	-9[bp],al
! 159 	    break;
.39:
br 	.15
! 160 	case STAR:
! 161 	    if ((fastin_t) lprecedence <= 19)
.3B:
cmp	byte ptr 4[bp],*$13
ja  	.3C
.3D:
! 162 	    {
! 163 		sym = MULOP;
mov	al,*$3C
mov	[_sym],al
! 164 		rprecedence = 20;
mov	al,*$14
mov	-9[bp],al
! 165 	    }
! 166 	    break;
.3C:
jmp .15
! 167 	case DIVOP:
! 168 	case MODOP:
.3E:
! 169 	    if ((fastin_t) lprecedence <= 19)
.3F:
cmp	byte ptr 4[bp],*$13
ja  	.40
.41:
! 170 		rprecedence = 20;
mov	al,*$14
mov	-9[bp],al
! 171 	    break;
.40:
jmp .15
! 172 	}
! 173 	if (rprecedence == 0)
jmp .15
.17:
sub	al,*8
jb  	.15
cmp	al,*$19
ja  	.42
xor	ah,ah
shl	ax,*1
mov	bx,ax
seg	cs
br	.43[bx]
.43:
.word	.24
.word	.15
.word	.15
.word	.15
.word	.15
.word	.15
.word	.35
.word	.15
.word	.15
.word	.15
.word	.15
.word	.15
.word	.15
.word	.15
.word	.15
.word	.3B
.word	.15
.word	.15
.word	.1E
.word	.21
.word	.15
.word	.2C
.word	.2E
.word	.38
.word	.3E
.word	.3F
.42:
sub	al,*$2B
jb  	.15
cmp	al,*7
ja  	.44
xor	ah,ah
shl	ax,*1
mov	bx,ax
seg	cs
br	.45[bx]
.45:
.word	.18
.word	.1B
.word	.27
.word	.28
.word	.2B
.word	.2D
.word	.31
.word	.32
.44:
.15:
..FFFF	=	-$C
mov	al,-9[bp]
test	al,al
jne 	.46
.47:
! 174 	    break;
jmp .12
! 175 	op = sym;
.46:
mov	al,[_sym]
xor	ah,ah
mov	-8[bp],ax
! 176 	nextsym();
call	_nextsym
! 177 	lhs = node(op, lhs, exp3to12(rprecedence));
mov	al,-9[bp]
xor	ah,ah
push	ax
call	_exp3to12
inc	sp
inc	sp
push	ax
push	-6[bp]
push	-8[bp]
call	_node
add	sp,*6
mov	-6[bp],ax
! 178     }
! 179     return lhs;
.13:
br 	.14
.48:
.12:
mov	ax,-6[bp]
add	sp,*6
pop	si
pop	di
pop	bp
ret
! 180 }
! 181 
! 182 PRIVATE struct nodestruct *listargs()
! 183 {
_listargs:
! 184     struct nodestruct *parent;
! 185     struct nodestruct *nextright;
! 186 
! 187     if (sym == RPAREN)
push	bp
mov	bp,sp
push	di
push	si
add	sp,*-4
cmp	byte ptr [_sym],*$15
jne 	.49
.4A:
! 188     {
! 189 	nextsym();
call	_nextsym
! 190 	return NULLNODE;
xor	ax,ax
add	sp,*4
pop	si
pop	di
pop	bp
ret
! 191     }
! 192     parent = node(arg1op, assignment_exp(), NULLNODE);
.49:
xor	ax,ax
push	ax
call	_assignment_exp
push	ax
push	[_arg1op]
call	_node
add	sp,*6
mov	-6[bp],ax
mov	bx,ax
mov	-8[bp],bx
! 194     while (sym == COMMA)
! 195     {
jmp .4C
.4D:
! 196 	nextsym();
call	_nextsym
! 197 	nextright = nextright->right
! 198 	 
! 198    = node(LISTOP, assignment_exp(), NULLNODE);
xor	ax,ax
push	ax
call	_assignment_exp
push	ax
mov	ax,*$46
push	ax
call	_node
add	sp,*6
mov	bx,-8[bp]
mov	8[bx],ax
mov	-8[bp],ax
! 199     }
! 200     rparen();
.4C:
cmp	byte ptr [_sym],*$B
je 	.4D
.4E:
.4B:
call	_rparen
! 201     return parent;
mov	ax,-6[bp]
add	sp,*4
pop	si
pop	di
pop	bp
ret
! 202 }
! 203 
! 204 PRIVATE struct nodestruct *postfix_exp(seenlp)
! 205 bool_pt seenlp;
_postfix_exp:
! 206 {
! 207     struct nodestruct *nodeptr;
! 208     struct symstruct *symptr;
! 209 
! 210     if (seenlp)
push	bp
mov	bp,sp
push	di
push	si
add	sp,*-4
mov	ax,4[bp]
test	ax,ax
je  	.4F
.50:
! 211     {
! 212 	nodeptr = expression();
call	_expression
mov	-6[bp],ax
! 213 	rparen();
call	_rparen
! 214     }
! 215     else
! 216 	nodeptr = primary_exp();
jmp .51
.4F:
call	_primary_exp
mov	-6[bp],ax
! 217     while (TRUE)
.51:
! 218     {
.54:
! 219 	switch (sym)
mov	al,[_sym]
! 220 	{
br 	.57
! 221 	case DECSYM:
! 222 	    nextsym();
.58:
call	_nextsym
! 223 	    nodeptr = node(POSTDECOP, nodeptr, NULLNODE);
xor	ax,ax
push	ax
push	-6[bp]
mov	ax,*$43
push	ax
call	_node
add	sp,*6
mov	-6[bp],ax
! 224 	    continue;
add	sp,#-$A-..FFFE
br 	.53
! 225 	case INCSYM:
! 226 	    nextsym();
.59:
call	_nextsym
! 227 	    nodeptr = node(POSTINCOP, nodeptr, NULLNODE);
xor	ax,ax
push	ax
push	-6[bp]
mov	ax,*$44
push	ax
call	_node
add	sp,*6
mov	-6[bp],ax
! 228 	    continue;
add	sp,#-$A-..FFFE
br 	.53
! 229 	case LBRACKET:
! 230 	    nextsym();
.5A:
call	_nextsym
! 231 	    nodeptr = node(INDIRECTOP, node(ADDOP, nodeptr, expression()),
! 232 			   NULLNODE);
xor	ax,ax
push	ax
call	_expression
push	ax
push	-6[bp]
mov	ax,*$1F
push	ax
call	_node
add	sp,*6
push	ax
mov	ax,*$3F
push	ax
call	_node
add	sp,*6
mov	-6[bp],ax
! 233 	    rbracket();
call	_rbracket
! 234 	    continue;
add	sp,#-$A-..FFFE
br 	.53
! 235 	case LPAREN:
! 236 	    nextsym();
.5B:
call	_nextsym
! 237 	    nodeptr = node(FUNCOP, nodeptr, listargs());
call	_listargs
push	ax
push	-6[bp]
mov	ax,*$45
push	ax
call	_node
add	sp,*6
mov	-6[bp],ax
mov	bx,ax
mov	si,8[bx]
! 242 		{
jmp .5E
.5F:
! 243 		    if (np->nodetype->scalar & RSCALAR)
mov	bx,4[si]
mov	al,[bx]
and	al,*$30
je  	.60
.61:
! 244 		    {
! 245 			np = nodeptr->left.nodeptr;
mov	bx,-6[bp]
mov	si,6[bx]
! 246 			if (np->tag != LEAF)
cmp	byte ptr [si],*$48
je  	.62
.63:
! 247 			    printf_fp = TRUE;
mov	al,*1
mov	[_printf_fp],al
! 248 			else
! 249 			{
jmp .64
.62:
! 250 			    unsigned len;
! 251 			    register char *name;
! 252 
! 253 			    name = np->left.symptr->name.namep;
mov	bx,6[si]
mov	di,$10[bx]
! 254 			    if ((len = strlen(name)) >= 6
! 255 				&& strcmp(name + len - 6, "printf") == 0)
push	di
call	_strlen
inc	sp
inc	sp
mov	-$A[bp],ax
cmp	ax,*6
jb  	.65
.68:
mov	bx,#.66
push	bx
mov	ax,-$A[bp]
mov	bx,di
add	bx,ax
add	bx,*-6
push	bx
call	_strcmp
add	sp,*4
test	ax,ax
jne 	.65
.67:
! 256 				printf_fp = TRUE;
mov	al,*1
mov	[_printf_fp],al
! 257 			}
.65:
! 258 			break;
.64:
jmp .5C
! 259 		    }
! 260 		}
.60:
! 261 		for (np = nodeptr->right; np != NULL; np = np->right)
.5D:
mov	si,8[si]
.5E:
test	si,si
jne	.5F
.69:
.5C:
mov	bx,-6[bp]
mov	si,8[bx]
! 262 		{
jmp .6C
.6D:
! 263 		    if (np->nodetype->constructor & POINTER
! 264 			&& np->nodetype->nexttype->scalar & RSCALAR)
mov	bx,4[si]
mov	al,1[bx]
and	al,*4
je  	.6E
.70:
mov	bx,4[si]
mov	bx,$10[bx]
mov	al,[bx]
and	al,*$30
je  	.6E
.6F:
! 265 		    {
! 266 			np = nodeptr->left.nodeptr;
mov	bx,-6[bp]
mov	si,6[bx]
! 267 			if (np->tag != LEAF)
cmp	byte ptr [si],*$48
je  	.71
.72:
! 268 			    scanf_fp = TRUE;
mov	al,*1
mov	[_scanf_fp],al
! 269 			else
! 270 			{
jmp .73
.71:
! 271 			    unsigned len;
! 272 			    register char *name;
! 273 
! 274 			    name = np->left.symptr->name.namep;
mov	bx,6[si]
mov	di,$10[bx]
! 275 			    if ((len = strlen(name)) >= 5
! 276 				&& strcmp(name + len - 5, "scanf") == 0)
push	di
call	_strlen
inc	sp
inc	sp
mov	-$A[bp],ax
cmp	ax,*5
jb  	.74
.77:
mov	bx,#.75
push	bx
mov	ax,-$A[bp]
mov	bx,di
add	bx,ax
add	bx,*-5
push	bx
call	_strcmp
add	sp,*4
test	ax,ax
jne 	.74
.76:
! 277 				scanf_fp = TRUE;
mov	al,*1
mov	[_scanf_fp],al
! 278 			}
.74:
! 279 			break;
.73:
jmp .6A
! 280 		    }
! 281 		}
.6E:
! 282 	    }
.6B:
mov	si,8[si]
.6C:
test	si,si
jne	.6D
.78:
.6A:
! 283 	    continue;
add	sp,#-$A-..FFFE
br 	.53
! 284 	case STRUCPTROP:
! 285 	    nodeptr = node(INDIRECTOP, nodeptr, NULLNODE);
.79:
xor	ax,ax
push	ax
push	-6[bp]
mov	ax,*$3F
push	ax
call	_node
add	sp,*6
mov	-6[bp],ax
! 286 	case STRUCELTOP:
! 287 	    nextsym();
.7A:
call	_nextsym
! 288 	    gs2name[0] = nodeptr->nodetype->structkey[0];
mov	bx,-6[bp]
mov	bx,4[bx]
mov	al,2[bx]
mov	[_gs2name],al
! 289 	    gs2name[1] = nodeptr->nodetype->structkey[1];
mov	bx,-6[bp]
mov	bx,4[bx]
mov	al,3[bx]
mov	[_gs2name+1],al
! 290 	    if ((gsymptr = findlorg(gs2name)) == NULL)
mov	bx,#_gs2name
push	bx
call	_findlorg
inc	sp
inc	sp
mov	[_gsymptr],ax
test	ax,ax
jne 	.7B
.7C:
! 291 	    {
! 292 		error("undefined structure element");
mov	bx,#.7D
push	bx
call	_error
inc	sp
inc	sp
! 293 	
! 293 	gsymptr = addglb(gs2name, itype);
push	[_itype]
mov	bx,#_gs2name
push	bx
call	_addglb
add	sp,*4
mov	[_gsymptr],ax
! 294 	    }
! 295 	    symptr = exprsym(gsymptr);
.7B:
push	[_gsymptr]
call	_exprsym
inc	sp
inc	sp
mov	-8[bp],ax
! 296 	    nextsym();
call	_nextsym
! 297 	    nodeptr = node(STRUCELTOP, nodeptr, leafnode(symptr));
push	-8[bp]
call	_leafnode
inc	sp
inc	sp
push	ax
push	-6[bp]
mov	ax,*$24
push	ax
call	_node
add	sp,*6
mov	-6[bp],ax
! 298 	    continue;
add	sp,#-$A-..FFFE
jmp .53
! 299 	default:
! 300 	    return nodeptr;
.7E:
mov	ax,-6[bp]
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 301 	}
! 302     }
jmp .55
.57:
dec	sp
dec	sp
sub	al,*$C
beq 	.58
sub	al,*3
beq 	.59
sub	al,*2
beq 	.5A
sub	al,*1
beq 	.5B
sub	al,*$12
beq 	.7A
sub	al,*1
beq 	.79
jmp	.7E
.55:
..FFFE	=	-$C
inc	sp
inc	sp
! 303 }
.53:
br 	.54
.7F:
.52:
add	sp,*4
pop	si
pop	di
pop	bp
ret
! 304 
! 305 PRIVATE struct nodestruct *primary_exp()
! 306 {
_primary_exp:
! 307     bool_t isdefined;
! 308     struct nodestruct *nodeptr;
! 309     uoffset_T stringlen;
! 310     struct symstruct *symptr;
! 311     struct symstruct *symptr1;
! 312     bool_t waslparen;
! 313 
! 314     switch (sym)
push	bp
mov	bp,sp
push	di
push	si
add	sp,*-$E
mov	al,[_sym]
! 315     {
br 	.82
! 316     case IDENT:
! 317 	if (incppexpr && !insizeof)
.83:
mov	al,[_incppexpr]
test	al,al
je  	.84
.86:
mov	ax,[_insizeof]
test	ax,ax
jne 	.84
.85:
! 318 	{
! 319 cpp_ident:
.FFFC:
! 320 	    nextsym();
call	_nextsym
! 321 	    return leafnode(constsym((value_t) 0));
xor	ax,ax
xor	bx,bx
push	bx
push	ax
call	_constsym
add	sp,*4
push	ax
call	_leafnode
inc	sp
inc	sp
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 322 	}
! 323 	if ((symptr = gsymptr) != NULL)
.84:
mov	bx,[_gsymptr]
mov	-$E[bp],bx
test	bx,bx
je  	.87
.88:
! 324 	    nextsym();
call	_nextsym
! 325 	else
! 326 	{
jmp .89
.87:
! 327 	    symptr = addglb(gsname, fitype);
push	[_fitype]
mov	bx,#_gs2name+2
push	bx
call	_addglb
add	sp,*4
mov	-$E[bp],ax
! 328 	    nextsym();
call	_nextsym
! 329 	    if (sym != LPAREN)
cmp	byte ptr [_sym],*$12
je  	.8A
.8B:
! 330 	    {
! 331 		error2error(symptr->name.namea, " undeclared");
mov	bx,#.8C
push	bx
mov	bx,-$E[bp]
add	bx,*$10
push	bx
call	_error2error
add	sp,*4
! 332 		symptr->indcount = 1;
mov	bx,-$E[bp]
mov	al,*1
mov	2[bx],al
! 333 		symptr->type = itype;
mov	bx,-$E[bp]
mov	si,[_itype]
mov	$A[bx],si
! 334 	    }
! 335 	}
.8A:
! 336 	symptr1 = exprsym(symptr);
.89:
push	-$E[bp]
call	_exprsym
inc	sp
inc	sp
mov	-$10[bp],ax
! 337 	if (symptr->flags & STATIC && symptr->level != GLBLEVEL)
mov	bx,-$E[bp]
mov	al,3[bx]
and	al,*4
je  	.8D
.8F:
mov	bx,-$E[bp]
mov	al,4[bx]
test	al,al
je  	.8D
.8E:
! 338 	{
! 339 	    symptr1->flags |= LABELLED;
mov	bx,-$10[bp]
mov	al,3[bx]
or	al,*$10
mov	3[bx],al
! 340 	    symptr1->offset.offi = 0;
mov	bx,-$10[bp]
xor	ax,ax
xor	si,si
mov	$C[bx],ax
mov	$E[bx],si
! 341 	    symptr1->name.label = symptr->offset.offlabel;
mov	bx,-$E[bp]
mov	si,-$10[bp]
mov	bx,$C[bx]
mov	$10[si],bx
! 342 	}
! 343 	nodeptr = leafnode(symptr1);
.8D:
push	-$10[bp]
call	_leafnode
inc	sp
inc	sp
mov	-8[bp],ax
mov	bx,ax
mov	bx,4[bx]
mov	al,1[bx]
and	al,*$13
jne 	.90
.91:
! 345 	    nodeptr->flags = LVALUE;
mov	bx,-8[bp]
mov	al,*1
mov	2[bx],al
! 346 	return nodeptr;
.90:
mov	ax,-8[bp]
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 347     case TYPEDEFNAME:
! 348 	if (incppexpr && !insizeof)
.92:
mov	al,[_incppexpr]
test	al,al
je  	.93
.95:
mov	ax,[_insizeof]
test	ax,ax
jne 	.93
.94:
! 349 	    goto cpp_ident;	/* else fall through */
add	sp,#..FFFC-..FFFD
br 	.FFFC
! 350     default:
.93:
! 351 	error("bad expression");
.96:
mov	bx,#.97
push	bx
call	_error
inc	sp
inc	sp
! 352 	constant.value.v = 0;
xor	ax,ax
xor	bx,bx
mov	[_constant],ax
mov	[_constant+2],bx
! 353 	constant.type = itype;
mov	bx,[_itype]
mov	[_constant+4],bx
! 354     case CHARCONST:
! 355     case INTCONST:		/* this includes enumeration-constants */
.98:
! 356 	symptr = constsym(constant.value.v);
.99:
push	[_constant+2]
push	[_constant]
call	_constsym
add	sp,*4
mov	-$E[bp],ax
mov	bx,ax
mov	si,[_constant+4]
mov	$A[bx],si
! 358 	if (!(ltype->scalar & LONG))
mov	bx,[_ltype]
mov	al,[bx]
and	al,*8
jne 	.9A
.9B:
! 359 	{
! 360 	    if (symptr->type == ltype)
mov	bx,-$E[bp]
mov	bx,$A[bx]
cmp	bx,[_ltype]
jne 	.9C
.9D:
! 361 		symptr->type = itype;
mov	bx,-$E[bp]
mov	si,[_itype]
mov	$A[bx],si
! 362 	    else if (symptr->type == ultype)
jmp .9E
.9C:
mov	bx,-$E[bp]
mov	bx,$A[bx]
cmp	bx,[_ultype]
jne 	.9F
.A0:
! 363 		symptr->type = uitype;
mov	bx,-$E[bp]
mov	si,[_uitype]
mov	$A[bx],si
! 364 	}
.9F:
.9E:
! 365 	nextsym();
.9A:
call	_nextsym
! 366 	return leafnode(symptr);
push	-$E[bp]
call	_leafnode
inc	sp
inc	sp
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 367     case DEFINEDSYM:
! 368 	waslparen = isdefined = FALSE;
.A1:
xor	al,al
mov	-5[bp],al
mov	-$11[bp],al
! 369 	if (!blanksident())
call	_blanksident
test	ax,ax
jne 	.A2
.A3:
! 370 	{
! 371 	    nextsym();
call	_nextsym
! 372 	    if (sym != LPAREN)
cmp	byte ptr [_sym],*$12
je  	.A4
.A5:
! 373 		lparen();
call	_lparen
! 374 	    else
! 375 		waslparen = TRUE;
jmp .A6
.A4:
mov	al,*1
mov	-$11[bp],al
! 376 	}
.A6:
! 377 	if (waslparen && !blanksident())
.A2:
mov	al,-$11[bp]
test	al,al
je  	.A7
.A9:
call	_blanksident
test	ax,ax
jne 	.A7
.A8:
! 378 	    needvarname();
call	_needvarname
! 379 	else
! 380 	{
jmp .AA
.A7:
! 381 	    if ((symptr = findlorg(gsname)) != NULL &&
! 382 		symptr->flags == DEFINITION)
mov	bx,#_gs2name+2
push	bx
call	_findlorg
inc	sp
inc	sp
mov	-$E[bp],ax
test	ax,ax
je  	.AB
.AD:
mov	bx,-$E[bp]
cmp	byte ptr 3[bx],*$20
jne 	.AB
.AC:
! 383 		isdefined = TRUE;
mov	al,*1
mov	-5[bp],al
! 384 	    nextsym();
.AB:
call	_nextsym
! 385 	}
! 386 	if (waslparen)
.AA:
! 386 
mov	al,-$11[bp]
test	al,al
je  	.AE
.AF:
! 387 	    rparen();
call	_rparen
! 388 	return leafnode(constsym((value_t) isdefined));
.AE:
mov	al,-5[bp]
xor	ah,ah
xor	bx,bx
push	bx
push	ax
call	_constsym
add	sp,*4
push	ax
call	_leafnode
inc	sp
inc	sp
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 389     case FLOATCONST:
! 390 	symptr = constsym((value_t) 0);
.B0:
xor	ax,ax
xor	bx,bx
push	bx
push	ax
call	_constsym
add	sp,*4
mov	-$E[bp],ax
mov	bx,ax
mov	si,[_constant+4]
mov	$A[bx],si
! 392 	symptr->offset.offd = qmalloc(sizeof *symptr->offset.offd);
mov	ax,*4
push	ax
call	_qmalloc
inc	sp
inc	sp
mov	bx,-$E[bp]
mov	$C[bx],ax
! 393 	*symptr->offset.offd = constant.value.d;
mov	bx,-$E[bp]
mov	bx,$C[bx]
mov	ax,[_constant]
mov	si,[_constant+2]
mov	[bx],ax
mov	2[bx],si
! 394 	nextsym();
call	_nextsym
! 395 	return leafnode(symptr);
push	-$E[bp]
call	_leafnode
inc	sp
inc	sp
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 396     case LPAREN:
! 397 	nextsym();
.B1:
call	_nextsym
! 398 	nodeptr = expression();
call	_expression
mov	-8[bp],ax
! 399 	rparen();
call	_rparen
! 400 	return nodeptr;
mov	ax,-8[bp]
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 401     case STRINGCONST:
! 402 	symptr = constsym((value_t) 0);
.B2:
xor	ax,ax
xor	bx,bx
push	bx
push	ax
call	_constsym
add	sp,*4
mov	-$E[bp],ax
mov	bx,ax
mov	ax,#$80
mov	[bx],ax
! 404 	symptr->flags = LABELLED | STRING;
mov	bx,-$E[bp]
mov	al,#$D0
mov	3[bx],al
! 405 	/* string length before defstr() or prefix() updates charptr */
! 406 	stringlen = charptr - constant.value.s + 1;
mov	ax,[_charptr]
sub	ax,[_constant]
inc	ax
cwd
mov	bx,dx
mov	-$C[bp],ax
mov	-$A[bp],bx
! 407 	symptr->name.label = defstr(constant.value.s, charptr, FALSE);
xor	ax,ax
push	ax
push	[_charptr]
push	[_constant]
call	_defstr
add	sp,*6
mov	bx,-$E[bp]
mov	$10[bx],ax
! 408 	symptr->type = prefix(ARRAY, stringlen, ctype);
push	[_ctype]
push	-$A[bp]
push	-$C[bp]
mov	ax,*1
push	ax
call	_prefix
add	sp,*8
mov	bx,-$E[bp]
mov	$A[bx],ax
! 409 	nextsym();
call	_nextsym
! 410 	return leafnode(symptr);
push	-$E[bp]
call	_leafnode
inc	sp
inc	sp
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 411     }
! 412 }
jmp .80
.82:
sub	al,*0
beq 	.83
sub	al,*1
beq 	.99
sub	al,*1
beq 	.B0
sub	al,*1
beq 	.98
sub	al,*4
beq 	.B2
sub	al,*$B
beq 	.B1
sub	al,*$3E
beq 	.92
sub	al,*$D
beq 	.A1
br 	.96
.80:
..FFFD	=	-$14
..FFFC	=	-$14
add	sp,*$E
pop	si
pop	di
pop	bp
ret
! 413 
! 414 PRIVATE struct nodestruct *unary_exp()
! 415 {
_unary_exp:
! 416     value_t size;
! 417     struct typestruct *vartype;
! 418 
! 419     switch (sym)
push	bp
mov	bp,sp
push	di
push	si
add	sp,*-6
mov	al,[_sym]
! 420     {
br 	.B6
! 421     case ADDOP:
! 422 	nextsym();
.B7:
call	_nextsym
! 423 	return cast_exp();
call	_cast_exp
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 424     case AMPERSAND:
! 425 	nextsym();
.B8:
call	_nextsym
! 426 	return node(ADDRESSOP, cast_exp(), NULLNODE);	/* maybe unary_exp */
xor	ax,ax
push	ax
call	_cast_exp
push	ax
mov	ax,*$3D
push	ax
call	_node
add	sp,*6
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 427     case DECSYM:
! 428 	nextsym();
.B9:
call	_nextsym
! 429 	return node(PREDECOP, unary_exp(), NULLNODE);
xor	ax,ax
push	ax
call	_unary_exp
push	ax
mov	ax,*$41
push	ax
call	_node
add	sp,*6
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 430     case HYPHEN:
! 431 	nextsym();
.BA:
call	_nextsym
! 432 	return node(NEGOP, cast_exp(), NULLNODE);
xor	ax,ax
push	ax
call	_cast_exp
push	ax
mov	ax,*$40
push	ax
call	_node
add	sp,*6
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 433     case INCSYM:
! 434 	nextsym();
.BB:
call	_nextsym
! 435 	return node(PREINCOP, unary_exp(), NULLNODE);
xor	ax,ax
push	ax
call	_unary_exp
push	ax
mov	ax,*$42
push	ax
call	_node
add	sp,*6
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 436     case LOGNOTOP:
! 437 	nextsym();
.BC:
call	_nextsym
! 438 	return node(LOGNOTOP, cast_exp(), NULLNODE);
xor	ax,ax
push	ax
call	_cast_exp
push	ax
mov	ax,*$22
push	ax
call	_node
add	sp,*6
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 439     case NOTOP:
! 440 	nextsym();
.BD:
call	_nextsym
! 441 	return node(NOTOP, cast_exp(), NULLNODE);
xor	ax,ax
push	ax
call	_cast_exp
push	ax
mov	ax,*$23
push	ax
call	_node
add	sp,*6
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 442     case SIZEOFSYM:
! 443 	nextsym();
.BE:
call	_nextsym
! 444 	++insizeof;
inc	word ptr [_insizeof]
mov	ax,[_insizeof]
! 445 	if (sym != LPAREN)
cmp	byte ptr [_sym],*$12
je  	.BF
.C0:
! 446 	    size = unary_exp()->nodetype->typesize;
call	_unary_exp
mov	bx,ax
mov	bx,4[bx]
mov	ax,8[bx]
mov	bx,$A[bx]
mov	-8[bp],ax
mov	-6[bp],bx
! 447 	else
! 448 	{
jmp .C1
.BF:
! 449 	    nextsym();
call	_nextsym
! 450 	    if ((vartype = typename()) != NULL)
call	_typename
mov	-$A[bp],ax
test	ax,ax
je  	.C2
.C3:
! 451 	    {
! 452 		rparen();
call	_rparen
! 453 		size = vartype->typesize;
mov	bx,-$A[bp]
mov	ax,8[bx]
mov	bx,$A[bx]
mov	-8[bp],ax
mov	-6[bp],bx
! 454 	    }
! 455 	    else
! 456 		size = postfix_exp(TRUE)->nodetype->typesize;
jmp .C4
.C2:
mov	ax,*1
push	ax
call	_postfix_exp
inc	sp
inc	sp
mov	bx,ax
mov	bx,4[bx]
mov	ax,8[bx]
mov	bx,$A[bx]
mov	-8[bp],ax
mov	-6[bp],bx
! 457 	}
.C4:
! 458 	--insizeof;
.C1:
dec	word ptr [_insizeof]
mov	ax,[_insizeof]
! 459 	return leafnode(constsym(size));
push	-6[bp]
push	-8[bp]
call	_constsym
add	sp,*4
push	ax
call	_leafnode
inc	sp
inc	sp
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 460     case STAR:
! 461 	nextsym();
.C5:
call	_nextsym
! 462 	return node(INDIRECTOP, cast_exp(), NULLNODE);	/* maybe unary_exp */
xor	ax,ax
push	ax
call	_cast_exp
push	ax
mov	ax,*$3F
push	ax
call	_node
add	sp,*6
lea	sp,-4[bp]
pop	si
pop	di
pop	bp
ret
! 463     }
! 464     return postfix_exp(FALSE);
jmp .B4
.B6:
sub	al,*8
jb  	.B4
cmp	al,*$1B
ja  	.C6
xor	ah,ah
shl	ax,*1
mov	bx,ax
seg	cs
br	.C7[bx]
.C7:
.word	.B8
.word	.B4
.word	.B4
.word	.B4
.word	.B9
.word	.B4
.word	.BA
.word	.BB
.word	.B4
.word	.B4
.word	.B4
.word	.B4
.word	.B4
.word	.B4
.word	.B4
.word	.C5
.word	.B4
.word	.B4
.word	.B4
.word	.B4
.word	.B4
.word	.B4
.word	.B4
.word	.B7
.word	.B4
.word	.B4
.word	.BC
.word	.BD
.C6:
sub	al,*$5C
beq 	.BE
.B4:
..FFFB	=	-$C
xor	ax,ax
push	ax
call	_postfix_exp
inc	sp
inc	sp
add	sp,*6
pop	si
pop	di
pop	bp
ret
! 465 }
! 466 
.data
.97:
.C8:
.ascii	"bad expression"
.byte	0
.8C:
.C9:
.ascii	" undeclared"
.byte	0
.7D:
.CA:
.ascii	"undefined structure element"
.byte	0
.75:
.CB:
.ascii	"scanf"
.byte	0
.66:
.CC:
.ascii	"printf"
.byte	0
.bss
_insizeof	lcomm	2
! 0 errors detected
