package com.jclark.xsl.expr;

import com.jclark.xsl.om.*;

class AttributeTest extends PathPatternBase {
  private final Name name;

  AttributeTest(Name name) {
    this.name = name;
  }

  public boolean matches(Node node, ExprContext context) {
    return (name.equals(node.getName())
	    && node.getType() == Node.ATTRIBUTE);
  }

  Name getMatchName() { return name; }
  byte getMatchNodeType() { return Node.ATTRIBUTE; }
  public int getDefaultPriority() { return 0; }
}
